#ifndef WCSTRIG
#define WCSTRIG

#include <math.h>

#ifndef PI
#ifdef M_PI
#define PI M_PI
#else
#define PI 3.141592653589793238462643
#endif
#endif

#define D2R PI/180.0
#define R2D 180.0/PI

#if __STDC__
   double cosD(double);
   double sinD(double);
   double tanD(double);
   double acosD(double);
   double asinD(double);
   double atanD(double);
   double atan2D(double, double);
#else
   double cosD();
   double sinD();
   double tanD();
   double acosD();
   double asinD();
   double atanD();
   double atan2D();
#endif

/* Domain tolerance for asin and acos functions. */
#define WCSTRIG_TOL 1e-10

#endif /* WCSTRIG */
