#ifndef CEL
#define CEL

#include "proj.h"

struct celprm {
   int flag;
   double ref[4];
   double euler[5];

#if __STDC__
   int (*prjfwd)(double, double, struct prjprm *, double *, double *);
   int (*prjrev)(double, double, struct prjprm *, double *, double *);
#else
   int (*prjfwd)();
   int (*prjrev)();
#endif
};

#if __STDC__
   int celset(char *, struct celprm *, struct prjprm *);
   int celfwd(char *, double, double,
              struct celprm *,
              double *, double *,
              struct prjprm *,
              double *, double *);
   int celrev(char *, double, double,
              struct prjprm *,
              double *, double *,
              struct celprm *,
              double *, double *);
   int sphfwd (double lng, double lat, double eul[], double *phi, double *theta);
   int sphrev (double phi, double theta, double eul[], double *lng, double *lat);
#else /* not __STDC__ */
   int celset(), celfwd(), celrev();
   int sphfwd(), sphrev();
#endif /* __STDC__ */

#define CELSET 137

#endif /* CEL */
