.\"	@(#) skyview
.\"
.TH skyview l "June 17, 1998" "Release 3.3" "Skyview Reference Manual"
.SH NAME
skyview \- interactive image display and analysis tool for astronomical data
.SH SYNOPSIS
.B skyview
.B
[ \fI-options\fR ] [ \fB-display\fI host:0[.0]\fR
]
.br
.B skyview
.I filename
.SH DESCRIPTION
.B IPAC skyview
is an image display and analysis program specifically for the
interactive analysis of astronomical image data using the X-Windows
user interface.

To use \fBskyview\fR, you need: a client
unix machine with about 7Mbytes of disk space, and an X-Windows display
server (X11R3, X11R4 or X11R5).  The client and server may be separate
machines both attached to the internet.

The \fIHints for skyview Users\fR (a quick-reference card), and 
the \fISkyview User's Guide\fR provide more complete details on 
the use of \fBskyview\fR. 

\fIfilename\fR specifies an image file to be painted.  
To end, move mouse cursor into image window and type the letter
.B q.
This feature allows 
.B skyview
to be used to display FITS mime-type images from a web browser.
.SH OPTIONS
.TP
\fB -d \fR
Start in debug mode. 
.TP
\fB -display\fR 
used to specify an alternate X display, when followed by
the \fIhost:0\fR where \fIhost\fR is the name of the machine to
display images on.
.TP
\fB -c\fR
Run in captive mode - disables subshells and commands that modify files.
.TP
\fB -8bit\fR
Force graphics to be in 8 plane mode, on machines capable of 24 plane graphics
(needed for some machines due to incompatibility between 
the X server and graphics board).
.TP
\fB -e\fR
Execute the single command which follows the \fB -e\fR, then wait for
skyview commands from stdin.  Suppress all output from stdout.  Do not
read SLOGIN file.
.TP
\fB -n\fR
No-graphics mode (simulating 8 plane graphics).  Skyview does not access X-Window server.
.TP
\fB -n24\fR
No-graphics mode simulating 24 plane graphics.  Skyview does not access X-Window server.
.TP
\fB -i\fR
Force X colormap load - illegal on most window managers, but useful on
some obstinant ones.  Avoid using this option.
.TP
\fB -server\fR
Run in server mode - Used by a calling 
program to execute 
.B skyview
commands from within that program.  Each 
.B skyview
command has specific output the calling program can expect, which is fully
documented on individual function help pages within 
.B skyview,
and in the 
.I Skyview User's Guide.
.TP
\fB -p\fR
Select palette size - other than 240 levels of color
.TP
\fB -imio\fR
Start up in IRAF `imio' mode so IRAF can use 
.B skyview
for interactive image display and analysis. Start up IRAF in another window
and the usual IRAF commands apply.  The most noticeable difference you will
see when using \fBskyview\fR  with IRAF is that you can display multiple images,
each in a separate window, instead of only one at a time.  You can also move
the mouse cursor into the text window running \fBskyview\fR and use most of
the normal \fBskyview\fR commands.
.SH ENVIRONMENT
\fBskyview\fR uses the following environment variables.  If not set by the 
user before starting \fBskyview\fR, the defaults are based on decisions made 
when the program was installed. 
.TP
SLOGIN
name of the start-up file. \fBskyview\fR executes the commands in this file
at start up if it is running in interactive mode (-server flag not set).
.TP
SMAN
name of the directory containing the \fBskyview\fR help files.
.TP
SDATA
path containing directories to search for valid \fBfield_of_view\fR files
and color table files.
.TP
STAPE
name of tape device to be used when reading and writing mag tapes with
\fBskyview\fR.  \fBskyview\fR is rarely (if ever) used to read tapes 
anymore.  The \fBtape_read\fR command and this environment variable 
remain for backward compatibility.
.TP
SPRINTER
name of printer to be used for output of hardcopy from \fBcontour\fR.
.TP
AGRADIR
directory tree containing the agra fonts.  Skyview will look for file
$(AGRADIR)/font/hershey_oc.dat.
.TP
RGBFILE
directory containing the X-windows file "rgb.txt".  In no-graphics
mode this file is used for color name resolution (in normal graphics
mode, color resolution is done by the X-Windows system). Default is
/usr/lib/X11/.
.PP
Since \fBskyview\fR uses the \fBX-Windows\fR interface, it has the
capability of reading an \fBX-resource\fR file. The file should be
called \fBSkyview\fR (with a capital \fIS\fR). The resource file is
read when the program is first invoked. The syntax of the file should
be:  \fIvariablename\fR, a colon (\fB:\fR), a blank space, and then the
\fIsetting\fR, with no trailing spaces.  The following variables can be 
defined in the resource file:
.TP
skyview*debug
determines whether \fBskyview\fR should be invoked with the debug mode 
turned on. (Default: off)
.TP
skyview*eightBit
force graphics to be in 8-bit mode (on machines capable of 24 plane 
graphics).
.TP
skyview*palette
selects the palette size--the number of levels of color to use. 
(Default: 240)
.TP
skyview*serverMode
determines whether \fBskyview\fR should be invoked in the server mode.
(Default: off)
.TP
skyview*mainButton1
used to describe which \fBskyview\fR function should be invoked 
when the left mouse button is clicked.
(Default: stretch)
.TP
skyview*mainButton2
used to describe which \fBskyview\fR function should be invoked 
when the center mouse button is clicked.
(Default: pick)
.TP
skyview*mainButton3
used to describe which \fBskyview\fR function should be invoked 
when the right mouse button is clicked.
(Default: zoom_pan)
.TP
skyview*mouse
determines whether mouse can be used.  Usually only turned off when server
mode is on.  (Default: on)
.TP
skyview*projtype
determines whether the \fBPROJTYPE\fR keyword in FITS headers should be
recognized.  (Default: off)
.TP
skyview*unsigned16Bit
specifies that 16-bit images contain unsigned 16-bit pixels.  The FITS
standard states that 16-bit pixels are signed.
(Default: off)
.TP
skyview*reread
specifies that each image should be re-read from the disk file every time
it is painted.  (Default: off)
.TP
skyview*conserveMem
determines whether to conserve memory by only storing in memory
the last image painted  (Default: off)
.TP
skyview*color
selects the Xcolor to be used for all graphic overlays.  
(Default: function default)
.TP
skyview*pointerShape
selects the Xcursor to be used for the mouse cursor bitmap.  
(Default: crosshair)
.SH COMMANDS
.IP alias 15
    Define an alias based on functions  or parameter definitions.
.IP annotate
    Annotate the screen with text.
.IP background
    Define a background level to be used in flux integration.
.IP border
    Provide black border around a displayed image.
.IP change_area
    Change from one defined area to another.
.IP change_directory
    Change directory.
.IP current_image
    Tell which filename is associated with the current image. 
.IP clip
    Clip off pixels from the image upon display. 
.IP contour(contourps,contourovl)
   Create a hardcopy contour plot of an image 
   or overlay it on the displayed image.
.IP crop
   Crop out a portion of an image, creating a new file 
   containing only that cropped portion.
.IP coord_system
   Specify the coordinate system to work within. 
.IP color_table
   Specify the color table to use when displaying images. 
.IP cutoff
   Cutoff the lower end of the color table.
.IP define_area
   Define an area within a displayed image.
.IP debug
   Debug mode. Please don't use this option.
.IP delete_file
   Delete a file.
.IP directory
   List the contents of the current directory.
.IP echo
   Echo a given string to the screen.
.IP end
   End the program.
.IP erase
   Erase all or specific images displayed on the screen.
.IP examine
   Examine a defined area.  (flux integration)
.IP exit
   Exit the program.
.IP file
   Set file name to work with. 
.IP find_plate
   Find the IRAS Skyflux or ISSA plate given
   certain coordinates.
.IP flatten
   Flatten an image by removing a least-squares fit plane.
.IP field_of_view
   Field of view overlay.
.IP frame
   Specify the display frame number to work within.
.IP graphics_examine
   Report catalog data from a table based on marks
   placed on a defined area.
.IP graphics_pick
   Report catalog data from a table based on a 
   mark nearest the cursor for points specified.
.IP graphics_point
   Report catalog data from a table based on a 
   mark nearest the cursor for one point.
.IP grid
   Draw a coordinate grid on the image.
.IP help
   Display help on a given function.
.IP header
   Display the header of an image.
.IP histogram
   Display the histogram of a displayed image. 
.IP histogram_original
   Display the histogram of an image file based on 
   the original data values.
.IP magnifier
   Display a magnifier window for seeing close-up detail
   while moving the mouse.
.IP map
   Map the display of an image to a specific color plane. 
.IP mark
   Mark a specific point on an image with a 
   particular color and shape.
.IP memdump
   Dump a screen image to a file in no-graphics mode.
.IP mode
   Set the mode for range stretch.
.IP movie
   Play a series of frames as a movie.
.IP movie_prep
   Prepare a series of frames for the movie command.
.IP off
   Turn off a specific color plane.
.IP on
   Turn on a specific color plane.
.IP paint
   Paint (display) image from disk onto screen.
.IP paint_blank
   Display a window on the screen, but do not paint the pixels.
.IP pause
   Pause and wait for a carriage-return before 
   executing any more commands.
.IP print_history
   Print a log of the session history.
.IP pick
   Pick  pixel values and locations on a displayed image.
.IP plane
   Select a plane from a multiple plane image for display.
.IP point
   Pick a single pixel value and location on a displayed image.
.IP print_working_dir
   Print working directory name.
.IP quit
   Exit the program.
.IP range
   Set the range for transfer function during paint.
.IP replicate
   Replicate image pixels in either direction.
.IP rewind
   Rewind tape.
.IP scatter_plot
   Create a scatter plot of two image's pixel values.
.IP screen_dump
   Screen dump a displayed image to tape or disk file.
.IP set 
   Assign (set) values to variables during the session.
.IP set_history_file
   Keep a log of the session history.
.IP skybox
   Gather sky statistics from pixel values within specified areas.
.IP slice
   Cut a slice (and display it's profile) through
   a displayed image.
.IP sleep
   Pause for a given length of time.
.IP stretch
   Stretch the color table.
.IP sync
   Synchronize the X-windows display to keep up with commands.
.IP take
   Take commands from a text file.
.IP table
   Read in columns from a table file to be used as
   parameters for other
.B skyview
commands.
.IP tape_read
   Tape read.
.IP tape_write
   Tape write.
.IP unix
   Exit program and go back to operating system.
.IP vector
   Display a vector on a currently displayed image.
.IP version
   Display the version number of the program currently being used.
.IP wedge
   Display a color table wedge. 
.IP write
   Write a new image file to disk containing zapped pixels.
.IP zap
   Zap (or edit) pixels in a displayed image.
.IP zoom_pan
   Zoom and pan a displayed image.
.IP #
   Insert a comment into the session history.
.IP !
   Pass a command to unix to be executed from the shell.
.IP ?
   Display the command syntax of a command.
.SH "SEE ALSO"
.nf
.na
Skyview User's Guide
Skyview Quick Reference Card
.fi
.ad
\" .SH MISC
.\" Other section headings may be added if needed.
.\" DIAGNOSTICS  to describe program diagnostic output
.\"Copyright (C) 1995, California Institute of Technology.
.\"U.S. Government Sponsorship under NASA Contract NAS7-918
.\"is acknowledged.
