/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include "skyview.h"
#include <stdio.h>
#include "jgio.h"

extern JFILE  *J12file;
extern FILE *session;
extern int debug;
extern char plane;

static int wedge_on = TRUE;  /* flag to paint wedge with rddisk and histogram */

wedge(x_min, y_min, x_max, y_max)
int x_min, y_min, x_max, y_max;
{
    int c, y;
    double slope, offset;

    if (debug)
	printf("wedge: x_min=%d x_max=%d y_min=%d y_max=%d\n",x_min, x_max, y_min, y_max);
    if (wedge_on)
    {
	if ((x_min < 0) || (x_max > 1279) || (y_min < 0) || (y_max > 1023))
	    return;
	slope = 254.0 / (y_max - y_min);
	offset = 254.0 * y_min / (y_max - y_min);
	for (y = y_min; y<= y_max; y++)
	{
	    c = slope * y - offset;
	    j_sec(c);
	    j_mov(x_min,y);
	    j_dfr(x_max, y);  /* filled rectangle */
	}
	jfflush(J12file);
    }
}

wedgecmd(argc, argv)
int argc;
char *argv[];
{
    if (argc == 2)
    {
	if (strncmp(argv[1], "off", 2) == 0)
	    wedge_on = FALSE;
	if (strcmp(argv[1], "on") == 0)
	    wedge_on = TRUE;
	if (strcmp(argv[1], "now") == 0)
	    wedge_now();
    }
    else
    {
	printf("wedge is %s\n", wedge_on ? "on" : "off");
	fprintf(session, "wedge is %s\n", wedge_on ? "on" : "off");
    }
}

wedge_now()
{
    int minx, miny, maxx, maxy, wedge_on_save;

    wedge_on_save = wedge_on;  /* save current mode */
    wedge_on = TRUE;
    overlay_setup('r');
    set_box(&minx, &miny, &maxx, &maxy);
    j_sec(0);   /* erase red lines */
    j_mov(minx, miny);
    j_dva(maxx,miny);
    j_dva(maxx,maxy);
    j_dva(minx,maxy);
    j_dva(minx,miny);
    image_setup(plane);
    wedge(minx, miny, maxx, maxy);
    wedge_on = wedge_on_save;  /* restore current mode */
}
