/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/********************************************************************/
/*                                                                  */
/* SWABFITS - Converts s workfile from old Jupiter format           */
/*          to new microvax format.  Swaps bytes and words          */
/*          as appropriate.                                         */
/*                                                                  */
/********************************************************************/


#include "skyview.h"
#include <stdio.h>
#include <sys/file.h>


main(argc, argv)

int argc;
char **argv;

{
    register short temp;
    register short *p;
    register int i;
    int bitpix, fl;
    int n_read;
    int read_n, posn;
    int fi;
    char *pt;
    char buf[2880];
    struct hdrstruct hdr;


    if (argc == 1)
    {
	printf("usage: swabfits imagefile imagefile ... \n");
	exit(1);
    }

for (fl = 1; fl < argc; fl++)
{
    printf("\nprocessing file %s\n", argv[fl]);

	fi = open(argv[fl], O_RDWR, 0644);
	if (fi < 0)
	{
	    perror(argv[fl]);
	    printf("\7");
	    continue;
	}


    /* Process the file */

    lseek(fi, 0, 0);
    read(fi, &hdr, sizeof(hdr));
    swab(&hdr, &hdr, sizeof(hdr));
    p = (short *) &hdr;
    for(i = 0; i < sizeof(hdr); i++)
    {
        temp = *p;
        *p = *(p+1);
        *(p+1) = temp;
	p+=2;
    }
    if ((hdr.tapetype != FITS) && (hdr.tapetype != VICAR))
    {
	printf("\007ERROR: bad IPAC header\n  tapetype  = %d\n", hdr.tapetype);
	continue;
    }

    if (hdr.tapetype == VICAR)
    {
	bitpix = 16;
    }

    if (hdr.tapetype == FITS)
    {
	/* check FITS header */
	lseek(fi, hdr.hdr_start, 0);
	read(fi, buf, 160);  /* read 1st two lines of fits header */
	if (strncmp(buf, "SIMPLE", 6) != 0)
	{
	    printf("\007FITS header does not start with SIMPLE\nstarts with: ");
	    for (i=0; i < 6; i++)
		printf("%c", buf[i]);
	    printf("\n");
	    continue;
	}
	if (strncmp(&buf[80], "BITPIX", 6) != 0)
	{
	    printf("\007Second item in FITS header is not BITPIX\n");
	    continue;
	}
	bitpix = atoi(&buf[90]);
    }
    printf("\n ====================================\n");
    printf(" tapetype  = %d\n", hdr.tapetype);
    printf(" hdr_start = %d\n", hdr.hdr_start);
    printf(" img_start = %d\n", hdr.img_start);
    printf(" hist_start = %d\n", hdr.hist_start);
    printf(" img_max = %d\n", hdr.img_max);
    printf(" img_min = %d\n", hdr.img_min);
    printf(" hist_bin_size = %d\n\n", hdr.hist_bin_size);

    printf("bitpix = %d\n", bitpix);


    /* Write out new header */
    lseek(fi, 0, 0);
    write(fi, &hdr, sizeof(hdr));

    /* no changes needed to FITS header */


	 /* Copy the pixels */


    posn = hdr.img_start;
    while (posn < hdr.hist_start)
    {
        if ((hdr.hist_start - posn) > 2880)
            read_n = 2880;
        else
            read_n = hdr.hist_start - posn;
        lseek(fi, posn, 0);
        n_read = read(fi, buf, read_n);
	    switch(bitpix)
	    {
	    case 32:
		    swab(buf, buf, read_n);
		    p = (short *) buf;
		    for(i = 0; i < read_n; i += 4)
		    {
			temp = *p;
			*p = *(p+1);
			*(p+1) = temp;
			p += 2;
		    }
		    break;
            case 16:
		    swab(buf, buf, read_n);
                    break;
            case 8:
                    break;
            }
        lseek(fi, posn, 0);
        write(fi, buf, read_n);
        posn += read_n;
    }


	 /* Copy the rest of file (histogram) */

    posn = hdr.hist_start;
    while (FOREVER)
    {
        lseek(fi, posn, 0);
        n_read = read(fi, buf, 2880);
	    swab(buf, buf, 2880);
	    p = (short *) buf;
	    for(i = 0; i < 2880; i += 4)
	    {
		temp = *p;
		*p = *(p+1);
		*(p+1) = temp;
		p+=2;
	    }
        lseek(fi, posn, 0);
        write(fi, buf, n_read);
        posn += 2880;
        if (n_read == 0)
            break;
    }
    }
}
