/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/* machine dependent code for SUN SPARCstation running Sunview */ 
#include "skyview.h"
#include "parse.h"
#include "img.h"
#include <stdio.h>
#include <strings.h>
#include <sgtty.h>
#include <sys/file.h>
#include <math.h>
#include <sys/types.h>
#include <suntool/sunview.h>  /* Sunview header file */
#include <suntool/canvas.h>  /* Canvas header file */
#include <suntool/tty.h>

#define CTLENGTH 256
#define DEF 1

extern FILE *session;
extern int wedge_on;
extern int output_coord_sys, ttyfd, debug, tmpfd;
extern int force_graphics, blank;
extern double bscale, b_zero;
extern char bunit[], *image_to_sky();

extern int hist_on;
extern int minx, miny, maxx, maxy;

static char Id[] = "@(#)sun.c   RBH        10/04/89>";

Frame base_frame, my_frame;
Canvas my_canvas;
Pixwin *pw, *my_pw;
Tty ttysw;
Pixrect *mem;

int J12file;
int area_number;
int x_area[100][MAX_AREAS];

unsigned char red[256], green[256], blue[256];

static int screenflag;
static int frame_top_y, cur_line;
static int my_done;

static int aedfd;


static Notify_value
my_notice_destroy(frame, status)
Frame frame;
Destroy_status status;
{
    if (status != DESTROY_CHECKING)
    {
	my_done = 1;
	(void) notify_stop();
    }
    return(notify_next_destroy_func(frame, status));
}

init_graphics(argc, argv)
int argc;
char *argv[];
{
    Pixwin *ttypw;
    int i;
    int tty_fd;
    struct singlecolor fore_color, back_color;

    if (!getenv("WINDOW_ME"))
    {
	/* default to no graphics if not at main console */
	if (!force_graphics)   /* but let him override it */
	    return(FALSE);
    }
    else
    {
	my_done = 0;

	fore_color.red = 0;
	fore_color.green = 255;
	fore_color.blue = 0;
	back_color.red = 0;
	back_color.green = 0;
	back_color.blue = 0;
	base_frame = window_create(NULL, FRAME, 
	    FRAME_ARGC_PTR_ARGV,	&argc,argv,
	    FRAME_FOREGROUND_COLOR, &fore_color,
	    FRAME_BACKGROUND_COLOR, &back_color,
	    FRAME_LABEL, "Main s frame",
	    0);
	if (base_frame == NULL)
	    return(FALSE);
#ifdef DEF 
	ttysw = window_create(base_frame, TTY, 
	    TTY_ARGV,	TTY_ARGV_DO_NOT_FORK,
	    0);
	tty_fd = (int)window_get(ttysw, TTY_TTY_FD);
	dup2(tty_fd, 0);
	dup2(tty_fd, 1);
	setbuf(stdin, NULL);
	/*
	window_set(base_frame, WIN_GRAB_ALL_INPUT , TRUE, 0);
	*/

	pw = (Pixwin *) window_get(base_frame, WIN_PIXWIN);
	ttypw = (Pixwin *) window_get(ttysw, WIN_PIXWIN);
	for (i = 0; i < 256; i++)
	{
	    red[i] = 1;
	    green[i] = 0;
	    blue[i] = 0;
	}
	red[0] = green[0] = blue[0] = 255;
	red[254] = green[254] = blue[254] = 255;
	red[255] = green[255] = blue[255] = 0;
	pw_setcmsname(pw, "s_colors");
	pw_putcolormap(pw, 0, 256, red, green, blue);
	pw_setcmsname(ttypw, "s_colors");
	pw_putcolormap(ttypw, 0, 256, red, green, blue);

	/*
	pw_blackonwhite(pw, 0, 255);
	pw_blackonwhite(ttypw, 0, 255);
	*/

	(void) notify_interpose_destroy_func(base_frame, my_notice_destroy);
	window_set(base_frame, WIN_SHOW,  TRUE, 0);
#endif DEF 
	/* Enable implicit dispatching */
	(void) notify_do_dispatch();
    }
    return(TRUE);
}

show_frame()
{
    int i;

    frame_top_y = maxy;
    my_frame = window_create(base_frame, FRAME, 
	FRAME_LABEL, "frame 1",
	0);
    my_canvas = window_create(my_frame, CANVAS, 
	CANVAS_AUTO_SHRINK,		FALSE,
	CANVAS_AUTO_EXPAND,		FALSE,
	WIN_VERTICAL_SCROLLBAR,		scrollbar_create(0),
	WIN_HORIZONTAL_SCROLLBAR,	scrollbar_create(0),
	WIN_WIDTH,			maxx - minx + 1,
	WIN_HEIGHT,			maxy - miny + 1,
	0);

    /* create color table */
    for (i = 0; i < 256; i++)
    {
	red[i] = i;
	green[i] = i;
	blue[i] = i;
    }
    red[0] = green[0] = blue[0] = 255;
    red[254] = green[254] = blue[254] = 255;
    red[255] = green[255] = blue[255] = 0;
    /* set the WIN_PIXWIN colormap (see p 73) */
    my_pw = (Pixwin * ) window_get(my_canvas, WIN_PIXWIN);
    pw_setcmsname(my_pw, "s_colors");
    pw_putcolormap(my_pw, 0, 256, red, green, blue);

    /* set the CANVAS_PIXWIN colormap (see p 73) */
    my_pw = canvas_pixwin(my_canvas);
    pw_setcmsname(my_pw, "s_colors");
    pw_putcolormap(my_pw, 0, 256, red, green, blue);

    window_set(my_canvas,
	CANVAS_RETAINED,		TRUE,
	WIN_VERTICAL_SCROLLBAR,		scrollbar_create(0),
	WIN_HORIZONTAL_SCROLLBAR,	scrollbar_create(0),
	0);
    
    window_fit(my_frame);
    window_set(my_frame, WIN_SHOW, TRUE, 0);

    /* create memory pixrect */
    mem = mem_create(maxx - minx + 1, 1, 8);
}

erase(argc, argv)
int argc;
char **argv;
{
    /* destroy the memory pixrect */
    pr_close(mem);

    window_set(my_frame, FRAME_NO_CONFIRM, TRUE, 0);
    window_destroy(my_frame);
}

main_command(p)

char *p;

{
    int n_bytes, n_read;

    n_bytes = 256;

    fflush(stdout);

			    /* Console Keyboard */
    n_read = read(ttyfd, p, n_bytes);
    *(p + n_read - 1) = '\0';
    if(debug == TRUE)
	printf("main_command: %s from console\n", p);

    return(TRUE);
}

com_setup()
{
}

ball_setup()
{
}

ball_reset()
{
}

jf_csrset()
{
}

_jgrabv()
{
}

jfflush()
{
    if (debug)
	printf("dummy jfflush called\n");
}

jf_cpars()
{
}

jf_char()
{
}

j_zoom()
{
    jf_zoom();
}

jf_zoom()
{
}

jf_bdmap()
{
    printf("dummy jf_bdmap called\n");
}

j_ov_sset()
{
}


j_ormask()
{
}

j_cltset(startat, len, r, g, b)
int startat, len;
unsigned char *r, *g, *b;
{
    jf_cltset(startat, len, r, g, b, J12file);
}

jf_cltset(startat, len, r, g, b, J12file)
int startat, len;
unsigned char *r, *g, *b;
int J12file;
{

    int i;

    r[0] = g[0] = b[0] = 255;
    r[254] = g[254] = b[254] = 255;
    r[255] = g[255] = b[255] = 0;
    for (i = 0; i < 10; i++)
	printf("RBH i = %d r = %d g=%d b=%d\n", i, r[i], g[i], b[i]);
    for (i = 250; i < 256; i++)
	printf("RBH i = %d r = %d g=%d b=%d\n", i, r[i], g[i], b[i]);
    pw_putcolormap(pw, startat, len, r, g, b);
}

ball()
{
}

j_bdepth()
{
    jf_bdepth();
}

jf_bdepth()
{
}

j_depth()
{
    jf_depth();
}

jf_depth()
{
}

j_area(x0,y0,x1,y1)
int x0,y0,x1,y1;
{
    cur_line = y0;
    return((x1 - x0 + 1) * (y1 - y0 + 1));
}

j_wrt_image(inptr, nbr)
int nbr;
char *inptr;
{
    int i;
    char *ptr;

    /* move pixels into memory pixrect */
    ptr = (char *) mpr_d(mem) -> md_image;
    for (i = 0; i < nbr; i++)
	*ptr++ = *inptr++;
    pw_write(my_pw, 1, frame_top_y-cur_line, nbr, 1, PIX_SRC, mem, 0, 0);
    /*
    printf("pixels = %x %x %x %x (hex)  cur_line = %d\n", inptr[0], inptr[1], inptr[2], inptr[3], cur_line);
    */
}

jf_get_attr()
{
}

jf_rd_image()
{
}

map()
{
    not_implemented();
}

overlay_setup()
{
}

image_setup()
{
}

zoom_setup()
{
}

background()
{
    not_implemented();
}

change_area()
{
    not_implemented();
}

define_area()
{
    not_implemented();
}

find_range()
{
    not_implemented();
}

flatten()
{
    not_implemented();
}

replicate()
{
    not_implemented();
}

zoom_pan()
{
    not_implemented();
}

draw_outline()
{
}

vector()
{
    not_implemented();
}

examine_area()
{
    not_implemented();
}

scatter_plot()
{
    not_implemented();
}

slice()
{
    not_implemented();
}

screen_dump()
{
    not_implemented();
}

not_implemented()
{
    printf("feature not implemented in SUN version\n");
    error();
}


wedge(x_min, y_min, x_max, y_max)
int x_min, y_min, x_max, y_max;
{
    int c, y;

    x_min = 490;
    x_max = 511;
    y_min = 0;
    y_max = 511;
    if (debug)
	printf("wedge: x_min=%d x_max=%d y_min=%d y_max=%d\n",x_min, x_max, y_min, y_max);
    if (wedge_on == FALSE)
    {
	/* make sure interpreter is off */
	aed_on();
	aed_off();
	return;
    }
    aed_on();
    for (y = 0, c = 0; y<= 510; y+=2, c++)
    {
	aed_sec(c);
	aed_mov(x_min,y);
	aed_dfr(x_max, y+1);  /* filed rectangle */
    }
    aed_off();
}

wedgecmd(argc, argv)
int argc;
char *argv[];
{
    int wedge_on_save;

    if (argc == 2)
    {
	if (strncmp(argv[1], "off", 2) == 0)
	    wedge_on = FALSE;
	if (strcmp(argv[1], "on") == 0)
	    wedge_on = TRUE;
	if (strcmp(argv[1], "now") == 0)
	{
	    wedge_on_save = wedge_on;  /* save current mode */
	    wedge_on = TRUE;
	    wedge(465, 0, 485, 511);
	    wedge_on = wedge_on_save;  /* restore current mode */
	}
    }
    else
    {
	printf("wedge is %s\n", wedge_on ? "on" : "off");
	fprintf(session, "wedge is %s\n", wedge_on ? "on" : "off");
    }
}

aed_on()
{
}

aed_off()
{
}

aed_sec(color)
int color;
{
}

xy20(x, y)
int x,y;
{

}

aed_mov(x, y)
int x,y;
{
}

aed_dfr(x,y)
int x,y;
{
}

aed_dva(x,y)
int x,y;
{
}


/******************************************************************/
/*                                                                */
/* PICK                                                           */
/* uses the AED joystick to define a point for flux extraction    */
/*                                                                */
/******************************************************************/
 
int backgnd_flag = FALSE;
double backgnd_level = 0.;

pick(argc, argv) 

int argc;
char **argv;
 
{ 
     char comm[20];
     int status;
     double z, zint; 
     double fluxes[4];
     char s_coord[2][40]; 
     int i, j, x, y, i_coord[2], end_box;
     int area = 1, area2, nint;
     int n_backgnd;
     double backgnd;
     struct img *imgp, *imgp_sav, *find_SC(), *sky_to_image();
     char buff[20], inbuf[20], *coord_str;

     n_backgnd = 0;
     backgnd = 0;

     /* process the coordinates if given */

     if(argc == 3)
          {
	  strcpy(s_coord[0], argv[1]);
	  strcpy(s_coord[1], argv[2]);

	  sky_to_image(s_coord, i_coord);

          IM_to_SC(i_coord);
	  x = i_coord[0];
	  y = i_coord[1];
          }

     if(argc == 4)
          {
          if (getint(argv[1], &area) == FALSE)
	      return;

	  strcpy(s_coord[0], argv[2]);
	  strcpy(s_coord[1], argv[3]);

	  sky_to_image(s_coord, i_coord);

          IM_to_SC(i_coord);
	  x = i_coord[0];
	  y = i_coord[1];
	  }

     if(argc == 2)
          if (getint(argv[1], &area) == FALSE)
	      return;

     if(argc == 1)
          area = 0;

     area = area / 2;

     if(area < 0)
	  area = 0;

     area2 = 2 * area + 1;

     if(area != 0) 
	  {
	  printf("Averaging over a %dx%d box.\n", area2, area2);
	  fprintf(session, "Averaging over a %dx%d box.\n", area2, area2);
	  }

     /* set up the cursor */

     if(argc < 3)   /* if using joystick */
	  {

	  printf("\n   Enter 'e' on console to end\n");
 
          /* Pick the point */ 

          end_box = FALSE;
	    if (debug)
		printf("enabling joystick\n");
	    aed_on();
	    buff[0] = 0x55;  /* enable joystick */
	    write(aedfd, buff, 1);
	    aed_off();
 
          while (FOREVER) 
               { 

               /* joystick */ 
 
               /* Check for command input */       

               status = main_command(comm); 
	       if(debug == TRUE && status == TRUE)
		    printf("\npick: command returned is %s (%d)\n",
		    comm, strlen(comm));

               if (status == TRUE) 
	            { 
		    imgp_sav = NULL;
                    end_box=FALSE;

                    if(comm[0] == '\0' ||
                       comm[0] == 'b'  ||
                       comm[0] == 'p'    )    /* Extract the flux */
			 {
			 if(debug == TRUE)
			      printf("pick: extract the flux\n");

		aed_on();
		buff[0] = 0x6a;  /* read cursor position */
		write(aedfd, buff, 1);
		read(aedfd, &inbuf[0], 1);  /* get answer */
		read(aedfd, &inbuf[1], 1);  /* get answer */
		read(aedfd, &inbuf[2], 1);  /* get answer */
		aed_off();
		x = (inbuf[1] & 0xff) | ((inbuf[0] & 0xf0) << 4);
		y = (inbuf[2] & 0xff) | ((inbuf[0] & 0xf) << 8);
		if (debug)
		    printf("got hex values %x %x %x  x=%d y=%d\n", inbuf[0] & 0xff, inbuf[1] & 0xff, inbuf[2] & 0xff, x, y);


			 zint = 0.;
			 nint = 0;

			 for(i = -area; i <= area; ++i)
			      {
			      for(j = -area; j <= area; ++j)
				   {
				   i_coord[0] = x + i;
				   i_coord[1] = y + j;

				   imgp = find_SC(x + i, y + j);
				   if ((imgp != NULL) && (debug))
				   printf("pixel came from %s\n", imgp->filnam);
				   if (imgp_sav == NULL)
					imgp_sav = imgp;
				   if ((imgp != imgp_sav) && (imgp != NULL))
				   {
					printf("area falls on multiple images\n");
					error();
					if (debug)
					    printf("disabling joystick\n");
					aed_on();
					buff[0] = 0x64;  /* disable joystick */
					write(aedfd, buff, 1);
					aed_off();
					return;  /* abort out of here */
				   }
				   SC_to_IM(i_coord);
				   flux(i_coord, fluxes);
                                   z = fluxes[0] * bscale + b_zero;

				   if(fluxes[0] != (double) blank)
					{
					++nint;
					zint += z;

					++n_backgnd;
					backgnd += z;
					}
                                   }
                              }

                         i_coord[0] = x;
                         i_coord[1] = y;
			 SC_to_IM(i_coord);


                         if(nint == 0) 
			      {
	                      printf("No flux available at indicated location\n");
			      fprintf(session,"\n\nNo flux available at indicated location\n");
			      error();
			      fflush(stdout);
			      }
                         else
			      {
			      zint = zint / nint;
			      coord_str = image_to_sky(i_coord);
	                      printf("%-g %s at %s", zint, bunit, coord_str);
			      fprintf(session, "%-g %s at %s", zint, bunit, coord_str);
			      }


			 if(nint > 1)
			      {
			      printf(" (using %d pixels)\n", nint);
			      fprintf(session, " (using %d pixels)\n", nint);
			      }

			 }

                    else if(comm[0] == 'e')
			 {
		         end_box=TRUE;
			 }
		    
		    else 
			 {
			 error();
			 fflush(stdout);
			 }


                    }

               if(end_box == TRUE) break;
	       }
          } 

     else        /* (argc > 2) */        /* not using joystick */
          {
	  aed_on();
	    buff[0] = 0x64;  /* disable joystick */
	    buff[1] = 0x63;  /* SCC  set cursor attributes */
	    buff[2] = 0xff;
	    buff[3] = 0x00;
	    buff[4] = 0x1e;
	    buff[5] = 0x70;  /* DCA draw cursor */
	    write(aedfd, buff, 6);
	    xy20(x, y);
          zint = 0.;
          nint = 0;

          for(i = -area; i <= area; ++i)
               {
               for(j = -area; j <= area; ++j)
		    {
		    i_coord[0] = x + i;
		    i_coord[1] = y + j;
		    SC_to_IM(i_coord);
		    flux(i_coord, fluxes);
                    z = fluxes[0] * bscale + b_zero;

                    if(fluxes[0] != (double) blank)
                         {
                         ++nint;
	                 zint += z;

			 ++n_backgnd;
			 backgnd += z;
                         }
                    }
               }

          i_coord[0] = x;
          i_coord[1] = y;
	  SC_to_IM(i_coord);


          if(nint == 0) 
	       {
               printf("No flux available at given location\n");
               fprintf(session, "No flux available at given location\n");
	       error();
	       fflush(stdout);
	       }
          else
	       {
	       zint = zint / nint;
	       coord_str = image_to_sky(i_coord);
	       printf("%-g %s at %s", zint, bunit, coord_str);
	       fprintf(session, "%-g %s at %s", zint, bunit, coord_str);
	       }


          if(nint > 1)
	       {
               printf(" (using %d pixels)\n", nint);
               fprintf(session, " (using %d pixels)\n", nint);
	       }

	       while (FOREVER)
	       {
               /* Check for command input */       

               status = main_command(comm); 
	       if(debug == TRUE && status == TRUE)
		    printf("\npick: command returned is %s (%d)\n",
		    comm, strlen(comm));

               if (status == TRUE) 
	       {
		    buff[0] = 0x35;   /* ECU erase cursor */
		    buff[1] = 0x63;   /* SCC set cursor no flash */
		    buff[2] = 0xff;
		    buff[3] = 0xff;
		    buff[4] = 0x00;
		    write(aedfd, buff, 5);
		    break;
	       }
	       }
          }

    if (debug)
	printf("disabling joystick\n");
    aed_on();
    buff[0] = 0x64;  /* disable joystick */
    write(aedfd, buff, 1);
    aed_off();

     if(n_backgnd > 0)
	  backgnd = backgnd / n_backgnd;

     if(debug == TRUE)
	  printf("pick:  background %-g, using %d points\n",
			 backgnd, n_backgnd);

     if(backgnd_flag == TRUE)
	  backgnd_level = backgnd;

} 


hist_cmd(argc, argv)
int argc;
char *argv[];
{
    if (argc == 2)
    {
	if (strncmp(argv[1], "off", 2) == 0)
	    hist_on = FALSE;
	if (strcmp(argv[1], "on") == 0)
	    hist_on = TRUE;
    }
    else
    {
	histogram(tmpfd);
    }
}

histogram(fd)
int fd;
{
    struct hdrstruct thdr;

    if (fd < 0)
    {
	printf("no workfile\n");
	return;
    }

    lseek(fd, 0, 0);
    read(fd,&thdr,sizeof(thdr));
    lseek(fd, thdr.hist_start, 0);
    switch (thdr.tapetype)
    {
    case FITS:
    {
	screenflag = FALSE;
	fitshist(fd, &thdr);
	break;
    }
    case VICAR:
    {
	screenflag = FALSE;
	fitshist(fd, &thdr);
	break;
    }
    case SCREEN:
    {
	screenflag = TRUE;
	fitshist(fd, &thdr);
	break;
    }
    default:
    {
	printf("no histogram available\n");
	break;
    }
    }
}

fitshist(fd, thdrp)
int fd;
struct hdrstruct *thdrp;
{
    int hist[HISTSIZ2+1], histscr[512];
    int i, hist_max, hist_lo, hist_diff, hist_hi, temp;
    register int scrx, scry, hist_right, text_left;
    float xscale;
    double ftemp;
    char *gcvt(), *string, charbuf[30];
    double label_lo, label_hi;
    double label_diff, dbl_i;
    double dy, nice_step();

    read(fd,hist,sizeof(hist));

    hist_right = 435;;
    text_left = hist_right + 10;

    hist_max = 0;
    hist_lo = HISTSIZ2;
    for (i=0; i<HISTSIZ2 ; i++)
    {
	if (hist[i] > 0)
	{
	    if (debug)
		printf("hist[%d]=%d\n", i, hist[i]);
	    hist_hi = i;      /* highest bin in use */
	    if (hist_lo > i)
		hist_lo = i;  /* lowest bin in use */
	}
    }

    if (screenflag)
    {
	hist_lo = 2048;
	hist_hi = 2302;
    }

    hist_diff = hist_hi - hist_lo;
    if (hist_diff == 0)
	hist_diff = 1;

    if (debug)
    {
	printf("hist_hi= %d  hist_lo= %d  hist_diff= %d\n",
				    hist_hi,hist_lo,hist_diff);
    }
    /* now do a rebinning for bins from 0 to 510 */
    for (i=0; i<512; i++)
	histscr[i] = 0;
    if (screenflag)
    {
	for (i=0; i<=254; i++)
	    histscr[2 * i] = hist[i + HISTSIZ];
    }
    else
    {
	for (i=hist_lo; i<=hist_hi; i++)
	{
	    if (hist[i] != 0)
	    {
	    ftemp  = (i - hist_lo) * 510.0 / hist_diff;
	    temp = ftemp;  /* integer part */
	    ftemp = ftemp - temp;  /* fractional part */
	    histscr[temp] += hist[i] -ftemp*hist[i]+0.5;   /* part into  */
							    /* this cell */
	    histscr[temp+1] += ftemp * hist[i]+0.5; /* rest in next cell */
	    if (debug)
	    {
		printf("putting %f into histscr[%d] ", 
					hist[i]-ftemp * hist[i]+0.5, temp);
		printf("and %f into histscr[%d]\n", 
						ftemp * hist[i]+0.5, temp+1);
	    }
	    }
	}
    }
    for (i=0; i<511; i++)
    {
	if (histscr[i] > hist_max)
	    hist_max = histscr[i];
	if ((debug) && (histscr[i] != 0))
	    printf("histscr[%d]= %d\n", i, histscr[i]);
    }
    xscale = 400.0 / hist_max;
    if (debug)
    {
	printf("max in histscr=%d\n",hist_max);
	printf("xscale=%e\n", xscale);
    }

    wedge(hist_right + 30, miny, hist_right + 50, miny + 512);
    aed_sec(255);  /* select white */

    /* now draw the histogram */
	aed_on();
	aed_mov(hist_right, miny);
	aed_dva(hist_right, miny + 512);   /* draw right edge of histogram */
	for (i=0; i<=510; i++) 
	{
	    scrx = hist_right - (histscr[i] * xscale);
	    scry = miny + i;
	    aed_mov(hist_right, scry );
	    aed_dva(scrx     , scry );
	}

    aed_off();
    /* now define the character fonts */

    /* now label the axis */
    label_lo = (hist_lo - HISTSIZ) * thdrp->hist_bin_size;
    label_hi = (hist_hi - HISTSIZ) * thdrp->hist_bin_size;
    if (!screenflag)
    {
	label_lo = label_lo * bscale + b_zero;
	label_hi = label_hi * bscale + b_zero;
    }
    label_diff = label_hi - label_lo;
    dy = label_diff / 20;  /* get about 20 labels */
    /* now find a nice step size for labels */
    dy = nice_step(dy);

    if (debug)
    {
	printf("label_lo= %g  label_hi= %g  label_diff=%g\n", label_lo, label_hi, label_diff);
	printf("dy=%d miny=%d\n", dy, miny);
    }
    /* first do from zero up */
    dbl_i = 0;
    while (dbl_i <= label_lo)   /* get past starting point */
	dbl_i = dbl_i + dy;
    while (dbl_i <= label_hi)
    {
	scry = miny + (dbl_i - label_lo) * 510/ label_diff;
	string = gcvt(dbl_i, 2, charbuf);
	if (debug)
	printf("string=%s, textleft=%d  scry=%d\n",string,text_left,scry);

	    aed_on();
	    aed_mov(text_left, scry );
	    aed_off();
	    write(aedfd, string, strlen(string));
	dbl_i = dbl_i + dy;
    }
    /* then do from zero down */
    dbl_i = -dy;
    while (dbl_i >= label_hi)  /* get past starting point */
	dbl_i = dbl_i - dy;
    while (dbl_i >= label_lo)
    {
	scry = miny + (dbl_i - label_lo) * 510/ label_diff;
	string = gcvt(dbl_i, 2, charbuf);
	if (debug)
	printf("string=%s, textleft=%d  scry=%d\n",string,text_left,scry);

	    aed_on();
	    aed_mov(text_left, scry );
	    aed_off();
	    write(aedfd, string, strlen(string));
	dbl_i = dbl_i - dy;
    }
}

label(argc, argv) 

int argc;
char **argv;
 
{ 
    double d_coord[2];
    char s_coord[2][40], text[40];
    int j, x, y;
    int nint;
    int status;
    char comm[20];
    struct img *imgp, *sky_to_image(), *find_SC();
    char buff[20], inbuf[20];
    int got_coord, argstart;
    int i_coord[2], j_coord[2];
    char *coord_str, *image_to_sky();

    got_coord = FALSE;
    argstart = 1;

    if (argc < 2)
    {
	printf("annotate command requires a string\n");
	error();
	return;
    }

    if (argc > 3)
    {
	if (output_coord_sys == SC)
	{
	    if (isint(argv[1]) && isint(argv[2]))
	    {
		got_coord = TRUE;
		argstart = 3;
		x = atoi(argv[1]);
		y = atoi(argv[2]);
	    }
	}
	else
	{
	    /* see if coordinates are present */
	    strcpy(s_coord[0], argv[1]);
	    strcpy(s_coord[1], argv[2]);

	    imgp = sky_to_image(s_coord, j_coord);
	    if (imgp != NULL)
	    {
		/* coords are on an image - must be good */
		got_coord = TRUE;
	    }
	    else
	    {
		/* coords not on an image - but may still be coords */
		if (str_to_coord(s_coord, d_coord))
		{
		    got_coord = TRUE;
		}
	    }
	    if (got_coord)
	    {
		argstart = 3;
		IM_to_SC(j_coord);
		x = j_coord[0];
		y = j_coord[1];
	    }
	}
    }

    /* get the text string */

    strcpy(text, argv[argstart]);

    if (!got_coord)

    {
	printf("\n   Enter 'e' to end\n");

	/* Pick the point */ 

	if (debug)
	    printf("enabling joystick\n");
	aed_on();
	buff[0] = 0x55;           /* enable joystick */
	write(aedfd, buff, 1);
	aed_off();

	/* Check for command input */       

	status = main_command(comm); 
	if(debug)
	    printf("\nlabel: command returned is %s\n", comm);

	aed_on();
	buff[0] = 0x6a;  /* read cursor position */
	write(aedfd, buff, 1);
	read(aedfd, &inbuf[0], 1);  /* get answer */
	read(aedfd, &inbuf[1], 1);  /* get answer */
	read(aedfd, &inbuf[2], 1);  /* get answer */
	aed_off();
	x = (inbuf[1] & 0xff) | ((inbuf[0] & 0xf0) << 4);
	y = (inbuf[2] & 0xff) | ((inbuf[0] & 0xf) << 8);
	if (debug)
	    printf("got hex values %x %x %x  x=%d y=%d\n", inbuf[0] & 0xff, inbuf[1] & 0xff, inbuf[2] & 0xff, x, y);
    } 

    aed_on();
    buff[0] = 0x64;  /* disable joystick */
    write(aedfd, buff, 1);
    aed_mov(x, y);
    aed_off();
    write(aedfd, text, strlen(text));
    aed_on();
    aed_off();

    /* print out final location */
    imgp = find_SC(x, y);
    i_coord[0] = x;
    i_coord[1] = y;
    SC_to_IM(i_coord);

    coord_str = image_to_sky(i_coord);
    printf("annotate at %s", coord_str);
    fprintf(session, "annotate at %s", coord_str);
} 

 
/* ROUND 
** converts a double precision number to the nearest integer 
*/ 
  
round(x) 
 
double x; 
  
{ 
     if( x - (double) floor(x) < 0.5)
          return(floor(x)); 
     else 
          return(ceil(x)); 
} 

swabboth(from_buf, to_buf, length)
char *from_buf, *to_buf;
int length;
{
    register int i;
    register short *p, temp;

    swab(from_buf, to_buf, length);
    p = (short *) to_buf;
    for(i = 0; i < length / 4; i++)
    {
        temp = *p;
        *p = *(p+1);
        *(p+1) = temp;
	p+=2;
    }
}
