/*
Copyright (C) 1995, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/* this file is used to test out new routines for skyview program */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>     /* includes strings.h, sys/time.h, and sys/file.h */
#include <X11/keysym.h>

#include "skyview.h"
#include "img_x.h"
#include "img.h"
#include "fits.h"
#include "job.h"
#include <string.h>
#include <stdio.h>
#include <pwd.h>
#include <math.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/file.h>

extern int debug;
extern int lines;
extern int pixels;
extern char filnam[], fi_name[];
extern double iraf_min, iraf_max;
extern FILE *cmdfile;
extern int hist[];
extern double hist_min, hist_binsiz;
extern unsigned char *image_org;    /* original buffer for xwindow pixels */
extern unsigned char *image_zoomed;  /* buffer for xwindow pixels after zoom */
extern double win_zoom;                /* zoom factor     */
extern unsigned int win_width, win_height;  /* current dimensions of win */
extern unsigned int width_org, height_org;  /* dimensions of image_org */
extern int win_x_offset, win_y_offset;   /* and translation */
extern int file_coord_sys, output_coord_sys;
extern double cdelt1, cdelt2, twist;
extern double	plt_scale; /* plate scale arc sec per mm */
extern double	x_pixel_size;	/* X pixel_size */
extern double	y_pixel_size;	/* Y pixel_size */
extern int maptype;
extern char server_str[];
extern struct img *curr_img;
Display *display;
extern Window win;
extern XImage *theImage;
extern unsigned width_zoomed, height_zoomed;
extern GC image_gc;

#ifdef _NO_PROTO
    void rbhmore();
    void stop_timer();
    void start_timer();
    void glop_callback();
#else
    void rbhmore(void);
    void stop_timer(void);
    void start_timer(void);
    void glop_callback(struct job_info *job);
#endif /* _NO_PROTO */

void glop_callback(job)
struct job_info *job;
{
    char input_line[100];
    static Window win;

    printf("entering glop_callback\n");
    fflush(stdout);
    fgets(input_line, 99, job->fp);
    printf("input_line = [%s]\n", input_line);
    if (strncmp(input_line, "win", 3) == 0)
    {
	sscanf(&input_line[6], "%ld", &win);
	printf("win+1 = %ld\n", win+1);
	sleep(5);
	/* Select event types wanted */
	XSelectInput(display, win, KeyPressMask | ExposureMask |
#ifdef NOTDEF
	    ButtonPressMask | 
#endif /* NOTDEF */
	    ButtonReleaseMask | 
	    StructureNotifyMask | 
	    PointerMotionMask | PointerMotionHintMask);
    }
    if (strncmp(input_line, "glop quitting", 13) == 0)
    {
	XSelectInput(display, win, 0);
	fclose(job->fp);
	del_job(job);
    }

}


/*ARGSUSED*/
void
stest(argc, argv)
int argc;
char *argv[];
{
#ifdef NOTDEF
	/* tab line */
    char bp[1024];
    int tty_lines;
    char *cmdv[10];
    int n, i, status, goodpix, pix_so_far;
    int fd[64];
    struct img *tmpimg;
    FILE *readfd, *writefd;
    struct job_info *job;
    int sav_frame;

    sav_frame = 0;
    tmpimg = find_last_img();
    while (tmpimg)
    {
	if (sav_frame == tmpimg->image_frame)
	    printf("RBH DUP FRAME\n");
	printf("frame = %d imgptr = 0x%p win_zoom = %f width_zoomed = %d height_zoomed = %d win_width = %d win_height = %d\n", 
	    tmpimg->image_frame, (void *)tmpimg, tmpimg->frameptr->win_zoom,
	    tmpimg->frameptr->width_zoomed,
	    tmpimg->frameptr->height_zoomed,
	    tmpimg->frameptr->win_width,
	    tmpimg->frameptr->win_height);
	sav_frame = tmpimg->image_frame;
	tmpimg = find_previous_img(tmpimg);
    }
#endif /* NOTDEF */



#ifdef NOTDEF
    cmdv[0] = "/home/booth/myX/glop";
    cmdv[1] = (char *) 0;

    if (duplex_pipe(cmdv, &readfd, &writefd, &job))
    {
	job->fp = readfd;
	job->imgp = curr_img;
	job->callback = glop_callback;    /* register callback */
	job->valid_callback = 1;
    }
    else
    {
	sprintf(server_str, 
	    "Unable to start background job: %s", "xv");
	error1(server_str);
    }
#endif /* NOTDEF */


#ifdef NOTDEF
    printf("height_org = %d\n", height_org);
    printf("width_org = %d\n", width_org);
    printf("win_x_offset = %d\n", win_x_offset);
    printf("win_y_offset = %d\n", win_y_offset);
    printf("win_height = %d\n", win_height);
    printf("win_width = %d\n", win_width);
    printf("win_zoom = %g\n", win_zoom);
    printf("image_org = 0x%x\n", image_org);
    printf("image_zoomed = 0x%x\n", image_zoomed);
#endif /* NOTDEF */


#ifdef NOTDEF
    for (i = 0; i < 64; i++)
    {
	fd[i] = open("/dev/null", O_RDONLY, 0644);
	if (fd[i] < 0)
	{
	    n = i;
	    printf("able to open %d files\n", n);
	    break;
	}
    }
    for (i = 0; i < n; i++)
    {
	if (fd[i] >= 0)
	{
	    close (fd[i]);
	}
    }
#endif /* NOTDEF */

#ifdef NOTDEF
    debug_graphics();
#endif /* NOTDEF */


#ifdef NOTDEF
    if (tgetent(bp, "/dev/tty") == 1)
    {
	tty_lines = tgetnum("li");
	if (tty_lines == -1)
	{
	    tty_lines = 24;
	    printf("cant find entry for li\n");
	}
    }
    else
    {
	tty_lines = 24;
	printf("cant find entry for /dev/tty\n");
    }
    printf("tty_lines = %d\n", tty_lines);
#endif /* NOTDEF */

#ifdef MALLOC_TEST
    printf("RBH testing malloc\n");
    status = malloc_verify();
    if (status == 0)
	printf("malloc_verify() indicates that errors have occurred\n");
    malloc_debug(2);
#endif /* MALLOC_TEST */

#ifdef NOTDEF
    goodpix = 0;
    for (i = 0; i < HISTSIZ2; i++)
	if (hist[i] != 0)
	    goodpix += hist[i];

    pix_so_far = 0;
    for (i = 0; i < HISTSIZ2; i++)
	if (hist[i] != 0)
	{
	    pix_so_far += hist[i];
	    printf("hist[%d] = %d  %f%%     DN = %g\n", i, hist[i], 
		(double) pix_so_far / goodpix,
		(i + 0.5) * hist_binsiz + hist_min);
	}
	printf("goodpix = %d\n", goodpix);
#endif /* NOTDEF */
    printf("exiting stest\n");
}



#define SCREENFULL 35
void
rbhmore()
{
    static int count = SCREENFULL;
    char s[20];

    if (!--count)
    {
	printf("enter CR to continue: ");
	fgets(s, 20, stdin);
	count = SCREENFULL;
    }
}

static struct timeval tpstart, tpstop;
void
start_timer()
{
    (void) gettimeofday(&tpstart, (struct timezone *) 0);
}

void
stop_timer()
{
    long delta_sec, delta_usec;

    (void) gettimeofday(&tpstop, (struct timezone *) 0);
    printf("start time = %ld seconds and %ld microseconds\n", 
	tpstart.tv_sec, tpstart.tv_usec);
    printf("stop time = %ld seconds and %ld microseconds\n", 
	tpstop.tv_sec, tpstop.tv_usec);
    delta_usec = tpstop.tv_usec - tpstart.tv_usec;
    delta_sec = tpstop.tv_sec - tpstart.tv_sec;
    if (delta_usec < 0)
    {
	delta_sec--;
	delta_usec += 1000000;
    }
    printf("elapsed time = %ld.%06ld seconds\n", 
	delta_sec, delta_usec);
	
}
