/*
Copyright (C) 1995, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/* ssplit.c */
/* Splits s files into NAXIS3 separate planes */
#include "skyview.h"
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/file.h>

struct hdrstruct filehdr;
debug = 0;
int blank, bitpix, pixels, lines;
char hist_filnam[MAXPATHLEN], filnam[MAXPATHLEN];
double hist_min, hist_binsiz, iraf_min, iraf_max;
float hist_datamax, hist_datamin;  /* max, min found while doing hist */
float fblank;
int hist[HISTSIZ2+1];
extern char *hdr_buf, *hdr_bufp_end;

main(argc, argv)
int argc;
char *argv[];
{
    double bscale, b_zero;
    int plane, i, line;
    char *p, strplane[5], *ppp, buf[2880];
    char fi_name[MAXPATHLEN], fil_name[MAXPATHLEN];
    int naxis3, bytes, bytes_per_pixel;
    int fd, fd1;
    int hist_shift, max;
    int hist[HISTSIZ2+1];
    int blocks, rdstat, hdr_bytes, bufsize;
    struct hdrstruct thdr;


    if (argc < 2)
    {
	printf("usage: ssplit filename\n");
	exit(1);
    }

    /* open input file */
    strcpy(fi_name, argv[1]);
    fd = open(fi_name, O_RDONLY, 0644);
    if (fd < 0)
    {
	perror(fi_name);    /* bad stuff - file has disappeared */
	return;
    }

    /* first read s header */

    lseek(fd, 0, 0);
    rdstat = read(fd, &thdr, sizeof(thdr));

    if (thdr.tapetype != FITS)
    {
	printf("ssplit error: %s does not look like an s workfile\n", fi_name);
	close(fd);
	return;
    }

    if (thdr.img_max > (-thdr.img_min))
	max = thdr.img_max;
    else
	max = -thdr.img_min;
    hist_shift = 0;
    while ((max >> hist_shift) > HISTSIZ)
	++hist_shift;

    /* now read old FITS header */
    bufsize = (thdr.img_start - thdr.hdr_start) / 2880; /* number of blocks */
    bufsize += 2; /* room for more */
    bufsize = bufsize * 2880;
    hdr_buf = (char *) malloc(bufsize);
    if (hdr_buf == 0)
    {
	printf ("error allocating space for ssplit\n");
	return;
    }

    lseek(fd, thdr.hdr_start, 0);
    rdstat = read (fd, hdr_buf, thdr.img_start - thdr.hdr_start);
    if (rdstat < 0)
    {
	printf("error reading input file\n");
	exit(1);
    }

    /* find END keyword */
    if (hdrinit(bufsize) == FALSE)
    {
	printf("ssplit error: no END in FITS header\n");
	return;
    }

    /* now parse old FITS header */
    bitpix = 0;
    pixels = 0;
    lines = 0;
    naxis3 = 0;
    bscale = 1;
    b_zero = 0;

	/* look for BITPIX and END keywords */

	p = hdr_buf;
	for (i=0; i<36; i++, p += 80)
	{
	    if (bcmp (p, "NAXIS1  ", 8) == 0)
		pixels = atoi(p+10);
	    if (bcmp (p, "NAXIS2  ", 8) == 0)
		lines = atoi(p+10);
	    if (bcmp (p, "NAXIS3  ", 8) == 0)
		naxis3 = atoi(p+10);
	    if (bcmp (p, "BSCALE  ", 8) == 0)
		bscale = atof(p+10);
	    if (bcmp (p, "BZERO   ", 8) == 0)
		b_zero = atof(p+10);
	    if (bcmp (p, "BITPIX  ", 8) == 0)
		bitpix = atoi(p+10);
	    if (bcmp (p, "BLANK   ", 8) == 0)
		blank = atoi(p+10);
	}

    if (naxis3 <= 1)
    {
	printf("ssplit error:  image file does not have multiple planes\n");
	return;
    }

    hdrint("NAXIS3", 1);
    /* the next two values will change, but need to reserve space */
    hdrfloat("DATAMIN", (float) 0);
    hdrfloat("DATAMAX", (float) 0);

    blocks = (hdr_bufp_end - hdr_buf) / 2880;
    if ((blocks * 2880) != (hdr_bufp_end - hdr_buf))
	blocks++;  /* round up to next integral number of blocks */
    hdr_bytes = blocks * 2880;
    ppp = hdr_bufp_end;
    while (ppp < hdr_buf + hdr_bytes)
	*ppp++ = ' ';                /* pad out with spaces */

    bytes_per_pixel = bitpix / 8;
    bytes = pixels * bytes_per_pixel;


    for (plane = 1; plane <= naxis3; plane++)
    {

    /* open output file */
    strcpy(fil_name, fi_name);
    strcat(fil_name, ".pl");
    sprintf(strplane, "%d", plane);
    strcat(fil_name, strplane);


    fd1 = open(fil_name, O_RDWR | O_CREAT | O_TRUNC, 0644);
    if (fd1 < 0)
    {
	perror(fil_name);
	return;
    }

    for (i=0; i<HISTSIZ2+1; i++)
	hist[i] = 0;
    thdr.img_max = 0x80000001;
    thdr.img_min = 0x7fffffff;

    /* first write s header */
    write(fd1, &thdr, sizeof(thdr));

    /* now write old FITS header */
    write(fd1, hdr_buf, hdr_bytes);

    thdr.img_start = lseek(fd1, 0, 1);

    for (line = 0; line < lines; line++)
    {
	rdstat = read(fd, buf, bytes);
	if (rdstat == bytes)
	{
	    write(fd1, buf, bytes);
	    /* compute histogram */
	    get_hist(bitpix, buf, pixels, &thdr.img_min, &thdr.img_max, blank, hist_shift, hist);
	}
	else
	{
	    printf("cannot read workfile \n");
	    close(fd1);
	    close(fd);
	    return;
	}
    }
    thdr.hist_start = lseek(fd1, 0, 1);
    write(fd1, hist, sizeof(hist));
    thdr.hist_bin_size = 1 << hist_shift;

    hdrfloat("DATAMIN", thdr.img_min * bscale + b_zero);
    hdrfloat("DATAMAX", thdr.img_max * bscale + b_zero);
    lseek(fd1, thdr.hdr_start, 0);
    write(fd1, hdr_buf, hdr_bytes);

    thdr.tapetype = FITS;
    lseek(fd1, 0, 0);
    write(fd1, &thdr, sizeof(thdr));
    close(fd1);
    }
    free(hdr_buf);
    close(fd);
}

imget()
{
}

error()
{
}
