/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include <sys/types.h>

#define FALSE 0
#define TRUE 1
#define FOREVER TRUE
#define FITS 46
#define VICAR 47
#define IMFILE 48
#define IRAF 7143529
#define SCREEN 52
#define INVALID 53
#define NCOLS 7  /* font dimensions */
#define NROWS 9
#define NOT_SPECIFIED 6
#define DEFAULT 7

    /* histogram handles positive and negative pixels */
    /* to increment histogram with 16 bit (signed) pixel value:  */
    /*  hist[ (value >> hist_shift) + HISTSIZ] += 1  */
#define HISTSIZ 2048  /* half size of hist array */
			/* ( hist[HISTSIZ] corresponds to pixel value 0 */
#define HISTSIZ2 4096  /* full size of hist array */

	    /* figure out shift for histogram */
	    /*  if HISTSIZ == 1024, hist_shift = 5 */ 
	    /*  if HISTSIZ == 2048, hist_shift = 4 */ 
	    /*  if HISTSIZ == 4096, hist_shift = 3, ect. */ 
#define HIST_SHIFT  4

struct hdrstruct {
    int tapetype;
    off_t hdr_start;
    off_t img_start;
    off_t hist_start;
    int img_max;   /* in DN */
    int img_min;   /* in DN */
    int hist_bin_size;
    };


#ifdef NO_IEEE
#define FINITE(x)  ((x) != blank_flag)
extern double blank_flag;
#else
#ifdef USE_ISINFINITE
/* compiler has function isfinite()  (C99) */
#define FINITE(x) isfinite(x)
#else
/* compiler has function finite()  (BSD) */
#define FINITE(x) finite(x)
#endif /* NEEDS_ISINFINITE */
#endif /* IEEE */

/* function prototypes */
#ifdef _NO_PROTO

void error1();
#ifdef NO_STRERROR
char *strerror();
#endif /* NO_STRERROR */
void srvflush();
void kill_contour_job();
void enable_control_c();
void alias();
void label();
void chgband();
void background();
void border();
void change_area();
void ch_dir();
void sho_curr_img();
void clip();
void curr_map_parms();
void cplot();
void crop();
void set_coord_system();
void set_coord_sys3();
void chgtbl();
void cutoff();
void define_area();
void delete_file();
void dir();
void rddisk();
void erase();
void examine_area();
void chgfil();
void flatten();
void fov();
void find_plate();
void frame_cmd();
void gexamine();
void gpick();
void gpoint();
void grid_cmd();
void header();
void hi_cmd();
void ho_cmd();
void map();
void mark();
void mag_cmd();
void manual_page();
void memdump();
void mode_set();
void on();
void off();
void origin();
void paint_blank();
void print_history();
void pick();
void pixcoord();
void point();
void post_cmd();
void pwd();
void range();
void replicate();
void rewind_tape();
void scatter_plot();
void screen_dump();
void set();
void set_history();
void sky_box();
void slice();
void sleep_cmd();
void smongo();
void split();
void st_cmd();
void sync_command();
void take();
void table();
void tek_cmd();
void stest();
void rdtape();
void writetape();
void vector();
void wedgecmd();
void write_image();
void zap();
void zoom_pan();
void help();
int getint();
void srv_string();
void srv_real();
void srvinit();
void srvcmd1();
void get_resources();
int init_graphics();
void ball_setup();
void image_setup();
void color_setup();
void start_imio();
int getcmd();
void close_take();
void load_aliases();
void helpinit();
void error_na();
void wait_for_event();
void close_graphics();
void sperror();
void srv_coord();
void get_param();
void do_sync();
void expand_alias();
int isint();
int isdbl();
void main_command();

/* table file routines */
void get_table_line();
void table_close();
void print_header_line();
int cmd();
int parse_fits();
void imhd();
void describe_area();
int switch_area();
int Round();
void draw_outline();
void overlay_setup();
void circle();
void ellipse();
void polygon();
void set_box();
void SC_to_IM();
void IM_to_SC();
void dIM_to_SC();
void dSC_to_IM();
void SC_to_WIN();
void dSC_to_WIN();
void WIN_to_SC();
void dWIN_to_SC();
void dIRAF_to_SC();
void deproject();
void find_range();
void segment_setup();
void x_list();
int set_current_window();
void overlay_color();
void next_bundle();
void flux_IRAF();
void do_mark();
int str_to_coord();
void sl_vector();
void overlay_dmov();
void overlay_ddraw();
void overlay_ddraw_n();
void flush_graphics();
int get_screen_height();
int get_screen_width();
int get_screen_bottom();
int get_screen_left();
void set_file_sys();
void scatter_sub();
int first_block();
int next_block();
void get_hist();
void d_get_center_xy();
void update_cur_window();
char *coord_name();
void clear_table_names();
void stretch();
void off_all_X_overlay();
void off_X_overlay();
void zoom_setup();
void set_overlay();
void set_overlay_mask();
void set_clt();
void st_ball();
void change_pixel_name();
void change_win_name();
char *maptype_string();
int position();
int on_horizontal();
void EC_to_EQ();
void GA_to_EQ();
void EQ_to_EC();
void GA_to_EC();
void EQ_to_GA();
void EC_to_GA();
void coord_to_string();
void dIM_to_IRAF();
void dIRAF_to_IM();
void dSC_to_IRAF();
int isnbr();
int hdrinit();
void hdrlogical();
void hdrint();
void hdrfloat();
void hdrstr();
void comment();
void repaintm32();
int agra_scale();
int parse_size();
int show_frame();
void wait_for_windowmgr();
void force_reread();
void next_frame();
void initial_zoom();
int need_hist();
void check_hist();
void wedge();
void map_for_AOI();
void write_AOI();
void map_normal();
void *imget();
double get_pct();
void create_hist_window();
void fov_plot();
void get_center_xy();
int trackball_pick();
void mark_the_spot();
int find_mark();
void repaint_x();
void trackball_mark();
int good_overlay_color();
void save_overlay_color();
void restore_overlay_color();
int set_overlay_color();
void trackball_zoom();
void do_zoom_pan();
void overlay_dcircle();
void fov_joy();
void stop_imio();
void overlay_darea();
void cursor_callback();
char *expand_path();
void erase_graphics_bundle();
void erase_graphics_color();
void debug_graphics();
void overlay_dellipse();
void erase_graphics_trackball();
void delete_all_RGB();
void expose_all();
void not_implemented();
void mag_expose();
void mag_destroy();
void mag_configure();
void hist_expose();
void hist_destroy();
void hist_configure();
void wedge_now();
void wedge_expose();
void wedge_destroy();
void wedge_configure();
void sc_expose();
void sc_destroy();
void sc_configure();
char *dimage_to_sky();
double dn_to_jy();
double jy_to_dn();
char *tek_sequence();
int parse_equinox();
void mlabel();
void movie();
void save_coord_sys();
void restore_coord_sys();
int max_FRAME();
char *sdata_filename();
void *zap_flux();
double nice_step();
double position_angle_bias();
void *imget_nofile();
void movie_prep();
void iraf_ct();
int set_blank_color();
void draw_border();
void srv_start_array();
void srv_end_array();
void srv_coord_val();
int set_desired_sex();
void pixcoord();

#else

#ifndef ERROR1_DEFINED
void error1(char *str);
#define ERROR1_DEFINED
#endif
#ifdef NO_STRERROR
char *strerror(int errnbr);
#endif /* NO_STRERROR */
void srvflush(char *str, int want_command, int want_end);
void kill_contour_job(void);
void enable_control_c(void);
void alias(int argc, char *argv[]);
void label(int argc, char *argv[]);
void chgband(int argc, char *argv[]);
void background(int argc, char *argv[]);
void border(int argc, char *argv[]);
void change_area(int argc, char *argv[]);
void ch_dir(int argc, char *argv[]);
void sho_curr_img(int argc, char *argv[]);
void clip(int argc, char *argv[]);
void curr_map_parms(int argc, char *argv[]);
void cplot(int argc, char *argv[]);
void crop(int argc, char *argv[]);
void set_coord_system(int argc, char *argv[]);
void set_coord_sys3(int argc, char *argv[], int silent);
void chgtbl(int argc, char *argv[]);
void cutoff(int argc, char *argv[]);
void define_area(int argc, char *argv[]);
void delete_file(int argc, char *argv[]);
void dir(int argc, char *argv[]);
void rddisk(int argc, char *argv[]);
void erase(int argc, char *argv[]);
void examine_area(int argc, char *argv[]);
void chgfil(int argc, char *argv[]);
void flatten(int argc, char *argv[]);
void fov(int argc, char *argv[]);
void find_plate(int argc, char *argv[]);
void frame_cmd(int argc, char *argv[]);
void gexamine(int argc, char *argv[]);
void gpick(int argc, char *argv[]);
void gpoint(int argc, char *argv[]);
void grid_cmd(int argc, char *argv[]);
void header(int argc, char *argv[]);
void hi_cmd(int argc, char *argv[]);
void ho_cmd(int argc, char *argv[]);
void map(int argc, char *argv[]);
void mark(int argc, char *argv[]);
void mag_cmd(int argc, char *argv[]);
void manual_page(int argc, char *argv[]);
void memdump(int argc, char *argv[]);
void mode_set(int argc, char *argv[]);
void on(int argc, char *argv[]);
void off(int argc, char *argv[]);
void origin(int argc, char *argv[]);
void paint_blank(int argc, char *argv[]);
void print_history(int argc, char *argv[]);
void pick(int argc, char *argv[]);
void point(int argc, char *argv[]);
void post_cmd(int argc, char *argv[]);
void pwd(int argc, char *argv[]);
void range(int argc, char *argv[]);
void replicate(int argc, char *argv[]);
void rewind_tape(void);
void scatter_plot(int argc, char *argv[]);
void screen_dump(int argc, char *argv[]);
void set(int argc, char *argv[]);
void set_history(int argc, char *argv[]);
void sky_box(int argc, char *argv[]);
void slice(int argc, char *argv[]);
void sleep_cmd(int argc, char *argv[]);
void smongo(int argc, char *argv[]);
void split(int argc, char *argv[]);
void st_cmd(int argc, char *argv[]);
void sync_command(int argc, char *argv[]);
void take(int argc, char *argv[]);
void table(int argc, char *argv[]);
void tek_cmd(int argc, char *argv[]);
void stest(int argc, char *argv[]);
void rdtape(int argc, char *argv[]);
void writetape(int argc, char *argv[]);
void vector(int argc, char *argv[]);
void wedgecmd(int argc, char *argv[]);
void write_image(int argc, char *argv[]);
void zap(int argc, char *argv[]);
void zoom_pan(int argc, char *argv[]);
void help(int argc, char *argv[]);
int getint(char *str, int *iret);
void srv_string(char *keyword, char *str);
void srv_real(char *keyword, char *str);
void srvinit(void);
void srvcmd1(char *str);
void get_resources(int *argc, char *argv[]);
int init_graphics(void);
void ball_setup(void);
void image_setup(int pl);
void color_setup(void);
void start_imio(void);
int getcmd(int *cmdc, char *cmdv[]);
void close_take(void);
void load_aliases(char *name);
void helpinit(void);
void error_na(char *str);
void wait_for_event(char *pptr, int *what, int *x, int *y, int *dx, int *dy, 
    int nowait);
void close_graphics(void);
void sperror(char *str, int this_errno);
void srv_coord(char *name, int coord_sys, char s_coord[][40], double equinox,
    int jsys);
void get_param(char *com);
void do_sync(void);
void expand_alias(char *in, char *out);
int isint(char *str);
int isdbl(char *str, double *dbl_ptr);
void main_command(char *p);

/* table file routines */
void get_table_line(char *anin);
void table_close(void);
void print_header_line(char *pt);
int cmd(char *p);
int parse_fits(char *p);
void imhd(int id);
void describe_area(int area_num);
int switch_area(char *instr);
int Round(double x);
void draw_outline(int overlay_plane, int color);
void overlay_setup(int plane1);
void circle(double radius);
void ellipse(void);
void polygon(void);
void set_box(double *xx1, double *yy1, double *xx2, double *yy2);
void SC_to_IM(int i_coord[]);
void IM_to_SC(int i_coord[]);
void dIM_to_SC(double d_coord[]);
void dSC_to_IM(double d_coord[]);
void SC_to_WIN(int i_coord[]);
void dSC_to_WIN(double d_coord[]);
void WIN_to_SC(int i_coord[]);
void dWIN_to_SC(double d_coord[]);
void dIRAF_to_SC(double d_coord[]);
void deproject(double coord[], double d_coord[]);
void find_range(int *min_x, int *max_x, int *min_y, int *max_y);
void segment_setup(void);
void x_list(int y);
int set_current_window(void);
void overlay_color(int c);
void next_bundle(void);
void flux_IRAF(int i_coord[], double fluxes[]);
void do_mark(double x, double y, int markertype, int markersize, 
    int markersize2, int markersize3);
int str_to_coord(char s_coord[][40], double coord[]);
void sl_vector(double d_coord[], double d_coord2[]);
void overlay_dmov(double x, double y);
void overlay_ddraw(double x, double y);
void overlay_ddraw_n(double x, double y, int xor);
void overlay_darc(double radius, double angle1, double angle_extent);
void flush_graphics(void);
int get_screen_height(void);
int get_screen_width(void);
int get_screen_bottom(void);
int get_screen_left(void);
void set_file_sys(void);
void scatter_sub(double *stashtemp, double *stashtemp1, 
    double dnmin[2], double dnmax[2], int stash_count,
    double *x, double *y, double *x2, double *y2);
int first_block(int mmfd, char *his_bufptr, int his_bytes);
int next_block(int mmfd, char *his_bufptr, int his_bytes);
void get_hist(int bitpix, void *buf, int ri, int *min, int *max, 
    double blank, int hist_shift, int hist1[]);
void d_get_center_xy(double d_coord[2]);
void update_cur_window(void);
char *coord_name(int coord_sys);
void clear_table_names(void);
void stretch(int llow, int hhigh);
void off_all_X_overlay(int on_off);
void off_X_overlay(char *color, int on_off);
void zoom_setup(void);
void set_overlay(void);
void set_overlay_mask(int dmask);
void set_clt(unsigned char *r, unsigned char *g, unsigned char *b);
void st_ball(void);
void change_pixel_name(char *old_name, char *new_name, int dirty_flag);
void change_win_name(char *window_name);
char *maptype_string(int m);
int position(int x);
int on_horizontal(int x, int y);
void EC_to_EQ(double coord[]);
void GA_to_EQ(double coord[]);
void EQ_to_EC(double coord[]);
void GA_to_EC(double coord[]);
void EQ_to_GA(double coord[]);
void EC_to_GA(double coord[]);
void coord_to_string( double coord[], char s_coord[][40]);
void dIM_to_IRAF(double d_coord[]);
void dIRAF_to_IM(double d_coord[]);
void dSC_to_IRAF(double d_coord[]);
int isnbr(char *str);
int hdrinit(int bufsize);
void hdrlogical(char word[], int chr);
void hdrint(char word[], int i);
void hdrfloat(char word[], double value);
void hdrstr(char word[], char str[]);
void comment(char str[]);
void repaintm32(int min_samp, int max_samp, int min_line, int max_line, 
    void *filptr);
int agra_scale(char *filename, char *lon, char *lat);
int parse_size(char *geom, int *width_ptr, int *height_ptr);
int show_frame(char *geom, int zp, char *labelptr);
void wait_for_windowmgr(int force);
void force_reread(char *fname);
void next_frame(void);
void initial_zoom(void);
int need_hist(void);
void check_hist(int fd);
void wedge(int x_min, int y_min, int x_max, int y_max);
void map_for_AOI(int this_plane);
void write_AOI(int xmin, int ymin, int xmax, int ymax, int *inptr);
void map_normal(void);
void *imget(int fd, char *f_name);
double get_pct(double ra_value);
void create_hist_window(void);
void fov_plot(double x_center, double y_center, double rot_angle, 
    int skeleton_only);
void get_center_xy(int i_coord[]);
int trackball_pick(int *x, int *y, int *winx, int *winy);
void mark_the_spot(int x, int y);
int find_mark(int xin, int yin);
void repaint_x(int min_samp, int max_samp, int min_line, int max_line);
void trackball_mark(void);
int good_overlay_color(char *color);
void save_overlay_color(void);
void restore_overlay_color(void);
int set_overlay_color(char *color);
void trackball_zoom(void);
void do_zoom_pan(int argc, double *tmpzoom, int *xc, int *yc, int do_expose);
void overlay_dcircle(double radius);
void fov_joy(double *rot_angle, double d_coord[2]);
void stop_imio(void);
void overlay_darea(double x, double y, int end);
void cursor_callback(int xwin, int ywin, int key_pressed);
char *expand_path(char *inpath);
void erase_graphics_bundle(int bundle);
void erase_graphics_color(char *color);
void debug_graphics(void);
void overlay_dellipse(double width, double height, double angle);
void erase_graphics_trackball(void);
void delete_all_RGB(void);
void expose_all(void);
void not_implemented(void);
void mag_expose(void);
void mag_destroy(void);
void mag_configure(unsigned int width, unsigned int height);
void hist_expose(void);
void hist_destroy(void);
void hist_configure(unsigned int width, unsigned int height);
void wedge_now(void);
void wedge_expose(int colors_only);
void wedge_destroy(void);
void wedge_configure(unsigned int width, unsigned height);
void sc_expose(void);
void sc_destroy(void);
void sc_configure(unsigned int width, unsigned int height);
char *dimage_to_sky(double d_coord[], char s_coord[][40], int *coord_sys, 
    double *output_equinox, int *output_jsys);
double dn_to_jy(double dn);
double jy_to_dn(double jy);
char *tek_sequence(char *anin);
void jcnvc2(int isys1, double epoki, double x0, double y0,
int isys2, double epoko, double *xnew, double *ynew, double tobsin);
void jcnvp2(int jsysin, double epokpa, double distin, double pain,
double epoki, double xlonin, double xlatin, double tobsin,
int jsysou, double epoko, double *paou, double *xlonou, double *xlatou, int *ierr);
int parse_equinox(char *p, char *outstr, double *equinox_val, char *equinox_char);
void mlabel(double lon0, double lat0, char *str, double chh, int xor);
void movie(int argc, char *argv[]);
void save_coord_sys(void);
void restore_coord_sys(void);
int max_FRAME(void);
char *sdata_filename(char *name);
void *zap_flux(int i_coord[]);
double nice_step(double dy);
double position_angle_bias(double d_coord[]);
void *imget_nofile(int totbytes, char *f_name);
void movie_prep(int argc, char **argv);
void iraf_ct(void);
int set_blank_color(char *color);
void draw_border(void);
void srv_start_array(char *name);
void srv_end_array(int nbr_elts);
void srv_coord_val(char *name, int coord_sys, char s_coord[][40],
    double equinox, int jsys, char *value, char *units);
int set_desired_sex(char *sex_str);
void pixcoord(int argc, char *argv[]);


#endif /* _NO_PROTO */
