/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/*
 *  skyplate   :: Same old code new wrapper
 *                 find Skyflux plate containing a position and
 *                 the tape containing the plate
 *  Mon Apr  1 17:10:58 PST 1991  R.Ebert
 *  Converted to standalone program
 *  expect  input   "skyplate  ra1950  dec1950"
 *  Formerly an S built-in
 *  Thu Nov 18 17:26:53 PST 1993
 *  added an extra layer of braces in the platedata structure
 *  to make gcc and Solaris(?) ansi c compilers happy.
 *  Note lines with {{{...}}}.  I think this is a bug in the
 *  compilers because the ansi spec allow elidition of braces
 *  when the next subaggregate begins with braces.  (cf. Kernighan & Ritchie
 *  2nd edition "The C prog. language", sec A8.7).  Rick Ebert.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define TRUE  1
#define FALSE !TRUE

/* compile in the plate tape data for this version               */
/* The contents of this struct come from the former tapes.s file */
struct
{
     struct
     {
	 char label[7];
	 int  filen;
     } tapefil[3];      /* 0 is hcon 1; 1 is hcon 2; 2 is hcon 3 */
}   platedata[] = 
{
  {{{    "",  0},{   "",  0},{   "",  0}}},      /* Take up space:  0 */
  {{{    "SH1901",  1},{   "SH2901",  1},{   "SH3901",  1}}},  /*   1 */
  {{{    "SH1901",  9},{   "SH2901",  9},{   "SH3901",  9}}},  /*   2 */
  {{{    "SH1901", 17},{   "SH2901", 17},{   "SH3901", 17}}},  /*   3 */
  {{{    "SH1901", 25},{   "SH2901", 25},{   "SH3901", 25}}},  /*   4 */
  {{{    "SH1901", 33},{   "SH2901", 33},{   "SH3901", 33}}},  /*   5 */
  {{{    "SH1901", 41},{   "SH2901", 41},{   "SH3901", 41}}},  /*   6 */
  {{{    "SH1901", 49},{   "SH2901", 49},{   "SH3901", 49}}},  /*   7 */
  {{{    "SH1901", 57},{   "SH2901", 57},{   "SH3901", 57}}},  /*   8 */
  {{{    "SH1902",  1},{   "SH2902",  1},{   "SH3902",  1}}},  /*   9 */
  {{{    "SH1902",  9},{   "SH2902",  9},{   "SH3902",  9}}},  /*  10 */
  {{{    "SH1902", 17},{   "SH2902", 17},{   "SH3902", 17}}},  /*  11 */
  {{{    "SH1902", 25},{   "SH2902", 25},{   "SH3902", 25}}},  /*  12 */
  {{{    "SH1902", 33},{   "SH2902", 33},{   "SH3902", 33}}},  /*  13 */
  {{{    "SH1902", 41},{   "SH2902", 41},{   "SH3902", 41}}},  /*  14 */
  {{{    "SH1902", 49},{   "SH2902", 49},{   "SH3902", 49}}},  /*  15 */
  {{{    "SH1902", 57},{   "SH2902", 57},{   "SH3902", 57}}},  /*  16 */
  {{{    "SH1903",  1},{   "SH2903",  1},{   "SH3903",  1}}},  /*  17 */
  {{{    "SH1903",  9},{   "SH2903",  9},{   "SH3903",  9}}},  /*  18 */
  {{{    "SH1903", 17},{   "SH2903", 17},{   "SH3903", 17}}},  /*  19 */
  {{{    "SH1903", 25},{   "SH2903", 25},{   "SH3903", 25}}},  /*  20 */
  {{{    "SH1903", 33},{   "SH2903", 33},{   "SH3903", 33}}},  /*  21 */
  {{{    "SH1903", 41},{   "SH2903", 41},{   "SH3903", 41}}},  /*  22 */
  {{{    "SH1903", 49},{   "SH2903", 49},{   "SH3903", 49}}},  /*  23 */
  {{{    "SH1903", 57},{   "SH2903", 57},{   "SH3903", 57}}},  /*  24 */
  {{{    "SH1904",  1},{   "SH2904",  1},{   "SH3904",  1}}},  /*  25 */
  {{{    "SH1904",  9},{   "SH2904",  9},{   "SH3904",  9}}},  /*  26 */
  {{{    "SH1904", 17},{   "SH2904", 17},{   "SH3904", 17}}},  /*  27 */
  {{{    "SH1904", 25},{   "SH2904", 25},{   "SH3904", 25}}},  /*  28 */
  {{{    "SH1904", 33},{   "SH2904", 33},{   "SH3904", 33}}},  /*  29 */
  {{{    "SH1904", 41},{   "SH2904", 41},{   "SH3904", 41}}},  /*  30 */
  {{{    "SH1904", 49},{   "SH2904", 49},{   "SH3904", 49}}},  /*  31 */
  {{{    "SH1904", 57},{   "SH2904", 57},{   "SH3904", 57}}},  /*  32 */
  {{{    "SH1905",  1},{   "SH2905",  1},{   "SH3905",  1}}},  /*  33 */
  {{{    "SH1905",  9},{   "SH2905",  9},{   "SH3905",  9}}},  /*  34 */
  {{{    "SH1905", 17},{   "SH2905", 17},{   "SH3905", 17}}},  /*  35 */
  {{{    "SH1905", 25},{   "SH2905", 25},{   "SH3905", 25}}},  /*  36 */
  {{{    "SH1905", 33},{   "SH2905", 33},{   "SH3905", 33}}},  /*  37 */
  {{{    "SH1905", 41},{   "SH2905", 41},{   "SH3905", 41}}},  /*  38 */
  {{{    "SH1905", 49},{   "SH2905", 49},{   "SH3905", 49}}},  /*  39 */
  {{{    "SH1905", 57},{   "SH2905", 57},{   "SH3905", 57}}},  /*  40 */
  {{{    "SH1906",  1},{   "SH2906",  1},{   "SH3906",  1}}},  /*  41 */
  {{{    "SH1906",  9},{   "SH2906",  9},{   "SH3906",  9}}},  /*  42 */
  {{{    "SH1906", 17},{   "SH2906", 17},{   "SH3906", 17}}},  /*  43 */
  {{{    "SH1906", 25},{   "SH2906", 25},{   "SH3906", 25}}},  /*  44 */
  {{{    "SH1906", 33},{   "SH2906", 33},{   "SH3906", 33}}},  /*  45 */
  {{{    "SH1906", 41},{   "SH2906", 41},{   "SH3906", 41}}},  /*  46 */
  {{{    "SH1906", 49},{   "SH2906", 49},{   "NONE"  ,  0}}},  /*  47 */
  {{{    "SH1906", 57},{   "SH2906", 57},{   "SH3906", 49}}},  /*  48 */
  {{{    "SH1907",  1},{   "SH2907",  1},{   "SH3906", 57}}},  /*  49 */
  {{{    "SH1907",  9},{   "SH2907",  9},{   "SH3907",  1}}},  /*  50 */
  {{{    "SH1907", 17},{   "SH2907", 17},{   "SH3907",  9}}},  /*  51 */
  {{{    "SH1907", 25},{   "SH2907", 25},{   "SH3907", 17}}},  /*  52 */
  {{{    "SH1907", 33},{   "SH2907", 33},{   "SH3907", 25}}},  /*  53 */
  {{{    "SH1907", 41},{   "SH2907", 41},{   "SH3907", 33}}},  /*  54 */
  {{{    "SH1907", 49},{   "SH2907", 49},{   "SH3907", 41}}},  /*  55 */
  {{{    "SH1907", 57},{   "SH2907", 57},{   "SH3907", 49}}},  /*  56 */
  {{{    "SH1908",  1},{   "SH2908",  1},{   "SH3907", 57}}},  /*  57 */
  {{{    "SH1908",  9},{   "SH2908",  9},{   "SH3908",  1}}},  /*  58 */
  {{{    "SH1908", 17},{   "SH2908", 17},{   "SH3908",  9}}},  /*  59 */
  {{{    "SH1908", 25},{   "SH2908", 25},{   "NONE"  ,  0}}},  /*  60 */
  {{{    "SH1908", 33},{   "SH2908", 33},{   "SH3908", 17}}},  /*  61 */
  {{{    "SH1908", 41},{   "SH2908", 41},{   "SH3908", 25}}},  /*  62 */
  {{{    "SH1908", 49},{   "SH2908", 49},{   "SH3908", 33}}},  /*  63 */
  {{{    "SH1908", 57},{   "SH2908", 57},{   "SH3908", 41}}},  /*  64 */
  {{{    "SH1909",  1},{   "SH2909",  1},{   "SH3908", 49}}},  /*  65 */
  {{{    "SH1909",  9},{   "SH2909",  9},{   "SH3908", 57}}},  /*  66 */
  {{{    "SH1909", 17},{   "SH2909", 17},{   "SH3909",  1}}},  /*  67 */
  {{{    "SH1909", 25},{   "SH2909", 25},{   "SH3909",  9}}},  /*  68 */
  {{{    "SH1909", 33},{   "SH2909", 33},{   "SH3909", 17}}},  /*  69 */
  {{{    "SH1909", 41},{   "SH2909", 41},{   "NONE"  ,  0}}},  /*  70 */
  {{{    "SH1909", 49},{   "SH2909", 49},{   "NONE"  ,  0}}},  /*  71 */
  {{{    "SH1909", 57},{   "SH2909", 57},{   "NONE"  ,  0}}},  /*  72 */
  {{{    "SH1910",  1},{   "SH2910",  1},{   "SH3909", 25}}},  /*  73 */
  {{{    "SH1910",  9},{   "SH2910",  9},{   "SH3909", 33}}},  /*  74 */
  {{{    "SH1910", 17},{   "SH2910", 17},{   "SH3909", 41}}},  /*  75 */
  {{{    "SH1910", 25},{   "SH2910", 25},{   "SH3909", 49}}},  /*  76 */
  {{{    "SH1910", 33},{   "SH2910", 33},{   "SH3909", 57}}},  /*  77 */
  {{{    "SH1910", 41},{   "SH2910", 41},{   "SH3910",  1}}},  /*  78 */
  {{{    "SH1910", 49},{   "SH2910", 49},{   "SH3910",  9}}},  /*  79 */
  {{{    "SH1910", 57},{   "SH2910", 57},{   "SH3910", 17}}},  /*  80 */
  {{{    "SH1911",  1},{   "SH2911",  1},{   "SH3910", 25}}},  /*  81 */
  {{{    "SH1911",  9},{   "SH2911",  9},{   "SH3910", 33}}},  /*  82 */
  {{{    "SH1911", 17},{   "SH2911", 17},{   "NONE"  ,  0}}},  /*  83 */
  {{{    "SH1911", 25},{   "SH2911", 25},{   "NONE"  ,  0}}},  /*  84 */
  {{{    "SH1911", 33},{   "SH2911", 33},{   "SH3910", 41}}},  /*  85 */
  {{{    "SH1911", 41},{   "SH2911", 41},{   "SH3910", 49}}},  /*  86 */
  {{{    "SH1911", 49},{   "SH2911", 49},{   "SH3910", 57}}},  /*  87 */
  {{{    "SH1911", 57},{   "SH2911", 57},{   "SH3911",  1}}},  /*  88 */
  {{{    "SH1912",  1},{   "SH2912",  1},{   "SH3911",  9}}},  /*  89 */
  {{{    "SH1912",  9},{   "SH2912",  9},{   "SH3911", 17}}},  /*  90 */
  {{{    "SH1912", 17},{   "SH2912", 17},{   "SH3911", 25}}},  /*  91 */
  {{{    "SH1912", 25},{   "SH2912", 25},{   "SH3911", 33}}},  /*  92 */
  {{{    "SH1912", 33},{   "SH2912", 33},{   "SH3911", 41}}},  /*  93 */
  {{{    "SH1912", 41},{   "SH2912", 41},{   "NONE"  ,  0}}},  /*  94 */
  {{{    "SH1912", 49},{   "SH2912", 49},{   "NONE"  ,  0}}},  /*  95 */
  {{{    "SH1912", 57},{   "SH2912", 57},{   "NONE"  ,  0}}},  /*  96 */
  {{{    "SH1913",  1},{   "SH2913",  1},{   "NONE"  ,  0}}},  /*  97 */
  {{{    "SH1913",  9},{   "SH2913",  9},{   "SH3911", 49}}},  /*  98 */
  {{{    "SH1913", 17},{   "SH2913", 17},{   "SH3911", 57}}},  /*  99 */
  {{{    "SH1913", 25},{   "SH2913", 25},{   "SH3912",  1}}},  /* 100 */
  {{{    "SH1913", 33},{   "SH2913", 33},{   "SH3912",  9}}},  /* 101 */
  {{{    "SH1913", 41},{   "SH2913", 41},{   "SH3912", 17}}},  /* 102 */
  {{{    "SH1913", 49},{   "SH2913", 49},{   "SH3912", 25}}},  /* 103 */
  {{{    "SH1913", 57},{   "SH2913", 57},{   "SH3912", 33}}},  /* 104 */
  {{{    "SH1914",  1},{   "SH2914",  1},{   "SH3912", 41}}},  /* 105 */
  {{{    "SH1914",  9},{   "SH2914",  9},{   "SH3912", 49}}},  /* 106 */
  {{{    "SH1914", 17},{   "SH2914", 17},{   "NONE"  ,  0}}},  /* 107 */
  {{{    "SH1914", 25},{   "SH2914", 25},{   "NONE"  ,  0}}},  /* 108 */
  {{{    "SH1914", 33},{   "SH2914", 33},{   "SH3912", 57}}},  /* 109 */
  {{{    "SH1914", 41},{   "SH2914", 41},{   "SH3913",  1}}},  /* 110 */
  {{{    "SH1914", 49},{   "SH2914", 49},{   "SH3913",  9}}},  /* 111 */
  {{{    "SH1914", 57},{   "SH2914", 57},{   "SH3913", 17}}},  /* 112 */
  {{{    "SH1915",  1},{   "SH2915",  1},{   "SH3913", 25}}},  /* 113 */
  {{{    "SH1915",  9},{   "SH2915",  9},{   "SH3913", 33}}},  /* 114 */
  {{{    "SH1915", 17},{   "SH2915", 17},{   "SH3913", 41}}},  /* 115 */
  {{{    "SH1915", 25},{   "SH2915", 25},{   "SH3913", 49}}},  /* 116 */
  {{{    "SH1915", 33},{   "SH2915", 33},{   "SH3913", 57}}},  /* 117 */
  {{{    "SH1915", 41},{   "SH2915", 41},{   "NONE"  ,  0}}},  /* 118 */
  {{{    "SH1915", 49},{   "SH2915", 49},{   "NONE"  ,  0}}},  /* 119 */
  {{{    "SH1915", 57},{   "SH2915", 57},{   "NONE"  ,  0}}},  /* 120 */
  {{{    "SH1916",  1},{   "SH2916",  1},{   "SH3914",  1}}},  /* 121 */
  {{{    "SH1916",  9},{   "SH2916",  9},{   "SH3914",  9}}},  /* 122 */
  {{{    "SH1916", 17},{   "SH2916", 17},{   "SH3914", 17}}},  /* 123 */
  {{{    "SH1916", 25},{   "SH2916", 25},{   "SH3914", 25}}},  /* 124 */
  {{{    "SH1916", 33},{   "SH2916", 33},{   "SH3914", 33}}},  /* 125 */
  {{{    "SH1916", 41},{   "SH2916", 41},{   "SH3914", 41}}},  /* 126 */
  {{{    "SH1916", 49},{   "SH2916", 49},{   "SH3914", 49}}},  /* 127 */
  {{{    "SH1916", 57},{   "SH2916", 57},{   "SH3914", 57}}},  /* 128 */
  {{{    "SH1917",  1},{   "SH2917",  1},{   "SH3915",  1}}},  /* 129 */
  {{{    "SH1917",  9},{   "SH2917",  9},{   "NONE"  ,  0}}},  /* 130 */
  {{{    "SH1917", 17},{   "SH2917", 17},{   "NONE"  ,  0}}},  /* 131 */
  {{{    "SH1917", 25},{   "SH2917", 25},{   "NONE"  ,  0}}},  /* 132 */
  {{{    "SH1917", 33},{   "SH2917", 33},{   "SH3915",  9}}},  /* 133 */
  {{{    "SH1917", 41},{   "SH2917", 41},{   "SH3915", 17}}},  /* 134 */
  {{{    "SH1917", 49},{   "SH2917", 49},{   "SH3915", 25}}},  /* 135 */
  {{{    "SH1917", 57},{   "SH2917", 57},{   "SH3915", 33}}},  /* 136 */
  {{{    "SH1918",  1},{   "SH2918",  1},{   "SH3915", 41}}},  /* 137 */
  {{{    "SH1918",  9},{   "SH2918",  9},{   "SH3915", 49}}},  /* 138 */
  {{{    "SH1918", 17},{   "SH2918", 17},{   "SH3915", 57}}},  /* 139 */
  {{{    "SH1918", 25},{   "SH2918", 25},{   "SH3916",  1}}},  /* 140 */
  {{{    "SH1918", 33},{   "SH2918", 33},{   "SH3916",  9}}},  /* 141 */
  {{{    "SH1918", 41},{   "SH2918", 41},{   "SH3916", 17}}},  /* 142 */
  {{{    "SH1918", 49},{   "SH2918", 49},{   "NONE"  ,  0}}},  /* 143 */
  {{{    "SH1918", 57},{   "SH2918", 57},{   "NONE"  ,  0}}},  /* 144 */
  {{{    "SH1919",  1},{   "SH2919",  1},{   "SH3916", 25}}},  /* 145 */
  {{{    "SH1919",  9},{   "SH2919",  9},{   "SH3916", 33}}},  /* 146 */
  {{{    "SH1919", 17},{   "SH2919", 17},{   "SH3916", 41}}},  /* 147 */
  {{{    "SH1919", 25},{   "SH2919", 25},{   "SH3916", 49}}},  /* 148 */
  {{{    "SH1919", 33},{   "SH2919", 33},{   "SH3916", 57}}},  /* 149 */
  {{{    "SH1919", 41},{   "SH2919", 41},{   "SH3917",  1}}},  /* 150 */
  {{{    "SH1919", 49},{   "SH2919", 49},{   "SH3917",  9}}},  /* 151 */
  {{{    "SH1919", 57},{   "SH2919", 57},{   "SH3917", 17}}},  /* 152 */
  {{{    "SH1920",  1},{   "SH2920",  1},{   "SH3917", 25}}},  /* 153 */
  {{{    "SH1920",  9},{   "SH2920",  9},{   "NONE"  ,  0}}},  /* 154 */
  {{{    "SH1920", 17},{   "SH2920", 17},{   "NONE"  ,  0}}},  /* 155 */
  {{{    "SH1920", 25},{   "SH2920", 25},{   "SH3917", 33}}},  /* 156 */
  {{{    "SH1920", 33},{   "SH2920", 33},{   "SH3917", 41}}},  /* 157 */
  {{{    "SH1920", 41},{   "SH2920", 41},{   "SH3917", 49}}},  /* 158 */
  {{{    "SH1920", 49},{   "SH2920", 49},{   "SH3917", 57}}},  /* 159 */
  {{{    "SH1920", 57},{   "SH2920", 57},{   "SH3918",  1}}},  /* 160 */
  {{{    "SH1921",  1},{   "SH2921",  1},{   "SH3918",  9}}},  /* 161 */
  {{{    "SH1921",  9},{   "SH2921",  9},{   "SH3918", 17}}},  /* 162 */
  {{{    "SH1921", 17},{   "SH2921", 17},{   "SH3918", 25}}},  /* 163 */
  {{{    "SH1921", 25},{   "SH2921", 25},{   "SH3918", 33}}},  /* 164 */
  {{{    "SH1921", 33},{   "SH2921", 33},{   "SH3918", 41}}},  /* 165 */
  {{{    "SH1921", 41},{   "SH2921", 41},{   "SH3918", 49}}},  /* 166 */
  {{{    "SH1921", 49},{   "SH2921", 49},{   "SH3918", 57}}},  /* 167 */
  {{{    "SH1921", 57},{   "SH2921", 57},{   "NONE"  ,  0}}},  /* 168 */
  {{{    "SH1922",  1},{   "SH2922",  1},{   "SH3919",  1}}},  /* 169 */
  {{{    "SH1922",  9},{   "SH2922",  9},{   "SH3919",  9}}},  /* 170 */
  {{{    "SH1922", 17},{   "SH2922", 17},{   "SH3919", 17}}},  /* 171 */
  {{{    "SH1922", 25},{   "SH2922", 25},{   "SH3919", 25}}},  /* 172 */
  {{{    "SH1922", 33},{   "SH2922", 33},{   "SH3919", 33}}},  /* 173 */
  {{{    "SH1922", 41},{   "SH2922", 41},{   "SH3919", 41}}},  /* 174 */
  {{{    "SH1922", 49},{   "SH2922", 49},{   "SH3919", 49}}},  /* 175 */
  {{{    "SH1922", 57},{   "SH2922", 57},{   "SH3919", 57}}},  /* 176 */
  {{{    "SH1923",  1},{   "SH2923",  1},{   "SH3920",  1}}},  /* 177 */
  {{{    "SH1923",  9},{   "SH2923",  9},{   "SH3920",  9}}},  /* 178 */
  {{{    "SH1923", 17},{   "SH2923", 17},{   "SH3920", 17}}},  /* 179 */
  {{{    "SH1923", 25},{   "SH2923", 25},{   "SH3920", 25}}},  /* 180 */
  {{{    "SH1923", 33},{   "SH2923", 33},{   "SH3920", 33}}},  /* 181 */
  {{{    "SH1923", 41},{   "SH2923", 41},{   "SH3920", 41}}},  /* 182 */
  {{{    "SH1923", 49},{   "SH2923", 49},{   "SH3920", 49}}},  /* 183 */
  {{{    "SH1923", 57},{   "SH2923", 57},{   "SH3920", 57}}},  /* 184 */
  {{{    "SH1924",  1},{   "SH2924",  1},{   "SH3921",  1}}},  /* 185 */
  {{{    "SH1924",  9},{   "SH2924",  9},{   "SH3921",  9}}},  /* 186 */
  {{{    "SH1924", 17},{   "SH2924", 17},{   "SH3921", 17}}},  /* 187 */
  {{{    "SH1924", 25},{   "SH2924", 25},{   "SH3921", 25}}},  /* 188 */
  {{{    "SH1924", 33},{   "SH2924", 33},{   "SH3921", 33}}},  /* 189 */
  {{{    "SH1924", 41},{   "SH2924", 41},{   "SH3921", 41}}},  /* 190 */
  {{{    "SH1924", 49},{   "SH2924", 49},{   "SH3921", 49}}},  /* 191 */
  {{{    "SH1924", 57},{   "SH2924", 57},{   "SH3921", 57}}},  /* 192 */
  {{{    "SH1925",  1},{   "SH2925",  1},{   "SH3922",  1}}},  /* 193 */
  {{{    "SH1925",  9},{   "SH2925",  9},{   "SH3922",  9}}},  /* 194 */
  {{{    "SH1925", 17},{   "SH2925", 17},{   "SH3922", 17}}},  /* 195 */
  {{{    "SH1925", 25},{   "SH2925", 25},{   "SH3922", 25}}},  /* 196 */
  {{{    "SH1925", 33},{   "SH2925", 33},{   "SH3922", 33}}},  /* 197 */
  {{{    "SH1925", 41},{   "SH2925", 41},{   "SH3922", 41}}},  /* 198 */
  {{{    "SH1925", 49},{   "SH2925", 49},{   "SH3922", 49}}},  /* 199 */
  {{{    "SH1925", 57},{   "SH2925", 57},{   "SH3922", 57}}},  /* 200 */
  {{{    "SH1926",  1},{   "SH2926",  1},{   "SH3923",  1}}},  /* 201 */
  {{{    "SH1926",  9},{   "SH2926",  9},{   "SH3923",  9}}},  /* 202 */
  {{{    "SH1926", 17},{   "SH2926", 17},{   "SH3923", 17}}},  /* 203 */
  {{{    "SH1926", 25},{   "SH2926", 25},{   "SH3923", 25}}},  /* 204 */
  {{{    "SH1926", 33},{   "SH2926", 33},{   "SH3923", 33}}},  /* 205 */
  {{{    "SH1926", 41},{   "SH2926", 41},{   "SH3923", 41}}},  /* 206 */
  {{{    "SH1926", 49},{   "SH2926", 49},{   "SH3923", 49}}},  /* 207 */
  {{{    "SH1926", 57},{   "SH2926", 57},{   "SH3923", 57}}},  /* 208 */
  {{{    "SH1927",  1},{   "SH2927",  1},{   "SH3924",  1}}},  /* 209 */
  {{{    "SH1927",  9},{   "SH2927",  9},{   "SH3924",  9}}},  /* 210 */
  {{{    "SH1927", 17},{   "SH2927", 17},{   "SH3924", 17}}},  /* 211 */
  {{{    "SH1927", 25},{   "SH2927", 25},{   "SH3924", 25}}}   /* 212 */
};

void usage(s)
char *s;
{
       fprintf(stderr, "Usage: %s RA1950(degrees)  Dec1950(degrees)\n", s);
       exit(-1);
}

int main(argc, argv)
int argc;
char **argv;
{
     int lat_band, band, file_number;
     int plate_no, file_no, found, hcon;
     char tape_label[20];
     double ra, dec;

     static double plate_width[13] = {360., 36., 24., 18., 15., 15., 15.,
				       15., 15., 18., 24., 36., 360.     };

     static int first_plate[13] = {1, 2, 12, 27, 47, 71, 95,
				   119, 143, 167, 187, 202, 212};

     if(argc != 3)
	  usage(argv[0]);  /* never returns */

     ra = atof(argv[1]);
     dec = atof(argv[2]);

     lat_band = (97.5 - dec) / 15.0;

     plate_no = first_plate[lat_band]
          + (ra + plate_width[lat_band] / 2.) / plate_width[lat_band];

     if(lat_band != 13 &&
	plate_no == first_plate[lat_band + 1])
	  plate_no = first_plate[lat_band];

#  ifdef  DEBUG
     fprintf(stdout,"skyplate:  lat_band %d\n", lat_band);
#  endif

     fprintf(stdout ,"\n\n Plate %d\n\n HCON  Band   Tape   File\n", plate_no);
     fprintf(stdout ,"==========================\n");

     found = FALSE;
     for(hcon=0; hcon<3; ++hcon)
	  {
	  strcpy(tape_label, platedata[plate_no].tapefil[hcon].label);
	  file_no = platedata[plate_no].tapefil[hcon].filen;

          if(strcmp(tape_label, "NONE") != 0) 
	       {
	       found = TRUE;

	       for(band=0; band<4; ++band)
		    {
		    file_number = file_no + 2 * band;
		    fprintf(stdout ,"   %d     %d   %s   %d\n",
			 hcon+1, band+1, tape_label, file_number);
		    }
	       }
	  fprintf(stdout ,"\n");
	  }

     if(found == FALSE)
	  fprintf(stdout , "There is no image covering this location.\n\n");

     fflush(stdout);
     exit (0);
     return(0);
}

