/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/* sfits.c */
/* converts an s file to a FITS file on disk */
/* Byte-sex of FITS file is such that IRAF can read it with rfits command */
/*    and that s can read it with the tape_read command */
#include "skyview.h"
#include <sys/types.h>
#include <ctype.h>
#include <sys/file.h>
#include <fcntl.h>
#include <netinet/in.h>

main(argc, argv)
int argc;
char *argv[];
{
    int bitpix;
    char *endp, *p;
    short temp, *pshort;
    int i, fd, fd2, bufsize, blocks;
    char pixbuf[2880];
    int rdstat, wrstat, count;
    struct hdrstruct thdr;
    int vax_bytes;
    u_long netlong;


    /* test for byteorder */
    netlong = 0x12345678;
    netlong = htonl(netlong);
    if (netlong == 0x12345678)
	vax_bytes = FALSE;
    else if (netlong == 0x78563412)
	vax_bytes = TRUE;
    else
    {
	printf("sfits error:  unknown byte order on this machine\n");
	exit(1);
    }

    if (argc != 3)
    {
	printf("usage: sfits s_filename fits_filename\n");
	exit(1);
    }
    fd = open(argv[1], O_RDONLY, 0644);
    if (fd < 0)
    {
	perror(argv[1]);
	exit(1);
    }
    fd2 = open(argv[2], O_RDWR | O_CREAT | O_TRUNC, 0644);
    if (fd2 < 0)
    {
	perror(argv[2]);
	exit(1);
    }

    lseek(fd, 0, 0);
    rdstat = read(fd, &thdr, sizeof(thdr));

    if (thdr.tapetype != FITS)
    {
	printf("sfits error:  %s does not look like an s workfile\n", argv[1]);
	exit(1);
    }


    /* now read old FITS header */
    bitpix = 0;
    endp = 0;
    lseek(fd, thdr.hdr_start, 0);
    while (endp == 0)
    {
	rdstat = read (fd, pixbuf, 2880);
	if (rdstat == 0)
	{
	    printf("sfits:  end of file looking for END keyword.  ABORTING\n");
	    exit(1);
	}
	if (rdstat < 0)
	{
	    perror("error reading input file");
	    exit(1);
	}

	/* look for BITPIX and END keywords */

	p = pixbuf;
	for (i=0; i<36; i++, p += 80)
	{
	    if (bcmp (p, "BITPIX  ", 8) == 0)
		bitpix = atoi(p+10);
	    if (bcmp (p, "END     ", 8) == 0)
		endp = p;
	}
	if (endp != 0)
	{
	    p = endp + 80;
	    while (p < pixbuf + 2880)
		*p++ = ' ';           /* pad out last block with spaces */
	}

	wrstat = write(fd2, pixbuf, 2880);
	if (wrstat == -1)
	{
	    perror("S error writing header on output file");
	    exit(1);
	}
    }

    if (bitpix == 0)
    {
	printf("BITPIX not found in header; aborting\n");
	exit(1);
    }

    printf("sfits: writing file %s to %s\n", argv[1], argv[2]);


    /* now copy pixels */
    lseek(fd, thdr.img_start, 0);

    count = thdr.hist_start - thdr.img_start;
    while (count > 0)
    {
	rdstat = read(fd, pixbuf, 2880);
	if (rdstat < 2880)
	    printf("read error  %d returned\n", rdstat);
	if (vax_bytes)
	{
	    if (bitpix != 8)
		swab(pixbuf, pixbuf, 2880);  /* swap bytes */

	    if (bitpix == 32)
	    {
		/* swap words */
		pshort = (short *) pixbuf;
		for(i = 0; i < rdstat; i += 4)
		{
		    temp = *pshort;
		    *pshort = *(pshort+1);
		    *(pshort+1) = temp;
		    pshort += 2;
		}
	    }
	}


	if (count < 2880)
	{
	    for (i=count; i<2880; i++)
		pixbuf[i] = 0;   /* fill with zeros */
	}
	wrstat = write(fd2, pixbuf, 2880);
	if (wrstat == -1)
	{
	    perror("error writing pixels on output file");
	    exit(1);
	}
	count -= 2880;
    }

    close(fd);

}
