/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include "parse.h"
#include "skyview.h"
#include <stdio.h>
#include "jconfig.h"
#include "jgio.h"
/*   #include <sys/jg.h>  */
#include <sys/file.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <ctype.h>
#include <sys/param.h>

#define DISKFILE 999


extern JFILE *J12file;
extern FILE *session;
extern mfd, debug, vax_bytes;
extern filnbr, tappos;
extern char plane;
extern char *hdr_buf, *hdr_bufp_end;
extern char *expand_path();

struct jggxattr ja;
static count = 0;
static selection = IPL;
static color_selection = WHITE;
static int p_lines, p_samp;
static int minx, miny, maxx, maxy;
static char fname[MAXPATHLEN];

screen_dump(argc, argv)
int argc;
char *argv[];
{
    char *tapename, *getenv();
    int arg_index, tmpnbr, nfilnbr;
    struct mtop  mstop;
    int sel, j_get_result;

    if (mfd < 0)
    {
	tappos = 1;
	filnbr = 0;   /* will be incremented by 1 (default) */
    }

    /* set up defaults */
    nfilnbr = filnbr + 1;

    for (arg_index = 1; arg_index < argc; arg_index++)
    {
	if (debug)
	    printf("sd: argument %d is =%s=\n", arg_index, argv[arg_index]);
	/* see if its a file number or a workfile name */
	if ((*argv[arg_index] == '+') || (*argv[arg_index] == '-') || (isdigit(*argv[arg_index])))
	{
	    /* its a number */
	    if (debug)
		printf("it is a number\n");
	    if (getint(argv[arg_index], &tmpnbr) == FALSE)
		return;
	    if ((*argv[arg_index] == '+') || (*argv[arg_index] == '-'))
	    {
		nfilnbr = filnbr + tmpnbr;
	    }
	    else
	    {
		nfilnbr = tmpnbr;
	    }
	}
	else
	{
	    sel = cmd(argv[arg_index]);
	    if (debug)
		printf("sel = %d\n", sel);
	    switch(sel)
	    {
	    case RED:
	    case GREEN:
	    case BLUE:
		if (debug)
		    printf("it is a color selection\n");
		color_selection = sel;
		break;
	    case IPL:
	    case BLINN:
	    case BLINNCOLOR:
		if (debug)
		    printf("it is a dump selection\n");
		selection = sel;
		break;
	    default:
		/* assume its a filename */
		if (debug)
		    printf("it is a filename\n");
		strcpy(fname, expand_path(argv[arg_index]));
		selection = DISKFILE;
		break;
	    }
	}
    }
    if (selection != DISKFILE)
    {
    wait(0);    /* let child processes die */
    if (mfd < 0)
    {

	if ((tapename = getenv("STAPE")) == NULL)
	    tapename = "/dev/rmt12";
	mfd = open(tapename, O_RDWR, 0);
	if (mfd < 0)
	{
	    perror(tapename);
	    error();
	    return;
	}
    }
    filnbr = nfilnbr;   /* (didnt want to change file nbr if file open blew */

    if (debug)
	printf("seeking tape filenumber %d   current tappos=%d\n", filnbr, tappos);
    if (filnbr > tappos)
    {
	mstop.mt_op = MTFSF;
	mstop.mt_count = filnbr - tappos;
	ioctl(mfd, MTIOCTOP, &mstop);
    }
    else    /* filnbr <= tappos */
    {
	if (filnbr != 1)
	{
	    mstop.mt_op = MTBSF;
	    mstop.mt_count = tappos - filnbr + 1;
	    ioctl(mfd, MTIOCTOP, &mstop);

	    mstop.mt_op = MTFSF;
	    mstop.mt_count = 1;
	    ioctl(mfd, MTIOCTOP, &mstop);
	}
    }
    tappos = filnbr;
    }



    j_get_result = j_get_attr(&ja);
    if (debug)
    {
	printf("j_get_attr result = %d\n", j_get_result);
	printf("xzoom = %f  yzoom = %f  origins: horiz = %d  vert = %d\n", ja.ja_xzoom, ja.ja_yzoom, ja.ja_horg, ja.ja_vorg);
	printf("image display mask=%x\n", ja.ja_cmask);
	printf("overlay display mask=%x\n", ja.ja_omask);
	printf("ja_bdsel arg = %d\n", ja.ja_bdsel);
    }
    
    /*
    for (y=0; y < 256; y++)
    {
	printf("red[%d] = %d\n", y, ja.ja_r[y]);
    }
    */


    p_lines = 1024 / ja.ja_yzoom;
    p_samp = 1280 / ja.ja_xzoom;
    maxy = ja.ja_vorg;
    miny = maxy - p_lines + 1;
    minx = ja.ja_horg;
    maxx = minx + p_samp - 1;

    if (debug)
    {
	printf("p_lines=%d p_samp=%d\n", p_lines, p_samp);
	printf("minx=%d miny=%d maxx=%d maxy=%d\n", minx, miny, maxx,maxy);
    }

    switch(selection)
    {
    case IPL:
    case DISKFILE:
	ipl_dump();
	break;
    case BLINN:
    case BLINNCOLOR:
	blinn_dump();
	break;
    }

    if (selection != DISKFILE)
    {
	mstop.mt_op = MTWEOF;    /* write second EOF  */
	mstop.mt_count = 1;
	ioctl(mfd, MTIOCTOP, &mstop);
	mstop.mt_op = MTBSF;   /* backspace over one of them */
	mstop.mt_count = 1;
	ioctl(mfd, MTIOCTOP, &mstop);
    }


    j_bdepth(ID_BUF1, 0, 16);  /* get j12 routines back to normal */
    image_setup(plane);
}

blinn_dump()
{
    struct
    {
	short magic;
	short magic2;
	short version;
	char label[246];
	int labelpointer;
	int dummy[40];
	short pheight;
	short pwidth;
	short theight;
	short twidth;
	short pformat;
	short pstorage;
	short blocking;
	short alpha;
	short xoffset;
	short yoffset;
	int dummy1[3];
	int dummy2[8];
	short tilept[256];
    } pic_hdr;
    int y, nbr;
    char r_pixbuf[1280], g_pixbuf[1280], b_pixbuf[1280], ovbuf[1280];
    char filbuf[3840], *pic_ptr;
    char tmpstr[4];
    register char *fptr;
    register int k, overlay;
    int r_pixval, g_pixval, b_pixval;
    int apply_ct, blksiz;
    struct mtop  mstop;

    /* fill header */
    printf("size of pic_hdr = %d\n", sizeof(pic_hdr));
    pic_ptr = (char *) &pic_hdr;
    for (k = 0; k < sizeof(pic_hdr); k++)
	*pic_ptr++ = 0;   /* initialize structure */
    pic_hdr.magic = 0164200;
    strcpy(pic_hdr.label, "IPAC");
    count++;
    sprintf(tmpstr, "%02d", count);
    strcat(pic_hdr.label, tmpstr);
    pic_hdr.pheight = p_lines;
    pic_hdr.theight = p_lines;
    pic_hdr.pwidth = p_samp;
    pic_hdr.twidth = p_samp;
    pic_hdr.pformat = 14;  /* binary 1110 */
    pic_hdr.pstorage = 2;  /* 8-bit dumped */
    if (p_samp < 512)
    {
	blksiz = 512 * 3;
    }
    else
    {
	blksiz = p_samp * 3;
    }
    pic_hdr.blocking = blksiz;
    pic_hdr.tilept[0] = 1024;


    if (selection == BLINNCOLOR)
    {
	printf("applying color table\n");
	apply_ct = TRUE;
    }
    else
	apply_ct = FALSE;

    printf("label used for this file: %s\n", pic_hdr.label);

    swab(pic_hdr.label, pic_hdr.label, sizeof(pic_hdr.label));
    write(mfd, &pic_hdr, sizeof(pic_hdr));

    for (k = 0; k < 3840; k++)
	filbuf[k] = 0;

    for (y = maxy; y >= miny; y--)
    {
	if (maxx > 1279)
	{
	    /* must read in 2 pieces due to slice bug - fails at x=1668 */
	    j_depth(0, 8);   /* fetch 4 bit overlay info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(ovbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&ovbuf[1280 - minx], nbr);

	    j_depth(8, 8);   /* fetch 8 bit red info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(r_pixbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&r_pixbuf[1280 - minx], nbr);

	    j_depth(16, 8);   /* fetch 8 bit green info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(g_pixbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&g_pixbuf[1280 - minx], nbr);

	    j_depth(24, 8);   /* fetch 8 bit blue info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(b_pixbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&b_pixbuf[1280 - minx], nbr);
	}
	else
	{
	    j_depth(0, 8);   /* fetch 4 bit overlay info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(ovbuf, nbr);
	    j_depth(8, 8);   /* fetch 8 bit red info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(r_pixbuf, nbr);
	    j_depth(16, 8);   /* fetch 8 bit green info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(g_pixbuf, nbr);
	    j_depth(24, 8);   /* fetch 8 bit blue info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(b_pixbuf, nbr);
	}

	/* massage pixels here */

	fptr = filbuf;

	for (k=0; k < p_samp; k++)
	{
	    overlay = ovbuf[k] & 0xf;
	    if (apply_ct)
	    {
		if (overlay == 0)
		{
		    r_pixval = r_pixbuf[k] & 0xff;
		    g_pixval = g_pixbuf[k] & 0xff;
		    b_pixval = b_pixbuf[k] & 0xff;
		}
		else
		{
		    r_pixval = ja.ja_ovr[overlay];
		    g_pixval = ja.ja_ovg[overlay];
		    b_pixval = ja.ja_ovb[overlay];
		}

		/*
		if (debug)
		    printf("input value=%d  color table value = %d", pixval, ja.ja_r[pixval]);
		*/

		r_pixval = ja.ja_r[r_pixval];  /* apply color table */
		g_pixval = ja.ja_g[g_pixval];  /* apply color table */
		b_pixval = ja.ja_b[b_pixval];  /* apply color table */
		*fptr++ = r_pixval;
		*fptr++ = g_pixval;
		*fptr++ = b_pixval;
	    }
	    else
	    {   /* dont apply color table */
		if (overlay == 0)
		{
		    *fptr++ = r_pixbuf[k] & 0xff;
		    *fptr++ = g_pixbuf[k] & 0xff;
		    *fptr++ = b_pixbuf[k] & 0xff;
		}
		else
		{
		    r_pixval = ja.ja_ovr[overlay];
		    *fptr++ = ja.ja_r[r_pixval];  /* apply color table */
						/* (must be done to overlay) */
		    g_pixval = ja.ja_ovg[overlay];
		    *fptr++ = ja.ja_g[g_pixval];  /* apply color table */
		    b_pixval = ja.ja_ovb[overlay];
		    *fptr++ = ja.ja_b[b_pixval];  /* apply color table */

		}
	    }
	}



	/*
	printf("writing %d bytes for line %d\n", p_samp * 3, y);
	*/
	/* Blinn says we need to swap bytes - I have not done it yet */
	write(mfd, filbuf, blksiz);
    }
    mstop.mt_op = MTWEOF;    /* write EOF on tape */
    mstop.mt_count = 1;
    ioctl(mfd, MTIOCTOP, &mstop);

    tappos++;
}

ipl_dump()
{
    int hdr_bytes, blocks, i, y, nbr, tfd;
    char pixbuf[1281], ovbuf[1280], tfilnam[80];
    char buf[2880], *bufp;
    register int k, pixval;
    struct mtop  mstop;
    int hist_shift;
    int hist[HISTSIZ2 + 1];
    struct hdrstruct hdr;

    if (debug)
	printf("doing ipl dump\n");

    if (selection == DISKFILE)
    {
	/* set up FITS header */
	for (i=0, bufp = buf; i<2880; i++, bufp++)
	    *bufp = ' ';
	strncpy(buf, "END", 3);
	hdr_buf = buf;
	(void) hdrinit(2880);
	hdrlogical("SIMPLE", 'T');
	hdrint("BITPIX", 8);
	hdrint("NAXIS", 3);
	hdrint("NAXIS1", p_samp);
	hdrint("NAXIS2", p_lines);
	hdrint("NAXIS3", 1);
	hdrint("CDELT2", -1);
	hdrlogical("BLOCKED", 'T');
	comment("SCREEN DUMP FILE FROM S");

	blocks = (hdr_bufp_end - hdr_buf) / 2880;
	if ((blocks * 2880) != (hdr_bufp_end - hdr_buf))
	    blocks++;  /* round up to next integral number of blocks */
	hdr_bytes = blocks * 2880;
    }

    /* first do red */
    if ((color_selection != BLUE) && (color_selection != GREEN))
    {
    if (selection == DISKFILE)
    {
	/* open the file */

	strcpy(tfilnam, fname);
	strcat(tfilnam, ".r");
	printf("opening disk file: %s\n", tfilnam);
	tfd = open(tfilnam, O_RDWR | O_CREAT | O_TRUNC, 0644);
	if (tfd < 0)
	{
	    perror(tfilnam);
	    error();
	    return;
	}

	for (i=0; i <= HISTSIZ2; i++)
	    hist[i] = 0;
	hist_shift = 0;

	hdr.hist_bin_size = 1;
	hdr.tapetype = INVALID;  /* mark workfile invalid during transfer */
	hdr.img_max = 0x80000001;
	hdr.img_min = 0x7fffffff;
	write(tfd, &hdr, sizeof(hdr));     /* write s header */
	hdr.hdr_start = lseek(tfd, 0, 1);
	write(tfd, hdr_buf, hdr_bytes);    /* write FITS header */
	hdr.img_start = lseek(tfd, 0, 1);
    }
    else
    {
	tfd = mfd;
	printf("now writing red file to tape\n");
    }

    for (y = maxy; y >= miny; y--)
    {
	if (maxx > 1279)
	{
	    /* must read in 2 pieces due to slice bug - fails at x=1668 */
	    j_depth(0, 8);   /* fetch 4 bit overlay info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(ovbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&ovbuf[1280 - minx], nbr);

	    j_depth(8, 8);   /* fetch 8 bit red info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(pixbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&pixbuf[1280 - minx], nbr);
	}
	else
	{
	    /*
	    printf("fetching from minx=%d to maxx=%d line=%d\n",minx,maxx,y);
	    */
	    j_depth(0, 8);   /* fetch 4 bit overlay info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(ovbuf, nbr);
	    j_depth(8, 8);   /* fetch 8 bit red info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(pixbuf, nbr);
	}

	/* massage pixels here */

	for (k=0; k < p_samp; k++)
	{
	    if ((ovbuf[k] & 0xf) == 0)
	    {
		pixbuf[k] = ja.ja_r[pixbuf[k] & 0xff];  /* apply color table */
	    }
	    else
	    {
		pixval = ja.ja_ovr[ovbuf[k] & 0xf];
		pixbuf[k] = ja.ja_r[pixval];  /* apply color table */
	    }
	}

	/* compute histogram */
	get_hist(8, pixbuf, p_samp, &hdr.img_min, &hdr.img_max, 0x7fffffff, hist_shift, hist);

    if (!vax_bytes)
    {
	if (selection != DISKFILE)
	    swab(pixbuf, pixbuf, p_samp);
    }

    write(tfd, pixbuf, p_samp);
    }

    if (selection == DISKFILE)
    {

	hdr.hist_start = lseek(tfd, 0, 1);
	write(tfd, hist, sizeof(hist));

	hdr.hdr_start = sizeof(hdr);

	hdr.tapetype = FITS;
	lseek(tfd, 0, 0);
	write(tfd, &hdr, sizeof(hdr));
	close(tfd);
    }
    else
    {
	mstop.mt_op = MTWEOF;    /* write EOF on tape */
	mstop.mt_count = 1;
	ioctl(mfd, MTIOCTOP, &mstop);

	tappos++;
	filnbr = tappos - 1;
    }
    }

    /* now do green */
    if ((color_selection != BLUE) && (color_selection != RED))
    {
    if (selection == DISKFILE)
    {
	/* open the file */

	strcpy(tfilnam, fname);
	strcat(tfilnam, ".g");
	printf("opening disk file: %s\n", tfilnam);
	tfd = open(tfilnam, O_RDWR | O_CREAT | O_TRUNC, 0644);
	if (tfd < 0)
	{
	    perror(tfilnam);
	    error();
	    return;
	}

	for (i=0; i <= HISTSIZ2; i++)
	    hist[i] = 0;
	hist_shift = 0;

	hdr.hist_bin_size = 1;
	hdr.tapetype = INVALID;  /* mark workfile invalid during transfer */
	hdr.img_max = 0x80000001;
	hdr.img_min = 0x7fffffff;
	write(tfd, &hdr, sizeof(hdr));    /* write s header */
	hdr.hdr_start = lseek(tfd, 0, 1);
	write(tfd, hdr_buf, hdr_bytes);    /* write FITS header */
	hdr.img_start = lseek(tfd, 0, 1);
    }
    else
    {
	tfd = mfd;
	printf("now writing green file to tape\n");
    }
    for (y = maxy; y >= miny; y--)
    {
	if (maxx > 1279)
	{
	    /* must read in 2 pieces due to slice bug - fails at x=1668 */
	    j_depth(0, 8);   /* fetch 4 bit overlay info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(ovbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&ovbuf[1280 - minx], nbr);

	    j_depth(16, 8);   /* fetch 8 bit green info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(pixbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&pixbuf[1280 - minx], nbr);
	}
	else
	{
	    j_depth(0, 8);   /* fetch 4 bit overlay info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(ovbuf, nbr);
	    j_depth(16, 8);   /* fetch 8 bit green info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(pixbuf, nbr);
	}


	/* massage pixels here */

	for (k=0; k < p_samp; k++)
	{
	    if ((ovbuf[k] & 0xf) == 0)
	    {
		pixbuf[k] = ja.ja_g[pixbuf[k] & 0xff];  /* apply color table */
	    }
	    else
	    {
		pixval = ja.ja_ovg[ovbuf[k] & 0xf];
		pixbuf[k] = ja.ja_g[pixval];  /* apply color table */
	    }
	}

	/* compute histogram */
	get_hist(8, pixbuf, p_samp, &hdr.img_min, &hdr.img_max, 0x7fffffff, hist_shift, hist);

    if (!vax_bytes)
    {
	if (selection != DISKFILE)
	    swab(pixbuf, pixbuf, p_samp);
    }

    write(tfd, pixbuf, p_samp);
    }

    if (selection == DISKFILE)
    {
	hdr.hist_start = lseek(tfd, 0, 1);
	write(tfd, hist, sizeof(hist));

	hdr.hdr_start = sizeof(hdr);

	hdr.tapetype = FITS;
	lseek(tfd, 0, 0);
	write(tfd, &hdr, sizeof(hdr));
	close(tfd);
    }
    else
    {
	mstop.mt_op = MTWEOF;    /* write EOF on tape */
	mstop.mt_count = 1;
	ioctl(mfd, MTIOCTOP, &mstop);

	tappos++;
	filnbr = tappos - 1;
    }
    }

    /* now do blue */
    if ((color_selection != GREEN) && (color_selection != RED))
    {
    if (selection == DISKFILE)
    {
	/* open the file */

	strcpy(tfilnam, fname);
	strcat(tfilnam, ".b");
	printf("opening disk file: %s\n", tfilnam);
	tfd = open(tfilnam, O_RDWR | O_CREAT | O_TRUNC, 0644);
	if (tfd < 0)
	{
	    perror(tfilnam);
	    error();
	    return;
	}

	for (i=0; i <= HISTSIZ2; i++)
	    hist[i] = 0;
	hist_shift = 0;

	hdr.hist_bin_size = 1;
	hdr.tapetype = INVALID;  /* mark workfile invalid during transfer */
	hdr.img_max = 0x80000001;
	hdr.img_min = 0x7fffffff;
	write(tfd, &hdr, sizeof(hdr));    /* write s header */
	hdr.hdr_start = lseek(tfd, 0, 1);
	write(tfd, hdr_buf, hdr_bytes);    /* write FITS header */
	hdr.img_start = lseek(tfd, 0, 1);
    }
    else
    {
	tfd = mfd;
	printf("now writing blue file to tape\n");
    }

    for (y = maxy; y >= miny; y--)
    {
	if (maxx > 1279)
	{
	    /* must read in 2 pieces due to slice bug - fails at x=1668 */
	    j_depth(0, 8);   /* fetch 4 bit overlay info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(ovbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&ovbuf[1280 - minx], nbr);

	    j_depth(24, 8);   /* fetch 8 bit blue info only */
	    nbr = j_area(minx, y, 1279, y);
	    j_rd_image(pixbuf, nbr);
	    nbr = j_area(0, y, maxx - 1280, y);
	    j_rd_image(&pixbuf[1280 - minx], nbr);
	}
	else
	{
	    j_depth(0, 8);   /* fetch 4 bit overlay info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(ovbuf, nbr);
	    j_depth(24, 8);   /* fetch 8 bit blue info only */
	    nbr = j_area(minx, y, maxx, y);
	    j_rd_image(pixbuf, nbr);
	}


	/* massage pixels here */

	for (k=0; k < p_samp; k++)
	{
	    if ((ovbuf[k] & 0xf) == 0)
	    {
		pixbuf[k] = ja.ja_b[pixbuf[k] & 0xff];  /* apply color table */
	    }
	    else
	    {
		pixval = ja.ja_ovb[ovbuf[k] & 0xf];
		pixbuf[k] = ja.ja_b[pixval];  /* apply color table */
	    }
	}

	/* compute histogram */
	get_hist(8, pixbuf, p_samp, &hdr.img_min, &hdr.img_max, 0x7fffffff, hist_shift, hist);

	if (!vax_bytes)
	{
	    if (selection != DISKFILE)
		swab(pixbuf, pixbuf, p_samp);
	}

	write(tfd, pixbuf, p_samp);
    }

    if (selection == DISKFILE)
    {
	hdr.hist_start = lseek(tfd, 0, 1);
	write(tfd, hist, sizeof(hist));

	hdr.hdr_start = sizeof(hdr);

	hdr.tapetype = FITS;
	lseek(tfd, 0, 0);
	write(tfd, &hdr, sizeof(hdr));
	close(tfd);
    }
    else
    {
	mstop.mt_op = MTWEOF;    /* write EOF on tape */
	mstop.mt_count = 1;
	ioctl(mfd, MTIOCTOP, &mstop);

	tappos++;
	filnbr = tappos - 1;
    }
    }

    if (selection != DISKFILE)
    {
    printf("Tell IPL that image is %d lines by %d samples\n", p_lines + 47, p_samp);
    fprintf(session, "Tell IPL that image is %d lines by %d samples\n", p_lines + 47, p_samp);
    }
}
