/*
Copyright (C) 1995, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>     /* includes strings.h, sys/time.h, and sys/file.h */

#include "skyview.h"
#include "img_x.h"
#include "img.h"
#include <stdio.h>
#include <stdlib.h>

extern int debug, graphics, frame_graphics;
extern struct img head_img, *curr_img;

extern FILE *debug_file;
extern struct framestruct *frameptr;
extern Display *display;
extern XImage *theImage;
extern Window win, cur_window;
extern unsigned win_width, win_height;
extern unsigned char *image_org;
extern unsigned width_org, height_org;
extern unsigned char *image_zoomed;
extern unsigned width_zoomed, height_zoomed;
extern double win_zoom;
extern int win_x_offset, win_y_offset;
extern int imio_last_x, imio_last_y;
extern int mapped;

/********************************************************************/
/*                                                                  */
/*  FIND_WIN                                                        */
/*  given a Window id returns a pointer to the img structure of     */
/*  the most recent image in that window.                           */
/*  Copies values from the structure to global variables            */
/*  making this the current image.                                  */
/*                                                                  */
/*  If no such image exists, returns NULL and makes no changes to   */
/*  current image.                                                  */
/*                                                                  */
/********************************************************************/

struct img *find_WIN(win1)
Window win1;
{
    struct img *p;

    p = head_img.rlink;
    while (p != &head_img)
    {
	if (p->frameptr->win == win1)
	{
	    if (debug)
		fprintf(debug_file,
		    "find_WIN: entry  win = 0x%lx  (found it) imgptr = 0x%p\n", 
		    win1, (void *) p);
	    if (curr_img != p)
		fill_glob(p);
	    return(p);
	}
	p = p->rlink;
    }
    if (debug)
	fprintf(debug_file, "find_WIN: entry  win = 0x%lx  NOT FOUND\n", win1);
    return(NULL);
}

/********************************************************************/
/*                                                                  */
/*  FIND_WIN_AGAIN                                                  */
/*  Given a pointer to an img array entry, returns a pointer to     */
/*  the previous entry for the same window "win".                   */
/*  Copies values from the structure to global variables            */
/*  making this the current image.                                  */
/*                                                                  */
/*  If no image remains, returns NULL and                           */
/*  makes no changes to current image or globals.                   */
/*                                                                  */
/********************************************************************/

struct img *find_WIN_again(p)
struct img *p;
{
    Window tmpwin;

    tmpwin = p->frameptr->win;
    p = p->rlink;
    while (p != &head_img)
    {
	if (p->frameptr->win == tmpwin)
	{
	    fill_glob(p);
	    return(p);
	}
	p = p->rlink;
    }
    return(NULL);
}

/********************************************************************/
/*                                                                  */
/*  DELETE_WIN                                                      */
/*  deletes the window whose variables are currently global         */
/*                                                                  */
/********************************************************************/

void
delete_WIN()
{
    struct img *tmpimg;
    struct framestruct *frameptr_save;

    if (frame_graphics)
	XDestroyWindow(display, win);
    erase_window_graphics(win);
    if (image_zoomed != NULL)
	free (image_zoomed);
    theImage->data = (char *) image_org;
    if (frame_graphics)
	XDestroyImage(theImage);
    else
	free(image_org);
    frameptr_save = frameptr;  /* framestruct is used by find_WIN */
			       /* so dont delete it yet */
    delete_img(curr_img);		/* delete from screen mgmt */
	/* now delete other images in this window */
    while ((tmpimg = find_WIN(win)) != NULL)
    {
	delete_img(tmpimg);		/* delete from screen mgmt */
    }
    free(frameptr_save);
    win = 0;
    curr_img = NULL;
}



/********************************************************************/
/*                                                                  */
/*  FILL_GLOB_FRAME                                                 */
/*  Fills global variables with values from an image structure.     */
/*  Sets curr_img                                                   */
/*                                                                  */
/********************************************************************/

void
fill_glob_frame(imgp)
struct img *imgp;
{
    if (imgp->frameptr != 0)
    {
	theImage = imgp->frameptr->theImage;
	win = imgp->frameptr->win;
	win_width = imgp->frameptr->win_width;
	win_height = imgp->frameptr->win_height;
	image_org = imgp->frameptr->image_org;
	width_org = imgp->frameptr->width_org;
	height_org = imgp->frameptr->height_org;
	image_zoomed = imgp->frameptr->image_zoomed;
	width_zoomed = imgp->frameptr->width_zoomed;
	height_zoomed = imgp->frameptr->height_zoomed;
	win_zoom = imgp->frameptr->win_zoom;
	win_x_offset = imgp->frameptr->win_x_offset;
	win_y_offset = imgp->frameptr->win_y_offset;
	imio_last_x = imgp->frameptr->imio_last_x;
	imio_last_y = imgp->frameptr->imio_last_y;
	mapped = imgp->frameptr->mapped;
	frame_graphics = imgp->frameptr->frame_graphics;
    }
}


/********************************************************************/
/*                                                                  */
/*  FILL_IMG_FRAME                                                  */
/*  Fills image structure with values from global variables         */
/*                                                                  */
/********************************************************************/

void
fill_img_frame(imgp)
struct img *imgp;
{
    if (imgp->frameptr != 0)
    {
	imgp->frameptr->theImage = theImage;
	imgp->frameptr->win = win;
	imgp->frameptr->win_width = win_width;
	imgp->frameptr->win_height = win_height;
	imgp->frameptr->image_org = image_org;
	imgp->frameptr->width_org = width_org;
	imgp->frameptr->height_org = height_org;
	imgp->frameptr->image_zoomed = image_zoomed;
	imgp->frameptr->width_zoomed = width_zoomed;
	imgp->frameptr->height_zoomed = height_zoomed;
	imgp->frameptr->win_zoom = win_zoom;
	imgp->frameptr->win_x_offset = win_x_offset;
	imgp->frameptr->win_y_offset = win_y_offset;
	imgp->frameptr->imio_last_x = imio_last_x;
	imgp->frameptr->imio_last_y = imio_last_y;
	imgp->frameptr->mapped = mapped;
	imgp->frameptr->frame_graphics = frame_graphics;
    }
}

void
update_cur_window()
{
    cur_window = win;
}
