/*
Copyright (C) 1995, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#ifndef XtOffsetOf    /* not defined in X11R3 */
#define XtOffsetOf(s_type,field) XtOffset(s_type*,field)
typedef char*           XtPointer;
#endif


extern char version[];    /* Makefile version date */
extern char Id[];         /* skyview.c internal date */
extern char *more;
extern int debug, graphics, captive;
extern unsigned int depth;
extern int server_mode, s1_server_mode, s0_server_mode, ads_server_mode;
extern int cmdline_mode, accepting_stdin;
extern int mouse_is_on, force_colormap, u16, use_projtype, conserve_mem;
extern int reread_on, imio_on;
extern int eight_bit;
extern int desired_colors;
extern FILE *debug_file;
extern Cursor cursor;
extern Display *display;
extern char main_button1[];
extern char main_button2[];
extern char main_button3[];
extern char ov_color[];
extern char default_font_name[];
extern char visualName[80];

static XrmDatabase resource_db;
static char early_debug_filename[512];

/* function prototypes */
#ifdef _NO_PROTO

static void usage();

#else

static void usage(int argc, char **argv);

#endif /* _NO_PROTO */

typedef struct
{
    int palette;
    Boolean s0_server_mode;
    Boolean s1_server_mode;
    Boolean ads_server_mode;
    Boolean new_server_mode;
    Boolean imio_mode;
    Boolean captive_mode;
    Boolean force_colormap_install;
    Boolean debug;
    String main_button1;
    String main_button2;
    String main_button3;
    Boolean mouse;
    Boolean projtype;
    Boolean unsigned_16_bit;
    Boolean reread;
    Boolean conserve_mem;
    String color;
    String debug_filename;
    String visualName;
    Cursor pointer_cursor;
    String font_name;
    Boolean eight_bit;
    String initial_command;
} AppData;

static XrmOptionDescRec early_opTable[] = {
{"-display",    ".display",     XrmoptionSepArg,        (caddr_t) NULL},
{"-d",          ".debug",       XrmoptionNoArg,         (caddr_t) "True"},
{"-n",          ".graphics",    XrmoptionNoArg,         (caddr_t) "False"},
{"-n24",        ".n24",         XrmoptionNoArg,         (caddr_t) "True"},
{"-name",       ".name",        XrmoptionSepArg,        (caddr_t) NULL},
{"-s",         ".s1serverMode",  XrmoptionNoArg,         (caddr_t) "True"},
{"-ads",       ".adsserverMode", XrmoptionNoArg,       (caddr_t) "True"},
{"-server",    ".adsserverMode", XrmoptionNoArg,       (caddr_t) "True"},
{"-e",          ".initialCommand", XrmoptionSepArg,        (caddr_t) NULL},
{"-debug_file", ".debugFile",     XrmoptionSepArg,        (caddr_t) NULL},
};

static XrmOptionDescRec opTable[] = {
{"-p",         ".palette",     XrmoptionSepArg,        (caddr_t) NULL},
{"-visual",    ".visualName",     XrmoptionSepArg,        (caddr_t) NULL},
{"-debug_file", ".debugFile",     XrmoptionSepArg,        (caddr_t) NULL},
{"-e",          ".initialCommand", XrmoptionSepArg,        (caddr_t) NULL},
{"-s0",        ".s0serverMode",  XrmoptionNoArg,         (caddr_t) "True"},
{"-imio",      ".imioMode",    XrmoptionNoArg,         (caddr_t) "True"},
{"-c",         ".captiveMode", XrmoptionNoArg,         (caddr_t) "True"},
{"-i",         ".forceColormapInstall", XrmoptionNoArg, (caddr_t) "True"},
{"-8bit",      ".eightBit", XrmoptionNoArg,         (caddr_t) "True"},
};

#define XtNdebug "debug"
#define XtCDebug "Debug"
#define XtNpalette "palette"
#define XtCPalette "Palette"
#define XtNserverMode "serverMode"
#define XtCServerMode "serverMode"
#define XtNs0serverMode "s0serverMode"
#define XtCS0serverMode "S0serverMode"
#define XtNs1serverMode "s1serverMode"
#define XtCS1serverMode "S1serverMode"
#define XtNadsserverMode "adsserverMode"
#define XtCAdsServerMode "AdsServerMode"
#define XtNimioMode "imioMode"
#define XtCImioMode "ImioMode"
#define XtNcaptiveMode "captiveMode"
#define XtCCaptiveMode "CaptiveMode"
#define XtNforceColormapInstall "forceColormapInstall"
#define XtCForceColormapInstall "ForceColormapInstall"
#define XtNmainButton1 "mainButton1"
#define XtCMainButton1 "MainButton1"
#define XtNmainButton2 "mainButton2"
#define XtCMainButton2 "MainButton2"
#define XtNmainButton3 "mainButton3"
#define XtCMainButton3 "MainButton3"
#define XtNmouse "mouse"
#define XtCMouse "Mouse"
#define XtNprojtype "projtype"
#define XtCProjtype "Projtype"
#define XtNunsigned16Bit "unsigned16Bit"
#define XtCUnsigned16Bit "Unsigned16Bit"
#define XtNreread "reread"
#define XtCReread "Reread"
#define XtNconserveMem "conserveMem"
#define XtCConserveMem "ConserveMem"
#define XtNvisualName "visualName"
#define XtCVisualName "VisualName"
#define XtNdebugFile "debugFile"
#define XtCDebugFile "DebugFile"
#define XtNcolor "color"
/*  define XtCColor "Color" (already defined in /usr/include/X11/StringDefs.h */
#define XtNpointerColor "pointerColor"
#define XtNpointerColorBackground "pointerColorBackground"
#define XtNpointerShape "pointerShape"
#define XtNeightBit "eightBit"
#define XtCEightBit "EightBit"
#define XtNinitialCommand "initialCommand"
#define XtCInitialCommand "InitialCommand"


static XtResource resources[] =
{
    {
    XtNdebug,
    XtCDebug,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, debug),
    XtRInt,
    (XtPointer) &debug,   /* default value */
    },
    {
    XtNpalette,
    XtCPalette,
    XtRInt,
    sizeof(int),
    XtOffsetOf(AppData, palette),
    XtRImmediate,
    (XtPointer) 0,   /* default value */
    },
    {
    XtNs0serverMode,
    XtCS0serverMode,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, s0_server_mode),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNs1serverMode,
    XtCS1serverMode,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, s1_server_mode),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNserverMode,
    XtCServerMode,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, new_server_mode),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNadsserverMode,
    XtCAdsServerMode,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, ads_server_mode),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNimioMode,
    XtCImioMode,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, imio_mode),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNcaptiveMode,
    XtCCaptiveMode,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, captive_mode),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNforceColormapInstall,
    XtCForceColormapInstall,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, force_colormap_install),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNmainButton1,
    XtCMainButton1,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, main_button1),
    XtRString,
    (XtPointer) "stretch",   /* default value */
    },
    {
    XtNmainButton2,
    XtCMainButton2,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, main_button2),
    XtRString,
    (XtPointer) "pick",   /* default value */
    },
    {
    XtNmainButton3,
    XtCMainButton3,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, main_button3),
    XtRString,
    (XtPointer) "zoom_pan",   /* default value */
    },
    {
    XtNmouse,
    XtCMouse,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, mouse),
    XtRImmediate,
    (XtPointer) TRUE,   /* default value */
    },
    {
    XtNprojtype,
    XtCProjtype,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, projtype),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNunsigned16Bit,
    XtCUnsigned16Bit,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, unsigned_16_bit),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNreread,
    XtCReread,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, reread),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNconserveMem,
    XtCConserveMem,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, conserve_mem),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNcolor,
    XtCColor,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, color),
    XtRString,
    (XtPointer) "default",   /* default value */
    },
    {
    XtNdebugFile,
    XtCDebugFile,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, debug_filename),
    XtRString,
    (XtPointer) early_debug_filename,   /* default value */
    },
    {
    XtNvisualName,
    XtCVisualName,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, visualName),
    XtRString,
    (XtPointer) "not_specified",   /* default value */
    },
    {
    XtNpointerShape,
    XtCCursor,
    XtRCursor,
    sizeof(Cursor),
    XtOffsetOf(AppData, pointer_cursor),
    XtRString,
    (XtPointer) "crosshair",   /* default value */
    },
    {
    XtNfont,
    XtCFont,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, font_name),
    XtRString,
    (XtPointer) "6x13",   /* default value */
    },
    {
    XtNeightBit,
    XtCEightBit,
    XtRBoolean,
    sizeof(Boolean),
    XtOffsetOf(AppData, eight_bit),
    XtRImmediate,
    (XtPointer) FALSE,   /* default value */
    },
    {
    XtNinitialCommand,
    XtCInitialCommand,
    XtRString,
    sizeof(String),
    XtOffsetOf(AppData, initial_command),
    XtRString,
    (XtPointer) "",   /* default value */
    },
};

static void
usage(argc, argv)
int argc;
char **argv;
{
    int i;

    if(server_mode == FALSE)
    {
	printf("skyview version %s\n\n",Id+26);
	printf("usage: -s -d -n -display host:0.0\n");
	for (i = 1; i < argc; i++)
	    printf("    unrecognized option: %s\n", argv[i]);
    }
    exit(1);
}

#ifdef DEBUGX
static int
err_handler(dpy, myerr)
Display *dpy;
XErrorEvent *myerr;
{
    char msg[80];

    XGetErrorText(dpy, myerr->error_code, msg, 80);
    printf("Error code %s\n", msg);
}

/*ARGSUSED*/
static int
ioerr_handler(dpy)
Display *dpy;
{
    printf("RBH Fatal Error\n");
    abort();
}
#endif /* DEBUGX */

void
get_resources(argc, argv)
int *argc;
char **argv;
{
    static char first_command[300];
    char display_name[256];
    char prog_name[256];
    char *str_type[20];
    char err_msg[80];
    XrmValue value;
    XtAppContext app_context;
    XrmDatabase commandline_db;
    Widget topLevel;
    ArgList args;
    AppData app_data;
#ifdef DEBUG
    int i;
#endif /* DEBUG */

#ifdef DEBUGX
    XSetErrorHandler(err_handler);
    XSetIOErrorHandler(ioerr_handler);
#endif /* DEBUGX */

#ifdef DEBUG
    printf("\nRBH   before getting resources:  argc = %d\n", *argc);
    for (i = 0; i < *argc; i++)
	printf("argv[%d] =%s=\n",i, argv[i]);
#endif /* DEBUG */

    /* first look at command line for graphics and display */
    XrmInitialize();

    commandline_db = NULL;
    XrmParseCommand(&commandline_db, early_opTable, XtNumber(early_opTable),
            "skyview", argc, argv);

    /* get debug */
    if (XrmGetResource(commandline_db, "skyview.debug",
	"Skyview.Debug", str_type, &value) == True) 
    {
        if (strncmp(value.addr, "True", (int) value.size) == 0) 
	{
            debug = TRUE;
	}
    }

    if (XrmGetResource(commandline_db, "skyview.graphics",
	"Skyview.Graphics", str_type, &value) == True) 
    {
        if (strncmp(value.addr, "False", (int) value.size) == 0) 
	{
	    depth = 8;
            graphics = FALSE;
	}
    }

    if (XrmGetResource(commandline_db, "skyview.n24",
	"Skyview.N24", str_type, &value) == True) 
    {
        if (strncmp(value.addr, "True", (int) value.size) == 0) 
	{
	    depth = 24;
            graphics = FALSE;
	}
    }

    if (XrmGetResource(commandline_db, "skyview.s1serverMode",
	"Skyview.S1serverMode", str_type, &value) == True) 
    {
        if (strncmp(value.addr, "True", (int) value.size) == 0) 
	{
	    s1_server_mode = TRUE;
	    server_mode = TRUE;
	    mouse_is_on = 0;    /* disable mouse buttons commands */
	}
    }

    if (XrmGetResource(commandline_db, "skyview.adsserverMode",
	"Skyview.AdsServerMode", str_type, &value) == True) 
    {
        if (strncmp(value.addr, "True", (int) value.size) == 0) 
	{
	    ads_server_mode = TRUE;
	    server_mode = TRUE;
	    mouse_is_on = 0;    /* disable mouse buttons commands */
	}
    }

    if (XrmGetResource(commandline_db, "skyview.name",
	"Skyview.Name", str_type, &value) == True) 
    {
        strncpy(prog_name, value.addr, value.size);
	prog_name[value.size] = '\0';
    }
    else
	strcpy(prog_name, "skyview");

    if (XrmGetResource(commandline_db, "skyview.display",
	"Skyview.Display", str_type, &value) == True) 
    {
        strncpy(display_name, value.addr, value.size);
	display_name[value.size] = '\0';
    }
    else
    {
	display_name[0] = '\0';
    }

    if (XrmGetResource(commandline_db, "skyview.initialCommand",
	"Skyview.InitialCommand", str_type, &value) == True) 
    {
        strncpy(first_command, value.addr, value.size);
	first_command[value.size] = '\0';
	more = first_command;
	cmdline_mode = 1;
    }
    else
    {
	first_command[0] = '\0';
    }

    if (XrmGetResource(commandline_db, "skyview.debugFile",
	"Skyview.DebugFile", str_type, &value) == True) 
    {
        strncpy(early_debug_filename, value.addr, value.size);
	early_debug_filename[value.size] = '\0';
    }
    else
    {
	strcpy(early_debug_filename, "stdout");
    }

#ifdef DEBUG
    printf("\nRBH   after getting early resources:  argc = %d\n", *argc);
    for (i = 0; i < *argc; i++)
	printf("argv[%d] =%s=\n",i, argv[i]);
#endif /* DEBUG */


    /* connect to X server */

    if (graphics)
    {
	display = XOpenDisplay(display_name);
	if (!display)
	{
	    /* BUG: server_mode is not yet set from resources */
	    if(server_mode == FALSE)
		fprintf(stderr, "\7skyview:  unable to open display '%s'\n",
		    XDisplayName(display_name));
	    graphics = FALSE;
	}
    }
    
    if (!graphics)
    {
	return;
    }

    /* now use the X Intrinsics to get the resources */
    XtToolkitInitialize();
    app_context = XtCreateApplicationContext();
    XtDisplayInitialize(app_context, display, prog_name, "Skyview",
        opTable, XtNumber(opTable),   /* command line option list */
        argc, argv);                  /* command line args */
    args = NULL;
    topLevel = XtAppCreateShell(prog_name, "Skyview", 
	(WidgetClass)applicationShellWidgetClass, display, args, 0);
    resource_db = XtDatabase(display);

#ifdef DEBUG
    printf("\nRBH   after getting resources:  argc = %d\n", *argc);
    for (i = 0; i < *argc; i++)
	printf("argv[%d] =%s=\n",i, argv[i]);
    printf("\n");
#endif /* DEBUG */

    if ((*argc == 2) && (argv[1][0] != '-'))
    /* if one arg is left, it should be a filename to paint */
    {
	sprintf(first_command, "paint %s", argv[1]);
	more = first_command;
	cmdline_mode = 1;
	accepting_stdin = 0;
    }
    else if (*argc != 1)  /* if any args are left, it's an error */
	usage(*argc, argv);


    /* now use these resources to set program options  */


    XtGetApplicationResources(topLevel, &app_data, 
	resources, XtNumber(resources),
	NULL, 0);

    debug = app_data.debug;
    if (strcmp(app_data.debug_filename, "stdout") == 0)
    {
	debug_file = stdout;
    }
    else if (strcmp(app_data.debug_filename, "stderr") == 0)
    {
	debug_file = stderr;
    }
    else
    {
	debug_file = fopen(app_data.debug_filename, "w");
	if (debug_file == NULL)
	{
	    sprintf(err_msg, "cannot open debug_file %s",
		app_data.debug_filename);
	    perror(err_msg);
	    debug_file = stdout;
	}
	else
	{
	    fprintf(debug_file, "%s\n%s\n", version, Id);
	}
    }

    desired_colors = app_data.palette;
    strcpy(visualName, app_data.visualName);
    mouse_is_on = app_data.mouse;
    s0_server_mode = app_data.s0_server_mode;
    if (app_data.new_server_mode)
	ads_server_mode = TRUE;
    if (app_data.ads_server_mode)
	ads_server_mode = TRUE;
    if (app_data.s1_server_mode)
	s1_server_mode = TRUE;
    if (s1_server_mode || ads_server_mode)
	server_mode = TRUE;
    else
	server_mode = FALSE;

    if ((s0_server_mode) || (server_mode == TRUE))
	mouse_is_on = 0;    /* disable mouse buttons commands */
    if (debug)
    {
	fprintf(debug_file, "skyview invoked with debug mode on.\n");
	fprintf(debug_file, "app_data.palette = %d\n", 
	    app_data.palette);
	fprintf(debug_file, "app_data.visualName = %s\n", 
	    app_data.visualName);
	fprintf(debug_file, "app_data.imio_mode = %d\n", 
	    app_data.imio_mode);
	fprintf(debug_file, "app_data.debug_filename = %s\n", 
	    app_data.debug_filename);
	fprintf(debug_file, "app_data.font_name = %s\n", 
	    app_data.font_name);
	fprintf(debug_file, "app_data.eight_bit = %d\n", 
	    app_data.eight_bit);
	fprintf(debug_file, "app_data.s0_server_mode = %d\n", 
	    app_data.s0_server_mode);
	fprintf(debug_file, "app_data.s1_server_mode = %d\n", 
	    app_data.s1_server_mode);
	fprintf(debug_file, "app_data.ads_server_mode = %d\n", 
	    app_data.ads_server_mode);
	fprintf(debug_file, "app_data.new_server_mode = %d\n", 
	    app_data.new_server_mode);
	fprintf(debug_file, " s0_server_mode = %d\n", s0_server_mode);
	fprintf(debug_file, " s1_server_mode = %d\n", s1_server_mode);
	fprintf(debug_file, " server_mode = %d\n", server_mode);
	fprintf(debug_file, " ads_server_mode = %d\n", ads_server_mode);
    }
    imio_on = app_data.imio_mode;
    captive = app_data.captive_mode;
    force_colormap = app_data.force_colormap_install;
    strcpy(main_button1, app_data.main_button1);
    strcpy(main_button2, app_data.main_button2);
    strcpy(main_button3, app_data.main_button3);
    use_projtype = app_data.projtype;
    u16 = app_data.unsigned_16_bit;
    reread_on = app_data.reread;
    conserve_mem = app_data.conserve_mem;
    strcpy(ov_color, app_data.color);
    cursor = app_data.pointer_cursor;
    strcpy(default_font_name, app_data.font_name);
    eight_bit = app_data.eight_bit;

    if (app_data.initial_command[0] != '\0')
    {
	/* disregard if already set on command line */
	if (first_command[0] == '\0')
	{
	    strcpy(first_command, app_data.initial_command);
	    more = first_command;
	    cmdline_mode = 1;
	}
    }
    if (cmdline_mode)
    {
	s1_server_mode = TRUE;
	server_mode = TRUE;
	mouse_is_on = 0;    /* disable mouse buttons commands */
	if (debug)
	    fprintf(debug_file, "first_command = [%s]\n", first_command);
    }

#ifdef NOTDEF
    printf("RBH sending resource database to file glop.rm\n");
    XrmPutFileDatabase(XtDatabase(XtDisplay(topLevel)), "glop.rm");
#endif /* NOTDEF */
}
