/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include "skyview.h"
#include <stdio.h>

extern int force_graphics, graphics, debug, captive, server;
extern char version[];
extern int mouse_on;

usage()
{
    printf("%s\n\n",version);
    printf("usage: -s -d -g -n\n");
    exit(1);
}

get_resources(argc, argv)
int *argc;
char **argv;
{
    int i;
    char *cp;

    for (i = 1; i < *argc; i++)
    {
	cp = argv[i];
	if (*cp == '-')
	{
	    while ((*++cp) != NULL)   /* collect all options from this argv */
		switch (*cp)
		{
		    case 'd':    /* can be debug or display */

			if (!strcmp(argv[i], "-display"))
			{
			    /* -display is illegal on Jupiter */
			    usage();
			    exit(1);
			}
			else
			{
			    debug = TRUE;
			    printf("s invoked with debug mode on.\n");
			}
			break;
		    case 'g': 
			force_graphics = TRUE;
			break;
		    case 'n': 
			graphics = FALSE;
			break;
		    case 'c': 
			captive = TRUE;
			break;
		    case 's': 
			server = TRUE;
			mouse_on = 0;    /* disable mouse buttons commands */
			break;
		    default:
			printf("%s\n\n",version);
			printf("unrecognized argument: %c\n", *cp);
			exit(1);
		}
	}
	else
	{
	    usage();
	}
    }
}
