/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include "skyview.h"
#include "fits.h"
#include "parse.h"
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <string.h>
#include <sys/file.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

double atof();

struct hdrstruct hdr;

/* declarations for parse.c */
int debug, control_c, take_param;
int cmdline_mode = FALSE;   /* flag if parsing commands from command line */
FILE *session, *debug_file;
int server = FALSE;
int server_mode = FALSE;
int s1_server_mode = FALSE;
int ads_server_mode = FALSE;
char server_str[4096];


char *coord_name(coord_sys)
int coord_sys;
{
    return("");
}

void wait_for_event(pptr, what, x, y, dx, dy, nowait)
char *pptr;
int *what, *x, *y, *dx, *dy, nowait;
{
}
void
do_sync()
{
}
char *expand_path(inpath)
char *inpath;
{
    return("");
}
void
expand_alias(in, out)
char *in, *out;
{
}
void
enable_control_c()
{
}
void
main_command(p)
char *p;
{
}
char *tek_sequence(anin)
char *anin;
{
    return("");
}
/* end of declarations for parse.c */


/***************************************************/
/*                                                 */
/* REPLICATE expands an image by pixel replication */
/*                                                 */
/***************************************************/

int main(argc, argv)

int argc;
char **argv;

{
    char error_msg[80];
    short *shpin, *shpout;
    int n_read, line, hdr_len, bitpix;
    int samp, repl_samp, repl_line, n_line, n_samp;
    int i, j, n_in, n_out, *intpin, *intpout;
    int naxis1, naxis2;
    double cdelt1, cdelt2, crpix1, crpix2;
    int obuf[2000];
    int ibuf[2000];
    char buf[5000];
    char hdstr[31];
    char *p, *chpin, *chpout;

    int fin, fout;

    if (argc < 5)
    {
	fprintf(stderr, 
"usage: replicate <infile> <outfile> <samp_rep_factor> <line_rep_factor>\n");
	exit(1);
    }

    fin = open(argv[1], O_RDONLY, 0644);
    if (fin < 0)
    {
	perror(argv[1]);
	exit(1);
    }

    /* read the image file header */
    read(fin, &hdr, sizeof(hdr));

    if (hdr.tapetype != FITS)
    {
	fprintf(stderr, "error: replicate works only on s workfiles\n");
	exit(1);
    }

    fout = open(argv[2], O_WRONLY | O_CREAT, 0644);
    if (fout < 0)
    {
	sprintf(error_msg, "replicate error: cannot open output file %s", argv[2]);
	perror(error_msg);
	exit(1);
    }
    repl_samp = atoi(argv[3]);
    repl_line = atoi(argv[4]);

    /* Transfer the image file header */
    printf(" tapetype  = %d\n", hdr.tapetype);
    printf(" hdr_start = %lld\n", hdr.hdr_start);
    printf(" img_start = %lld\n", hdr.img_start);
    printf(" hist_start = %lld\n", hdr.hist_start);
    printf(" img_max = %d\n", hdr.img_max);
    printf(" img_min = %d\n", hdr.img_min);
    printf(" hist_bin_size = %d\n\n", hdr.hist_bin_size);

    hdr_len = hdr.img_start - hdr.hdr_start;

    write(fout, &hdr, sizeof(hdr));     /* write out to hold space */


    /* Fits header update and transfer */

    lseek(fin, hdr.hdr_start, 0);
    read(fin, buf, hdr_len);


    p = buf;
    for (i = 0; i < hdr_len; i += 80, p += 80)
    {
	switch(parse_fits(p))
	{
	    case BITPIX:
		bitpix = atoi(p+10);
		break;
	    case NAXIS1:
		strncpy(hdstr, p+10, 30);
		hdstr[30] = '\0';
		naxis1 = atoi(hdstr);
		n_samp = naxis1;
		printf("NAXIS1 is %d (%s)\n", naxis1, hdstr);
		naxis1 = naxis1 * repl_samp;
		sprintf(hdstr, "%d", naxis1);
		printf("changes to %d (%s)\n", naxis1, hdstr);
		strncpy(p+12, hdstr, 30);  /* 12 vice 10 to avoid bug in IM */
		break;
	    case NAXIS2:
		strncpy(hdstr, p+10, 30);
		hdstr[30] = '\0';
		naxis2 = atoi(hdstr);
		n_line = naxis2;
		printf("NAXIS2 is %d (%s)\n", naxis2, hdstr);
		naxis2 = naxis2 * repl_line;
		sprintf(hdstr, "%d", naxis2);
		printf("changes to %d (%s)\n", naxis2, hdstr);
		strncpy(p+12, hdstr, 30);
		break;
	    case CRPIX1:
		strncpy(hdstr, p+10, 30);
		hdstr[30] = '\0';
		crpix1 = atof(hdstr);
		printf("CRPIX1 is %-g (%s)\n", crpix1, hdstr);
		crpix1 = (crpix1 - 0.5) * repl_samp + 0.5;
		sprintf(hdstr, "%-g", crpix1);
		printf("changes to %-g (%s)\n", crpix1, hdstr);
		strncpy(p+12, hdstr, 30);
		break;
	    case CRPIX2:
		strncpy(hdstr, p+10, 30);
		hdstr[30] = '\0';
		crpix2 = atof(hdstr);
		printf("CRPIX2 is %-g (%s)\n", crpix2, hdstr);
		crpix2 = (crpix2 - 0.5) * repl_line + 0.5;
		sprintf(hdstr, "%-g", crpix2);
		printf("changes to %-g (%s)\n", crpix2, hdstr);
		strncpy(p+12, hdstr, 30);
		break;
	    case CDELT1:
		strncpy(hdstr, p+10, 30);
		hdstr[30] = '\0';
		cdelt1 = atof(hdstr);
		printf("CDELT1 is %-g (%s)\n", cdelt1, hdstr);
		cdelt1 = cdelt1 / repl_samp;
		sprintf(hdstr, "%-g", cdelt1);
		printf("changes to %-g (%s)\n", cdelt1, hdstr);
		strncpy(p+12, hdstr, 30);
		break;
	    case CDELT2:
		strncpy(hdstr, p+10, 30);
		hdstr[30] = '\0';
		cdelt2 = atof(hdstr);
		printf("CDELT2 is %-g (%s)\n", cdelt2, hdstr);
		cdelt2 = cdelt2 / repl_line;
		sprintf(hdstr, "%-g", cdelt2);
		printf("changes to %-g (%s)\n", cdelt2, hdstr);
		strncpy(p+12, hdstr, 30);
		break;

	}
    }

    for (i = 0; i < hdr_len; ++i)
	if (buf[i] == '\0')
	    buf[i] = ' ';

    write(fout, buf, hdr_len);

    printf("Header transferred, %d bytes.\n", hdr_len);

    printf("Image is %d by %d\n", n_samp, n_line);
    n_in = n_samp * bitpix / 8;
    n_out = n_in * repl_samp;



    /* Image transfer */


    for (line = 0; line < n_line; ++line)
    {
	read(fin, ibuf, n_in);

	printf("Line %d:\r", line);
	fflush(stdout);

	switch(bitpix)
	{
	    case 32:
		intpin = (int *) ibuf;
		intpout = (int *) obuf;

		for (samp = 0; samp < n_samp; ++samp)	/* For each sample */
		{
		    for (j = 0; j < repl_samp; ++j)
		    {
			*intpout++ = *intpin;
		    }
		    intpin++;
		}
		break;
	    case 16:
		shpin = (short *) ibuf;
		shpout = (short *) obuf;

		for (samp = 0; samp < n_samp; ++samp)	/* For each sample */
		{
		    for (j = 0; j < repl_samp; ++j)
		    {
			*shpout++ = *shpin;
		    }
		    shpin++;
		}
		break;
	    case 8:
		chpin = (char *) ibuf;
		chpout = (char *) obuf;

		for (samp = 0; samp < n_samp; ++samp)	/* For each sample */
		{
		    for (j = 0; j < repl_samp; ++j)
		    {
			*chpout++ = *chpin;
		    }
		    chpin++;
		}
		break;
	}

	for (i = 0; i < repl_line; ++i)
	    write(fout, obuf, n_out);
    }

    /* Copy the histogram information */

    lseek(fin, hdr.hist_start, 0);
    hdr.hist_start = lseek(fout, 0, 1);;
    while (FOREVER)
    {
	n_read = read(fin, buf, 2880);
	write(fout, buf, n_read);
	if (n_read != 2880)
	    break;
    }

    lseek(fout, 0, 0);		/* rewrite internal s header */
    write(fout, &hdr, sizeof(hdr));

    printf("\n");
    return(0);
}
