/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/********************************************************************/
/* 								    */
/* PUTHD -- Replaces the fits header information from a             */
/* SKYFLUX image file with that from a text file                    */
/* 								    */
/********************************************************************/


#include "skyview.h"
#include "range.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>


int debug, pixels, lines, bitpix, blank;
struct hdrstruct filehdr;
char hist_filnam[MAXPATHLEN], filnam[MAXPATHLEN];
double hist_min, hist_binsiz, iraf_min, iraf_max;
float hist_datamax, hist_datamin;  /* max, min found while doing hist */
float fblank;
int hist[HISTSIZ2+1];
double bscale, b_zero;
double slow, shigh;
int graphics = TRUE;
int server_mode = FALSE;
char fi_name[MAXPATHLEN] = "";
int debug_val = 0;
FILE *debug_file;
int minx = 0, maxx, miny = 0, maxy; 
int u16;
struct img *curr_img;
int llow_save, hhigh_save;
struct full_ra min_ra;
struct full_ra max_ra;
int be_quiet = 0;
int band_offset = 0;
int hist_band = 0;



int main(argc, argv)
int argc;
char **argv;

{
    int found_end;
    int total_bytes, needed_blocks;
    int lines, samples;
    int current_loc, needed_lines;
    int i, n_char, n_read;
    int posn, n_data, n_tot, shift;
    int fh, fi, fo, input_set, output_set, header_set, skip_set;
    int all_blank, skip;
    char *pt;
    char input[MAXPATHLEN], output[MAXPATHLEN], header[MAXPATHLEN];
    char line[80], buf[2880];
    struct hdrstruct hdr, nhdr;
    int hist2[HISTSIZ2 + 1];
    int bitpix, blank, hist_shift, byte_per_pix;


    debug_file = stdout;

    if ((argc == 1) || (argc > 5))
    {
	printf("usage: puthd if=imagefile [hf=tempfile] [of=outputfile]\n");
	exit(1);
    }




    /* Determine file names */

    strcpy(header, "temp.hdr");
    strcpy(output, "temp.img");
    input_set = FALSE;
    header_set = FALSE;
    output_set = FALSE;
    skip_set = FALSE;
    for (i = 1; i < argc; ++i)
    {
	pt = argv[i];
	if (strncmp(pt, "if=", 3) == 0)
	{
	    input_set = TRUE;
	    pt += 3;
	    strcpy(input, pt);
	}

	if (strncmp(pt, "of=", 3) == 0)
	{
	    output_set = TRUE;
	    pt += 3;
	    strcpy(output, pt);
	}

	if (strncmp(pt, "hf=", 3) == 0)
	{
	    header_set = TRUE;
	    pt += 3;
	    strcpy(header, pt);
	}

	if (strncmp(pt, "skip=", 5) == 0)
	{
	    skip_set = TRUE;
	    pt += 5;
	    skip = atoi(pt);
	}
    }

    if (input_set == FALSE)
    {
	printf("Input file was not specified.\n");
	exit(1);
    }
    else
    {
	fi = open(input, O_RDONLY, 0644);
	if (fi < 0)
	{
	    perror(input);
	    exit(1);
	}
    }

    if (output_set == FALSE)
	printf("outputting to file temp.img\n");
    fo = open(output, O_WRONLY | O_CREAT | O_TRUNC, 0644);
    if (fo < 0)
    {
	perror(output);
	exit(1);
    }

    if (header_set == FALSE)
	printf("using header from file temp.hdr\n");
    fh = open(header, O_RDONLY, 0644);
    if (fh < 0)
    {
	perror(header);
	exit(1);
    }



    /* Process the files */

    lseek(fi, 0, 0);
    read(fi, &hdr, sizeof(hdr));
#ifdef NOTDEF
    printf("\n Original File\n");
    printf(" ====================================\n");
    printf(" tapetype  = %d\n", hdr.tapetype);
    printf(" hdr_start = %d\n", hdr.hdr_start);
    printf(" img_start = %d\n", hdr.img_start);
    printf(" hist_start = %d\n", hdr.hist_start);
    printf(" img_max = %d\n", hdr.img_max);
    printf(" img_min = %d\n", hdr.img_min);
    printf(" hist_bin_size = %d\n\n", hdr.hist_bin_size);
#endif /* NOTDEF */


    /* Make first cut at binary header (change later) */

    nhdr.tapetype = INVALID;
    nhdr.hdr_start = hdr.hdr_start;
    nhdr.img_max = hdr.img_max;
    nhdr.img_min = hdr.img_min;
    nhdr.hist_bin_size = hdr.hist_bin_size;

    /* Write out new header */
    write(fo, &nhdr, sizeof(nhdr));



    switch (hdr.tapetype)
    {
    case 1397312848:
    case 1347242323:
	/* find the beginning of the pixels */
	lseek(fi, 0, 0);
	found_end = 0;
	while (!found_end)
	{
	    n_read = read(fi, buf, 2880);
	    pt = buf;
	    for (i = 0; i < 36; i++, pt+=80)
	    {
	    if (strncmp(pt, "END", 3) == 0)
		found_end = 1;
	    }
	}
	hdr.img_start = lseek(fi, 0, 1);
	/*
	printf("found END at byte %d\n", hdr.img_start);
	*/
	lseek(fo, 0, 0);  /* discard skyview workfile header */
	/* fall through */
    case FITS:
	{
	    posn = 0;
	    for (;;)
	    {
		lseek(fh, posn, 0);
		n_read = read(fh, buf, 80);

		if (n_read == 0)
		    break;

		all_blank = TRUE;
		for (i = 0; i < 80; ++i)
		{
		    posn++;
		    line[i] = buf[i];
		    if (buf[i] == '\n')
			break;
		    if (buf[i] != ' ')
			all_blank = FALSE;
		}



		for (i = i; i < 80; ++i)
		    line[i] = ' ';

		if (!all_blank)	/* discard blank lines */
		{
		    write(fo, line, 80);
		}

		if (strncmp(line, "NAXIS1", 6) == 0)
		{
		    samples = atoi(line + 10);
		}

		if (strncmp(line, "NAXIS2", 6) == 0)
		{
		    lines = atoi(line + 10);
		}

		if (strncmp(line, "BITPIX", 6) == 0)
		{
		    bitpix = atoi(line + 10);
		}

		if (strncmp(line, "END", 3) == 0)
		    break;
	    }

	    /* now round up to next 2880 byte block */
	    current_loc = lseek(fo, 0, 1);
	    nhdr.img_start =  (current_loc / 2880 + 1 ) * 2880;
	    needed_lines = (nhdr.img_start - current_loc) / 80;
	    for (i = 0; i < 80; ++i)
		line[i] = ' ';
	    for (i = 0; i < needed_lines; i++)
	    {
		write(fo, line, 80);
	    }



	    /* Copy the pixels and histogram */

	    /*
	    printf("RBH start of pixels = %d\n", hdr.img_start);
	    */
	    n_tot = 0;
	    lseek(fi, hdr.img_start, 0);
	    switch (bitpix)
	    {
		case -64:
		    byte_per_pix = 8;
		    break;
		case 32:
		case -32:
		    byte_per_pix = 4;
		    break;
		case 16:
		    byte_per_pix = 2;
		    break;
		case 8:
		    byte_per_pix = 1;
		    break;
	    }
	    total_bytes = samples * lines * byte_per_pix;
	    needed_blocks = total_bytes / 2880 + 1;
	    for (i = 0; i < needed_blocks; i++)
	    {
		n_data = read(fi, buf, 2880);
		n_tot += n_data;

		write(fo, buf, n_data);

		if (n_data != 2880)
		    break;
	    }

	    printf("\n %d bytes of image and histogram data transferred.\n", n_tot);
	    break;
	}
    case VICAR:
	{
	    printf("processing VICAR type image\n");
	    posn = 0;
	    lseek(fh, posn, 0);
	    n_read = read(fh, buf, 80);
	    for (;;)
	    {
		for (i = 0; i < 80; ++i)
		{
		    n_char = i;
		    line[i] = buf[i];
		    if (buf[i] == '\n')
			break;
		}

		posn += n_char + 1;

		for (i = n_char; i < 80; ++i)
		    line[i] = ' ';

		lseek(fh, posn, 0);
		n_read = read(fh, buf, 80);

		if (n_read == 0)
		{
		    line[71] = 'L';
		    write(fo, line, 72);	/* write last line */
		    break;
		}
		else
		{
		    line[71] = 'C';
		    write(fo, line, 72);	/* write last line */
		}

	    }


	    nhdr.img_start = lseek(fo, 0, 1);

	    /* Copy the pixels and histogram */

	    n_tot = 0;
	    lseek(fi, hdr.img_start, 0);
	    for (;;)
	    {
		n_data = read(fi, buf, 2880);
		n_tot += n_data;

		write(fo, buf, n_data);

		if (n_data != 2880)
		    break;
	    }

	    printf("\n %d bytes of image and histogram data transferred.\n", n_tot);
	    break;
	}
    default:
	{
	    printf("processing unknown type image file\n");
	    posn = 0;
	    lseek(fh, posn, 0);
	    n_read = read(fh, buf, 80);
	    if (strncmp(buf, "SIMPLE", 6) != 0)
	    {
		printf(
		    "The header in %s does not begin with SIMPLE\naborting\n", 
		    header);
		exit(1);
	    }
	    if (!skip_set)
	    {
		printf("skip how many bytes at the start of input file? ");
		scanf("%d", &skip);
	    }
	    posn = 0;
	    for (;;)
	    {

		all_blank = TRUE;
		for (i = 0; i < 80; ++i)
		{
		    posn++;
		    line[i] = buf[i];
		    if (buf[i] == '\n')
			break;
		    if (buf[i] != ' ')
			all_blank = FALSE;
		}

		for (i = i; i < 80; ++i)
		    line[i] = ' ';

		if (!all_blank)	/* discard blank lines */
		    write(fo, line, 80);

		if (strncmp(line, "BITPIX", 6) == 0)
		{
		    bitpix = atoi(line + 10);
		}
		if (strncmp(line, "BLANK", 5) == 0)
		{
		    blank = atoi(line + 10);
		}

		if (strncmp(line, "END", 3) == 0)
		    break;

		lseek(fh, posn, 0);
		n_read = read(fh, buf, 80);

		if (n_read == 0)
		    break;
	    }


	    nhdr.img_start = lseek(fo, 0, 1);

	    /* Copy the pixels and histogram */

	    for (i = 0; i < HISTSIZ2 + 1; i++)
		hist2[i] = 0;
	    nhdr.img_max = 0x80000001;
	    nhdr.img_min = 0x7fffffff;

	    switch (bitpix)
	    {
	    case 32:
		hist_shift = 20;
		byte_per_pix = 4;
		break;
	    case 16:
		hist_shift = 4;
		byte_per_pix = 2;
		break;
	    case 8:
		hist_shift = 0;
		byte_per_pix = 1;
		break;
	    }
	    n_tot = 0;
	    lseek(fi, skip, 0);
	    for (;;)
	    {
		n_data = read(fi, buf, 2880);
		n_tot += n_data;

		write(fo, buf, n_data);

		get_hist(bitpix, buf, n_data / byte_per_pix, &nhdr.img_min, &nhdr.img_max, blank, hist_shift, hist2);

		if (n_data != 2880)
		    break;
	    }
	    nhdr.hist_start = lseek(fo, 0, 1);
	    write(fo, hist2, sizeof(hist2));
	    n_tot += sizeof(hist2);

	    printf("\n %d bytes of image and dummy histogram data transferred.\n", n_tot);
	    nhdr.hist_bin_size = 1 << hist_shift;
	    nhdr.hdr_start = sizeof(hdr);

	    hdr.tapetype = FITS;
	    hdr.img_start = nhdr.img_start;
	    hdr.hist_start = nhdr.hist_start;
	    break;
	}
    }


    if ((hdr.tapetype == 1397312848) || (hdr.tapetype == 1347242323))
    {
	/* we're done if it's a pure FITS file */
	return(0);
    }

    /* Now fix up the binary header */

    shift = nhdr.img_start - hdr.img_start;
    nhdr.hist_start = hdr.hist_start + shift;
    nhdr.tapetype = hdr.tapetype;

#ifdef NOTDEF
    printf("\n Output File\n");
    printf(" ====================================\n");
    printf(" tapetype  = %d\n", nhdr.tapetype);
    printf(" hdr_start = %d\n", nhdr.hdr_start);
    printf(" img_start = %d\n", nhdr.img_start);
    printf(" hist_start = %d\n", nhdr.hist_start);
    printf(" img_max = %d\n", nhdr.img_max);
    printf(" img_min = %d\n", nhdr.img_min);
    printf(" hist_bin_size = %d\n\n", nhdr.hist_bin_size);
#endif /* NOTDEF */

    lseek(fo, 0, 0);
    write(fo, &nhdr, sizeof(nhdr));
    return(0);
}

/*ARGSUSED*/
void
error1(str)
char *str;
{
}

/*ARGSUSED*/
void
sperror(str, this_errno)
char *str;
int this_errno;
{
}

/*ARGSUSED*/
int
im_close(file_d)
int file_d;
{
    return(-3);
}


/*ARGSUSED*/
void *imget(fd, f_name)
int fd;
char *f_name;
{
    return(NULL);
}

void
create_hist_window()
{
}

void
fill_glob()
{
}

int wf_open()
{
}

/*ARGSUSED*/
int parse_minmax(input_string, ra_struct, which)
char *input_string;
struct full_ra *ra_struct;
int which;
{
}


