#include "skyview.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define LSIZE   132
#define AGRADIR "."

typedef struct Gpoint
{
    double x;
    double y;
} Gpoint;


static FILE   *fd;

static int open_font_done = 0;

#ifdef _NO_PROTO
static void open_font();
static int read_char();

#else
static void open_font(void);
static int read_char(int font, int nglyph);
#endif /* _NO_PROTO */

void
mlabel(lon0, lat0, str, chh, xor)
double lon0, lat0, chh;
char *str;
int xor;  /* flag that these characters should be drawn with XOR, */
	  /* and they should not go into graphics database */
{
   int ipoint;
   int i, j, k;
   int index, jump, len, nchar, nglyph, strlength, ref;
   int nstroke[200], chlen[200];
   int oldfont, newfont;
   int font_change = FALSE;
   int ix[200][150], iy[200][150];

   double u, v;
   double boxymin, boxymax, tmp;

   char line[132], dum[132], *cptr, *p;

   int   n;
   Gpoint pt[200];
   
   oldfont = 'r';
   strlength = 0;
   boxymin = boxymax = 82.;
   p = str;

   if (!open_font_done)
      open_font();

   if (open_font_done)
   {
   nchar = 0;
   while (*p != '\0')
      {
      if (*p == '\\')
	 {
	 p++;
	 if (*p == '\\')
	    {
	    font_change = FALSE;
	    p++;
	    oldfont = (unsigned int)(*p);
	    p++;
	    }
         else
	    {
	    font_change = TRUE;
	    newfont = (unsigned int)(*p);
	    p++;
	    }
         }

      nglyph = (int)(*p);

      if (font_change == TRUE)
	 {
         index = read_char(newfont, nglyph);
	 font_change = FALSE;
	 }
      else
         index = read_char(oldfont, nglyph);

      rewind(fd);

      for (;;)
	 {
	 if (fgets(line, LSIZE, fd) == NULL)
	       printf("Cannot find character #%d\n", index);

         line[strlen(line)-1] = '\0';

         strcpy(dum, line);
         dum[5] = '\0';
         ref = atoi(dum);
         if (ref == index)
	    break;
         }
      
      len = strlen(line);

      strcpy(dum, line);
      cptr = dum + 5;
      dum[8] = '\0';
      nstroke[nchar] = atoi(cptr);

      cptr = line+8;
      k = 0;
      len -= 8;

      for (j=0; j<nstroke[nchar]; ++j)
	  {
          ix[nchar][j] = (unsigned int) *cptr;
          iy[nchar][j] = (unsigned int) *(cptr+1);

	  if (j == 0)
	     {
	     chlen[nchar] = iy[nchar][j] - ix[nchar][j];
	     strlength += chlen[nchar];
	     }

          if (nchar==0 && j==1)
	     {
	     boxymin = iy[nchar][j];
	     boxymax = iy[nchar][j];
	     }

          if (j >= 1 && (iy[nchar][j] < boxymin)) boxymin = iy[nchar][j];
	  if (j >= 1 && (iy[nchar][j] > boxymax)) boxymax = iy[nchar][j];

          cptr += 2;
	  ++k;

	  if (2*k == len && j < nstroke[nchar]-1)
	     {
	     fgets(line, LSIZE, fd);
	     line[strlen(line)-1] = '\0';

	     k = 0;
	     cptr = line;
	     len = strlen(line);
	     }
          }
      nchar += 1;
      p++;
      }
   tmp = boxymin;
   
   boxymin = -boxymax;
   boxymax = -tmp;

   jump   = 0;

      u = lon0;
      v = lat0;


   for (i=0; i<nchar; i++)
       {
       n = 0;
       if (i==0)
	  jump = 0;
       else
	  jump += chlen[i-1];

       for (j=1;j<nstroke[i];++j)
          if (ix[i][j] == 32)
	     {
		/* flush n points described by pt */
		overlay_dmov(pt[0].x, pt[0].y);
		for (ipoint = 1; ipoint < n; ipoint++)
		{
		    if (xor)
			overlay_ddraw_n(pt[ipoint].x, pt[ipoint].y, xor);
		    else
			overlay_ddraw(pt[ipoint].x, pt[ipoint].y);
		}
		n = 0;
       	     }
          else
	     {
#ifdef NOTDEF
	     pt[n].x = u+chh/(boxymax-boxymin)*
		       (ix[i][j]-82-strlength/2.+jump);
#endif /* NOTDEF */
	     pt[n].x = u+chh/(boxymax-boxymin)*
		       (ix[i][j]-82+9+jump);
	     pt[n].y = v+chh/(boxymax-boxymin)*(-iy[i][j]+82+9);
	     ++n;
             }

       if (nstroke[i] > 1)
	  {
	     /* output n points pointed to by pt */
		overlay_dmov(pt[0].x, pt[0].y);
		for (ipoint = 1; ipoint < n; ipoint++)
		{
		    if (xor)
			overlay_ddraw_n(pt[ipoint].x, pt[ipoint].y, xor);
		    else
			overlay_ddraw(pt[ipoint].x, pt[ipoint].y);
		}
	  }
       }
        
   }
}


static void
open_font()
{
   char fname[132];

   if (getenv("AGRADIR") != NULL)
      {
      *fname = '\0';
      strcpy(fname, getenv("AGRADIR"));
      strcat(fname, "/font/hershey_oc.dat");
      fd = fopen(fname, "r");
      }
   
   else
      {
      *fname = '\0';
      strcpy(fname, AGRADIR);
      strcat(fname, "/font/hershey_oc.dat");
      fd = fopen(fname, "r");

      if (fd == NULL)
         {
         *fname = '\0';
         strcpy(fname, "../font/hershey_oc.dat");
         fd = fopen(fname, "r");
         }
      }

   if (fd != NULL)
      open_font_done = 1;
   
   else
      {
      printf("Font data is not found.\n");
      fflush(stdout);
      }
}


static int
read_char(font, nglyph)
int font, nglyph;
{
   static int table[96][5] = 
                            {{2199, 5009, 2198, 2199, 2198},          /* 32 */
                             {2214, 2131, 2764, 2214, 2282},          /* 33 */
                             {2217, 2134, 2778, 2217, 2283},          /* 34 */
                             {2275, 2147, 2275, 2275, 2284},          /* 35 */
                             {2274, 2402, 2769, 2274, 2285},          /* 36 */
                             {2271, 2199, 2271, 2271, 2286},          /* 37 */
                             {2272, 2276, 2768, 2772, 2287},          /* 38 */
                             {2251, 2236, 2777, 2751, 2288},          /* 39 */
                             {2221, 2281, 2771, 2221, 2289},          /* 40 */
                             {2222, 2284, 2772, 2222, 2290},          /* 41 */
                             {2219, 2235, 2773, 2219, 2291},          /* 42 */
                             {2232, 2233, 2775, 2232, 2292},          /* 43 */
                             {2211, 2245, 2761, 2211, 2293},          /* 44 */
                             {2231, 2234, 2774, 2231, 2301},          /* 45 */
                             {2210,  908, 2760, 2210, 2302},          /* 46 */
                             {2220, 2237, 2770, 2220, 2303},          /* 47 */
                             {2200,  700, 2750,  700, 3700},          /* 48 */
                             {2201,  701, 2751,  701, 3701},          /* 49 */
                             {2202,  702, 2752,  702, 3702},          /* 50 */
                             {2203,  703, 2753,  703, 3703},          /* 51 */
                             {2204,  704, 2754,  704, 3704},          /* 52 */
                             {2205,  705, 2755,  705, 3705},          /* 53 */
                             {2206,  706, 2756,  706, 3706},          /* 54 */
                             {2207,  707, 2757,  707, 3707},          /* 55 */
                             {2208,  708, 2758,  708, 3708},          /* 56 */
                             {2209,  709, 2759,  709, 3709},          /* 57 */
                             {2212, 2268, 2762, 2212, 2304},          /* 58 */
                             {2213, 2269, 2763, 2213, 2305},          /* 59 */
                             {2241, 2243, 2227, 2241, 2306},          /* 60 */
                             {2238, 2240, 2776, 2238, 2307},          /* 61 */
                             {2242, 2244, 2228, 2242, 2308},          /* 62 */
                             {2215, 2239, 2765, 2215, 2309},          /* 63 */
                             {2273,  745, 2273, 2273, 2310},          /* 64 */
                             {2001, 5007, 2551,  501, 3501},          /* 65 */
                             {2002, 2270, 2552,  502, 3502},          /* 66 */
                             {2003, 5004, 2553,  503, 3503},          /* 67 */
                             {2004, 2030, 2554,  504, 3504},          /* 68 */
                             {2005, 2260, 2555,  505, 3505},          /* 69 */
                             {2006, 2047, 2556,  506, 3506},          /* 70 */
                             {2007, 2029, 2557,  507, 3507},          /* 71 */
                             {2008, 2077, 2558,  508, 3508},          /* 72 */
                             {2009, 2230, 2559,  509, 3509},          /* 73 */
                             {2010, 2266, 2560,  510, 3510},          /* 74 */
                             {2011, 5005, 2561,  511, 3511},          /* 75 */
                             {2012, 2037, 2562,  512, 3512},          /* 76 */
                             {2013, 2262, 2563,  513, 3513},          /* 77 */
                             {2014, 2264, 2564,  514, 3514},          /* 78 */
                             {2015,  904, 2565,  515, 3515},          /* 79 */
                             {2016, 2042, 2566,  516, 3516},          /* 80 */
                             {2017, 2034, 2567,  517, 3517},          /* 81 */
                             {2018,  870, 2568,  518, 3518},          /* 82 */
                             {2019, 2044, 2569,  519, 3519},          /* 83 */
                             {2020, 5006, 2570,  520, 3520},          /* 84 */
                             {2021, 2046, 2571,  521, 3521},          /* 85 */
                             {2022, 5007, 2572,  522, 3522},          /* 86 */
                             {2023, 2050, 2573,  523, 3523},          /* 87 */
                             {2024, 2040, 2574,  524, 3524},          /* 88 */
                             {2025, 2049, 2575,  525, 3525},          /* 89 */
                             {2026, 5008, 2576,  526, 3526},          /* 90 */
                             {2223, 2277, 2223, 2223, 2311},          /* 91 */
                             { 804,  804,  804,  804, 2199},          /* 92 */
                             {2224, 2278, 2224, 2224, 2312},          /* 93 */
                             {2247, 2411, 2247, 2247, 2294},          /* 94 */
                             {5010, 2261, 5010, 5010, 5001},          /* 95 */
                             {2252, 2267, 2779, 2252, 5011},          /* 96 */
                             {2101, 2127, 2651,  601, 3601},          /* 97 */
                             {2102, 2128, 2652,  602, 3602},          /* 98 */
                             {2103, 2148, 2653,  603, 3603},          /* 99 */
                             {2104, 2130, 2654,  604, 3604},          /* 100 */
                             {2105, 2184, 2655,  605, 3605},          /* 101 */
                             {2106, 2186, 2656,  606, 3606},          /* 102 */
                             {2107, 2129, 2657,  607, 3607},          /* 103 */
                             {2108, 2133, 2658,  608, 3608},          /* 104 */
                             {2109, 2135, 2659,  609, 3609},          /* 105 */
                             {2110, 2265, 2660,  610, 3610},          /* 106 */
                             {2111, 2136, 2661,  611, 3611},          /* 107 */
                             {2112, 2137, 2662,  612, 3612},          /* 108 */
                             {2113, 2138, 2663,  613, 3613},          /* 109 */
                             {2114, 2139, 2664,  614, 3614},          /* 110 */
                             {2115, 2141, 2665,  615, 3615},          /* 111 */
                             {2116, 2142, 2666,  616, 3616},          /* 112 */
                             {2117, 2185, 2667,  617, 3617},          /* 113 */
                             {2118, 2143, 2668,  618, 3618},          /* 114 */
                             {2119, 2144, 2669,  619, 3619},          /* 115 */
                             {2120, 2145, 2670,  620, 3620},          /* 116 */
                             {2121, 2146, 2671,  621, 3621},          /* 117 */
                             {2122,  871, 2672,  622, 3622},          /* 118 */
                             {2123, 2150, 2673,  623, 3623},          /* 119 */
                             {2124, 2140, 2674,  624, 3624},          /* 120 */
                             {2125, 2149, 2675,  625, 3625},          /* 121 */
                             {2126, 2132, 2676,  626, 3626},          /* 122 */
                             {2225, 2227,  741, 2225, 2199},          /* 123 */
                             {2229, 2230,  742, 2229, 2199},          /* 124 */
                             {2226, 2228,  743, 2226, 2199},          /* 125 */
                             {2246, 2263,  744, 2246, 2199},          /* 126 */
                             {2218, 2218, 2199, 2218, 2199}};         /* 127 */
   
   int m, n;

   switch(font)
      {
      case 'r': n = 0;
	 break;
      case 'g': n = 1;
	 break;
      case 's': n = 2;
	 break;
      case 't': n = 3;
	 break;
      case 'o': n = 4;
	 break;
      default:
	 printf("Illegal option\n");
      }

   m = nglyph - ' ';
   
   return(table[m][n]);
}
