/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/


/************************************************************************/
/*                                                                      */
/* MAP                                                                  */
/* allows the user to enable the red, green, or blue images             */
/*                                                                      */
/************************************************************************/

#include "skyview.h"
#include "jgio.h"
#include "jconfig.h"

extern  JFILE  *J12file;
extern int debug;
extern char plane;


map(argc, argv)

int argc;
char **argv;

{
     char *p;

     if(argc == 1)
	  printf("current mapping: %c\n", plane);

     if(argc == 2)
	  {
	  p = argv[1];
	  if(strlen(p) > 1)
	       p[1] = '\0';

	  if(strcmp(p,"a") == 0)
	       plane = 'a';

          if(strcmp(p,"r") == 0)
	       plane = 'r';

          if(strcmp(p,"g") == 0)
	       plane = 'g';

          if(strcmp(p,"b") == 0)
	       plane = 'b';
          }

     if(debug == TRUE)
	  printf("map:  plane = %c\n", plane);

     image_setup(plane);
}




/************************************************************************/
/*                                                                      */
/* ERASE                                                                */
/* allows the user to erase the red, green, or blue images or the       */
/* red, green, blue, or white overlays                                  */
/*                                                                      */
/************************************************************************/


erase(argc, argv)

int argc;
char **argv;

{
    int image;
    char color;

    if(argc == 1)
	color = 'a';

    if(argc == 2)
    {
	if(argv[1][1] == 'o')
	    image = FALSE;
	else
	    image = TRUE;

	switch(argv[1][0])
	{
	    case 'a':
	    case 'r':
	    case 'g':
	    case 'b':
		color = argv[1][0];
		break;
	    case 'w':
		if (!image)
		{
		    color = argv[1][0];
		    break;
		}
	    default:
		printf("erase: color not recognized\n");
		error();
		return;
	}

    }

    if(debug == TRUE)
	printf("erase: %s color = %c\n", image ? "image" : "overlay", color);


    if(image == FALSE || argc == 1)
    {
	overlay_setup(color);
	j_erase();
    }

    if(image == TRUE || argc == 1)
    {
	image_setup(color);
	map_for_AOI(color);
	j_erase();
	map_normal();
	image_setup(plane);
	if (color == 'a')
	    clear_img();   /* screen mgmt */
    }

    jfflush(J12file);
}





/*********************************************************************/
/*                                                                   */
/* OVERLAY_SETUP                                                     */
/* enable a specific overlay plane for writing or erasing            */
/*                                                                   */
/*********************************************************************/


overlay_setup(color)

char color;

{  
    int dummy, mask;
    struct jbdmap bdtab;
    register short *p, *lim;
#if defined(VAXJUP) || defined(SUNJUP)
    int s = sizeof(bdtab) / sizeof(short);
#endif VAXJUP || SUNJUP

     if(debug == TRUE)
	  printf("overlay_setup: color = %c\n", color);

     switch(color)
	  {
	  case 'r'  :   mask = 1;
		        break;

	  case 'g':   mask = 2;
		        break;

	  case 'b' :   mask = 4;
		        break;

	  case 'w':   mask = 8;
		        break;

	  case 'a'  :   mask = 15;
		        break;
	  }

     bdtab.bd_p[0].bd_map = 0;

     bdtab.bd_p[0].bd_nabl = 0;
     bdtab.bd_p[1].bd_map = 0;
     bdtab.bd_p[1].bd_nabl = 0;
     bdtab.bd_p[2].bd_map = 0;
     bdtab.bd_p[2].bd_nabl = 0;
     bdtab.bd_p[3].bd_map = 0x0000;
     bdtab.bd_p[3].bd_nabl = 0x03;

     bdtab.bd_1st_cyc = 3;
     bdtab.bd_effect = 1;

     jf_bdmap(&bdtab, J12file);

#if defined(VAXJUP) || defined(SUNJUP)
     /*
      * set the cursor board map also 
      */
	(void) jgrabv(1 + s, J12file);
	(void) jputv(J_CBDTAB, J12file);
	for (p = (short *)&bdtab, lim = p + s; p < lim; p++)
		(void) jputv(*p, J12file);
#endif VAXJUP || SUNJUP

     j_wmask(mask);

#ifdef SUNJUP
     j_oi_sel(OI_OVERLAYS);
     j_cursor_sel(OI_OVERLAYS);   /* RBH added at suggestion of Jack Kl. */
#endif SUNJUP

     jfflush(J12file);

#ifdef SUNJUP
     j_nboards(&dummy);
#endif SUNJUP
}  




/**********************************************************************/
/*                                                                    */
/* IMAGE_SETUP                                                        */
/* if color = RED  enable memory boards 2 and 3                       */
/*          = GREEN    4 and 5                                        */
/*          = BLUE     6 and 7                                        */
/*                                                                    */
/*          = ALL      2 through 7                                    */
/*                                                                    */
/*          (not boards 0 and 1, these are actually the same board    */
/*           which is used for the overlays)                          */
/*                                                                    */
/**********************************************************************/

image_setup(color)

char color;

{  
     struct jbdmap bdtab;
     int dummy;

     if(debug == TRUE)
	  printf("image_setup: color = %c\n", color);

     bdtab.bd_p[0].bd_map = 0;
     bdtab.bd_p[0].bd_nabl = 0;
     bdtab.bd_p[1].bd_map = 0;
     bdtab.bd_p[1].bd_nabl = 0;
     bdtab.bd_p[2].bd_map = 0;
     bdtab.bd_p[2].bd_nabl = 0;

     switch(color)
         {
         case 'a':
              {
	      bdtab.bd_p[3].bd_map = 0x4440;
	      bdtab.bd_p[3].bd_nabl = 0xfc;
	      break;
              }

         case 'r':
              {
	      bdtab.bd_p[3].bd_map = 0x0040;
	      bdtab.bd_p[3].bd_nabl = 0x0c;
	      break;
              }

         case 'g':
              {
	      bdtab.bd_p[3].bd_map = 0x0400;
	      bdtab.bd_p[3].bd_nabl = 0x30;
	      break;
              }

         case 'b':
              {
	      bdtab.bd_p[3].bd_map = 0x4000;
	      bdtab.bd_p[3].bd_nabl = 0xc0;
	      break;
              }
	 default:
	    return;
         }


     bdtab.bd_1st_cyc = 3;
     bdtab.bd_effect = 1;

     jf_bdmap(&bdtab, J12file);
     j_wmask(0xff);

#ifdef SUNJUP
     j_oi_sel(OI_IMAGE);
#endif SUNJUP

     jfflush(J12file);

#ifdef SUNJUP
     j_nboards(&dummy);   /* reading from slice does a very thorough flush */
			  /* Graphics got botched without it */
#endif SUNJUP
}




/*********************************************************************/
/*                                                                   */
/* ZOOM_SETUP                                                        */
/* enable all the planes (specifically so all can be panned/zoomed)  */
/*                                                                   */
/*********************************************************************/


zoom_setup()

{  
     int mask = 255;
     struct jbdmap bdtab;


     bdtab.bd_p[0].bd_map = 0;
     bdtab.bd_p[0].bd_nabl = 0;
     bdtab.bd_p[1].bd_map = 0;
     bdtab.bd_p[1].bd_nabl = 0;
     bdtab.bd_p[2].bd_map = 0;
     bdtab.bd_p[2].bd_nabl = 0;
     bdtab.bd_p[3].bd_map = 0x4440;
     bdtab.bd_p[3].bd_nabl = 0xff;

     bdtab.bd_1st_cyc = 3;
     bdtab.bd_effect = 1;

     jf_bdmap(&bdtab, J12file);
     j_wmask(mask);
#ifdef SUNJUP
     j_oi_sel(OI_BOTH);
#endif SUNJUP
     jfflush(J12file);
}  

/* map_for_AOI sets up board mapping for Area-of-Interest transfer */
map_for_AOI(this_plane)
char this_plane;
{
    switch(this_plane)
    {
	case 'a':
	    j_bdepth(ID_BUF1, 0, 8);
	    break;
	case 'r':
	    j_depth(8, 8);
	    break;
	case 'g':
	    j_depth(16, 8);
	    break;
	case 'b':
	    j_depth(24, 8);
	    break;
    }
}

/*  map_normal resets damage done by map_for_AOI()  */
map_normal()
{
    j_bdepth(ID_BUF1, 0, 16);   /* reset to standard */
}
