/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include "skyview.h"
#include <stdio.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <strings.h>
#include <sys/file.h>

struct hdrstruct    hdr;


/***************************************************/
/*                                                 */
/* LINBACK removes a bilinear background from      */
/* an image                                        */
/*                                                 */
/***************************************************/

main (argc, argv)

int     argc;
char  **argv;

{
    int     n_read, line, hdr_offset, hdr_len;
    int     samp, val0, dval_samp, dval_line, n_line, n_samp;
    int     i, val, val_min, n_byte;
    double  slp_line, slp_samp;
    int     obuf[2000];
    int     ibuf[2000];
    char    buf[5000];
    int     hist[HISTSIZ2 + 1];

    int     fin, fout;

    fin = open (argv[1], O_RDONLY, 0644);
    fout = open (argv[2], O_WRONLY | O_CREAT, 0644);
    if (fout < 0)
    {
	printf("flatten error: cannot open output file %s\7\n", argv[2]);
	exit(1);
    }

    n_samp = atoi (argv[3]);
    n_line = atoi (argv[4]);
    printf ("\nImage is %d lines by %d samples \n\n", n_line, n_samp);

    val0 = atoi (argv[5]);
    dval_samp = atoi (argv[6]);
    dval_line = atoi (argv[7]);

    n_byte = 4 * n_samp;


 /* Find the offset for the start of the image data */

    read (fin, &hdr, sizeof (hdr));
    write (fout, &hdr, sizeof (hdr));

    hdr_offset = hdr.hdr_start;
    hdr_len = hdr.img_start - hdr.hdr_start;
    lseek (fin, hdr_offset, 0);

    read (fin, buf, hdr_len);
    write (fout, buf, hdr_len);

    slp_samp = (double) dval_samp / (double) n_samp;
    slp_line = (double) dval_line / (double) n_line;

    hdr.img_max = 0x80000001;
    hdr.img_min = 0x7fffffff;

    for (line = 0; line < n_line; ++line)
    {
	read (fin, ibuf, n_byte);

	for (samp = 0; samp < n_samp; ++samp)/* For each sample */
	{
	    if (ibuf[samp] == -2000000000)
		obuf[samp] = ibuf[samp];

	    else		/* The background must be flattened */
	    {
		val = val0 + (double) samp * slp_samp + (double) line * slp_line;

		obuf[samp] = ibuf[samp] - val;

		if (obuf[samp] > hdr.img_max)
		    hdr.img_max = obuf[samp];
		if (obuf[samp] < hdr.img_min)
		    hdr.img_min = obuf[samp];
	    }
	}

	write (fout, obuf, n_byte);

	printf ("line: %d\r", line);
	fflush (stdout);
    }

 /* create dummy histogram */

    for (i = 0; i < HISTSIZ2 + 1; i++)
	hist[i] = 0;
    write (fout, hist, sizeof(hist));


 /* Change the header information */
    hdr.hist_bin_size = 0x7fffffff;  /* make sure histogram will be recalced */
    lseek (fout, 0, 0);
    write (fout, &hdr, sizeof (hdr));

    printf ("\n\nBackground removed from %s,\n Output image is %s\n",
	    argv[1], argv[2]);
}
