/*
Copyright (C) 1995, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include <X11/Xlib.h>
#include "skyview.h"
#include "parse.h"
#include "img_x.h"
#include "img.h"
#include <stdio.h>
#include <string.h>


extern int mouse_is_on, ads_signal;
extern int server_mode;
extern Window cur_window, win;

char main_button1[256];
char main_button2[256];
char main_button3[256];

/************************************************************/
/*                                                          */
/* MAIN_COMMAND gets a command string, either from the       */
/* keyboard or from the trackball keys.                     */
/*                                                          */
/* Input: p is pointer to char array for the input chars    */
/*                                                          */
/************************************************************/

void
main_command(p)
char *p;
{
    int dummy_x = 0, dummy_y = 0, dummy_dx, dummy_dy;
    int got_button, done, what;
    char *button_text;

    done = 0;
    while(!done)
    {
	got_button = 0;

	wait_for_event(p, &what, &dummy_x, &dummy_y, &dummy_dx, &dummy_dy, 0);

	if (what == TTYINPUT)
	    return;

	switch(what)
	{
	case Button1:
	    button_text = main_button1;
	    got_button = 1;
	    break;

	case Button2:
	    button_text = main_button2;
	    got_button = 1;
	    break;

	case Button3:
	    button_text = main_button3;
	    got_button = 1;
	    break;
	/* others:  continue looping - ignor POINTERMOTION */
	}
	if (got_button)
	{
	    /* try to load globals for window receiving this button event */
	    if (win != cur_window)
		(void) find_WIN(cur_window);
	    if (mouse_is_on)
	    {
		strcpy(p, button_text);
		if(server_mode == FALSE)
		    printf("%s\n", p);
		ads_signal = 1;
		done = 1;
	    }
	}
    }
}
