/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include <stdio.h>
#include <fcntl.h>
#include <sgtty.h>
#include <sys/types.h>
#include "parse.h"

#define FALSE   0
#define TRUE    1

#define FOREVER TRUE

extern int debug, graphics, mouse_on;
extern int ttyfd, Ball_fd;
extern int x_orig, y_orig, x_zoom, y_zoom;


/************************************************************/
/*                                                          */
/* WAIT_FOR_EVENT waits for the next user action.           */
/*                                                          */
/* Arguments:                                               */
/*   pptr:  returns pointer to TTYINPUT string              */
/*   what:  returns indication of what user action occurred */
/*      Button1                                             */
/*      Button2                                             */
/*      Button3                                             */
/*      TTYINPUT (from keyboard)                            */
/*      POINTERMOTION                                       */
/*    x, y:  final position of pointer.  Will be            */
/*           constrained to visible screen.                 */
/*           If the pointer device returns relative values  */
/*           (dx and dy), then x and y must have            */
/*           legitimate values on input.                    */
/*    dx, dy:  pointer device motion.  dy is positive in    */
/*             up direction.                                */
/*                                                          */
/* NOTE: If your console keyboard driver cannot handle      */
/*       the select() function, use keys_old.c              */
/*                                                          */
/************************************************************/

wait_for_event(pptr, what, x, y, dx, dy, nowait)
char *pptr;     /* place to store keyboard input line */
int *what;      /* what ended event wait */
int *x, *y;
int *dx, *dy;
int nowait;  /* not used on jupiter */
{
    int n_read, n_ready;
    int pint[5], button[3];
    int power, scale;
    int nfound;
    int x_size, y_size;
    fd_set fdset;

    /* get events */
    *pptr = '\0';
    *what = 0;
    *dx = 0;
    *dy = 0;

    power = 2;
    scale = 1;
    x_size = 1280 / x_zoom;
    y_size = 1024 / y_zoom;


    /* get ready for select call */

    while (FOREVER)
    {
	/*
	if (debug)
	    printf ("entering select   Ball_fd = %d  ttyfd = %d\n", Ball_fd, ttyfd);
	*/
	FD_ZERO(&fdset);
	FD_SET(ttyfd, &fdset);
	if (graphics)
	    FD_SET(Ball_fd, &fdset);
	add_callbacks(&fdset);
	nfound = select(getdtablesize(), &fdset, 0, 0, 0);


	if (FD_ISSET(Ball_fd, &fdset))
	{
	if(ball1(pint, power, scale) == TRUE)     /* Trackball Keys */
	{
	    if (pint[2] == 1)
		*what = Button1;
	    else if (pint[3] == 1)
		*what = Button2;
	    else if (pint[4] == 1)
		*what = Button3;
	    else
	    {
		*dx = *pint;
		*dy = *(pint + 1);

		*x += *dx;
		*y += *dy;

		/* Check range on x,y */

		if (*x < x_orig - 640)
		    *x += 1280;   /* do the big step if necessary */

		if (*x > x_orig + x_size + 640)
		    *x -= 1280;   /* do the big step if necessary */

		while(*x < x_orig)
		    *x += x_size;   /* little steps */

		while(*x >= x_orig + x_size)
		    *x -= x_size;

		*x = *x % 1280;


		if (*y < y_orig - 512)
		    *y += 1024;   /* do the big step if necessary */

		if (*y > y_orig + y_size + 512)
		    *y -= 1024;   /* do the big step if necessary */

		while(*y < y_orig)
		    *y += y_size;

		while(*y >= y_orig + y_size)
		    *y -= y_size;

		*y = *y % 1024;

		*what = POINTERMOTION;
	    }
	    break;
	}
	}
	else if (FD_ISSET(ttyfd, &fdset))
	{
	    n_read = read(ttyfd, pptr, MAXLINE);
	    if (n_read > 0)
	    {
		*(pptr + n_read - 1) = '\0';
	    }
	    else
	    {
		/* EOF on stdin means we're all done */
		strcpy(pptr, "unix (simulated)");
	    }

	    *what = TTYINPUT;
	    break;
	}
	else
	{
	    /* some forked job now is sending back output */
	    do_callback(&fdset);
	    continue;
	}
    }
}



/************************************************************/
/*                                                          */
/* MAIN_COMMAND gets a command string, either from the       */
/* keyboard or from the trackball keys.                     */
/*                                                          */
/* Input: p is pointer to char array for the input chars    */
/*                                                          */
/************************************************************/

main_command(p)
char *p;
{
    int dummy_x = 0, dummy_y = 0, dummy_dx, dummy_dy;
    int done, what;

    done = 0;
    while(!done)
    {
	wait_for_event(p, &what, &dummy_x, &dummy_y, &dummy_dx, &dummy_dy, 0);

	if (what == TTYINPUT)
	    return;
	if (!mouse_on)
	    continue;

	switch(what)
	{
	case Button1:
	    strcpy(p, "st");
	    printf("color table stretch\n");
	    done = 1;
	    break;

	case Button2:
	    strcpy(p, "pi");
	    printf("pick position and flux\n");
	    done = 1;
	    break;

	case Button3:
	    strcpy(p, "zp");
	    printf("zoom and pan image\n");
	    done = 1;
	    break;
	/* others:  continue looping - ignor POINTERMOTION */
	}
    }
}
