/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <time.h>
#include <sys/time.h>
#include <sys/select.h>

struct job_info
{
    struct job_info *llink, *rlink;
    int pid;
    char pidname[MAXPATHLEN];
    FILE *fp;     /* use to read from child */
    FILE *fpout;  /* use to write to child */
    int valid_callback;
#ifdef _NO_PROTO
    void (*callback)();    /* callback function */
#else
    void (*callback)(struct job_info *p);    /* callback function */
#endif /* _NO_PROTO */
    struct img *imgp;
    char job_argfilname[MAXPATHLEN];
};

/* function prototypes */
#ifdef _NO_PROTO

struct job_info *add_job();
struct job_info *find_job();
struct job_info *find_next_job();
struct job_info *find_first_job();
void del_job();
int duplex_pipe();
void add_callbacks();
void do_callback();
void nop_callback();
void check_forks();

#else

struct job_info *add_job(void);
struct job_info *find_job(int pid);
struct job_info *find_next_job(struct job_info *psave_local);
struct job_info *find_first_job(void);
void del_job(struct job_info *p);
int duplex_pipe(char *argv[], FILE **readfd, FILE **writefd, 
    struct job_info **jobptr);
void add_callbacks(fd_set *fdset);
void do_callback(fd_set *fdset);
void nop_callback(struct job_info *job);
void check_forks(void);

#endif /* _NO_PROTO */
