/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

struct framestruct {

    /* In skyview, a frame is exactly a Window, so this stuff is "per Window"  */

    Window win;
    unsigned int win_width, win_height;  /* current dimensions of win */

    XImage *theImage;

    unsigned char *image_org;    /* original buffer for xwindow pixels */
    unsigned int width_org, height_org;  /* dimensions of image_org */
				     
    unsigned char *image_zoomed;    /* buffer for xwindow pixels after zoom */
    unsigned int width_zoomed, height_zoomed;  /* dimensions of image_zoomed */
    double win_zoom;                /* zoom factor     */
    int win_x_offset, win_y_offset;   /* and translation */
    int imio_last_x, imio_last_y;
    int mapped;   /* 1 if mapped;  0 if unmapped */
    int frame_graphics;   /* flag if this frame was painted with graphics on */
    };

/* function prototypes */
#ifdef _NO_PROTO

struct img *find_WIN();
struct img *find_WIN_again();
void delete_WIN();
void repaint_graphics();
void erase_window_graphics();
void overlay_string();
void draw_box();
void draw_circle();
void draw_ellipse();
void set_motion_notify();
void clear_motion_notify();
void get_ellipse_points();
void mag_motion();
void load_font();
GC delete_RGB();
GC lookup_RGB();
Window new_window();
int dmpcolor();
GC get_rgb();

#else

struct img *find_WIN(Window win1);
struct img *find_WIN_again(struct img *p);
void delete_WIN(void);
void repaint_graphics(Drawable dest);
void erase_window_graphics(Window win1);
void overlay_string(double x, double y, char *text, Font desired_font_id,
  double font_size);
void draw_box(Window box_win, GC gc, int x, int y, 
    int box_width, int box_height);
void draw_circle(Window circle_win, GC gc, int x, int y, unsigned int radius);
void draw_arc(Window arc_win, GC gc, int x, int y, unsigned int radius, 
    double angle1, double angle_extent);
void draw_ellipse(Window ellipse_win, GC gc, int x, int y, 
    int width, int height, double angle);
void set_motion_notify(Window wind);
void clear_motion_notify(void);
void get_ellipse_points(double x, double y, 
    double half_width, double half_height, double angle, XPoint *points);
void mag_motion(Window wind, int x, int y);
void load_font(XFontStruct **font_info1, char *fontname);
GC delete_RGB(XColor *user_color);
GC lookup_RGB(XColor *user_color);
Window new_window(int x, int y, unsigned int width, unsigned int height);
int dmpcolor(GC gc_color);
GC get_rgb(char *color);

#endif /* _NO_PROTO */

