#include <sys/param.h>

#define SZ_WCSBUF       320     /* WCS text buffer size          */

struct img {

    struct img *llink, *rlink;
    char filnam[MAXPATHLEN]; /* current image workfile name   */
			     /* (with path already prepended) */
    char mod_filnam[12];    /* scratch filename for a modified file (zapped) */
    struct hdrstruct filehdr;

    int bitpix;         /* bits per pixel on tape and in workfile */
    int u16;             /* flag to treat BITPIX 16 as unsigned */
    int blank_set;         /* flag if blank has meaning */
    double blank;          /* value of missing pixel */
    double report_blank;   /* value to report to user */
    int naxis;
    int pixels;         /* NAXIS1 - pixels per line */
    int lines;          /* NAXIS2 - lines in image */
    int naxis3;
    double cdelt1, cdelt2, twist;  /* pixel dimensions, deepsky twist angle */
    double cd1_1, cd1_2, cd2_1, cd2_2;
    double dc1_1, dc1_2, dc2_1, dc2_2;
    int using_cd;
    double crpix1, crpix2;
    double bscale, b_zero, glat, glong, crval3;
    char bunit[80];   /* units of pixel flux value */
    char ctype1[80], ctype2[80];  /* strings "lat", "lon", etc. */
    char ctype1sav[80], ctype2sav[80];  /* strings saved for tapewrite */
    char object[80];        /* name of object */
    int maptype;           /* projection type */
    int map_distortion;    /* flag for SIRTF distortion corrections */
    int a_order, ap_order, b_order, bp_order;      /* distortion corrections */
    double a[5][5], ap[5][5], b[5][5], bp[5][5];  /*  distortion corrections */
    double base, noise;    /* deepsky stuff */
    int dskygrid;
    int x_offset;       /* relationship of screen x to image sample */
    int minx, maxx, miny, maxy;  /* screen coords of image corners */
    int sgn_y, y_offset;   /* relationship of screen y to image line */
    int file_coord_sys;    /* set by set_file_sys() based on ctype1 */
    double iraf_max, iraf_min;
    int band_offset;
    double slow, shigh;    /* range stretch used on this image */
    int mode_used;         /* mode log vs linear used on this image */
    int samp_disp;   /* pixel displacement from left edge to 1st desired */
    int line_disp;  /* line displacement from top edge to 1st desired line */
    int graphics_window;
    double file_equinox;
    char radecsys[80];
    int imio_config;  /* IRAF IMIO frame buffer config */
    int imio_frame;   /* IRAF IMIO frame */
    int imio_ok;      /* IRAF IMIO ok to paint into this frame  */
    char *imio_filptr; /* IRAF IMIO file pointer for this frame  */
    char wcsbuf[SZ_WCSBUF]; /* IRAF "world coord system"         */

    /* stuff below stolen from Doug Mink's saoimage */
/* saoimage/wcslib/wcs.h
   March 6, 1995
   By Doug Mink, Harvard-Smithsonian Center for Astrophysics */

    double	plate_ra;	/* Right ascension of plate center */
    double	plate_dec;	/* Declination of plate center */
    double	x_pixel_offset;	/* X pixel offset of image lower right */
    double	y_pixel_offset;	/* Y pixel offset of image lower right */
    double	x_pixel_size;	/* X pixel_size */
    double	y_pixel_size;	/* Y pixel_size */
    double	ppo_coeff[6];
    double	amd_x_coeff[20]; /* X coefficients for plate model */
    double	amd_y_coeff[20]; /* Y coefficients for plate model */
    double	plt_scale; /* plate scale arc sec per mm */

    /* stuff below added for X windows */
    int image_frame;
    struct framestruct *frameptr;
    };

/* function prototypes */
#ifdef _NO_PROTO

int wf_open();
struct img *find_FILNAM();
struct img *peek_FILNAM();
struct img *find_last_img();
struct img *find_previous_img();
struct img *find_SC();
struct img *find_IM();
struct img *find_IRAF();
struct img *find_COORD();
struct img *new_img();
struct img *peek_FRAME();
struct img *sky_to_image();
struct img *find_IMIO();
void fill_glob();
void clear_img();
void delete_img();
void fill_img();
void fill_glob_frame();
void fill_img_frame();
int platepos ();
void amdinv();
void set_header_defaults();
void imhdr();
int check_img();

#else

int wf_open(char fname[], struct img *imgp, int give_error_messages);
struct img *find_FILNAM(char *fname);
struct img *peek_FILNAM(char *fname);
struct img *find_last_img(void);
struct img *find_previous_img(struct img *p);
struct img *find_SC(int x, int y);
struct img *find_IM(int i_coord[]);
struct img *find_IRAF(double d_coord[]);
struct img *find_COORD(double coord[], double dcoord[]);
struct img *new_img(void);
struct img *peek_FRAME(int frame);
struct img *sky_to_image(char s_coord[][40], double d_coord2[]);
struct img *find_IMIO(int config, int desired_frame);
void fill_glob(struct img *imgp);
void clear_img(void);
void delete_img(struct img *p);
void fill_img(struct img *imgp);
void fill_glob_frame(struct img *imgp);
void fill_img_frame(struct img *imgp);
int platepos (double xpix, double ypix, struct img *imgp, double *xpos,
    double *ypos);
void amdinv(struct img *imgp, double ra, double dec, double mag, double col,
    double *x, double *y);
void set_header_defaults(struct img *imgp);
void imhdr(int fd, struct img *imgp);
int check_img(struct img *q);

#endif /* _NO_PROTO */
