/*
Copyright (C) 1995, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/* machine dependent code for SUN SPARCstation running X windows */ 

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>     /* includes strings.h, sys/time.h, and sys/file.h */

#include <stdio.h>
#include "skyview.h"
#include "img_x.h"
#include "range.h"
#include <sys/param.h>

extern unsigned long black_pixval;
extern Atom wm_delete_window;
extern int debug, server_mode, graphics;
extern char server_str[];
extern char plane, hist_filnam[], screen_hist_filnam[], filnam[];
extern int band_offset, hist_band;
extern double hist_min, hist_binsiz;
extern int ho_on;
extern struct full_ra min_ho;
extern struct full_ra max_ho;

static int wedge_on = FALSE;
static unsigned int wedge_height, wedge_width;
static unsigned int hist_height, hist_width;
extern Window hist_win, wedge_win;
extern FILE *session, *debug_file;

extern Display *display;
extern int screen;

extern GC gc_red, gc_green, gc_blue;
extern GC hist_gc, wedge_gc;
extern unsigned int ncolors;    /* number of colors in our private color map */
extern unsigned long pixval[];
extern XColor exact_defs[];
extern Pixmap icon_pixmap;
extern XFontStruct *default_font;

extern struct hdrstruct filehdr;
extern double bscale, b_zero;
extern int screenflag;
extern int hist[], screen_hist[];


void
hi_cmd(argc, argv)
int argc;
char *argv[];
{
    if (!graphics)
	return;

    if (argc == 2)
    {
	if (strncmp(argv[1], "off", 2) == 0)
	{
	    hist_destroy();
	    return;
	}
    }
    screenflag = TRUE;
    create_hist_window();
}


void
create_hist_window()
{
    XSizeHints size_hints;
    int x = 0, y = 0;            /* window position */
    char *window_name;
    char *icon_name;
    int cmdc;
    char **cmdv;

    if (hist_win != 0)
    {
	hist_expose();
	return;
    }
    window_name = "histogram";
    icon_name = window_name;
    hist_width = 266;
    hist_height = 100;

    hist_win = new_window( x, y, hist_width, hist_height);

    /* initialize size hint property for window manager */
    size_hints.flags = PSize | PMinSize;
    size_hints.x = x;
    size_hints.y = y;
    size_hints.width = hist_width;
    size_hints.height = hist_height;
    size_hints.min_width = 266;
    size_hints.min_height = 80;
    cmdc = 0;
    cmdv = NULL;

    /* set Properties for window manager (always before mapping) */
    XSetStandardProperties(display, hist_win, window_name, icon_name,
	icon_pixmap, cmdv, cmdc, &size_hints);

#ifdef WithdrawnState
    (void) XSetWMProtocols (display, hist_win, &wm_delete_window, 1);
#endif /* WithdrawnState */

    /* Select event types wanted */
    XSelectInput(display, hist_win, KeyPressMask | ExposureMask |
	ButtonPressMask | StructureNotifyMask);

    /* Display window */
    XMapWindow(display, hist_win);

    ho_on = TRUE;
}


void
hist_expose()
{
    double nbinsm2, yscale;
    int len, half_char_width, xbase, ybase, xscale;
    int max;
    char string[20];
    char hist_win_name[MAXPATHLEN];

    int histscr[1152];
    int i, scrx, nbins, hist_lo, hist_diff, hist_hi, temp;
    int temp_lo, temp_hi;
    double label_lo, label_hi, label_diff;
    double dy;
    double dbl_i;
    char string1[30];


    if (hist_win == 0)
	return;

    half_char_width = default_font->max_bounds.width / 2;
    xbase = half_char_width + 1;
    ybase = hist_height - 20;

    if (screenflag)
    {

	if (screen_hist_filnam[0] == '\0')
	    return;
	XClearArea(display, hist_win, 0, 0, 0, 0, False);
	strcpy(hist_win_name, "histogram:  ");
	strcat(hist_win_name, strrchr(screen_hist_filnam, '/') + 1);
	XStoreName(display, hist_win, hist_win_name);

	max = 1;
	for (i=0; i<256; i++)
	{
	    if (screen_hist[i] > max)
		max = screen_hist[i];
	}
	yscale = (double) (ybase - 5) / max;
	xscale = (hist_width - 10)/ 256;
	if (debug)
	{
	    fprintf(debug_file, "max in screen_hist=%d\n",max);
	    fprintf(debug_file, "yscale=%e\n", yscale);
	}


	/* now draw the histogram */
	for (i=0; i<256; i++) 
	{
	    XDrawLine(display, hist_win, hist_gc, xbase + i * xscale, ybase, 
		xbase + i * xscale, ybase - (int)(screen_hist[i] * yscale));
	}

	/* put a baseline on the histogram */
	XDrawLine(display, hist_win, hist_gc, xbase, ybase, 
	    xbase + 255 * xscale, ybase );

	/* now label the axes */
	for (i = 0; i < 255; i+=20)
	{
	    sprintf(string, "%d", i);
	    len = strlen(string);
	    if (debug)
		fprintf(debug_file, 
		    "string=%s=, i * xscale =%d\n",string,i * xscale);

	    XDrawString(display, hist_win, hist_gc, 
		xbase + i * xscale - half_char_width * len,
		(int) hist_height - 5, string, len);

	    XDrawLine(display, hist_win, hist_gc, xbase + i * xscale, ybase, 
		xbase + i * xscale, ybase +3);
	}
    }
    else
    {
	if (hist_filnam[0] == '\0')            /* if no histogram    */
	    return;
	if ((strcmp(hist_filnam, filnam) != 0) || 
	    (hist_band != band_offset)) /* if wrong histogram */
	    return;
	XClearArea(display, hist_win, 0, 0, 0, 0, False);
	strcpy(hist_win_name, "ho:  ");
	strcat(hist_win_name, strrchr(hist_filnam, '/') + 1);
	XStoreName(display, hist_win, hist_win_name);


	label_lo = get_minmax(&min_ho);
	label_hi = get_minmax(&max_ho);

	hist_lo = (label_lo - hist_min) / hist_binsiz;
	hist_hi = (label_hi - hist_min) / hist_binsiz;

	hist_diff = hist_hi - hist_lo;
	if (hist_diff == 0)
	    hist_diff = 1;

	if (debug)
	{
	    fprintf(debug_file, "hist_hi= %d  hist_lo= %d  hist_diff= %d\n",
					hist_hi,hist_lo,hist_diff);
	}
	if ((hist_lo < 0) && (hist_hi < 0))
	    return;
	if ((hist_lo >= HISTSIZ2) && (hist_hi >= HISTSIZ2))
	    return;

	/* now do a rebinning */
	nbins = hist_width - 10;
	nbinsm2 = nbins - 2;
	for (i=0; i<nbins; i++)
	    histscr[i] = 0;
	if (hist_lo < 0)
	    temp_lo = 0;
	else
	    temp_lo = hist_lo;
	if (hist_hi > HISTSIZ2)
	    temp_hi = HISTSIZ2;
	else
	    temp_hi = hist_hi;
	for (i=temp_lo; i<=temp_hi; i++)
	{
	    if ((i >= 0) && (i <= HISTSIZ2))
	    {
		if (hist[i] != 0)
		{
		    temp  = (i - hist_lo) * nbinsm2 / hist_diff;
		    histscr[temp] += hist[i];
		}
	    }
	}

	max = 1;
	for (i=0; i<nbins; i++)
	{
	    if (histscr[i] > max)
		max = histscr[i];
	    if ((debug) && (histscr[i] != 0))
		fprintf(debug_file, "histscr[%d]= %d\n", i, histscr[i]);
	}
	yscale = (double) (ybase - 5) / max;
	xscale = (hist_width - 10)/ nbins;
	if (debug)
	{
	    fprintf(debug_file, "max in histscr=%d\n",max);
	    fprintf(debug_file, "yscale=%e\n", yscale);
	}

	/* now draw the histogram */
	for (i=0; i<nbins; i++) 
	{
	    XDrawLine(display, hist_win, hist_gc, xbase + i * xscale, ybase, 
		xbase + i * xscale, ybase - (int)(histscr[i] * yscale));
	}

	/* put a baseline on the histogram */
	XDrawLine(display, hist_win, hist_gc, xbase, ybase, 
	    xbase + nbins * xscale, ybase );


    /* now label the axis */

    label_lo = label_lo * bscale + b_zero;
    label_hi = label_hi * bscale + b_zero;

    label_diff = label_hi - label_lo;
    dy = label_diff / (hist_width / 50);   /* get (hist_width / 50) labels */
    /* now find a nice step size for labels */
    dy = nice_step(dy);

    if (debug)
    {
	fprintf(debug_file, "label_lo= %g  label_hi= %g  label_diff=%g\n", 
	    label_lo, label_hi, label_diff);
	fprintf(debug_file, "dy=%g\n", dy);
    }
    /* first do from zero up */
    dbl_i = 0;
    while (dbl_i <= label_lo)   /* get past starting point */
	dbl_i = dbl_i + dy;
    while (dbl_i <= label_hi)
    {
	scrx = xbase + (dbl_i - label_lo) * nbinsm2/ label_diff;
	sprintf(string1, "%2.2g", dbl_i);

	    len = strlen(string1);
	    if (debug)
		fprintf(debug_file, "string1=%s=, scrx=%d\n",string1, scrx);

	    XDrawString(display, hist_win, hist_gc, 
		scrx - half_char_width * len,
		(int) hist_height - 5, string1, len);

	    XDrawLine(display, hist_win, hist_gc, scrx, ybase, 
		scrx, ybase +3);
	dbl_i = dbl_i + dy;
    }
    /* then do from zero down */
    dbl_i = -dy;
    while (dbl_i >= label_hi)  /* get past starting point */
	dbl_i = dbl_i - dy;
    while (dbl_i >= label_lo)
    {

	scrx = xbase + (dbl_i - label_lo) * nbinsm2/ label_diff;
	sprintf(string1, "%2.2g", dbl_i);

	    len = strlen(string1);
	    if (debug)
		fprintf(debug_file, "string1=%s=, scrx=%d\n",string1, scrx);

	    XDrawString(display, hist_win, hist_gc, 
		scrx - half_char_width * len,
		(int) hist_height - 5, string1, len);

	    XDrawLine(display, hist_win, hist_gc, scrx, ybase, 
		scrx, ybase +3);
	dbl_i = dbl_i - dy;
    }
    }
}

void
hist_destroy()
{
    if (hist_win != 0)
    {
	XDestroyWindow(display, hist_win);
	hist_win = 0;
	ho_on = FALSE;
    }
}

void
hist_configure(width, height)
unsigned int width, height;
{
    hist_width = width;
    hist_height = height;
}

/*ARGSUSED*/
void
wedge(x_min, y_min, x_max, y_max)
int x_min, y_min, x_max, y_max;
{
}

void
wedgecmd(argc, argv)
int argc;
char *argv[];
{
    if (!graphics)
	return;

    if (argc == 2)
    {
	if (strncmp(argv[1], "off", 2) == 0)
	{
	    wedge_on = FALSE;
	    wedge_destroy();
	}
	if (strcmp(argv[1], "on") == 0)
	{
	    wedge_on = TRUE;
	    wedge_now();
	}
	if (strcmp(argv[1], "now") == 0)
	{
	    wedge_on = TRUE;
	    wedge_now();
	}
    }
    else
    {
	if(server_mode == FALSE)
	    printf("wedge is %s\n", wedge_on ? "on" : "off");
	else
	{
	    sprintf(server_str, "%s", wedge_on ? "on" : "off");
	    srv_string("wedge_status", server_str);
	}
	fprintf(session, "wedge is %s\n", wedge_on ? "on" : "off");
    }
}

void
wedge_now()
{
    XSizeHints size_hints;
    int x = 0, y = 0;            /* window position */
    char *window_name;
    char *icon_name;
    int cmdc;
    char **cmdv;

    if (wedge_win != 0)
	return;
    window_name = "wedge";
    icon_name = window_name;
    wedge_width = 256;
    wedge_height = 100;


    wedge_win = new_window(x, y, wedge_width, wedge_height);

    /* initialize size hint property for window manager */
    size_hints.flags = PSize;
    size_hints.x = x;
    size_hints.y = y;
    size_hints.width = wedge_width;
    size_hints.height = wedge_height;
    cmdc = 0;
    cmdv = NULL;

    /* set Properties for window manager (always before mapping) */
    XSetStandardProperties(display, wedge_win, window_name, icon_name,
	icon_pixmap, cmdv, cmdc, &size_hints);

#ifdef WithdrawnState
    (void) XSetWMProtocols (display, wedge_win, &wm_delete_window, 1);
#endif /* WithdrawnState */

    /* Select event types wanted */
    XSelectInput(display, wedge_win, KeyPressMask | ExposureMask |
	ButtonPressMask | StructureNotifyMask);

    /* Display window */
    XMapWindow(display, wedge_win);

    if(server_mode == TRUE)
    {
	sprintf(server_str, "%s", wedge_on ? "on" : "off");
	srv_string("wedge_status", server_str);
    }
}

void
wedge_expose(colors_only)
int colors_only;  /* flag that only graph part must be redrawn */
	  /* (set if only a color table change, and no expose or configure */
{
    int i;
    int this_x, this_def, rectangle_width;
    XPoint r[256], g[256], b[256];

    if (wedge_win == 0)
	return;
    if (!colors_only)
    {
	rectangle_width = (int)(wedge_width / 255);
	for (i = 0; i < 255; i++)
	{
	    XSetForeground(display, wedge_gc, pixval[i]);
	    XFillRectangle(display, wedge_win, wedge_gc,
		(int)(i * wedge_width / 255),
		0,
		(unsigned int) rectangle_width + 1,
		wedge_height / 2 - 3);
	}
    }

    /* now do the graph */
    XSetForeground(display, wedge_gc, black_pixval);
    XFillRectangle(display, wedge_win, wedge_gc,
	0,
	(int) wedge_height / 2 - 3,
	wedge_width,
	wedge_height / 2 + 4);


    for (i = 0; i < 255; i++)
    {
	this_x = i * wedge_width / 254;
	r[i].x = this_x;
	g[i].x = this_x;
	b[i].x = this_x;

	this_def = ncolors * i / 255; /* translate from pixval to exact_defs */
	r[i].y = wedge_height - 2 - 
	    (exact_defs[this_def].red >> 8) * wedge_height / 512;
	g[i].y = wedge_height - 1 - 
	    (exact_defs[this_def].green >> 8) * wedge_height / 512;
	b[i].y = wedge_height - 
	    (exact_defs[this_def].blue >> 8) * wedge_height / 512;
    }
    XDrawLines(display, wedge_win, gc_red, r, 255, 
	CoordModeOrigin);
    XDrawLines(display, wedge_win, gc_green, g, 255, 
	CoordModeOrigin);
    XDrawLines(display, wedge_win, gc_blue, b, 255, 
	CoordModeOrigin);
}

void
wedge_destroy()
{
    if (wedge_win != 0)
    {
	XDestroyWindow(display, wedge_win);
	wedge_win = 0;
    }
    wedge_on = FALSE;
}

void
wedge_configure(width, height)
unsigned int width, height;
{
    wedge_width = width;
    wedge_height = height;
}
