/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include <stdio.h>
#include "jgio.h"
#include <sys/file.h>
#include "skyview.h"

extern JFILE  *J12file;
extern char plane;
extern minx, miny;

extern int debug, graphics, pixels, lines;
extern struct hdrstruct filehdr;
extern double bscale, b_zero;
extern double hist_binsiz, hist_min, ho_min, ho_max, get_minmax();
extern int screen_hist[], hist[], ho_minflg, ho_maxflg;

hi_cmd(argc, argv)
int argc;
char *argv[];
{
    int max;
    float xscale;
    register int scrx, scry;
    int i;
    char string[10];
    register int hist_right, text_left;



    hist_right = minx + 520;;
    text_left = hist_right + 10;

    max = 1;
    for (i=0; i<256; i++)
    {
	if (screen_hist[i] > max)
	    max = screen_hist[i];
    }
    xscale = 400.0 / max;
    if (debug)
    {
	printf("max in screen_hist=%d\n",max);
	printf("xscale=%e\n", xscale);
    }

    overlay_setup('w');

    /*  first clear old histogram */
    j_sec(0);    /* black */
    j_mov(hist_right-400, miny);
    j_dfr(hist_right + 150, miny + 512);

    j_sec(8);    /*  white  */

    /* now draw the histogram */
    j_mov(hist_right, miny);
    j_dva(hist_right, miny + 512);   /* draw right edge of histogram */
    for (i=0; i<256; i++) 
    {
	scrx = hist_right - (screen_hist[i] * xscale);
	scry = miny + 2 * i;
	j_mov(hist_right, scry );
	j_dva(scrx     , scry );
    }

    /* now define the character fonts */
    if (get_font("c79") < 0)
	return;
    j_txt_cols(0xff, 0, 8, 8, 8, 0, 0, 1, 1);

    /* now label the axes */
    for (i = 0; i < 255; i+=20)
    {
	scry = i * 2;
	sprintf(string, "%3d", i);
	if (debug)
	printf("string=%s, textleft=%d  scry=%d\n",string,text_left,scry);

	if (graphics)
	{
	    j_text(text_left, scry, string);
	    jfflush(J12file);
	}
    }
    image_setup(plane);
    wedge(hist_right + 30, miny, hist_right + 50, miny + 512);
    jfflush(J12file);
}


create_hist_window()
{
    int histscr[512];
    int i, hist_lo, hist_diff, hist_hi, temp;
    double ftemp;
    double label_lo, label_hi;


    label_lo = get_minmax(ho_minflg, ho_min);
    label_hi = get_minmax(ho_maxflg, ho_max);

    hist_lo = (label_lo - hist_min) / hist_binsiz;
    hist_hi = (label_hi - hist_min) / hist_binsiz;

    hist_diff = hist_hi - hist_lo;
    if (hist_diff == 0)
	hist_diff = 1;

    if (debug)
    {
	printf("hist_hi= %d  hist_lo= %d  hist_diff= %d\n",
				    hist_hi,hist_lo,hist_diff);
    }
    /* now do a rebinning for bins from 0 to 510 */
    for (i=0; i<512; i++)
	histscr[i] = 0;
    for (i=hist_lo; i<=hist_hi; i++)
    {
	if ((hist[i] != 0) && (i >= 0) && (i <= HISTSIZ2))
	{
	ftemp  = (i - hist_lo) * 510.0 / hist_diff;
	temp = ftemp;  /* integer part */
	ftemp = ftemp - temp;  /* fractional part */
	histscr[temp] += hist[i] -ftemp*hist[i]+0.5;   /* part into  */
							/* this cell */
	histscr[temp+1] += ftemp * hist[i]+0.5; /* rest in next cell */
	if (debug)
	{
	    printf("putting %f into histscr[%d] ", 
				    hist[i]-ftemp * hist[i]+0.5, temp);
	    printf("and %f into histscr[%d]\n", 
					    ftemp * hist[i]+0.5, temp+1);
	}
	}
    }

    label_lo = label_lo * bscale + b_zero;
    label_hi = label_hi * bscale + b_zero;

    if (graphics)
	do_hist(label_lo, label_hi, histscr);
}

do_hist(label_lo, label_hi, histscr)
double label_lo, label_hi;
int histscr[];
{
    int max;
    float xscale;
    register int scrx, scry;
    int i;
    double dy, nice_step();
    double label_diff, dbl_i;
    char *gcvt(), *string, charbuf[30];
    register int hist_right, text_left;

    hist_right = minx + 520;;
    text_left = hist_right + 10;

    max = 1;
    for (i=0; i<511; i++)
    {
	if (histscr[i] > max)
	    max = histscr[i];
	if ((debug) && (histscr[i] != 0))
	    printf("histscr[%d]= %d\n", i, histscr[i]);
    }
    xscale = 400.0 / max;
    if (debug)
    {
	printf("max in histscr=%d\n",max);
	printf("xscale=%e\n", xscale);
    }

    overlay_setup('w');

    /*  first clear old histogram */
    j_sec(0);    /* black */
    j_mov(hist_right-400, miny);
    j_dfr(hist_right + 150, miny + 512);

    j_sec(8);    /*  white  */

    /* now draw the histogram */
    j_mov(hist_right, miny);
    j_dva(hist_right, miny + 512);   /* draw right edge of histogram */
    for (i=0; i<=510; i++) 
    {
	scrx = hist_right - (histscr[i] * xscale);
	scry = miny + i;
	j_mov(hist_right, scry );
	j_dva(scrx     , scry );
    }

    /* now define the character fonts */
    if (get_font("c79") < 0)
	return;
    j_txt_cols(0xff, 0, 8, 8, 8, 0, 0, 1, 1);

    /* now label the axis */
    label_diff = label_hi - label_lo;
    dy = label_diff / 20;  /* get about 20 labels */
    /* now find a nice step size for labels */
    dy = nice_step(dy);

    if (debug)
    {
	printf("label_lo= %g  label_hi= %g  label_diff=%g\n", label_lo, label_hi, label_diff);
	printf("dy=%g miny=%d\n", dy, miny);
    }
    /* first do from zero up */
    dbl_i = 0;
    while (dbl_i <= label_lo)   /* get past starting point */
	dbl_i = dbl_i + dy;
    while (dbl_i <= label_hi)
    {
	scry = miny + (dbl_i - label_lo) * 510/ label_diff;
	string = gcvt(dbl_i, 2, charbuf);
	if (debug)
	printf("string=%s, textleft=%d  scry=%d\n",string,text_left,scry);

	if (graphics)
	{
	    j_text(text_left, scry, string);
	    jfflush(J12file);
	}
	dbl_i = dbl_i + dy;
    }
    /* then do from zero down */
    dbl_i = -dy;
    while (dbl_i >= label_hi)  /* get past starting point */
	dbl_i = dbl_i - dy;
    while (dbl_i >= label_lo)
    {
	scry = miny + (dbl_i - label_lo) * 510/ label_diff;
	string = gcvt(dbl_i, 2, charbuf);
	if (debug)
	printf("string=%s, textleft=%d  scry=%d\n",string,text_left,scry);

	if (graphics)
	{
	    j_text(text_left, scry, string);
	    jfflush(J12file);
	}
	dbl_i = dbl_i - dy;
    }
    image_setup(plane);
    wedge(hist_right + 30, miny, hist_right + 50, miny + 512);
    jfflush(J12file);
}


get_font(s)
char *s;
{
    static short *c79phys = NULL;

    static short *phys = NULL;
    static char oldfont[20];

    char fontname[80];
    short *font;
    int stat;

    /* define the character fonts */
    if ((strcmp(s, "c79") == 0) && (c79phys != NULL))
    {
	/* he wants c79 and its already loaded */
	if (debug)
	    printf("c79 already loaded\n");
	j_cfont(c79phys);		/* change to the font */
    }
    else if (strcmp(s, oldfont) == 0)
    {
	/* he wants another font that is already loaded */
	if (debug)
	    printf("font %s is already loaded\n", s);
	j_cfont(phys);
    }
    else
    {
	/* must load a font */

	/* first remove old font if one exists */
	if (phys != NULL)
	{
	    stat = jf_rmfont(phys, J12file);
	    if (stat < 0)
	    {
		if (debug)
		    printf("could not remove font %s\n", oldfont);
	    }
	    else
	    {
		phys = NULL;
		oldfont[0] = '\0';
	    }
	}

	strcpy(fontname, "/usr/lib/jfont/");
	strcat(fontname, s);
	strcat(fontname, ".jup");
	fontname[29] = '\0';     /* 29 chars max */
	oldfont[0] = '\0';              /* mark no old font */
	if (debug)
	    printf("loading font %s\n", fontname);
	font = j_rdfont(fontname, &phys);
	if (font == NULL)
	{
	    printf("Can't load character font\n");
	    stat = open(fontname, O_RDONLY, 0);
	    if (stat < 0)
	    {
		printf("cannot open file %s\n", fontname);
	    }
	    else
	    {
		printf("     (file exists - kernal must be out of space)\n");
		close (stat);
	    }
	    return(-1);
	}
	else
	{
	    j_cfont(phys);		/* change to the font */
	    if (strcmp(s, "c79") == 0)
	    {
		c79phys = phys;
		phys = NULL;
	    }
	    else
	    {
		strcpy(oldfont, s);
	    }
	}
    }
    return(0);
}
