/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include "skyview.h"
#include "parse.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

extern int server_mode;
static char oldarg[40] = {'\0'};
static char us[5], ue[5];

/* function prototypes */
#ifdef _NO_PROTO

static void printhelp();

#else

static void printhelp(char *msg);

#endif /* _NO_PROTO */

void
helpinit ()     /* get terminal sequences for underline and normal */
{
    if (server_mode)
	return;
    strcpy(us, "\033[4m");
    strcpy(ue, "\033[0m");
}

void
help(argc,argv)
int argc;
char *argv[];
{
    char *msg;

    if (server_mode)
    {
	error_na("Help not available in server mode");
	return;
    }

    if (argc == 1)
    {
	if ((strncmp(argv[0], "?", 1) == 0) && (strlen(argv[0]) > (size_t) 1))
	{
	    /* got "?" and keyword with no intervening space */
	    argv[1] = argv[0] + 1;   /* point to keyword */
	    argc = 2;
	}
    }

    if (argc == 2)
    {
	switch(cmd(argv[1]))
	{
	    case AL:
		msg = "alias .Iname .Istring\n";
		break;
	    case AN:
		msg = "an ---- annotate [.Ix .Iy] .Istring [red | green | blue | white] [.Ifont]\n";
		break;
	    case BL:
		msg ="ba ---- background [ [ = .Ilevel] | [.In] [.Ix .Iy] ]\n";
		break;
	    case BORDER:
		msg = "  border  [.Itop .Ibottom .Ileft .Iright]\n";
		break;
	    case CA:
		msg = "  ca  ---- change_area [.In]\n";
		break;
	    case CD:
		msg = "  cd  ---- change_directory [.Idname]\n";
		break;
	    case CIMG:
		msg = "  ci  ---- current_image [.Ifilename]\n";
		break;
	    case CL:
		msg = "  cl  ---- clip [top .In] [bottom .In]  [left .In]  [right .In]\n";
		break;
	    case CMAP:
		msg = "  cm  ---- current_map [.Itarget_coord_sys]\n";
		break;
	    case CONTOUR:
	msg = "co -- \n";
		printhelp(msg);
	msg = "  contour_plot [.Iimagefile] [.Ipercentile [.Imultiplier]] [linear][grid][gridonly]\n";
		printhelp(msg);
	msg = "  contourovl   [.Iimagefile] [.Ipercentile [.Imultiplier]] [linear][grid][gridonly]\n";
		printhelp(msg);
	msg = "  contourps    -o .Ioutputfile [.Iimagefile] [.Ipercentile [.Imultiplier]] [linear][grid][gridonly]\n";
		break;
	    case CROP:
		msg = "crop -- crop [n] .Ifilename\n";
		break;
	    case CS:
		msg = "cs ---- coord_system [equ|ecl|gal|sgal|xy|im|sc|iraf] [.Iequinox|image] [both|input|output]\n";
		break;
	    case CT:
		msg = "ct ---- color_table [.In | .Ifilename]\n";
		break;
	    case CU:
		msg = "cu ---- cutoff [.Ilevel]\n";
		break;
	    case DA:
		msg = "da ---- define_area [.In] [ci | bo | po | el | li] [nomark]\n";
		break;
	    case DE:
		msg = "de ---- debug\n";
		break;
	    case DF:
		msg = "df ---- delete_file .Ifname\n";
		break;
	    case DIRR:
		msg = "dir---- directory\n";
		break;
	    case DR:
		msg = "pa ---- paint [.Ifname] [zp|nozp] [st|nost] [ =.Iwidthx.Iheight+.Ixoffset+.Iyoffset]\n";
		break;
	    case ECHO1:
		msg = "echo -- echo [.Istring]\n";
		break;
	    case ER:
		msg = "er ---- erase [ro | go | bo | ao | r | g | b | a | .Iframe | .Icolor | bundle]\n";
		break;
	    case EX:
		msg = "ex ---- examine [.In] [mark]\n";
		break;
	    case FI:
		msg = "fi ---- file [.Ifname]\n";
		break;
	    case FL:
		msg = "fl ---- flatten [.In] .Ioutput_.Ifilename\n";
		printhelp(msg);
		msg = "        flatten list\n";
		break;
	    case FOV:
		msg = "fov --- fov .Ifilename [.Ix .Iy [.Iposition_.Iangle]]\n";
		printhelp(msg);
		msg = "fov --- fov .Ifilename [.Ix .Iy [.Irotation_.Iangle r]]\n";
		printhelp(msg);
		msg = "        fov .Ifilename [.Irotation_.Iangle]\n";
		break;
	    case FP:
		msg = "fp ---- find_plate .Ix .Iy\n";
		printhelp(msg);
		msg = "        find_plate skyflux .Ix .Iy\n";
#ifdef NOTDEF
		msg = "        find_plate issa .Ix .Iy [.Iband [.Ihcon]]\n";
#endif /* NOTDEF */
		break;
	    case FR:
		msg = "fr ---- frame [.In] [advance | noadvance]\n";
		break;
	    case GEX:
		msg = "gex ---- graphics_examine [.In]\n";
		break;
	    case GPICK:
		msg = " gpick  ---- graphics_pick [.Ix .Iy]\n";
		break;
	    case GPOINT:
		msg = " gpoint  ---- graphics_point [.Ix .Iy]\n";
		break;
	    case GRID:
		msg = "grid ---- grid [.Ilabelscale]\n";
		break;
	    case HE:
		msg = "he ---- header [long|short] [.Ifilename]\n";
		break;
	    case HI:
		msg = "hi ---- histogram\n";
		break;
	    case HO:
		msg = "  ho ----  histogram_original [min | .Imin_.Ivalue  max | .Imax_.Ivalue]\n";
		break;
	    case MA:
		msg = "  ma  ---- map [r|g|b|a]\n";
		break;
	    case MARK:
		msg = "  mark --- mark .Ix .Iy [.Imarker_.Itype] [.Imarker_.Icolor] [.Imarker_.Isize]\n";
		break;
	    case MAG:
		msg = "  mag  ---- magnifier [on] [off] [.Izoom_.Ifactor]\n";
		break;
	    case MAN:
		msg = "help -- help [.Icommand_.Iname]\n";
		break;
	    case MD:
		msg = "md -- memdump .Ifilename [.Iquality]\n";
		printhelp(msg);
		msg = "     default quality = 75\n";
		break;
	    case MO:
		msg = "mo ---- mode [linear | log | loglog | equ]\n";
		break;
	    case MOVIE:
		msg = "movie -- movie .Itimes_.Ithrough .Isec_.Iper_.Iframe\n";
		break;
	    case MOVIE_PREP:
		msg = "mp -- movie_prep [-zp .Izoom_.Ifactor] .Ifilename [.Istart_.Iframe .Iend_.Iframe .Istep_.Isize]\n";
		break;
	    case OF:
		msg = "  off ---- off [.Icolor]\n";
		break;
	    case ONN:
		msg = "  on  ---- on [.Icolor]\n";
		break;
	    case OR:
		msg = "  or  ---- origin [[+] .Ix .Iy]\n";
		break;
	    case PAINT_BLANK:
		msg = "pb ---- paint_blank [.Ifname] [ =.Iwidthx.Iheight+.Ixoffset+.Iyoffset]\n";
		printhelp(msg);
		msg = "pb ---- paint_blank [.Ifname $x $y] [ =.Iwidthx.Iheight+.Ixoffset+.Iyoffset]\n";
		break;
	    case PAUSE:
		msg = "  pause ---- pause\n";
		break;
	    case PH:
		msg = "  ph  ---- print_history [terminal]\n";
		break;
	    case PICK:
		msg = "  pi  ---- pick [.In] [.Ix .Iy]\n";
		break;
	    case POINT:
		msg = "  point  ---- point [.In] [.Ix .Iy]\n";
		break;
	    case PLANE:
		msg = "  plane --- plane [.In]\n";
		break;
	    case PWD:
		msg = "  pwd  ---- pwd\n";
		break;
	    case RA:
		msg = "  ra ----  range [min | .Imin_.Ivalue  max | .Imax_.Ivalue]\n";
		msg = "  ra ----  range [.Iarg[.Ioparg] .Iarg[.Ioparg]]\n";
		printhelp(msg);
		msg = "         where .Iarg = min | max | lastmin | lastmax | lastdiff | .Ivalue% | .Ivalue\n";
		printhelp(msg);
		msg = "         and   .Iop  = + | -";
		break;
	    case RE:
		msg = "  rep ---  replicate .Ifilename .Iline .Isamp\n";
		break;
	    case REW:
		msg = "  rewind ---  rewind\n";
		break;
	    case SC:
		msg = "  sc -- scatter_plot [.In] .Ifilename [.Ioutfilename]\n";
		break;
	    case SD:
#ifdef NOTDEF
		msg = "sd - screen_dump [[+].In] [fullimage] [red|green|blue|gif|ppm[bin]] [ipl|.Ifilename]\n";
#endif /* NOTDEF */
		msg = "sd - screen_dump [fullimage] [red|green|blue|gif|jpeg|ppm[bin]] [ipl|.Ifilename]\n";
		printhelp(msg);
		msg = "                          IPL is default - 3 files to tape (R,G,B)\n";
		printhelp(msg);
		msg = "                          red|green|blue put one file on IPL tape or diskfile\n";
		break;
	    case SET:
		msg = "  set----  set .Ikeyword off|on\n";
		printhelp(msg);
		msg = "               .Ikeyword:  mouse | projtype | u16 | reread\n";
		break;
	    case SH:
		msg = "  sh ----  set_history_file [.Ifilename] [create] [off] [on]\n";
		break;
	    case SKY_BOX:
		msg = "  skybox  ---- skybox [.In] [.Icliplevel] [zap]\n";
		break;
	    case SL:
		msg = "  sl  ---- slice [.Ifilename] [.Ix0 .Iy0 .Ix1 .Iy1]\n";
		break;
	    case SLEEP:
		msg = "  sleep  ---- sleep .In\n";
		break;
	    case SPLIT:
		msg = "  ssplit -- ssplit .Ifilename\n";
		break;
	    case ST:
		msg = "  st ----  stretch [.Ilow .Ihigh]\n";
		break;
	    case SYNC:
		msg = "  sync ---- sync [on | off]\n";
		break;
	    case TA:
		msg = "  ta  ---- take .Ifilename [noerror|error] [.Iarg1 .Iarg2 ...]\n";
		break;
	    case TABLE:
		msg = "  table -- table .Ifilename .Is_.Icommand\n";
		break;
	    case TEK:
		msg = "  tek ---- tek [.Ifilename] [dimensions]\n";
		break;
	    case TR:
		msg = "  tr  ---- tape_read [[+].In] [.Iinfile] .Ioutfile [vicar]\n";
		break;
	    case TW:
		msg = "  tw  ---- tape_write [[+]N] [.Ifilename]\n";
		break;
	    case UNIX:
		msg = "  unix  ---- exit to operating system\n";
		break;
	    case VE:
		msg = "  ve  ---- vector [.Ix0 .Iy0 .Ix1 .Iy1]\n";
		break;
	    case WE:
		msg = "  we  ---- wedge [on|off|now]\n";
		break;
	    case WRITE:
		msg = "  write -- write .Ifilename .Iblank-.Ivalue\n";
		break;
	    case ZAP:
		msg = "  zap ---- zap [area]\n";
		break;
	    case ZP:
		msg = "  zp  ---- zoom_pan [.In] [.Ix .Iy]\n";
		break;
	    case BANG:
		msg = "  !   ---- ! .Iunix-.Icommand\n";
		break;
	    case QMARK:
		msg = "  help  ---- help [.Icommandname]\n";
		break;
	    case NIL:
		msg = "  #  ---- # [.Icomment]\n";
		break;
	    default:
		printf("no such command; commands are:\n");
		goto fulllist;
	}
	printhelp(msg);
	strcpy(oldarg, argv[1]);
	printf(
	"\nhelp commandname  gives full information from IPAC Users' Guide\n");
	return;
    }
fulllist:
    printf("  al  ---- alias\n");
    printf("  an  ---- annotate\n");
    printf("  ba  ---- background level\n");
    printf("  border - provide black border around image\n");
    printf("  ca  ---- change_area\n");
    printf("  cd  ---- change directory\n");
    printf("  ci  ---- give current_image information\n");
    printf("  cl  ---- clip\n");
    printf("  co  ---- contour plot, contour overlay\n");
    printf("  crop --- crop\n");
    printf("  cs  ---- coordinate system specify\n");
    printf("  ct  ---- color table selection\n");
    printf("  cu  ---- cutoff color table\n");
    printf("  da  ---- define_area\n");
    printf("  df  ---- delete_file\n");
    printf("  dir ---- directory\n");
    printf("  echo --- echo line to terminal and session history\n");
    printf("  end ---- exit to operating system\n");
    printf("  er  ---- erase screen\n");
    printf("  ex  ---- examine a defined area\n");
    printf("  exit --- exit to operating system\n");
    printf("  fi  ---- file set name\n");
    printf("  fl  ---- flatten\n");
    printf("  fov ---- field_of_view overlay\n");
    printf("  fp  ---- find_plate with certain coordinates\n");
    printf("  fr  ---- frame number selection\n");
    printf("  gex ---- report table marks in area\n");
    printf("  gpick -- report table mark nearest cursor\n");
    printf("  gpoint - gpick once only\n");
    printf("  grid --- draw coordinate grid\n");
    printf("  help --- display User Guide page\n");
    printf("  he  ---- header display\n");
    printf("  hi  ---- histogram of displayed image\n");
    printf("  ho  ---- histogram of original image file\n");
    printf("  ma  ---- mapping to color plane\n");
    printf("  mag ---- magnifier window\n");
    printf("  mark --- marker\n");
    printf("  md  ---- memdump an image from memory to disk in GIF format\n");
    printf("  mo  ---- mode for range stretch\n");
    printf("  movie -- step through frames set up by movie_prep\n");
    printf("  mp   --- set up a movie using an ISO CAM FITS binary tablefile\n");
    printf("  of  ---- turn off a color plane\n");
    printf("  on  ---- turn on a color plane\n");
#ifdef NOTDEF
    printf("  or  ---- origin reset\n");
#endif /* NOTDEF */
    printf("  pa  ---- paint image from disk\n");
    printf("  pause -- wait for user release\n");
    printf("  pb  ---- paint blank image\n");
    printf("  ph  ---- print history\n");
    printf("  pi  ---- pixel value and location\n");
    printf("  plane -- plane for disk read\n");
    printf("  point -- pick once only\n");
    printf("  pwd ---- print working directory name\n");
    printf("  quit ---- exit to operating system\n");
    printf("  ra  ---- range set for disk_read\n");
    printf("  rep ---- replicate\n");
    printf("  rew ---- rewind tape\n");
    printf("  sb  ---- skybox\n");
    printf("  sc  ---- scatter_plot\n");
    printf("  sd  ---- screen_dump to tape\n");
    printf("  set ---- set program parameters\n");
    printf("  sh  ---- set_history_file\n");
    printf("  sl  ---- slice\n");
    printf("  sleep -- go inactive for n seconds\n");
    printf("  st  ---- stretch color table\n");
    printf("  sync---- synchronize (X windows)\n");
    printf("  ta  ---- take commands from a file\n");
    printf("  table -- table file\n");
    printf("  tr  ---- tape read\n");
    printf("  tw  ---- tape write\n");
    printf("  unix --- exit to operating system\n");
    printf("  ve  ---- vector\n");
    printf("  we  ---- wedge control\n");
    printf("  write -- write modified image to disk\n");
    printf("  zap ---- change value of pixel\n");
    printf("  zp  ---- zoom and pan\n");
    printf("  #   ---- comment\n");
    printf("  !   ---- pass a command to unix\n");
    printf("  ?   ---- display one-line of help on a command\n");
    printf("\nhelp commandname  gives full information from Skyview Reference Manual\n");
}

static void
printhelp(msg)
char *msg;
{
    char *p;
    int underline;

    underline = 0;
    p = msg;
    while(*p)
    {
	if (*p == '.')
	{
	    p++;
	    if (*p == 'I')
	    {
		p++;
		if (strlen(us) != 0)
		{
		    fputs(us, stdout);
		    underline = 1;
		}
	    }
	    else
	    {
		putchar('.');
	    }
	}
	if ((!isalnum(*p)) && (underline != 0) && (strlen(ue) != 0))
	{
	    fputs(ue, stdout);
	    underline = 0;
	}

	putchar(*p++);
    }
}

void
manual_page(argc, argv)
int argc;
char *argv[];
{
    char sysstr[40];

    if (server_mode)
    {
	error_na("Man pages not available in server mode");
	return;
    }

    strcpy(sysstr, "s.help ");
    if (argc >= 2)
    {
	if (argv[1][0] == '!')
	    strcat(sysstr, "bang");
	else if (argv[1][0] == '#')
	    strcat(sysstr, "comment");
	else
	    strcat(sysstr, argv[1]);
    }
    else
    {
	if (oldarg[0] == '\0')
	    strcpy(oldarg, "help");
	strcat(sysstr,oldarg); 
    }
    system(sysstr);
}
