/*
Copyright (C) 1995, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include "skyview.h"
#include "fits.h"
#include "parse.h"
#include "img.h"
#include "im_proto.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <unistd.h>
#include <string.h>

extern FILE *session;
extern char fi_name[];
extern int server_mode;


static int short_hdr = FALSE;

/* function prototypes */
#ifdef _NO_PROTO

static void vicarhd();
static void fitshd();

#else

static void vicarhd(int fd);
static void fitshd(int fd);

#endif /* _NO_PROTO */


void
header(argc,argv)
int argc;
char *argv[];
{
    struct img tmpimg;
    int fd;

    if(server_mode == TRUE)
    {
	error_na("header command not available in server mode");
	return;
    }

    while (argc >= 2)
    {
	switch (cmd(argv[1]))
	{
	    case SH:
		short_hdr = TRUE;
		break;
	    case LONG:
		short_hdr = FALSE;
		break;
	    default:
		strcpy(fi_name, expand_path(argv[1]));
		break;
	}
	argc--;
	argv++;
    }

    if (fi_name[0] == '\0')
    {
	error1("no workfile has been specified");
	return;
    }
    fd = wf_open(fi_name, &tmpimg, 1);
    if (fd < 0)
	return;

    printf("\nworkfile: %s\n\n",fi_name);
    fprintf(session, "\nworkfile: %s\n\n",fi_name);

    switch (tmpimg.filehdr.tapetype)
    {
    case FITS:
    {
	lseek(fd, (long) tmpimg.filehdr.hdr_start, 0);
	fitshd(fd);
	close(fd);
	break;
    }
    case VICAR:
    {
	lseek(fd, (long) tmpimg.filehdr.hdr_start, 0);
	vicarhd(fd);
	close(fd);
	break;
    }
    case IMFILE:
    {
	imhd(fd);
	im_close(fd);
	break;
    }
    default:
    {
	lseek(fd,0L,0);
	fitshd(fd);
	close(fd);
	break;
    }
    }
}

static void
vicarhd(fd)
int fd;
{
    char hdr[360], *pt;
    int i;

    for (;;)
    {
        read(fd,hdr,360);

	pt = hdr;
	for (i=0;i<5 ; i++, pt+=72)
	{
	    *(pt+70) = '\0';
	    printf("%s\n", pt);
	    fprintf(session, "%s\n", pt);
	    if (*(pt+71) == 'L')
	    return;
	}
    }
}

static void
fitshd(fd)
int fd;
{
    char hdr[2880], *pt;
    int i;

    for (;;)
    {
        read(fd,hdr,2880);

	pt = hdr;
	for (i=0;i<36 ; i++, pt+=80)
	{
	    *(pt+79) = '\0';
	    print_header_line(pt);
	    if (parse_fits(pt) == END)
	    return;
	}
    }
}

void
print_header_line(pt)
char *pt;
{
    if (short_hdr)
    {
	switch (parse_fits(pt))
	{
	    case BUNIT:
	    case CRVAL1:
	    case CRVAL2:
	    case CRVAL3:
	    case CTYPE1:
	    case CTYPE2:
	    case CTYPE3:
	    case CD1_1:
	    case CD1_2:
	    case CD2_1:
	    case CD2_2:
	    case DATAMAX:
	    case DATAMIN:
	    case INSTRUME:
	    case OBJECT:
	    case DSKYGRID:
	    case OBSERVER:
		printf("%s\n", pt);
		fprintf(session, "%s\n", pt);
		break;
	    case COMMENT:
		if (strncmp((pt+42), "EST. MEDIAN NOISE", 17) == 0)
		{
		    printf("%s\n", pt);
		    fprintf(session, "%s\n", pt);
		}
		break;
	}
    }
    else
    {
	printf("%s\n", pt);
	fprintf(session, "%s\n", pt);
    }
}
