/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/********************************************************************/
/*                                                                  */
/* GETHD -- Extracts the fits header information from a             */
/*          SKYFLUX image file and puts in a text file for          */
/*          editing. It is then replaced using PUTHD                */
/*                                                                  */
/********************************************************************/


#include "skyview.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>


int main(argc, argv)

int argc;
char **argv;

{
    int i;
    int fi, fh;
    char nl[1];
    int n_read, header_set, input_set;
    char input[MAXPATHLEN], header[MAXPATHLEN], buf[2880], *pt;
    struct hdrstruct hdr;


    if ((argc != 2) && (argc != 3))
    {
	printf("usage: gethd if=imagefile [hf=tempfile]\n");
	exit(1);
    }

    input_set = FALSE;
    header_set = FALSE;
    for(i=1; i<argc; ++i)
    {
	pt = argv[i];
	if(strncmp(pt, "if=", 3) == 0)
	{
	    input_set = TRUE;
	    pt += 3;
	    strcpy(input, pt);
	}

	if(strncmp(pt, "hf=", 3) == 0)
	{
	    header_set = TRUE;
	    pt += 3;
	    strcpy(header, pt);
	}
    } 

    if(input_set == FALSE)
    {
	printf("Input file was not specified.\n");
	exit(1);
    }
    else
    {
	fi = open(input, O_RDONLY , 0644);
	if (fi < 0)
	{
	    perror(input);
	    exit(1);
	}
    }

    if (header_set == FALSE)
    {
	strcpy(header, "temp.hdr");
	printf("output will be to file %s\n\n", header);
    }
    fh = open(header, O_WRONLY | O_CREAT | O_TRUNC, 0644);
    if (fh < 0)
    {
	perror(header);
	exit(1);
    }

    lseek(fi, 0, 0);
    read(fi, &hdr, sizeof(hdr));
    lseek(fi, hdr.hdr_start, 0);

    printf("hdr.tapetype = %d\n", hdr.tapetype);
    switch(hdr.tapetype)
    {
    case 1397312848:
    case 1347242323:
	/* it's a real FITS file, not a skyview workfile */
	lseek(fi, 0, 0);  /* start over at the start of the file */
	/* drop through */

    case FITS:
    {
	nl[0] = '\n';
	while (FOREVER)
	{
	    n_read = read(fi, buf, 2880);

	    if(n_read < 2880)
	    {
		printf("unexpected EOF encountered.\nAborting\n");
		exit(1);
	    }

	    pt = buf;
	    for (i=0; i<36; i++, pt+=80)
	    {
		/*
		*(pt+79) = '\n';
		*/
		write(fh, pt, 80);
		write(fh, nl, 1);

		*(pt+79) = '\0';
		printf("%s\n",pt);

		if(strncmp(pt,"END",3) == 0)
		{
		    printf("END encountered.\n");
		    return(0);
		}
	    }
	}
	break;
    }
    case VICAR:
    {
	printf("processing VICAR header\n");
	while (FOREVER)
	{
	    n_read = read(fi, buf, 72);

	    if(n_read < 72)
	    {
		printf("unexpected EOF encountered.\nAborting\n");
		exit(1);
	    }

	    pt = buf;
	    *(pt+70) = '\n';
	    write(fh, pt, 71);

	    *(pt+70) = '\0';
	    printf("%s\n",pt);

	    if(*(pt+71) == 'L')
	    {
		printf("END encountered.\n");
		return(0);
	    }
	}
	break;
    }
    default:
    {
	printf("unrecognized image file type\n");
	break;
    }
    }
    return(0);
}
