/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include "skyview.h"
#include <stdio.h>
#include <string.h>

char *hdr_bufp_end, *hdr_buf;  /* used by screen dump and crop also */
static char *bufp;

/* function prototypes */
#ifdef _NO_PROTO

static void keyseek();

#else

static void keyseek(char word[]);

#endif /* _NO_PROTO */

/**********************************************************************
**                                                                   ** 
**  HDRINIT looks for END keyword and sets hdr_buf_end to point      **
**  just past the END card.  Returns TRUE if END found, FALSE        **
**  otherwise.                                                       **
**                                                                   ** 
**********************************************************************/ 
int
hdrinit(bufsize)
int bufsize;
{
    /* find END keyword */
    bufp = hdr_buf;
    while ((strncmp(bufp, "END", 3)) && (bufp < bufp + bufsize))
    {
	bufp += 80;
    }

    if (bufp >= bufp + bufsize)
    {
	/* not found */
	hdr_bufp_end = hdr_buf;    /* point to start of buffer */
				   /* (for lack of a better place) */
	return(FALSE);
    }
    else
    {
	hdr_bufp_end = bufp + 80; /* point past the END card */
	return(TRUE);
    }
}

void
hdrlogical(word, chr)
char word[];
int chr;
{
    keyseek(word);
    *(bufp+29) = (char) chr;
}

void
hdrint(word, i)
char word[];
int i;
{
    char str[20];

    keyseek(word);
    sprintf(str, "%d", i);
    strncpy( bufp+30-strlen(str), str, strlen(str));
}

void
hdrfloat(word, value)
char word[];
double value;
{
    char *p, str[20];

    keyseek(word);
    sprintf(str, "%1.7g", value);
    p = strchr(str, 'e');
    if (p == 0)
    {
	if (strchr(str, '.') == 0)
	    strcat(str, ".");
    }
    else
    {
	*p = 'E';
    }
    strncpy( (bufp+30-strlen(str)), str, strlen(str));
}

void
hdrstr(word, str)
char word[];
char str[];
{
    char str1[70];

    keyseek(word);
    strcpy(str1, "'");
    strcat(str1,str);
    if (strlen(str1) < (size_t) 9)
	strncat(str1, "        ", 9-strlen(str1));
    strcat(str1, "'");
    strncpy(bufp+10, str1, strlen(str1));
}

void
comment(str)
char str[];
{
    keyseek("dummy");
    strncpy(bufp, "COMMENT ", 8);
    strncpy(bufp+8, str, strlen(str));
}

/**********************************************************************
**                                                                   ** 
**  KEYSEEK looks for keyword in existing FITS header                **
**    (looks from beginning of hdr_buf to hdr_buf_end).              ** 
**  If found sets bufp to keyword and returns                        **
**      after clearing out the old value (cols 10-39).               ** 
**  If not found opens up space before END keyword, sets bufp        **
**  pointing to this space, fills in the keyword and spaces,         **
**  and returns                                                      **
**                                                                   ** 
**********************************************************************/ 

static void
keyseek(word)
char word[];
{
    int len_word, i;
    char *p, *p1, *p2;

    bufp = hdr_buf;
    len_word = strlen(word);
    while ((strncmp(bufp, word, len_word)) && (bufp < hdr_bufp_end))
    {
	bufp += 80;
    }
    if (bufp >= hdr_bufp_end)
    {
	/* not found */
	if (strncmp(word, "BLOCKED", 7) == 0)
	{
	    /* special case for BLOCKED - must be in first 2880 record */
	    /* so, put it after last NAXISn */
	    bufp = hdr_buf + 160;        /* point to first NAXIS */
	    while (strncmp(bufp, "NAXIS", 5) == 0)
	    {
		bufp += 80;
	    }
	}
	else
	{
	    bufp = hdr_bufp_end - 80;    /* point to END card */
	}
	hdr_bufp_end += 80;     /* new end of buffer */

	p1 = hdr_bufp_end;      /* move cards */
	p2 = p1 - 80;
	while (p2 > bufp)
	    *(--p1) = *(--p2);

	strcpy(bufp, word);   /* fill in keyword */
	strcat(bufp, "         ");
	*(bufp+8) = '=';
	for (p = bufp+9, i=0; i<71; i++, p++)
	    *p = ' ';   /* clear out rest of 80 col field */
    }
    else
	for (p = bufp+9, i=0; i<30; i++, p++)
	    *p = ' ';   /* clear out old value */
}
