#define IPAC_ASCII 0
#define FITS_BINARY 1

typedef unsigned char INT8;
typedef short INT16;
typedef int INT32;
typedef float REAL4;
typedef double REAL8;

#ifndef _NO_PROTO
#ifndef __STDC__
#define _NO_PROTO
#endif /* __STDC__ */
#endif /* _NO_PROTO */

#ifdef _NO_PROTO

void topenr();
int tblread();
void tseek();
void tindp();
void tpinfo();
void tgetc();
void tgetd();
void tgeti();
void tgetr();
void REAL8fetch();
void REAL4fetch();
void INT32fetch();
void INT16fetch();
void tcls();
int itstat();
void topenw();
void tlink();
void tgetaddr();
void tblwrit();
void tget_primary();
void tget_extension();
int tgetrowcount();
void tseti();
void tsetc();
void tsetr();
void tnewp();
void tfiltyp();
void tblwrit_raw();
void t_rkey_c();
void t_rkey_i();
void t_rkey_d();
void t_rkey_r();
char *t_error();
int tgettyp();

#else

void topenr(int unit, char *filename, int *nparms);
int tblread(int unit);
void tseek(int unit, int recno);
void tindp(int unit, char *fieldname, int *pindex);
void tpinfo(int unit, int pindex, char pname[], char *ptype, char pblank[], 
    char punit[], double *pscale, double *poffs, int *pcol, 
    int *plen, int *pelements);
void tgetc(int unit, int pindex, char *pvalc);
void tgetd(int unit, int pindex, double *pvald);
void tgeti(int unit, int pindex, int *pvali);
void tgetr(int unit, int pindex, float *pvalr);
void REAL8fetch(REAL8 *inptr, REAL8 *outptr);
void REAL4fetch(REAL4 *inptr, REAL4 *outptr);
void INT32fetch(INT32 *inptr, INT32 *outptr);
void INT16fetch(INT16 *inptr, INT16 *outptr);
void tcls(int unit);
int itstat(void);
void topenw(int unit, char *filename);
void tlink(int unit_in, int unit_out);
void tgetaddr(int unit, int pindex, char **adr);
void tblwrit(int unit);
void tget_primary(int unit, char **pt, int *bytes);
void tget_extension(int unit, char **adr, int *bytes);
int tgetrowcount(int unit);
void tseti(int unit, int col, int integer);
void tsetc(int unit, int col, char *string);
void tsetr(int unit, int col, double real);
void tnewp(int unit, char *pname, char *ptype, char *pblank, char *punit, 
    double pscal, double poff, char *pfmt, int plen, int *pindex);
void tfiltyp(int unit, int newtype);
void tblwrit_raw(int unit, char *string);
void t_rkey_c(int unit, char *c_ptr, char *keyword);
void t_rkey_i(int unit, int *i_ptr, char *keyword);
void t_rkey_d(int unit, double *d_ptr, char *keyword);
void t_rkey_r(int unit, float *f_ptr, char *keyword);
char *t_error(void);
int tgettyp(int unit);

#endif /* _NO_PROTO */
