			Screen Management Notes

The program remembers up to 10 images.
Painting images after the 10th causes
the oldest images to be forgotten.

Joystick operations like "pick" search through all
painted images for the most recently painted image
which colored the pixel in question.

The commands "define" , "pick", and "background_level" specify an
area of pixels.  This area may include undefined pixels.
It is an error, however, for this area to contain only undefined
pixels, or for it to contain pixels from more than one image.

The commands "define", "pick", "background_level", and "zoom_pan" may be
used with coordinates, rather than joystick.  To interpret
these coordinates, the program first looks to the "current image"
(defined below).  If the specified coordinates are not visible on the 
"current image" then all the images maintained by screen management
are scanned from the most recently painted to the oldest.  If the
coordinates are found on an image, then that image becomes the
"current image".

The "current image" is usually the image on which the current work
is being done.  When an image is painted it becomes the "current
image".  A successful "define", "pick", or "background_level" command
changes the "current image" to the image referenced.  A "zoom_pan"
or "frame" command changes the "current image" to the image
which now occupies the center of the screen, or, if no such image exists,
to the image whose center is nearest to the center of the screen.
The user may force an image to be the "current_image" using the "ci"
command.

The results of a "define_area" command are saved internally as a line and 
sample range.  An "examine" command applies this line and
sample range to the "current" image.  It is therefor possible
to paint different bands of an image into different frames on
the screen, do a "define_area" on one band, and "examine"
commands on each different band to get the information on
corresponding areas in each band.


	    Functions

clear_img()
    Reset entire screen management structure to empty screen.

struct img *new_img()
    Enter a new image into screen management.  Called by paint.

fill_glob(imgp)
    Transfer values from an image structure to global

fill_img(imgp)
    Transfer values from global to an image structure.

center_img()
    Find image which occupies center of screen, or whose center
    is nearest center of screen.  Makes it the "current" image.

struct img *find_SC(x,y)
    Finds image with x,y visible.  Makes it the "current image".
    If no image at (x,y), returns NULL and makes no change to
    "current image".

struct img *find_IM(i_coord)
    i_coord[0] = samp
    i_coord[1] = line
    Finds image with samp,line visible.  Favors "current image".
    If samp,line is found on "current image", routine still checks
    that no image has overpainted that pixel.

struct img *find_COORD(coord, i_coord)
    coord[0] = lon
    coord[1] = lat
    i_coord[0] = samp
    i_coord[1] = line
    Finds image with lat,lon.  Favors "current image".  
    If "current image" contains lat,lon, it is still checked
    to see if that pixel has been overpainted.

struct img *sky_to_image(s_coord, i_coord)
    Converts the string read in to image coordinates (samp,line).
    Uses the current image if the resulting samp,line is visible
    on the screen.  Otherwise, finds an image with the coordinates
    visible and fills the global variables from that image structure.
    With success, returns a pointer to the img structure from which
    the global variables have been filled.
    With failure (no visible image with specified coordinates),
    returns NULL pointer and leaves global variables as at entry.


	    NOTES FOR X WINDOWS VERSION

Every paint creates an "img" structure.

If the "frame" has been already painted, it is reused ( i.e. the existing
window is reused).

    If either height or width has increased, a new "theImage" is 
    created using XSubImage(), which copies in the old pixels.  The old
    "theImage" is then destroyed.

    Otherwise, if neither height nor width has increased, the old "theImage"
    is retained:  its pointer is copied to the new "img" structure, and
    the "theImage" pointer in the old "img" structure is set to NULL.

    If there exists an old zoom_image, it is deleted and then 
    subsequently recreated.

Thus, there may be more than one "img" structure for a given "win", but
only the last "img" structure will have an associated "theImage" and
"zoom_window".  There is exactly one "win" for each "frame" (they mean
the same thing).
