/*==================================================================
** NAME         :dispos.c
** TYPE         :double
** DESCRIPTION  :dispos computes distance and position angle
**              :solving a spherical triangle (no approximations)
** INPUT        :coo in decimal degrees
** OUTPUT       :dist in arcmin, returns phi in degrees (East of North)
** AUTHOR       :a.p.martinez
** DATE         :91;
** LIB          :
*=================================================================*/
#include "skyview.h"
#include "parse.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

extern int s1_server_mode;
extern int output_coord_sys;

double dispos(dra0,decd0,dra,decd,dist)
	double *dra, *dra0, *decd, *decd0, *dist;
{
	double alf,alf0,del,del0,phi;
	double sd,sd0,cd,cd0,cosda,cosd,sind,sinpa,cospa;
	double radian=180./M_PI;

/* coo transformed in radiants */

	alf = *dra / radian ;
	alf0= *dra0 / radian ;
	del = *decd / radian;
	del0= *decd0 / radian;

	sd0=sin(del0);
	sd =sin(del);
	cd0=cos(del0);
	cd =cos(del);
	cosda=cos(alf-alf0);
        cosd=sd0*sd+cd0*cd*cosda;
	*dist=acos(cosd);
	phi=0.0;
	if(*dist > 0.0000004)
	{
	   sind=sin(*dist);
	   cospa=(sd*cd0 - cd*sd0*cosda)/sind;
	   if(cospa>1.0)cospa=1.0;
	   if(cospa<-1.0)cospa=-1.0;  /* RBH added */
	   sinpa=cd*sin(alf-alf0)/sind;
	   phi=acos(cospa)*radian;
	   if(sinpa < 0.0)phi = 360.0-phi;
	}
	*dist *=radian;
	*dist *=60.0;
	if(*decd0 == 90.) phi = 180.0;
	if(*decd0 == -90.) phi = 0.0;
	return(phi);
}

/* position_angle_bias returns delta between north and straight up on image */
double position_angle_bias(d_coord)
double d_coord[2];   /* position in SC coords */
{
    double d_coord1[2];
    char *coord_str, s_coord[2][40];
    int coord_sys;
    double ra1, dec1, ra2, dec2, dist;
    int s1_server_mode_save, output_coord_sys_save;
    int jsys;
    double equinox;

    d_coord1[0] = d_coord[0];
    d_coord1[1] = d_coord[1];
    dSC_to_IM(d_coord1);
    s1_server_mode_save = s1_server_mode;
    s1_server_mode = 1;  /* force decimal output from dimage_to_string */
    output_coord_sys_save = output_coord_sys;
    output_coord_sys = EQ;  /* force equatorial */
    coord_str = dimage_to_sky(d_coord1, s_coord, &coord_sys, &equinox, &jsys);
    s1_server_mode = s1_server_mode_save;      /* restore */
    output_coord_sys = output_coord_sys_save;  /* restore */
    if (strncmp(coord_str, "undefined", 9) == 0)
    {
	return(0.0);
    }
    ra1 = atof(s_coord[0]);
    dec1 = atof(s_coord[1]);

    d_coord1[0] = d_coord[0];
    d_coord1[1] = d_coord[1] + 1;  /* one pixel up */
    dSC_to_IM(d_coord1);
    s1_server_mode_save = s1_server_mode;
    s1_server_mode = 1;  /* force decimal output from dimage_to_string */
    output_coord_sys_save = output_coord_sys;
    output_coord_sys = EQ;  /* force equatorial */
    coord_str = dimage_to_sky(d_coord1, s_coord, &coord_sys, &equinox, &jsys);
    s1_server_mode = s1_server_mode_save;  /* restore */
    output_coord_sys = output_coord_sys_save;  /* restore */
    if (strncmp(coord_str, "undefined", 9) == 0)
    {
	return(0.0);
    }
    ra2 = atof(s_coord[0]);
    dec2 = atof(s_coord[1]);

    return(dispos(&ra1,&dec1,&ra2,&dec2,&dist));

}


#ifdef TEST_DRIVER
main(argc, argv)
int argc;
char *argv[];
{
       double angle;
       double r1, d1, r2, d2, dist;
       char bufr1[100];
       char bufd1[100];
       char bufr2[100];
       char bufd2[100];
       int isdec;

       if(argc < 5 ){
	  fprintf(stderr,"not enough args\n");
	  exit(1);
       };
       
       c_coord(argv[1], 0, 1, bufr1, &isdec, &r1);
       c_coord(argv[2], 1, 1, bufd1, &isdec, &d1);
       c_coord(argv[3], 0, 1, bufr2, &isdec, &r2);
       c_coord(argv[4], 1, 1, bufd2, &isdec, &d2);

       angle = dispos(&r1,&d1,&r2,&d2,&dist);
       printf("%s %s -> %s %s\n", bufr1, bufd1, bufr2, bufd2);
       printf("%f %f -> %f %f = %f arcmin\n", r1, d1, r2, d2, dist);
       printf("angle = %g\n", angle);

       return (0);
}
#endif /* TEST_DRIVER */
