/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#define BUFSIZE  32768
#define NULL 0

#include "skyview.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


static int blksiz;
static char *bufptr, *bufadr;

int
first_block(mmfd, his_bufptr, his_bytes)
int mmfd;
char *his_bufptr;     /* must be 2880 bytes */
int his_bytes;
{

    if (bufadr == NULL)
	bufadr = malloc(BUFSIZE);
    if (bufadr == NULL)
	printf("first_block: malloc failed\n");
    blksiz = read(mmfd, bufadr, BUFSIZE);
    printf("block size = %d\n",blksiz);
    if (blksiz <= 0)
    {
	free(bufadr);
	bufadr = NULL;
	return(blksiz);
    }
    if ((blksiz % 2880 == 0) && (blksiz != 2880))
    {
	/* its a blocked FITS tape */
	bufptr = bufadr;
	memcpy(his_bufptr, bufptr, 2880);  /* give him the first 2880 */
	return(2880);               /* make it look like unblocked FITS */
    }
    else
    {
	/* we will not be doing any unblocking */
	if (blksiz > his_bytes) 
	{
	    blksiz = -2;
	    error1("unusually large block encountered\n");
	}
	if (blksiz > 0)
	    memcpy(his_bufptr, bufadr, blksiz);
	free(bufadr);
	bufadr = NULL;
	return(blksiz);
    }
}

int
next_block(mmfd, his_bufptr, his_bytes)
int mmfd;
char *his_bufptr;
int his_bytes;
{
    if (bufadr == NULL)
    {
	/* this will happen for unblocked FITS tapes */
	return(read(mmfd, his_bufptr, his_bytes));
    }

    /* were working on a blocked FITS tape */
    bufptr += 2880;             /* move to next logical block */
    if (bufptr - bufadr >= blksiz)
    {
	blksiz = read(mmfd, bufadr, blksiz);
	if (blksiz <= 0)
	{
	    free(bufadr);
	    bufadr = NULL;
	    return(blksiz);
	}
	bufptr = bufadr;
    }
    memcpy(his_bufptr, bufptr, 2880);
    return(2880);
}
