/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include <stdio.h>
#include <sys/file.h>
#include "jgio.h"
#include <sgtty.h>
#include <sys/types.h>
#include <sys/time.h>

#define TTY     "/dev/ttya"

#define FALSE   0
#define TRUE    1
#define FOREVER TRUE
 
#define XX 0x00
#define YY 0x02
#define BB 0x01

extern int debug, graphics;

int Ball_fd = -1;


/************************************************************/
/*                                                          */
/* BALL_SETUP opens the trackball device                    */
/*                                                          */
/************************************************************/

ball_setup()

{
     int dumint;
     struct sgttyb arg;

     Ball_fd = open(TTY, 2);
     if(Ball_fd < 0) 
     {
	  perror(TTY);
	  return;
     }
     else
     {
	 ioctl(Ball_fd, TIOCGETP, &arg);

	 arg.sg_ispeed = B9600;           /* insure 9600 baud */
	 arg.sg_ospeed = B9600;
	 arg.sg_flags &= ~ECHO;           /* Turn ECHO off        */
	 arg.sg_flags &= ~CBREAK;         /* Turn CBREAK mode off */
	 arg.sg_flags |= RAW;             /* Turn RAW mode on     */

	 ioctl(Ball_fd, TIOCSETP, &arg);
	 dumint = 0;
	 ioctl(Ball_fd, TIOCFLUSH, &dumint);
     }
}



/************************************************************/
/*                                                          */
/* BALL checks the trackball for input and deciphers it     */
/*                                                          */
/************************************************************/

ball1(output, power, scale)

int *output, power, scale;

{
    int i, var, type, sign, dx, dy, button;
    int n_read, n_ready, dumint;
    char ch_var, com[300];
    struct timeval tp;
    static last_button;
    static long old_sec, old_usec;
    long delta_sec, delta_usec, delta_msec;

    dx = 0;
    dy = 0;
    button = 0;

    dumint = 0;
    output[0] = 0;
    output[1] = 0;
    output[2] = FALSE;
    output[3] = FALSE;
    output[4] = FALSE;

    n_ready = 0;
    ioctl(Ball_fd, FIONREAD, &n_ready);

    if(n_ready < 3)
	return(FALSE);

    n_read = read(Ball_fd, com, 300);
    ioctl(Ball_fd, TIOCFLUSH, &dumint);

    if(n_read <= 0)
	return(FALSE);

    for(i=0; i<n_read; ++i)
    {
	ch_var = com[i];
	var = ch_var & 0xff;
	type = (var >> 6);

	if(type == XX)
	     dx = (int) ch_var;

	if(type == YY)
	     dy = (int) ch_var;

	if(type == BB)
	     button = (int) ch_var;
    }

    if(dx != 0)
    {
	sign = dx & 0x20;
	dx = dx & 0x1f;
	if(sign > 0) 
	    dx = -(32-dx);     /* two's complement */

	for(i=1; i<power; ++i)
	   dx *= dx;

	output[0] = dx * scale;
	if (sign > 0)
	    output[0] = -abs(output[0]);
    }

    if(dy != 0)
    {
	sign = dy & 0x20;
	dy = dy & 0x1f;
	if(sign > 0) 
	    dy = -(32-dy);

	for(i=1; i<power; ++i)
	   dy *= dy;

	output[1] = dy * scale;
	if (sign > 0)
	    output[1] = -abs(output[1]);
    }

    /* now debounce the trackball buttons */
    /* longest bounce I have observed is 140 ms, so I use 160 ms */
    if (button & 0x7)
    {
	gettimeofday(&tp, 0);
	delta_sec = tp.tv_sec - old_sec;
	delta_usec = tp.tv_usec - old_usec;
	delta_msec = (delta_usec / 1000) + (1000 * delta_sec);
	old_sec = tp.tv_sec;
	old_usec = tp.tv_usec;
	if ((delta_msec < 160) && ((button & 0x7) == last_button))
	{
	    if (debug)
		printf("ball: contact bounce on trackball  %ld msec\n", delta_msec);
	    return(FALSE);
	}
	last_button = button & 0x7;

	if((button & 0x01) != 0)
	    output[2] = TRUE;

	if((button & 0x02) != 0)
	    output[3] = TRUE;

	if((button & 0x04) != 0)
	    output[4] = TRUE;
    }

    if(debug == TRUE)
	printf("ball: x=%d y=%d button=%d%d%d\n",
	    output[0], output[1],
	    output[2], output[3], output[4]);

    return(TRUE);
}
