/*
Copyright (C) 1995, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>     /* includes strings.h, sys/time.h, and sys/file.h */

#include "skyview.h"
#include "parse.h"
#include "img_x.h"
#include "img.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

extern int debug, graphics;
extern int server_mode;
extern char server_str[];
extern char plane;
extern FILE *session;
extern char last_coord[2][40];

extern Display *display;
extern Window win;
extern GC gcxor;
extern Font default_font_id;
extern Font label_font_id;

Font agra_font_id = 12345; /* random number */

/********************************************************************** 
**                                                                   ** 
**  LABEL                                                            ** 
**  place text strings on the image                                  ** 
**                                                                   ** 
**********************************************************************/ 

void
label(argc, argv) 
int argc;
char **argv;
 
{ 
    char *ptr;
    static double font_size = 10.0;
    double dummy_dbl;
    char text[80];
    int textlen;
    double d_coord[2], dummy[2];
    char *coord_str;
    int i, coord_sys; 
    int oldxcur, oldycur;
    int got_coord, string_arg;
    struct img *imgp;
    char s_coord[2][40];
    static char fontname[MAXPATHLEN];
    char anin[MAXLINE];
    unsigned int keys_buttons;
    int done, what;
    Window root, child;
    int root_x, root_y;
    int x, y;
    int dummy_dx, dummy_dy;
    XFontStruct *font_info1;
    static char     xcolor[25] = {'g', 'r', 'e', 'e', 'n'};
    int jsys;
    double equinox;

    if (!set_current_window())
    {
	error1("no images currently being displayed");
	return;
    }

    got_coord = FALSE;
    string_arg = 1;

    if (argc < 2)
    {
	error1("annotate command requires a string");
	return;
    }

    if (argc > 3)
    {
	/* see if coordinates are present */

	if (isnbr(argv[1]) && isnbr(argv[2]))
	{
	    strcpy(s_coord[0], argv[1]);
	    strcpy(s_coord[1], argv[2]);
	    imgp = sky_to_image(s_coord, d_coord);
	    if (imgp != NULL)
	    {
		/* coords are on an image - must be good */
		got_coord = TRUE;
	    }
	    else
	    {
		/* coords not on an image - but may still be coords */
		if (str_to_coord(s_coord, dummy))
		{
		    got_coord = TRUE;
		}
	    }
	}
	if (got_coord)
	{
	    string_arg = 3;
	    dIM_to_SC(d_coord);
	}
    }

    for (i = string_arg + 1; i < argc; i++)
    {
	if (good_overlay_color(argv[i]))
	    strcpy(xcolor, argv[i]);
	else
	{
	    /* must be a font */
	    strcpy(fontname, argv[i]);
	    if (strcmp(fontname, "agra") == 0)
	    {
		label_font_id = agra_font_id;
		/* see if "agra" is followed by a size parameter */
		if (argc > i+1)
		{
		    dummy_dbl = strtod(argv[i+1], &ptr);
		    if (ptr == argv[i+1])
		    {
			error1("font size is not a number");
			return;
		    }
		    else
			font_size = dummy_dbl;
			i++;
		}
	    }
	    else
	    {
		if (!graphics)
		{
		    error1("illegal to specify non-agra font in non-graphics mode");
		    return;
		}
		load_font(&font_info1, fontname);
		if (font_info1 == NULL)
		    return;
		label_font_id = font_info1->fid;
	    }
	}
    }


    /* get the text string */

    strcpy(text, argv[string_arg]);
    textlen = strlen(text);

    if (!got_coord)
    {
	if (!graphics)
	{
	    error1("interactive annotate illegal in non-graphics mode");
	    return;
	}
	if ((label_font_id != default_font_id) &&
	    (label_font_id != agra_font_id))
	    XSetFont(display, gcxor, label_font_id);

        /* X Windows mouse stuff */ 

	XQueryPointer(display, win,
	    &root, &child, &root_x, &root_y, 
	    &oldxcur, &oldycur, &keys_buttons);
	
	x = oldxcur;  /* make purify happy */
	y = oldycur;  /* make purify happy */


	set_motion_notify(win);
	done = 0;
	while(!done)
	{
	    if (label_font_id == agra_font_id)
	    {
		d_coord[0] = oldxcur;
		d_coord[1] = oldycur;
		dWIN_to_SC(d_coord);
		mlabel(d_coord[0], d_coord[1], text, font_size, 1);
	    }
	    else
		XDrawString(display, win, gcxor, oldxcur, oldycur, text, textlen);

	    wait_for_event(anin, &what, &x, &y, &dummy_dx, &dummy_dy, 0);

	    /* undraw old string */
	    if (label_font_id == agra_font_id)
	    {
		d_coord[0] = oldxcur;
		d_coord[1] = oldycur;
		dWIN_to_SC(d_coord);
		mlabel(d_coord[0], d_coord[1], text, font_size, 1);
	    }
	    else
		XDrawString(display, win, gcxor, oldxcur, oldycur, text, textlen);

	    switch(what)
	    {
	    case Button1:
		break;
	    case Button2:
	    case TTYINPUT:
		done = 1;
		break;
	    case Button3:
		break;
	    case POINTERMOTION:
		oldxcur = x;
		oldycur = y;
		break;
	    }

	}
     
	clear_motion_notify();

	d_coord[0] = oldxcur;
	d_coord[1] = oldycur;
	dWIN_to_SC(d_coord);

	if ((label_font_id != default_font_id) &&
	    (label_font_id != agra_font_id))
	    XSetFont(display, gcxor, default_font_id); /* restore normal font */
    }

    save_overlay_color();
    set_overlay_color(xcolor);
    overlay_setup('g');    /* actual color doesn't matter */
    next_bundle();

    overlay_string(d_coord[0], d_coord[1], text, label_font_id, font_size);

    image_setup(plane);
    restore_overlay_color();  /* nullify effect of set_overlay_color() */


    /* print out final location */
    dSC_to_IM(d_coord);

    coord_str = dimage_to_sky(d_coord, s_coord, &coord_sys, &equinox, &jsys);
    if (argc <= 3)
    {
	strcpy(last_coord[0], s_coord[0]);
	strcpy(last_coord[1], s_coord[1]);
    }

    if(server_mode == FALSE)
       printf("annotate at %s", coord_str);
    else
    {   
       srv_coord("coord", coord_sys, s_coord, equinox, jsys);
    }

    fprintf(session, "annotate at %s", coord_str);
} 
