/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

#include "skyflux.h"
#include "parse.h"
#include "img_jup.h"
#include "img.h"
#include <stdio.h>
#include "jgio.h"

extern int debug, graphics;
extern int x_zoom, y_zoom, x_orig, y_orig;
extern char plane;
extern JFILE *J12file;
extern FILE *session;

/********************************************************************** 
**                                                                   ** 
**  LABEL                                                            ** 
**  allows placement of text strings on the image                    ** 
**                                                                   ** 
**********************************************************************/ 

label(argc, argv) 

int argc;
char **argv;
 
{ 
    char text[80];
    double d_coord[2], dummy[2];
    char *coord_str, *image_to_sky();
    int i, x, y; 
    int done, what;
    char comm[20];
    int stat;
    int oldxcur, oldycur;
    int x_size, y_size, dx, dy;
    int got_coord, argstart;
    struct img *imgp;
    int i_coord[2];
    char s_coord[2][40];
    static char fontname[MAXPATHLEN] = {'c', '7', '9', '\0'};
    static char color = 'g';
    static int color_val = 2;


    got_coord = FALSE;
    argstart = 1;

    if (argc < 2)
    {
	printf("annotate command requires a string\n");
	error();
	return;
    }

    if (argc > 3)
    {
	/* see if coordinates are present */

	if (isnbr(argv[1]) && isnbr(argv[2]))
	{
	    strcpy(s_coord[0], argv[1]);
	    strcpy(s_coord[1], argv[2]);
	    imgp = sky_to_image(s_coord, d_coord);
	    if (imgp != NULL)
	    {
		/* coords are on an image - must be good */
		got_coord = TRUE;
	    }
	    else
	    {
		/* coords not on an image - but may still be coords */
		if (str_to_coord(s_coord, dummy))
		{
		    got_coord = TRUE;
		}
	    }
	}
	if (got_coord)
	{
	    argstart = 3;
	    dIM_to_SC(d_coord);
	    oldxcur = round(d_coord[0]);
	    oldycur = round(d_coord[1]);
	}
    }

    for (i = argstart + 1; i < argc; i++)
    {
	switch(cmd(argv[i]))
	{
	case RED:
	    color = 'r';
	    color_val = 1;
	    break;
	case GREEN:
	    color = 'g';
	    color_val = 2;
	    break;
	case BLUE:
	    color = 'b';
	    color_val = 4;
	    break;
	case WHITE:
	    color = 'w';
	    color_val = 8;
	    break;
	default:
	    strcpy(fontname, argv[i]);
	    break;
	}
    }

    /* now define the character fonts */
    if (graphics)
    {
	stat = get_font(fontname);
	if (stat < 0)
	    return;
    }

    overlay_setup('r');

    /* get the text string */

    strcpy(text, argv[argstart]);

    if (!got_coord)
    {


          /* Pick the point */ 

	  x_size = 1280 / x_zoom;
	  y_size = 1024 / y_zoom;

	  oldxcur = x_orig + x_size / 2;
	  oldycur = y_orig + y_size / 2;
	  x = oldxcur;
	  y = oldycur;

	  if(debug == TRUE)
	      {
	      printf("x = %d (from %d, size %d)\n", x, x_orig, x_size);
	      printf("y = %d (from %d, size %d)\n", y, y_orig, y_size);
	      }

	done = 0;
	while (!done) 
	{ 

	    j_txt_cols(0x01, 0, 1, 8, 8, 0, 0, 1, 1);
	    j_text(oldxcur, oldycur, text);          /* write the text    */
	    jfflush(J12file); 

	    wait_for_event(comm, &what, &x, &y, &dx, &dy, 0);

	    j_txt_cols(0x01, 0, 0, 8, 8, 0, 0, 1, 1);
	    j_text(oldxcur, oldycur, text);  /* write over the old location */

	    switch(what)
	    {
		case Button1:
		    break;
		case Button2:
		case TTYINPUT:
		    done = 1;
		    break;
		case Button3:
		    break;
		case POINTERMOTION:
		    oldxcur = x;
		    oldycur = y;
		    break;
	    }


	} 
    }


    overlay_setup(color);
    j_txt_cols(color_val, 0, color_val, 8, 8, 0, 0, 1, 1);
    j_text(oldxcur, oldycur, text);          /* write the text    */

    image_setup(plane);

    jfflush(J12file); 

    /* print out final location */
    imgp = find_SC(oldxcur, oldycur);
    i_coord[0] = oldxcur;
    i_coord[1] = oldycur;
    SC_to_IM(i_coord);

    coord_str = image_to_sky(i_coord);
    printf("annotate at %s", coord_str);
    fprintf(session, "annotate at %s", coord_str);
} 
