/*
Copyright (C) 1992, California Institute of Technology.
U.S. Government Sponsorship under NASA Contract NAS7-918 is acknowledged.
*/

/* routines to interface AED 512 to s program  */ 
#include "skyview.h"
#include "parse.h"
#include "img.h"
#include <stdio.h>
#include <strings.h>
#include <sgtty.h>
#include <sys/file.h>
#include <math.h>

extern FILE *session;
extern int wedge_on;
extern int output_coord_sys, ttyfd, debug, tmpfd;
extern int blank;
extern double bscale, b_zero;
extern char bunit[], *image_to_sky();

extern int hist_on;
extern minx, miny;

static char Id[] = "@(#)aed.c   RBH        06/03/88>";

#ifndef JUPITER
int J12file;
#endif 

int area_number;
int x_area[100][MAX_AREAS];

static int screenflag;
/*
static char hist_font[] = {
0x5e, 0x31, 0x35, 0x7, 0x14, 0x4c}; */ /* SAP set font, lock alpha to CAP */
static char hist_font[] = {
0x5e, 0x31, 0x37, 0x9, 0xe, 0x4c}; /* SAP set font, lock alpha to CAP */
static char norm_font[] = {
0x5e, 0x31, 0x37, 0x9, 0xe, 0x55}; /* SAP set font, unlock alpha from CAP */

static int aedfd;

static char initbuff[] = 
    {
    0x1b,                                /* invoke interpreter */
    0x47, 0x31, 0x38, 0x38, 0x38, 0x4e,  /* one byte commands */
    0x27, 0x01,                  /* STD  set turnaround delay to 10/60 sec */
    0x1                         /* exit interpreter */
    };

jginit()
{
    int stat;
    struct sgttyb oldtty, newtty;

    aedfd = open("/dev/tty00", 2);
    if (aedfd < 0)
    {
	perror("/dev/tty00");
	exit(0);
    }
    stat = ioctl(aedfd, TIOCGETP, &oldtty);
    if (stat == -1)
	perror("TIOCGETP");
    if (debug)
    {
	printf("old ispeed=%d ospeed=%d flags=%o octal\n", oldtty.sg_ispeed, oldtty.sg_ospeed, oldtty.sg_flags);
    }
    stat = ioctl(aedfd, TIOCGETP, &newtty);
    if (stat == -1)
	perror("TIOCGETP");
    newtty.sg_flags |= (RAW);
    newtty.sg_flags &= ~(ECHO | CRMOD);
    newtty.sg_ospeed = EXTA;  /* 19200 baud */
    newtty.sg_ispeed = EXTA;  /* 19200 baud */
    stat = ioctl(aedfd, TIOCSETP, &newtty);
    if (stat == -1)
	perror("TIOCSETP");
    write(aedfd, initbuff, sizeof(initbuff));
    /*   this stuff unnecessary - it happens at program termination anyway
    stat = ioctl(aedfd, TIOCSETP, &oldtty);
    if (stat == -1)
	perror("TIOCSETP");
    */
    return(1);
}

static char era_buff[] = 
    {
    0x1b,                                /* invoke interpreter */
    0x64,                         /* DJC  disable joystick - erase cursor  */
    0x26,                         /* DPA  disable pan  */
    0x4b, 0xff, 0x01, 0xff, 0xff, 0xff,     /* SCT  set color 255 to white */
    0x43, 0xff,                        /* SEC  set current color to white  */
    0x63, 0xff, 0xff, 0x00,       /* SCC  set cursor color white, no flash */
    0x5d, 0x2b, 0, 0,             /* SCP  set cursor to + */
    0x67, 0, 0, 0, 0,             /* BSO  set origins to zero */
    0x45, 1, 1,                   /* SZR  set zoom to 1,1 */
    0x5f,                         /* HOM  home alpha cursor */
    0x7b, 0xff,                   /* SAC  set alpha cursor color to white */
    0x5e, 0x31, 0x37, 0x9, 0xe, 0x55, /* SAP set font, unlock alpha from CAP */
    0x5b, 0,                      /* SBC  set background color to black */
    0xc        /* FFD  erase video memory, restore origins, exit interpreter */
    };

erase(argc, argv)
int argc;
char **argv;
{
    if (argc > 1)
    {
	printf("erase command does not allow arguments in AED version\n");
	error();
	return;
    }
    write(aedfd, era_buff, sizeof(era_buff));
}

main_command(p)

char *p;

{
    int n_bytes, n_read;

    n_bytes = 256;

    fflush(stdout);

			    /* Console Keyboard */
    n_read = read(ttyfd, p, n_bytes);
    *(p + n_read - 1) = '\0';
    if(debug == TRUE)
	printf("main_command: %s from console\n", p);

    return(TRUE);
}

get_command(p)

char *p;

{
    int n_bytes, n_read, n_ready, got_command;

    n_bytes = 256;

    fflush(stdout);
    got_command = FALSE;

	n_ready = 0;                            /* Console Keyboard */
	(void) ioctl(ttyfd, FIONREAD, &n_ready);
	if (n_ready > 0)
	{
	    n_read = read(ttyfd, p, n_bytes);
	    *(p + n_read - 1) = '\0';
	    if(debug == TRUE)
		printf("get_command: %s from console\n", p);

	    got_command = TRUE;
	}
    return(got_command);
}

com_setup()
{
}

ball_setup()
{
}

ball_reset()
{
}

/************************************************************/
/*                                                          */
/* OPEN_TMP_FILE opens the temporary file                   */
/*                                                          */
/************************************************************/

open_tmp_file()
{
    tmpfd = open("/usr/tmp/skyflux_aed.tmp", O_RDWR | O_CREAT , 0777);
    if (tmpfd < 0)
	perror("error opening skyflux_aed.tmp");
    fchmod(tmpfd, 0777);  /* give everybody full access */
}

/* sunview stuff */
show_frame()
{
}

show_main_frame()
{
}

notify_dispatch()
{
}

joy_setup()
{
}

jf_csrset()
{
}

_jgrabv()
{
}

jfflush()
{
    if (debug)
	printf("dummy jfflush called\n");
}

jf_cpars()
{
}

jf_char()
{
}

j_zoom()
{
    jf_zoom();
}

jf_zoom()
{
}

j_bdmap()
{
    jf_bdmap();
}

jf_bdmap()
{
    printf("dummy jf_bdmap called\n");
}

j_ov_sset()
{
    jf_ov_sset();
}

jf_ov_sset()
{
}

j_ormask()
{
    jf_ormask();
}

jf_ormask()
{
}

j_cltset(startat, len, r, g, b)
int startat, len;
unsigned char *r, *g, *b;
{
    jf_cltset(startat, len, r, g, b, J12file);
}

jf_cltset(startat, len, r, g, b, J12file)
int startat, len;
unsigned char *r, *g, *b;
int J12file;
{
    unsigned char buf[770], *p;
    int i;

    p = buf;
    *p++ = 0x1b;  /* invoke interpreter */
    *p++ = 75;   /* SCT  set color table */
    *p++ = startat;
    *p++ = len;
    for (i=0; i < len; i++)
    {
	*p++ = r[i];
	*p++ = g[i];
	*p++ = b[i];
    }
    *p++ = 1;   /* exit interpreter */
    write(aedfd, buf, 3 * len + 5);
}

ball()
{
}

j_bdepth()
{
    jf_bdepth();
}

jf_bdepth()
{
}

j_depth()
{
    jf_depth();
}

jf_depth()
{
}

j_area(x0,y0,x1,y1)
int x0,y0,x1,y1;
{
    jf_area(x0,y0,x1,y1, J12file);
}

jf_area(x0,y0,x1,y1, J12file)
int x0,y0,x1,y1;
int J12file;
{
    unsigned char buf[4];

    aed_on();
    aed_mov(x0, y0);  /* move to starting location */

    buf[0] = 114;   /* define area of interest */
    buf[1] = ((x1 & 0xf00) >> 4) | ((y1 & 0xf00) >> 8);
    buf[2] = x1 & 0xff;
    buf[3] = y1 & 0xff;
    /*
    write(aedfd, buf, sizeof(buf));
    */
    return((x1 - x0 + 1) * (y1 - y0 + 1));
}

j_wrt_image(inptr, nbr)
int nbr;
char *inptr;
{
    jf_wrt_image(inptr, nbr, J12file);
}

jf_wrt_image(inptr, nbr, J12file)
int nbr;
char *inptr;
int J12file;
{
    unsigned char buf[3];

    aed_on();
    buf[0] = 117;  /* write horizontal scan */
    buf[1] = (nbr & 0xff00) >> 8;
    buf[2] = nbr & 0xff;
    write(aedfd, buf, sizeof(buf));
    write(aedfd, inptr, nbr);
}

jf_get_attr()
{
}

jf_rd_image()
{
}

map()
{
    not_implemented();
}

overlay_setup()
{
}

image_setup()
{
}

zoom_setup()
{
}

background()
{
    not_implemented();
}

change_area()
{
    not_implemented();
}

define_area()
{
    not_implemented();
}

find_range()
{
    not_implemented();
}

flatten()
{
    not_implemented();
}

replicate()
{
    not_implemented();
}

zoom_pan()
{
    not_implemented();
}

draw_outline()
{
}

vector()
{
    not_implemented();
}

examine_area()
{
    not_implemented();
}

scatter_plot()
{
    not_implemented();
}

slice()
{
    not_implemented();
}

screen_dump()
{
    not_implemented();
}

not_implemented()
{
    printf("feature not implemented in AED version\n");
    error();
}


wedge(x_min, y_min, x_max, y_max)
int x_min, y_min, x_max, y_max;
{
    int c, y;

    x_min = 490;
    x_max = 511;
    y_min = 0;
    y_max = 511;
    if (debug)
	printf("wedge: x_min=%d x_max=%d y_min=%d y_max=%d\n",x_min, x_max, y_min, y_max);
    if (wedge_on == FALSE)
    {
	/* make sure interpreter is off */
	aed_on();
	aed_off();
	return;
    }
    aed_on();
    for (y = 0, c = 0; y<= 510; y+=2, c++)
    {
	aed_sec(c);
	aed_mov(x_min,y);
	aed_dfr(x_max, y+1);  /* filed rectangle */
    }
    aed_off();
}

wedgecmd(argc, argv)
int argc;
char *argv[];
{
    int wedge_on_save;

    if (argc == 2)
    {
	if (strncmp(argv[1], "off", 2) == 0)
	    wedge_on = FALSE;
	if (strcmp(argv[1], "on") == 0)
	    wedge_on = TRUE;
	if (strcmp(argv[1], "now") == 0)
	{
	    wedge_on_save = wedge_on;  /* save current mode */
	    wedge_on = TRUE;
	    wedge(465, 0, 485, 511);
	    wedge_on = wedge_on_save;  /* restore current mode */
	}
    }
    else
    {
	printf("wedge is %s\n", wedge_on ? "on" : "off");
	fprintf(session, "wedge is %s\n", wedge_on ? "on" : "off");
    }
}

aed_on()
{
    unsigned char buf[1];

    buf[0] = 0x1b;  /* turn on interpreter */
    write(aedfd, buf, sizeof(buf));
}

aed_off()
{
    unsigned char buf[1];

    buf[0] = 1;  /* turn off interpreter */
    write(aedfd, buf, sizeof(buf));
}

aed_sec(color)
int color;
{
    unsigned char buf[2];

    buf[0] = 67;  /* set current color */
    buf[1] = color;
    write(aedfd, buf, sizeof(buf));
}

xy20(x, y)
int x,y;
{
    unsigned char buf[3];

    buf[0] = ((x & 0xf00) >> 4) | ((y & 0xf00) >> 8);
    buf[1] = x & 0xff;
    buf[2] = y & 0xff;
    write(aedfd, buf, sizeof(buf));
}

aed_mov(x, y)
int x,y;
{
    unsigned char buf[4];

    buf[0] = 81;  /* move */
    buf[1] = ((x & 0xf00) >> 4) | ((y & 0xf00) >> 8);
    buf[2] = x & 0xff;
    buf[3] = y & 0xff;
    write(aedfd, buf, sizeof(buf));
}

aed_dfr(x,y)
int x,y;
{
    unsigned char buf[4];

    buf[0] = 111;  /* draw filled rectangle */
    buf[1] = ((x & 0xf00) >> 4) | ((y & 0xf00) >> 8);
    buf[2] = x & 0xff;
    buf[3] = y & 0xff;
    write(aedfd, buf, sizeof(buf));
}

aed_dva(x,y)
int x,y;
{
    unsigned char buf[4];

    buf[0] = 65;  /* draw vector */
    buf[1] = ((x & 0xf00) >> 4) | ((y & 0xf00) >> 8);
    buf[2] = x & 0xff;
    buf[3] = y & 0xff;
    write(aedfd, buf, sizeof(buf));
}


/******************************************************************/
/*                                                                */
/* PICK                                                           */
/* uses the AED joystick to define a point for flux extraction    */
/*                                                                */
/******************************************************************/
 
int backgnd_flag = FALSE;
double backgnd_level = 0.;

pick(argc, argv) 

int argc;
char **argv;
 
{ 
     char comm[20];
     int status;
     double z, zint; 
     double fluxes[4];
     char s_coord[2][40]; 
     int i, j, x, y, i_coord[2], end_box;
     int area = 1, area2, nint;
     int n_backgnd;
     double backgnd;
     struct img *imgp, *imgp_sav, *find_SC(), *sky_to_image();
     char buff[20], inbuf[20], *coord_str;

     n_backgnd = 0;
     backgnd = 0;

     /* process the coordinates if given */

     if(argc == 3)
          {
	  strcpy(s_coord[0], argv[1]);
	  strcpy(s_coord[1], argv[2]);

	  sky_to_image(s_coord, i_coord);

          IM_to_SC(i_coord);
	  x = i_coord[0];
	  y = i_coord[1];
          }

     if(argc == 4)
          {
          if (getint(argv[1], &area) == FALSE)
	      return;

	  strcpy(s_coord[0], argv[2]);
	  strcpy(s_coord[1], argv[3]);

	  sky_to_image(s_coord, i_coord);

          IM_to_SC(i_coord);
	  x = i_coord[0];
	  y = i_coord[1];
	  }

     if(argc == 2)
          if (getint(argv[1], &area) == FALSE)
	      return;

     if(argc == 1)
          area = 0;

     area = area / 2;

     if(area < 0)
	  area = 0;

     area2 = 2 * area + 1;

     if(area != 0) 
	  {
	  printf("Averaging over a %dx%d box.\n", area2, area2);
	  fprintf(session, "Averaging over a %dx%d box.\n", area2, area2);
	  }

     /* set up the cursor */

     if(argc < 3)   /* if using joystick */
	  {

	  printf("\n   Enter 'e' on console to end\n");
 
          /* Pick the point */ 

          end_box = FALSE;
	    if (debug)
		printf("enabling joystick\n");
	    aed_on();
	    buff[0] = 0x55;  /* enable joystick */
	    write(aedfd, buff, 1);
	    aed_off();
 
          while (FOREVER) 
               { 

               /* joystick */ 
 
               /* Check for command input */       

               status = main_command(comm); 
	       if(debug == TRUE && status == TRUE)
		    printf("\npick: command returned is %s (%d)\n",
		    comm, strlen(comm));

               if (status == TRUE) 
	            { 
		    imgp_sav = NULL;
                    end_box=FALSE;

                    if(comm[0] == '\0' ||
                       comm[0] == 'b'  ||
                       comm[0] == 'p'    )    /* Extract the flux */
			 {
			 if(debug == TRUE)
			      printf("pick: extract the flux\n");

		aed_on();
		buff[0] = 0x6a;  /* read cursor position */
		write(aedfd, buff, 1);
		read(aedfd, &inbuf[0], 1);  /* get answer */
		read(aedfd, &inbuf[1], 1);  /* get answer */
		read(aedfd, &inbuf[2], 1);  /* get answer */
		aed_off();
		x = (inbuf[1] & 0xff) | ((inbuf[0] & 0xf0) << 4);
		y = (inbuf[2] & 0xff) | ((inbuf[0] & 0xf) << 8);
		if (debug)
		    printf("got hex values %x %x %x  x=%d y=%d\n", inbuf[0] & 0xff, inbuf[1] & 0xff, inbuf[2] & 0xff, x, y);


			 zint = 0.;
			 nint = 0;

			 for(i = -area; i <= area; ++i)
			      {
			      for(j = -area; j <= area; ++j)
				   {
				   i_coord[0] = x + i;
				   i_coord[1] = y + j;

				   imgp = find_SC(x + i, y + j);
				   if ((imgp != NULL) && (debug))
				   printf("pixel came from %s\n", imgp->filnam);
				   if (imgp_sav == NULL)
					imgp_sav = imgp;
				   if ((imgp != imgp_sav) && (imgp != NULL))
				   {
					printf("area falls on multiple images\n");
					error();
					if (debug)
					    printf("disabling joystick\n");
					aed_on();
					buff[0] = 0x64;  /* disable joystick */
					write(aedfd, buff, 1);
					aed_off();
					return;  /* abort out of here */
				   }
				   SC_to_IM(i_coord);
				   flux(i_coord, fluxes);
                                   z = fluxes[0] * bscale + b_zero;

				   if(fluxes[0] != (double) blank)
					{
					++nint;
					zint += z;

					++n_backgnd;
					backgnd += z;
					}
                                   }
                              }

                         i_coord[0] = x;
                         i_coord[1] = y;
			 SC_to_IM(i_coord);


                         if(nint == 0) 
			      {
	                      printf("No flux available at indicated location\n");
			      fprintf(session,"\n\nNo flux available at indicated location\n");
			      error();
			      fflush(stdout);
			      }
                         else
			      {
			      zint = zint / nint;
			      coord_str = image_to_sky(i_coord);
	                      printf("%-g %s at %s", zint, bunit, coord_str);
			      fprintf(session, "%-g %s at %s", zint, bunit, coord_str);
			      }


			 if(nint > 1)
			      {
			      printf(" (using %d pixels)\n", nint);
			      fprintf(session, " (using %d pixels)\n", nint);
			      }

			 }

                    else if(comm[0] == 'e')
			 {
		         end_box=TRUE;
			 }
		    
		    else 
			 {
			 error();
			 fflush(stdout);
			 }


                    }

               if(end_box == TRUE) break;
	       }
          } 

     else        /* (argc > 2) */        /* not using joystick */
          {
	  aed_on();
	    buff[0] = 0x64;  /* disable joystick */
	    buff[1] = 0x63;  /* SCC  set cursor attributes */
	    buff[2] = 0xff;
	    buff[3] = 0x00;
	    buff[4] = 0x1e;
	    buff[5] = 0x70;  /* DCA draw cursor */
	    write(aedfd, buff, 6);
	    xy20(x, y);
          zint = 0.;
          nint = 0;

          for(i = -area; i <= area; ++i)
               {
               for(j = -area; j <= area; ++j)
		    {
		    i_coord[0] = x + i;
		    i_coord[1] = y + j;
		    SC_to_IM(i_coord);
		    flux(i_coord, fluxes);
                    z = fluxes[0] * bscale + b_zero;

                    if(fluxes[0] != (double) blank)
                         {
                         ++nint;
	                 zint += z;

			 ++n_backgnd;
			 backgnd += z;
                         }
                    }
               }

          i_coord[0] = x;
          i_coord[1] = y;
	  SC_to_IM(i_coord);


          if(nint == 0) 
	       {
               printf("No flux available at given location\n");
               fprintf(session, "No flux available at given location\n");
	       error();
	       fflush(stdout);
	       }
          else
	       {
	       zint = zint / nint;
	       coord_str = image_to_sky(i_coord);
	       printf("%-g %s at %s", zint, bunit, coord_str);
	       fprintf(session, "%-g %s at %s", zint, bunit, coord_str);
	       }


          if(nint > 1)
	       {
               printf(" (using %d pixels)\n", nint);
               fprintf(session, " (using %d pixels)\n", nint);
	       }

	       while (FOREVER)
	       {
               /* Check for command input */       

               status = main_command(comm); 
	       if(debug == TRUE && status == TRUE)
		    printf("\npick: command returned is %s (%d)\n",
		    comm, strlen(comm));

               if (status == TRUE) 
	       {
		    buff[0] = 0x35;   /* ECU erase cursor */
		    buff[1] = 0x63;   /* SCC set cursor no flash */
		    buff[2] = 0xff;
		    buff[3] = 0xff;
		    buff[4] = 0x00;
		    write(aedfd, buff, 5);
		    break;
	       }
	       }
          }

    if (debug)
	printf("disabling joystick\n");
    aed_on();
    buff[0] = 0x64;  /* disable joystick */
    write(aedfd, buff, 1);
    aed_off();

     if(n_backgnd > 0)
	  backgnd = backgnd / n_backgnd;

     if(debug == TRUE)
	  printf("pick:  background %-g, using %d points\n",
			 backgnd, n_backgnd);

     if(backgnd_flag == TRUE)
	  backgnd_level = backgnd;

} 


hist_cmd(argc, argv)
int argc;
char *argv[];
{
    if (argc == 2)
    {
	if (strncmp(argv[1], "off", 2) == 0)
	    hist_on = FALSE;
	if (strcmp(argv[1], "on") == 0)
	    hist_on = TRUE;
    }
    else
    {
	histogram(tmpfd);
    }
}

histogram(fd)
int fd;
{
    struct hdrstruct thdr;

    if (fd < 0)
    {
	printf("no workfile\n");
	return;
    }

    lseek(fd, 0, 0);
    read(fd,&thdr,sizeof(thdr));
    lseek(fd, thdr.hist_start, 0);
    switch (thdr.tapetype)
    {
    case FITS:
    {
	screenflag = FALSE;
	fitshist(fd, &thdr);
	break;
    }
    case VICAR:
    {
	screenflag = FALSE;
	fitshist(fd, &thdr);
	break;
    }
    case SCREEN:
    {
	screenflag = TRUE;
	fitshist(fd, &thdr);
	break;
    }
    default:
    {
	printf("no histogram available\n");
	break;
    }
    }
}

fitshist(fd, thdrp)
int fd;
struct hdrstruct *thdrp;
{
    int hist[HISTSIZ2+1], histscr[512];
    int i, max, hist_lo, hist_diff, hist_hi, temp;
    register int scrx, scry, hist_right, text_left;
    float xscale;
    double ftemp;
    char *gcvt(), *string, charbuf[30];
    double label_lo, label_hi;
    double label_diff, dbl_i;
    double dy, nice_step();

    read(fd,hist,sizeof(hist));

    hist_right = 435;;
    text_left = hist_right + 10;

    max = 0;
    hist_lo = HISTSIZ2;
    for (i=0; i<HISTSIZ2 ; i++)
    {
	if (hist[i] > 0)
	{
	    if (debug)
		printf("hist[%d]=%d\n", i, hist[i]);
	    hist_hi = i;      /* highest bin in use */
	    if (hist_lo > i)
		hist_lo = i;  /* lowest bin in use */
	}
    }

    if (screenflag)
    {
	hist_lo = 2048;
	hist_hi = 2302;
    }

    hist_diff = hist_hi - hist_lo;
    if (hist_diff == 0)
	hist_diff = 1;

    if (debug)
    {
	printf("hist_hi= %d  hist_lo= %d  hist_diff= %d\n",
				    hist_hi,hist_lo,hist_diff);
    }
    /* now do a rebinning for bins from 0 to 510 */
    for (i=0; i<512; i++)
	histscr[i] = 0;
    if (screenflag)
    {
	for (i=0; i<=254; i++)
	    histscr[2 * i] = hist[i + HISTSIZ];
    }
    else
    {
	for (i=hist_lo; i<=hist_hi; i++)
	{
	    if (hist[i] != 0)
	    {
	    ftemp  = (i - hist_lo) * 510.0 / hist_diff;
	    temp = ftemp;  /* integer part */
	    ftemp = ftemp - temp;  /* fractional part */
	    histscr[temp] += hist[i] -ftemp*hist[i]+0.5;   /* part into  */
							    /* this cell */
	    histscr[temp+1] += ftemp * hist[i]+0.5; /* rest in next cell */
	    if (debug)
	    {
		printf("putting %f into histscr[%d] ", 
					hist[i]-ftemp * hist[i]+0.5, temp);
		printf("and %f into histscr[%d]\n", 
						ftemp * hist[i]+0.5, temp+1);
	    }
	    }
	}
    }
    for (i=0; i<511; i++)
    {
	if (histscr[i] > max)
	    max = histscr[i];
	if ((debug) && (histscr[i] != 0))
	    printf("histscr[%d]= %d\n", i, histscr[i]);
    }
    xscale = 400.0 / max;
    if (debug)
    {
	printf("max in histscr=%d\n",max);
	printf("xscale=%e\n", xscale);
    }

    wedge(hist_right + 30, miny, hist_right + 50, miny + 512);
    aed_sec(255);  /* select white */

    /* now draw the histogram */
	aed_on();
	aed_mov(hist_right, miny);
	aed_dva(hist_right, miny + 512);   /* draw right edge of histogram */
	for (i=0; i<=510; i++) 
	{
	    scrx = hist_right - (histscr[i] * xscale);
	    scry = miny + i;
	    aed_mov(hist_right, scry );
	    aed_dva(scrx     , scry );
	}

    aed_off();
    /* now define the character fonts */

    /* now label the axis */
    label_lo = (hist_lo - HISTSIZ) * thdrp->hist_bin_size;
    label_hi = (hist_hi - HISTSIZ) * thdrp->hist_bin_size;
    if (!screenflag)
    {
	label_lo = label_lo * bscale + b_zero;
	label_hi = label_hi * bscale + b_zero;
    }
    label_diff = label_hi - label_lo;
    dy = label_diff / 20;  /* get about 20 labels */
    /* now find a nice step size for labels */
    dy = nice_step(dy);

    if (debug)
    {
	printf("label_lo= %g  label_hi= %g  label_diff=%g\n", label_lo, label_hi, label_diff);
	printf("dy=%d miny=%d\n", dy, miny);
    }
    aed_on();
    write(aedfd, hist_font, sizeof(hist_font));
    aed_off();
    /* first do from zero up */
    dbl_i = 0;
    while (dbl_i <= label_lo)   /* get past starting point */
	dbl_i = dbl_i + dy;
    while (dbl_i <= label_hi)
    {
	scry = miny + (dbl_i - label_lo) * 510/ label_diff;
	string = gcvt(dbl_i, 2, charbuf);
	if (debug)
	printf("string=%s, textleft=%d  scry=%d\n",string,text_left,scry);

	    aed_on();
	    aed_mov(text_left, scry );
	    aed_off();
	    write(aedfd, string, strlen(string));
	dbl_i = dbl_i + dy;
    }
    /* then do from zero down */
    dbl_i = -dy;
    while (dbl_i >= label_hi)  /* get past starting point */
	dbl_i = dbl_i - dy;
    while (dbl_i >= label_lo)
    {
	scry = miny + (dbl_i - label_lo) * 510/ label_diff;
	string = gcvt(dbl_i, 2, charbuf);
	if (debug)
	printf("string=%s, textleft=%d  scry=%d\n",string,text_left,scry);

	    aed_on();
	    aed_mov(text_left, scry );
	    aed_off();
	    write(aedfd, string, strlen(string));
	dbl_i = dbl_i - dy;
    }
    aed_on();
    write(aedfd, norm_font, sizeof(norm_font));
    aed_off();
}

label(argc, argv) 

int argc;
char **argv;
 
{ 
    double coord[2];
    char s_coord[2][40], text[40];
    int j, x, y;
    int nint;
    int status;
    char comm[20];
    struct img *imgp, *sky_to_image(), *find_SC();
    char buff[20], inbuf[20];
    int got_coord, argstart;
    int i_coord[2], j_coord[2];
    char *coord_str, *image_to_sky();

    got_coord = FALSE;
    argstart = 1;

    if (argc < 2)
    {
	printf("annotate command requires a string\n");
	error();
	return;
    }

    if (argc > 3)
    {
	if (output_coord_sys == SC)
	{
	    if (isint(argv[1]) && isint(argv[2]))
	    {
		got_coord = TRUE;
		argstart = 3;
		x = atoi(argv[1]);
		y = atoi(argv[2]);
	    }
	}
	else
	{
	    /* see if coordinates are present */
	    strcpy(s_coord[0], argv[1]);
	    strcpy(s_coord[1], argv[2]);

	    imgp = sky_to_image(s_coord, j_coord);
	    if (imgp != NULL)
	    {
		/* coords are on an image - must be good */
		got_coord = TRUE;
	    }
	    else
	    {
		/* coords not on an image - but may still be coords */
		if (str_to_coord(s_coord, coord))
		{
		    got_coord = TRUE;
		}
	    }
	    if (got_coord)
	    {
		argstart = 3;
		IM_to_SC(j_coord);
		x = j_coord[0];
		y = j_coord[1];
	    }
	}
    }

    /* get the text string */

    strcpy(text, argv[argstart]);

    if (!got_coord)

    {
	printf("\n   Enter 'e' to end\n");

	/* Pick the point */ 

	if (debug)
	    printf("enabling joystick\n");
	aed_on();
	buff[0] = 0x55;           /* enable joystick */
	write(aedfd, buff, 1);
	aed_off();

	/* Check for command input */       

	status = main_command(comm); 
	if(debug)
	    printf("\nlabel: command returned is %s\n", comm);

	aed_on();
	buff[0] = 0x6a;  /* read cursor position */
	write(aedfd, buff, 1);
	read(aedfd, &inbuf[0], 1);  /* get answer */
	read(aedfd, &inbuf[1], 1);  /* get answer */
	read(aedfd, &inbuf[2], 1);  /* get answer */
	aed_off();
	x = (inbuf[1] & 0xff) | ((inbuf[0] & 0xf0) << 4);
	y = (inbuf[2] & 0xff) | ((inbuf[0] & 0xf) << 8);
	if (debug)
	    printf("got hex values %x %x %x  x=%d y=%d\n", inbuf[0] & 0xff, inbuf[1] & 0xff, inbuf[2] & 0xff, x, y);
    } 

    aed_on();
    buff[0] = 0x64;  /* disable joystick */
    write(aedfd, buff, 1);
    write(aedfd, hist_font, sizeof(hist_font));
    aed_mov(x, y);
    aed_off();
    write(aedfd, text, strlen(text));
    aed_on();
    write(aedfd, norm_font, sizeof(norm_font));
    aed_off();

    /* print out final location */
    imgp = find_SC(x, y);
    i_coord[0] = x;
    i_coord[1] = y;
    SC_to_IM(i_coord);

    coord_str = image_to_sky(i_coord);
    printf("annotate at %s", coord_str);
    fprintf(session, "annotate at %s", coord_str);
} 

 
/* ROUND 
** converts a double precision number to the nearest integer 
*/ 
  
round(x) 
 
double x; 
  
{ 
     if( x - (double) floor(x) < 0.5)
          return(floor(x)); 
     else 
          return(ceil(x)); 
} 
