/*****************************************************/
/********************   TEXT.C   *********************/
/*****************************************************/
/* %W% %E% %U% */

/* generates lines for image HISTORY cards, logging, etc. */

/************** global data **************/
#include "par.h"
#include <stdio.h>

extern struct param_struct Params[MAXPARAMS];
extern int n_params;
extern char language;

extern char V_PAR[];
extern char Par_version[];

extern char Par_Argv0[];

static char Par_date11[12];

par_list(where) 
FILE *where; /* where to send output (usually stdio or stderr */
/* printf all parameters set or required */
{
   struct param_struct *p;
   int param_n;
   int pn;
   char *c, *cc;
   char tmp_chars[200];
   char name_text[80];
   char value_text[80];
   int n;

   char *l;

   /* form the parameter lines */
   for (param_n=0; param_n<n_params; param_n++) {
      p = &Params[param_n];
      for (pn=0; pn < p->actual_entries; pn++) {
         if (p->max_entries <= 1) sprintf(name_text,"%s",p->name);
         else                     sprintf(name_text,"%s.%d",p->name,pn+1);
         l = value_text;
         switch(p->type) {
            case INT: sprintf(l,"%d",*(p->info.in.ptr+pn)); break;
            case FLOAT: sprintf(l,"%G",*(p->info.fl.ptr+pn)); break;
            case DOUBLE: sprintf(l,"%lG",*(p->info.db.ptr+pn)); break;
            case CHAR:
             cc = p->info.ch.ptr+pn*p->info.ch.maxchars;
             if (language == 'f') {
                for(c=cc+p->info.ch.maxchars-1; *c==' '; c--);
                n = c-cc+1;
                strncpy(tmp_chars,cc,n);
                cc = tmp_chars;
                cc[n]='\0'; 
             }
             for(c=cc; (*c) && (*c!=' '); c++);
             if (*c) sprintf(l,"\"%s\"",cc);
             else    sprintf(l,"%s",cc);
             break;
         } /* end switch p->type */
         fprintf(where,"%s = %s\n",name_text,value_text);
      }

      for (; pn < p->min_entries; pn++) {
         if (p->max_entries <= 1) sprintf(name_text,"%s",p->name);
         else                     sprintf(name_text,"%s.%d",p->name,pn);
         fprintf(where,"%s [REQUIRED]\n",name_text,value_text);
      }

      if (pn == 0) {
         fprintf(where,"%s (not entered)\n",p->name);
      }
   } /* end for (param_n= ...  */

   return(0);
}

par_text(text_type,lines,max_lines) 
int text_type; /* 0=history  +1=command for setenv  -1=commnad for print */
char lines[][72];
int max_lines;
{
   struct param_struct *p;
   int param_n;
   int n_lines;
   int need_name;
   int pn;
   char *progname;
   char *c, *cc;
   char *prev_l;
   char cwd[200];
   char tmp_chars[80];
   int line_size;
   int n;

   char *l;

   n_lines = 0;

   /* set line_size */
   if (text_type == 0) line_size = 72;
   else if (text_type == -1) line_size = 68;
   else line_size = 72*max_lines-2;

   /* form the pre-parameter text */
   if (text_type == 0) { /* for HISTORY */
      progname = Par_Argv0; 
      for (c=progname; *c; c++) if (*c=='/') progname = c+1;
      date11(Par_date11);
      if (Par_version[0]) c = Par_version;
      else                c = V_PAR+4;
      sprintf(lines[0],"%s %s (%s) IPAC", progname,Par_date11,c);
      l = 0;
   }

   else if (text_type < 0) { /* for print the command */
      getcwd(cwd, 199);
      date11(Par_date11);
      sprintf(lines[0],"%s %s wd=%s", Par_Argv0,Par_date11,cwd);
      l = 0;
   }

   else {
     sprintf(lines[0],"%s ",Par_Argv0);
     for(l=lines[0]; *l; l++);
   }

   /* form the parameter lines */
   if (text_type) need_name = 0;
   else           need_name = 1;
   for (param_n=0; param_n<n_params; param_n++) {
      p = &Params[param_n];
      for (pn=0; pn < p->entered_entries; pn++) {
         if (l == 0) {
           n_lines ++;
           l = lines[n_lines];
           if (text_type==0) {*l++='*'; *l++=' ';}
         }
         prev_l = l;
         if (need_name) { 
            for(c=p->name; *c; c++) *l++ = *c;
            *l++ = '=';
            need_name = 0;
         }

         switch(p->type) {
            case INT: sprintf(l,"%d",*(p->info.in.ptr+pn)); break;
            case FLOAT: sprintf(l,"%G",*(p->info.fl.ptr+pn)); break;
            case DOUBLE: sprintf(l,"%lG",*(p->info.db.ptr+pn)); break;
            case CHAR:
             cc = p->info.ch.ptr+pn*p->info.ch.maxchars;
             if (language == 'f') {
                for(c=cc+p->info.ch.maxchars-1; *c==' '; c--);
                n = c-cc+1;
                strncpy(tmp_chars,cc,n);
                cc = tmp_chars;
                cc[n]='\0'; 
             }
             /* add quotes if needed */
             for(c=cc; (*c) && (*c!=' '); c++);
             if (*c) sprintf(l,"\"%s\"",cc);
             else    sprintf(l,"%s",cc);
             break;
         } /* end switch p->type */

         /* split the line if needed */
         while(*l++);
         if (l >= lines[n_lines]+line_size) { /* split to next line */
            *(prev_l-1) = '\0';
            if (n_lines > max_lines) return(-2);
            n_lines ++;
            l = lines[n_lines];
            if (text_type==0) {*l++='*'; *l++=' ';}

            strcpy(tmp_chars,prev_l);
            strcpy(l,tmp_chars);
            while(*l++);
         }
         *(l-1) = ' ';
      }
      if (text_type == 0) need_name = 1;
      else if (p->entered_entries < p->max_entries) need_name = 1;
   }
   if (text_type > 0) {*(l -1)= '\n'; *(l)= '\0';}
   else if (l) *(l -1)= '\0';

   return(n_lines+1);
}


/*********************************************/
info_synopsis()
{
   struct param_struct *q;
   char param_string[160];
   int i;
   char *c;
   char *progname;
   int n_lines;

   progname = Par_Argv0;
   for (c=Par_Argv0; *c; c++) if (*c == '/') progname = c+1;
   
   printf("\n%s",progname);
   for(q=Params; q<&Params[n_params]; q++) {
      if (q->deflt != no || q->min_entries==0) printf(" [");
      else                  printf(" ");
      printf("%s",q->name);
      if (q->actual_pointer) {
         i = q->min_entries;
         if (i==0) i=1;
         if (i != q->max_entries) {
            printf("(%d:%d)",i,q->max_entries);
         }
         else if (i>1) printf("(%d)",i);
      }
      if (q->deflt != no || q->min_entries==0) printf("]");
   }
   printf("\n\n");


   for(q=Params; q<&Params[n_params]; q++) {

      printf("%s",q->name);

      switch(q->type) {

         case INT:
          if (q->deflt != no) printf(" <%d>",q->info.in.deflt);
          else if (q->min_entries==0) printf(" <deflt>");
          printf(" integer");
          printf("{%d",q->info.in.min);
          printf(":%d}",q->info.in.max);
          break;

         case FLOAT:
          if (q->deflt != no) printf(" <%G>",q->info.fl.deflt);
          printf(" real");
          printf("{%G",q->info.fl.min);
          printf(":%G}",q->info.fl.max);
          break;

         case DOUBLE:
          if (q->deflt != no) printf(" <%lG>",q->info.db.deflt);
          printf(" double");
          printf("{%lG",q->info.db.min);
          printf(":%lG}",q->info.db.max);
          break;

         case CHAR:
          if (q->deflt != no) printf(" <%s>",q->info.ch.deflt);
          if (language=='c') printf(" string{%d}",q->info.ch.maxchars-1);
          else               printf(" string{%d}",q->info.ch.maxchars);
          break;

      }; /* end switch */

      printf(" %s\n",q->comment);
   } /* end for q */

   printf("\n");
}
