/*******************************************************/
/********************   PARSE.C   **********************/
/*******************************************************/
/* %W% %E% %U% */

#include "par.h"
#include <stdio.h>

extern int n_params;
extern struct param_struct Params[MAXPARAMS];
extern struct param_struct *p;
extern char language;

static int index; /* 0-based  (user sees 1-based) */
            /* -6 for "EXEC",   -5 for z_ override,   -1 for undefined */
static char env_vrbl[80]; /* name of z_ env vrbl to override */

#define MAXERRORS 30
#define LEN_ERR 120
   static int n_errors;
   static char error_messages[MAXERRORS][LEN_ERR];
   static int n_dflt_errors;
   static char dflt_error_array[MAXERRORS][MAXNAMESIZE];

   static char append_text[120] = "";

/**************  set_value  **************/
/* Internal routine called by parser */
/* Sets a value into a parameter array */

static char *
set_value(c)
char c[];
{
   int int_val;
   float float_val;
   double double_val;

   static char message_place[100];

   char tmp_char[200];

   if (index == -5) { /* an override of a z_ environment vrbl */
      env_over(c,"z_abort");
   }

   if (index == -6) { /* an EXEC= */
      if (strcmp("S",c)==0 || strcmp("Q",c)==0) { /* quiet all diags */
         env_over("3","z_abort");
         env_over("4","z_display");
         env_over("4","z_log");
         return(0);
      }
      msg(2,66,"Illegal value for parameter EXEC=");
      return(0);
   }

   if (index < 0) return(0);

   if (*c == '%' && *(c+1)==0) {
      p->actual_entries = index;
      return(0);
   }

   if (index >= p->max_entries) {
      p++;
      append_text[0] = '\0';
      if (p >= Params+n_params) {
      return("  -----  Too many parameters");
}
      index = 0;
   }

   switch(p->type) {
      case INT:
       if(sscanf(c,"%d",&int_val) == 0) {
          sprintf(message_place,"is bad integer synatax [%s]",p->name);
          return(message_place);
       }
       if(int_val < p->info.in.min) {
          int_val = p->info.in.min;
          sprintf(message_place,"is less than %d [%s]",int_val,p->name);
          return(message_place);
          }
       if(int_val > p->info.in.max) {
          int_val = p->info.in.max;
          sprintf(message_place,"is more than %d [%s]",int_val,p->name);
          return(message_place);
          }
       *(p->info.in.ptr+index) = int_val;
       break;
      case FLOAT:
       if(sscanf(c,"%f",&float_val) == 0) {
          sprintf(message_place,"is bad floating synatax [%s]",p->name);
          return(message_place);
       }
       if(float_val < p->info.fl.min) {
          float_val = p->info.fl.min;
          sprintf(message_place,"is less than %f [%s]",float_val,p->name);
          return(message_place);
       }
       if(float_val > p->info.fl.max) {
          float_val = p->info.fl.max;
          sprintf(message_place,"is more than %f [%s]",float_val,p->name);
          return(message_place);
       }
       *(p->info.fl.ptr+index) = float_val;
       break;
      case DOUBLE:
       if(sscanf(c,"%lf",&double_val) == 0) {
          sprintf(message_place,"is bad floating synatax [%s]",p->name);
          return(message_place);
       }
       if(double_val < p->info.db.min) {
          double_val = p->info.db.min;
          sprintf(message_place,"is less than %lf [%s]",double_val,p->name);
          return(message_place);
       }
       if(double_val > p->info.db.max) {
          double_val = p->info.db.max;
          sprintf(message_place,"is more than %lf [%s]",double_val,p->name);
          return(message_place);
       }
       *(p->info.db.ptr+index) = double_val;
       break;
      case CHAR:
       if (*c == ',') {
          strcpy(append_text,c);
          if (*(c+1) == '\0') append_text[0] = '\0';
          index--; 
       }
       else {
          strcpy(tmp_char,c);
          strcat(tmp_char,append_text);
          charncpy(p->info.ch.ptr+(index*p->info.ch.maxchars),tmp_char,
                 p->info.ch.maxchars,language);
       }
       break;
   }; /* end switch */

   index ++;
   if(index > p->actual_entries) p->actual_entries = index;

   return(0);

}



/**************  set_name  **************/
/* Internal routine called by parser */
/* looks up the name and sets that parameter as the active one */

static char *
set_name(string)
char string[];
{
   char base_name[20];
   char *s, *n;

   static char message_place[100];

   append_text[0] = '\0';

   for (s=string, n=base_name; *s && *s != '.'; s++, n++) *n = *s;
   *n = '\0';

   if (lookup_name(base_name)) {
      if (strncmp("z_",base_name,2)==0) { /*see if override of z_ variable */
         strcpy(env_vrbl,base_name);
         index = -5;
         return(0);
      }
      if (strcmp("EXEC",base_name)==0) { /*see if special parameter "EXEC" */
         index = -6;
         return(0);
      }
      index = -1;
      return("is not a known parameter name");
   }

   if (*s == '.') {

      if (*(s+1)) {
         index = -1;
         sscanf(s+1,"%d",&index);
         index --;
         if (index < 0) return("has an illegal index (after the decimal)");
      }
      else index = p->actual_entries;

   }
   else index = 0;

   if (index >= p->max_entries) {
      sprintf(message_place,"has an index more than %d [%s]",
       p->max_entries,p->name);
      return(message_place);
   }

   if (index > p->actual_entries) {
      sprintf(message_place,"index skipped over %d [%s]",
       p->actual_entries-1,p->name);
      return(message_place);
   }

   return(0);
}



/* subroutine to fill in parameters with their default values */

static put_in_defaults()
{
   struct param_struct *next_p;
   int i;

   next_p = 0;
   n_dflt_errors = 0;
   for (p=Params; p<&Params[n_params]; p++) {
      p->entered_entries = p->actual_entries;
      while (p->actual_entries < p->min_entries) {
         if(p->deflt == no) {
            if (next_p == 0) next_p = p;
            if (n_dflt_errors < MAXERRORS) {
               if (p->min_entries<=1)
                strcpy(dflt_error_array[n_dflt_errors],p->name);
               else sprintf(dflt_error_array[n_dflt_errors],"%s.%d",
                p->name,p->min_entries);
               n_dflt_errors ++;
            }
            break;
         }
         switch(p->type) {
            case INT:
              *(p->info.in.ptr+p->actual_entries) = p->info.in.deflt;
             break;
            case FLOAT:
              *(p->info.fl.ptr+p->actual_entries) = p->info.fl.deflt;
             break;
            case DOUBLE:
              *(p->info.db.ptr+p->actual_entries) = p->info.db.deflt;
             break;
            case CHAR:
              charncpy(p->info.ch.ptr+(p->actual_entries*p->info.ch.maxchars),
                     p->info.ch.deflt,p->info.ch.maxchars,language);
             break;
         } /* end if( )  switch */
         p->actual_entries++;
      } /* end while actual<min */
      if (p->actual_pointer) *p->actual_pointer = p->actual_entries;
   } /* end for */

   return;
}


/**************  do_parse  **************/

do_parse(argc,argv)
/* return:  0=OK  -1=quit  2=warnings  3=errors */
int argc;
char *argv[];

{

/* "=" is a delimeter unless the argv contains a space */ 
#define MAXTOKENS 2000

   int arg;
   char *err_msg;
   char *a;
   char *c;

   int n_tokens;
   char *tokens[MAXTOKENS];
   char token_flag[MAXTOKENS]; /* '='=name  '\0'=string */

   int i, n;

   int no_blanks;

   if (argc == -1) { /* just printout the errors */
      for (i=0; i<n_errors; i++) 
       fprintf(stderr,"** %s\n",error_messages[i]);
      return(0);
   }

   if (argc == -2) { /* just printout the errors */
      for (i=0; i<n_errors; i++) msg(2,0,error_messages[i]);
      for (i=0; i<n_dflt_errors; i++)
       msg1(3,0,"Must set parameter %s",dflt_error_array[i]);
      return(0);
   }

   c = argv[1];
   if (argc == 2) switch (c[0]) { /* process special values */
      case 'p': /* "par"  "pars"  "params"  "parameters" */
       if ( (strcmp(c+1,"ar")==0) 
         || (strcmp(c+1,"ars")==0) 
         || (strcmp(c+1,"arams")==0) 
         || (strcmp(c+1,"arameters")==0) ) { 
          info_synopsis();
          return(-1);
       }
       break;
   } /* end switch(c[0]) */

   n_tokens = 0;
   n_errors = 0;

   for (arg=1; arg<argc; arg++) {

      /* check on overflow of token area */
      if (n_tokens > MAXTOKENS-4) {
         fprintf(stderr,"TOO MANY PARAMETERS ON COMMAND LINE\n");
         return(-1);
      }

      tokens[n_tokens] = argv[arg];
      token_flag[n_tokens] = '\0';

      /* break up if has = sign */
      no_blanks = 1;
      for (a=argv[arg]; *a; a++)  {
         if (*a == ' ') no_blanks = 0;
         else if (  (*a=='=')  && (no_blanks) &&  (*(a+1)!=' ')  ) {
            if (tokens[n_tokens] == a) n_tokens --;
            if (n_tokens >= 0) token_flag[n_tokens] = '=';

            *a = '\0';

            n_tokens ++;
            tokens[n_tokens] = a+1;
            token_flag[n_tokens] = '\0';
         }
      } /* end for(a= ... */

      if (*tokens[n_tokens]) n_tokens ++;

   } /* end for(arg=  . ...  */

   /* get the info into the Parse structure */
   p = Params;
   index = 0;
   for (arg=0; arg<n_tokens; arg++) {
 
      if (token_flag[arg]) {
         err_msg = set_name(tokens[arg]);
      }
      else {
         err_msg = set_value(tokens[arg]);
      }
      if (err_msg) {
         sprintf(error_messages[n_errors],"%s %s",tokens[arg],err_msg);
         n_errors ++;
      }
   }

   put_in_defaults();

   if (n_dflt_errors) {
      return(3);
   }
   else if (n_errors) return(2);
   else               return(0);
}

