/* FORTRAN BINDING TO PARAM SUBROUTINES */
/* %W% %E% %U% */

extern char language;

/**************  pari_  **************/
void pari_(ptr,string,string_len)
 int *ptr;
 char *string;
 long int string_len;
{
   char param_string[400];
   int stat;

   strncpy(param_string,string,string_len);
   param_string[string_len] = '\0';

   stat = par_i(ptr,param_string);
   return;
}

/**************  parr_  **************/
void parr_(ptr,string,string_len)
 float *ptr;
 char *string;
 long int string_len;
{
   char param_string[400];
   int stat;

   strncpy(param_string,string,string_len);
   param_string[string_len] = '\0';

   stat = par_r(ptr,param_string);
   return;
}

/**************  pard_  **************/
void pard_(ptr,string,string_len)
 double *ptr;
 char *string;
 long int string_len;
{
   char param_string[400];
   int stat;

   strncpy(param_string,string,string_len);
   param_string[string_len] = '\0';

   stat = par_d(ptr,param_string);
   return;
}

/**************  parc_  **************/
void parc_(ptr,string,ptr_len,string_len)
 char *ptr;
 char *string;
 long int ptr_len;
 long int string_len;
{
   char size_text[8];
   char *s;
   char param_string[400];
   char *p;
   int i;
   int stat;

   sprintf(size_text,"[%d]",ptr_len);
   p = param_string; 
   for (i=0; i<string_len; i++) {
      if (string[i] == ',') break;
      *p++ = string[i];
   }
   for (s=size_text; *s; s++) *p++ = *s; 
   for (; i<string_len; i++) *p++ = string[i];
   *p = '\0';
   
   language = 'f';
   stat = par_c(ptr,param_string);
   return;
}

/**************  parf_  **************/
parf_(ptr,string,ptr_len,string_len)
 char *ptr;
 char *string;
 long int ptr_len;
 long int string_len;
{
   char param_string[400];
   int stat;

   strncpy(param_string,string,string_len);
   param_string[string_len] = '\0';

   language = 'f';
   stat = par_f(ptr,param_string);
   return;
}

/**************  para_  **************/
void para_(ptr,string,string_len)
 int *ptr;
 char *string;
 long int string_len;
{
   char param_string[400];
   int stat;

   strncpy(param_string,string,string_len);
   param_string[string_len] = '\0';

   stat = par_a(ptr,param_string);
   return;
}



/**************  parg_  **************/
float parg_()
{
#define MAXARGV 100
#define ARGVSIZE 100
   int argc;
   char pars[MAXARGV][ARGVSIZE];
   char *argv[MAXARGV];
   int i;
   int stat;
   char *c;

   argc = iargc_() + 1;
   if (argc>MAXARGV)
      msg1(3,3,"PAR - Too many parameters in command line. (max=%d)",MAXARGV);

   for (i=0; i<argc; i++) {
      getarg_(&i,pars[i],ARGVSIZE);
      for (c = &pars[i][ARGVSIZE-1]; *c==' '; c--);
      *(c+1) = '\0'; 
      argv[i] = pars[i];
   }

   language = 'f';

   stat = par_g(argc,argv);
   return(stat);
}
