/*****************  PARAM.H  ******************/
/* %W% %E% %U% */

/* define default min,max values */
#define MININT  -32768
#define MAXINT   32767
#define MAXFLOAT -1.7E38
#define MINFLOAT  1.7E38
#define MAXDOUBLE -1.7E38
#define MINDOUBLE  1.7E38

/* define maximunm sizes for everything */
#define MAXPARAMS 200
#define MAXNAMESIZE 16
#define MAXFIELDS 5
#define MAXCHARDEFLT 64
#define MAXCOMMENT 80
#define MAXPARAMSTRING 256
#define FILENAMESIZE 64

/* define structure which holds all parameter info */
struct param_struct {
   enum {INT, FLOAT, DOUBLE, CHAR} type;
   char name[MAXNAMESIZE];
   int actual_entries; /* number of entries counting defaulted ones */
   int entered_entries; /* actual number of entries from parameter string */
   int *actual_pointer; /* value of actual_entries in application prog */
   int max_entries;
   int min_entries;
   enum {yes, no} deflt;
   union {
      struct { int *ptr; int deflt; int min; int max; } in;
      struct { float *ptr; float deflt; float min; float max; } fl;
      struct { double *ptr; double deflt; double min; double max; } db;
      struct { char *ptr; char deflt[MAXCHARDEFLT]; int maxchars; } ch;
   } info;
   char comment[MAXCOMMENT];
};
