/****************************************************/
/********************   PAR.C   *********************/
/****************************************************/

/************** global data **************/
#include <stdio.h>
#include "par.h"

char V_PAR[] = "@(#)par.a %I% %E%";

struct param_struct Params[MAXPARAMS];
struct param_struct *p;
int n_params;
char Par_Argv0[80] = "";
char Par_version[80] = "";

char *split_fields[MAXFIELDS];

char language = 'c'; /* 'c' or 'f'ortran for handling of character strings */

static int z_display = 0;

#define MAXERRORS 20



/**************  par_i  ***************/
/* External subroutine to define an integer parameter */

par_i(ptr,string)
 int *ptr;
 char *string;
{
   int tmp;

   split(string,MAXFIELDS,split_fields);

   if (new_name(split_fields[0])) return(-1);
   if (ptr == 0) return(error("#Data pointer not set",p->name));

   p->type = INT;
   p->info.in.ptr = ptr;

   /* save default value */
   if (*split_fields[1]) {
      p->deflt = yes;
      sscanf(split_fields[1],"%d",&p->info.in.deflt);
   }

   /* save min/max values */
   if (*split_fields[2]) sscanf(split_fields[2],"%d",&p->info.in.max);
   else p->info.in.max = MAXINT;
   if (*split_fields[3]) sscanf(split_fields[3],"%d",&p->info.in.min);
   else p->info.in.min = MININT;
   /* swap min/max if reversed */
   if(p->info.in.min > p->info.in.max) {
      tmp = p->info.in.min;
      p->info.in.min = p->info.in.max;
      p->info.in.max = tmp;
   }

   strncpy(p->comment,split_fields[4],MAXCOMMENT);

   n_params++;
   return(0);
}


/**************  par_r  ***************/
/* External subroutine to define a floating parameter */

par_r(ptr,string)
 float *ptr;
 char *string;
{
   float tmp;

   split(string,MAXFIELDS,split_fields);

   if (new_name(split_fields[0])) return(-1);
   if (ptr == 0) return(error("#Data pointer not set",p->name));

   p->type = FLOAT;
   p->info.fl.ptr = ptr;

   /* save default value */
   if (*split_fields[1]) {
      p->deflt = yes;
      sscanf(split_fields[1],"%f",&p->info.fl.deflt);
   }

   /* save min/max values */
   if (*split_fields[2]) sscanf(split_fields[2],"%f",&p->info.fl.max);
   else p->info.fl.max = MAXFLOAT;
   if (*split_fields[3]) sscanf(split_fields[3],"%f",&p->info.fl.min);
   else p->info.fl.min = MINFLOAT;
   /* swap min/max if reversed */
   if(p->info.fl.min > p->info.fl.max) {
      tmp = p->info.fl.min;
      p->info.fl.min = p->info.fl.max;
      p->info.fl.max = tmp;
   }

   strncpy(p->comment,split_fields[4],MAXCOMMENT);

   n_params++;
   return(0);
}


/**************  par_d  ***************/
/* External subroutine to define a double parameter */

par_d(ptr,string)
 double *ptr;
 char *string;
{
   double tmp;

   split(string,MAXFIELDS,split_fields);

   if (new_name(split_fields[0])) return(-1);
   if (ptr == 0) return(error("#Data pointer not set",p->name));

   p->type = DOUBLE;
   p->info.db.ptr = ptr;

   /* save default */
   if (*split_fields[1]) {
      p->deflt = yes;
      sscanf(split_fields[1],"%lf",&p->info.db.deflt);
   }

   /* save min/max values */
   if (*split_fields[2]) sscanf(split_fields[2],"%lf",&p->info.db.max);
   else p->info.db.max = MAXDOUBLE;
   if (*split_fields[3]) sscanf(split_fields[3],"%lf",&p->info.db.min);
   else p->info.db.min = MINDOUBLE;
   /* swap min/max if reversed */
   if(p->info.db.min > p->info.db.max) {
      tmp = p->info.db.min;
      p->info.db.min = p->info.db.max;
      p->info.db.max = tmp;
   }

   strncpy(p->comment,split_fields[4],MAXCOMMENT);

   n_params++;
   return(0);
}


/**************  par_c  ***************/
/* External subroutine to define a character string parameter */

par_c(ptr,string)
 char *ptr;
 char *string;
{
   char *c;

   split(string,MAXFIELDS-2,split_fields);

   /* set name and maxchars (string size) */
   for (c=split_fields[0]; *c != '['; c++) {
    if (*c=='\0') return(error
              ("#String length not specified  (e.g. str[8])",split_fields[0])); 
   }
   *c = '\0';

   if (new_name(split_fields[0])) return(-1);
   sscanf(c+1,"%d",&p->info.ch.maxchars);
   if (ptr == 0) return(error("#Data pointer not set",p->name));

   p->type = CHAR;
   p->info.ch.ptr = ptr;

   /* save default string */
   if (*split_fields[1]) {
      p->deflt = yes;
      strncpy(p->info.ch.deflt,split_fields[1],MAXCHARDEFLT);
      p->info.ch.deflt[MAXCHARDEFLT-1] = '\0';
   }

   strncpy(p->comment,split_fields[2],MAXCOMMENT);

   n_params++;
   return(0);
}

/**************  par_f  ***************/
/* External subroutine to define a filename parameter */

par_f(ptr,string)
 char *ptr;
 char *string;
{
   char *c;

   split(string,MAXFIELDS,split_fields);

   for (c=split_fields[0]; *c != '\0'; c++)
    if (*c == '[') return(error
      ("#Do not specify length of filename (FILENAMESIZE)"));

   if (new_name(split_fields[0])) return(-1);
   if (ptr == 0) return(error("#Data pointer not set",p->name));

   p->type = CHAR;
   p->info.ch.ptr = ptr;

   /* save default string */
   if (*split_fields[1]) {
      p->deflt = yes;
      strncpy(p->info.ch.deflt,split_fields[1],MAXCHARDEFLT);
      p->info.ch.deflt[MAXCHARDEFLT-1] = '\0';
   }

   /* set maxchars (string size) */
   p->info.ch.maxchars = FILENAMESIZE;

   strncpy(p->comment,split_fields[2],MAXCOMMENT);

   n_params++;
   return(0);
}

/**************  par_a  **************/
/* External subroutine to declare a parameter to be an array */

par_a(ptr,string)
int *ptr;
char *string;
{
   int tmp;

   split(string,MAXFIELDS,split_fields);

   if (lookup_name(split_fields[0]))
    return(error("#Name not defined for ARRAY",split_fields[0]));
   if (ptr == 0) return(error("#Array count pointer not set",p->name));

   p->actual_pointer = ptr;

   /* set min/max values */
   if(*split_fields[1]) sscanf(split_fields[1],"%d",&p->max_entries);
   else error("Array size not given",p->name);
   if(*split_fields[2]) sscanf(split_fields[2],"%d",&p->min_entries);
   /* swap min/max if reversed */
   if(p->min_entries > p->max_entries) {
      tmp = p->min_entries;
      p->min_entries = p->max_entries;
      p->max_entries = tmp;
   }
   if(p->max_entries < 1) {
      error("Size of array must be at least 1",p->name);
      p->max_entries = 1;
   }
   if(p->min_entries < 0) {
      error("Minimum entries for array must be at least 0",p->name);
      p->min_entries = 0;
   }

   return(0);

}




/**************  par_g  **************/
/* External subroutine which causes filling in of parameters 
    by calling parse_params */

par_g(argc,argv)
int argc;
char *argv[];
{
#define MAXTEXTLINES 20
   int i;
   int stat;
   char *a,*c;

   int n_text_lines;
   char text_lines[MAXTEXTLINES][72];

   char zlast_name[32];
   FILE *zlast_file;

   /* insure version text is loaded */
   c = V_PAR;

   /* save argv[0] */
   strcpy(Par_Argv0,argv[0]);

   /* parse the parameters */
   stat = do_parse(argc,argv); /* parse command line arguments */

   if (stat <0) return(-1);

   /* turn off log file if errors and the display is on */
   if (stat) {
      env_i(&z_display,"z_display");
      if (z_display <= 3) env_over("4","z_log");
   }

   /* if display is on */
   if (z_display <= 3) {

   /* save command in ~/.zlast 
     n_text_lines = par_text(1,text_lines,MAXTEXTLINES-2); 
      env_c(zlast_name,"HOME");
      strcat(zlast_name,"/.zlast");
      zlast_file = fopen(zlast_name,"w");
      fputs(text_lines,zlast_file);
      fclose(zlast_file);
   */

      if (stat) {
         do_parse(-1,0); /* print out error mesages */
         par_list(stderr);
         fprintf(stderr,"parameter errors\n");
         return(-1);
      }
   }

   /* if display is off */

   /* log/display the start message */
   n_text_lines = par_text(-1,text_lines,MAXTEXTLINES-2); 
   msg(911,0,text_lines[0]);
   for (i=1; i<n_text_lines; i++) msg(912,0,text_lines[i]);

   /* log/display error messages */
   if (stat) {
      do_parse(-2,0); /* print out error mesages */
      msg(stat,1,"Parameter Errors");
   }

   return(0);
}




/**************  par_vers  **************/
/* External subroutine used to set version ID (put in HISTORY cards, etc.) */

par_vers(string)
char *string;
{
   strncpy(Par_version,string,39);
   Par_version[39] = '\0';
   return(0);
}



/*************  lookup_name  **************/
/* Looks for the name c in the parameters table and sets p if found*/
/* if not found, returns -1 (sets p to &Params[n_params-1]) */

lookup_name(c)
char c[];
{
   upper_case(c); /* convert to all upper case */

   for (p=Params; p<&Params[n_params]; p++) {
      if (strncmp(p->name,c,MAXNAMESIZE) == 0) return(0);
   }

   p = &Params[n_params-1];
   return(-1);
}

/*************  new_name  **************/
/* adds the name c to the parameters table and sets p */
/* checks for errors; return = -1 if error  =0 if OK */

new_name(c)
char c[];
{
   upper_case(c); /* convert to all upper case */

   if (n_params > MAXPARAMS-1)
      return(error("#Too many parameters declared",c));

   if (c[0] == '\0') 
      return(error("#Parameter name must be specified",c));

   if (lookup_name(c) == 0) 
    return(error("Duplicate parameter name",c));

   if (strlen(c) > MAXNAMESIZE) 
      return(error("#Parameter name is too long",c));
            

   p = &Params[n_params];
   strncpy(p->name,c,MAXNAMESIZE);
   p->deflt = no;
   p->min_entries = p->max_entries = 1;
   p->actual_entries = 0;
   p->actual_pointer = (int *) 0;
   
   return(0);
}

/**************  upper_case  **************/
static upper_case(c) char *c;
{ for(;*c;c++) if(*c>='a' && *c<='z') *c += 'A'-'a'; }


/**************  error  **************/
/* Prints the error message and returns a value of -1;
   also sets param_goodness to 0 if the 1st character is '#' */

static error(message,detail)
char message[];
char detail[];
{
   if (detail[0] != '\0') fprintf(stderr,"\n%s: %s\n",message,detail);
   else                   fprintf(stderr,"\n%s\n",message);

   return(-1);
}


/**************  split  **************/
/* break up string at commas, and put into fields */

static split(string,maxfields,fields)
char *string;
int maxfields;
char *fields[];
{
   char *ptr;
   int i;

   i = 1;
   fields[0] = string;
   for (ptr=string; *ptr; ptr++) if (*ptr == ',') {
      if (i < maxfields) {
         *ptr = '\0';
         fields[i] = ptr+1;
         i++;
      }
   }
   for (;i<maxfields;i++) fields[i] = ptr; /* set the rest to null stings */
   return(0);

}


/**************  charncpy  **************/
/* Just like strncpy, except does blank filling if in fortran mode */

charncpy(out,in,n,language)
char *out;
char *in;
int n;
char language; /* 'c' or 'f'ortran */
{
   int i;

   /* copy in "c" mode */
   if (language == 'c') {
      strncpy(out,in,n);
      if (out[n-1]) {
         out[n-1] = '\0';
         error("Character string too long (truncated)",out);
      }
   }

   /* copy in Fortran mode */
   else {
      for (i=0;i<n;i++) {
         if (in[i]) out[i] = in[i];
         else break;
      }
      for (;i<n;i++) out[i] = ' ';
   }
} 
