/******* msg *******/
/* %W% %E% %U% */

#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <pwd.h>

extern char Par_Argv0[];

static struct timeval start_time;
static struct timeval end_time;
static struct timezone zone;

static int z_abort = 0; /* (needs to be set ) */
static int z_log = 4; /* no logging */
static int z_display = 0; /* display all messages */
static char z_logfile[64] = "";
static FILE *logfile_ptr = 0;

static char text[200];
static int do_display;
static int do_log;

/*     --------------------------
      911 = Start of task
      912 = Parmaeters for a task
      711 = Normal End of task
        3 = FATAL errors
        2 = errors
        1 = warnings
        0 = informational messages
       <0 for debug messagess
         (use 4 for never display or log)
       --------------------------     */



/****************************************/
static char *set_up_msg(level)
int level;
{

   char *text_ptr;
   char *s;

   /* read in environment variables if needed */
   if (z_abort == 0) {
      z_abort = 2;
      env_i(&z_abort,"z_abort");
      if (z_abort > 3) z_abort = 3;
      if (z_abort <= 0) z_abort = 1;

      env_i(&z_display,"z_display");

      env_i(&z_log,"z_log");

      env_c(z_logfile,"z_logfile");
      if (z_logfile[0] == 0) {
         env_c(z_logfile,"HOME");
         strcat(z_logfile,"/zlog");
      }
         

      if (z_display == -255) {
         fprintf(stderr,"z_abort = %d\n",z_abort);
         fprintf(stderr,"z_log = %d\n",z_log);
         fprintf(stderr,"z_display = %d\n",z_display);
         fprintf(stderr,"z_logfile = %s\n",z_logfile);
      }
   } /* end if z_abort==0

   /* figgure out what to output */
   do_display = 0;
   do_log     = 0;

   if (level >= z_abort) {
      if (z_display <= 3) do_display = 1;
      if (z_log     <= 3) do_log     = 1;
   }

   else if (level >= 0) {
      if (level >= z_display) do_display = 1;
      if (level >= z_log    ) do_log     = 1;
   }

   else {
      if (level == z_display) do_display = 1;
      if (level == z_log    ) do_log     = 1;
   }

   if ( (do_display | do_log) ==0) return(0);

   if (do_log) {
      if (logfile_ptr == 0) { /* open logfile if needed */
         logfile_ptr = fopen(z_logfile,"a");
         if (logfile_ptr == NULL) {
            fprintf(stderr,"Cannot open z_logfile: {%s}\n",z_logfile); 
            do_log = 0;
         }
      }
   }

   if (level == 911) gettimeofday(&start_time,&zone);

   if    (level ==911) s = "START";
   else if(level==912) s = "PARAM";
   else if(level==711) s = "END  ";
   else if (level >=3) s = "FATAL";
   else if (level ==2) s = "ERROR";
   else if (level ==1) s = "WARN ";
   else if (level ==0) s = "INFO ";
   else                s = "DEBUG";

   sprintf(text,"%5.5d %s ",getpid()%100000, s);

   return(text+12);
}


/************************************************************************/
static format_timing_info(ptr)
char *ptr;
{
   int stat;
   char datetime[12];
   int wall_sec;
   int cpu_sec, cpu_usec;
#ifdef NOTDEF
   struct rusage used;
#endif /* NOTDEF */

   date11(datetime);

   gettimeofday(&end_time,&zone);
   wall_sec = end_time.tv_sec - start_time.tv_sec;
   stat = end_time.tv_usec - start_time.tv_usec;
   if (stat > 500000) wall_sec ++;
   else if (stat < -500000) wall_sec --;

#ifdef NOTDEF
   getrusage(RUSAGE_SELF,&used);
   cpu_sec = used.ru_utime.tv_sec + used.ru_stime.tv_sec;
   cpu_usec = used.ru_utime.tv_usec + used.ru_stime.tv_usec;
   if (cpu_usec > 1000000) {
      cpu_sec ++;
      cpu_usec -= 1000000;
   }

   sprintf(ptr,"%s %s   %d sec   %d.%02d cpu-sec   %d Kb max real",
    Par_Argv0,datetime,wall_sec,cpu_sec,cpu_usec/10000,used.ru_maxrss);
#endif /* NOTDEF */
   sprintf(ptr,"%s %s   %d sec   %d.%02d cpu-sec   %d Kb max real",
    Par_Argv0,datetime,wall_sec, 0, 0, 0);
}


/************************************************************************/
static put_out_msg(level,exit_status)
int level;
int exit_status;
{
  char datetime[12];

   strcat(text+8,"\n");

   if (do_display) fputs(text,stderr);
   if (do_log) fputs(text,logfile_ptr);

   if (level >= z_abort) {
      if (exit_status) {
         strcpy(text+6,"ABORT ");
         format_timing_info(text+12);
         strcat(text+12,"\n");
         if (do_display) fputs(text,stderr);
         if (do_log) fputs(text,logfile_ptr);
         exit(exit_status);
      }
      else return(1);
   }

   return(0);
}


/************************************************************************/
msg(level,exit_status,message)
int level;
int exit_status;
char message[];
{
   char *text_ptr;
   int stat;

   text_ptr = set_up_msg(level);
   if (text_ptr == 0) return(0);

   if (level == 711) {
      exit_status = 0;
      format_timing_info(text+12);
   }
   else strcpy(text_ptr,message);

   stat = put_out_msg(level,exit_status);
   return(stat);

}

/************************************************************************/
msg1(level,exit_status,format,v1)
int level;
int exit_status;
char format[];
char *v1;
{
   char *text_ptr;
   int stat;

   text_ptr = set_up_msg(level);
   if (text_ptr == 0) return(0);

   sprintf(text_ptr,format,v1);
   stat = put_out_msg(level,exit_status);
   return(stat);

}


/************************************************************************/
msg2(level,exit_status,format,v1,v2)
int level;
int exit_status;
char format[];
char *v1, *v2;
{
   char *text_ptr;
   int stat;

   text_ptr = set_up_msg(level);
   if (text_ptr == 0) return(0);

   sprintf(text_ptr,format,v1,v2);
   stat = put_out_msg(level,exit_status);
   return(stat);

}


/************************************************************************/
msg3(level,exit_status,format,v1,v2,v3)
int level;
int exit_status;
char format[];
char *v1, *v2, *v3;
{
   char *text_ptr;
   int stat;

   text_ptr = set_up_msg(level);
   if (text_ptr == 0) return(0);

   sprintf(text_ptr,format,v1,v2,v3);
   stat = put_out_msg(level,exit_status);
   return(stat);

}


/************************************************************************/
msg4(level,exit_status,format,v1,v2,v3,v4)
int level;
int exit_status;
char format[];
char *v1, *v2, *v3, *v4;
{
   char *text_ptr;
   int stat;

   text_ptr = set_up_msg(level);
   if (text_ptr == 0) return(0);

   sprintf(text_ptr,format,v1,v2,v3,v4);
   stat = put_out_msg(level,exit_status);
   return(stat);

}


/************************************************************************/
msg5(level,exit_status,format,v1,v2,v3,v4,v5)
int level;
int exit_status;
char format[];
char *v1, *v2, *v3, *v4, *v5;
{
   char *text_ptr;
   int stat;

   text_ptr = set_up_msg(level);
   if (text_ptr == 0) return(0);

   sprintf(text_ptr,format,v1,v2,v3,v4,v5);
   stat = put_out_msg(level,exit_status);
   return(stat);

}
