/******* env_c & env_i *******/
/* %W% %E% %U% */

/*  (reads environment variable, if exists: updates at user's pointer)  */

#define MAX_OVERRIDES 20
#define MAX_O_NAME_SIZE 20
#define MAX_O_VAL_SIZE 20

static char o_names[MAX_OVERRIDES][MAX_O_NAME_SIZE];
static char  o_vals[MAX_OVERRIDES][MAX_O_VAL_SIZE];
static int n_overrides = 0;


/*___________________________________________________________________*/
void env_over(pointer,name)
char *pointer;
char name[];
/* sets override of environment variable */
{
   int i;

   if (strlen(name) > MAX_O_NAME_SIZE-1) {
      msg2(2,0,"%s = %s",name,pointer);
      msg1(2,1,"Environment overide name too long. (max:%d)",MAX_O_NAME_SIZE-1);
   }
   if (strlen(pointer) > MAX_O_VAL_SIZE-1) {
      msg2(2,0,"%s = %s",name,pointer);
      msg1(2,1,"Environment overide value too long.(max:%d)",MAX_O_VAL_SIZE-1);
   }

   /* check if already in override table */
   for (i=0; i<n_overrides; i++) 
    if (strcmp(o_names,name) == 0) {
      strcpy(o_vals[i],pointer);
      return;
   }

   if (n_overrides >= MAX_OVERRIDES)  {
      msg2(2,0,"%s = %s",name,pointer);
      msg1(2,1,"Too many environment overides. (max:%d)",MAX_OVERRIDES);
   }

   strcpy(o_names[n_overrides],name);
   strcpy(o_vals[n_overrides],pointer);
   n_overrides ++;

   return;
}


/*___________________________________________________________________*/
void env_c(pointer,name)
char *pointer;
char name[];
{
   int i;
   char *env_ptr;
   char *getenv();

   /* check if in override table */
   for (i=0; i<n_overrides; i++) 
    if (strcmp(o_names[i],name) == 0) {
      strcpy(pointer,o_vals[i]);
      return;
   }

   /* check in UNIX environment */
   env_ptr = getenv(name);
   if (env_ptr) strcpy(pointer,env_ptr);

   return;
}


/*___________________________________________________________________*/
void env_i(pointer,name)
int *pointer;
char name[];
{
   char char_val[24];

   char_val[0] = '\0';
   env_c(char_val,name);

   if (char_val[0]) sscanf(char_val,"%d",pointer);
}
