#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include "coord.h"
#if defined(USE_STDLIB)
#include <stdlib.h>
#endif
/*
 *    
 *   ssfplate [-v] RA1950 DEC1950 [band [HCON]]
 *          find the Super SkyFlux plates on which a given position appears
 *          Mark the "best plate" (with position furthest from an edge) with
 *          a caret (>)
 *          Calls  sbstpn.c
 *
 *  $Header: /imaging/config/dev/src/issa/src/RCS/ssfplate.c,v 3.1 1993/05/11 00:51:48 rick Rel $
 *  Wed May  5 16:20:36 PDT 1883
 *  Rick Ebert <rick@ipac.caltech.edu>
 *  Updates for the phase II release of ISSA.  Change this routine to call
 *  bstcmdd(), whichcoadd(), whichhcon() (new cd look-up routines).  Change
 *  the name of the executable to be (in usage()) issaffld to fit the 8.3
 *  format demanded by the part of ISO 9660 the CD's will use and for MSDOS
 *  purposes.
 *
 *  Mon Apr  1 17:37:12 PST 1991
 *  Rick Ebert <rick@ipac.caltech.edu>
 *  California Institute of Technology
 *
 *  Wed Aug  7 10:46:40 PDT 1991  Rick Ebert <rick@ipac.caltech.edu>
 *  Added "Done" field in output to indicate which plates are included
 *  in 1991 release.
 *
 *  Wed Aug 28 10:51:31 PDT 1991  <rick@ipac.caltech.edu>
 *  Convert to use C version of sbstpn.c
 *
 *  Thu Aug 29 18:47:18 PDT 1991  <rick@ipac.caltech.edu>
 *  Add use of coordinate conversion routines with -c flag
 *
 *  Mon Sep 30 14:40:51 PDT 1991  <rick@ipac.caltech.edu>
 *  Make use of Coord conversion the default ( -c turns it *off*)
 *  Replace the "Done" Field with a "ISSA 1991 Release CDROM Number"
 *    field.  This field to only have an entry if the Field is in
 *    the release.  The field entry will give the CD number containing
 *    the requested ISSA plate/field.
 *    Oh yes, note that SSF has changed to ISSA - so SSF plates have
 *    become ISSA Fields.
 *
 *  Wed Oct  2 14:24:31 PDT 1991 <rick@ipac.caltech.edu>
 *  eliminate use of sprintf in arguments of functions (old versions of
 *  C stdlib have sprintf return int instead of (char *)). Oh well...
 *  
 *  Thu Oct  3 14:02:57 PDT 1991 <rick@ipac.caltech.edu>
 *  Fix handling of argv[1] a number beginning with '-' .
 *  Add VMS conditionals  STATOK exit inhibits VMS error messages on completion:
 *  VMS 1 is OK, 0 is error; UNIX 0 is ok, 1 is error (argh!)
 *  Add extern definition of atof() for VMS compiles (in coord.h)
 *  since VMS setup doesn't declare it in math.h (old UNIX bug too).
 *  Add version/origin information at the tail end of usage() output.
 *
 *  Tue Oct 29 18:47:01 PST 1996 <booth>
 *  Add -b option
 */
static char *Version = "3.0 (May 5, 1993)";

#define minimum(a,b)  (a<b)?a:b
#define DEFEPOCH     1950.0  /* Besselian Equinox for default */
#ifdef VMS
#define STATOK 1
#else
#define STATOK 0
#endif

int usage(char *s);

int main(argc, argv)
int argc;
char *argv[];
{
     int ndx;
     char **pargs;
     int bflag, iflag, vflag, cflag, pargc;
     int eqflag;
     int showflag;
     int in_csystem;

     double rad, decd, deams[10], prads[10], pdecds[10], pixely[10], pixelz[10];
     int   ipcnt, ipndx, plates[10];
     int   band, hcon;
     int   hcd;
     int reject, north;
     char  *cp;
     char  coaddcd[15];
     char  hconcd[15];
     char  cklat[81], cklon[81];

     struct COORD c_in, c_out;


     if(argc < 3 || argc > 8) usage(argv[0]); /* never returns */
     pargs = argv;
     pargc = argc;
     pargs++;
     pargc--;
     vflag=1;  /* set default */
     cflag=1;
     bflag = 0;
     iflag=0;
     eqflag=0;

     cp = *pargs;
     if ( *cp == '-' && ! isdigit(*(cp+1)) && *(cp+1) != '.') {
	    while (*++cp != '\0')
	    switch (*cp){

		case 'v':
			vflag = 0;
                        break;
                case 'c':
			cflag = 0;
			break;
                case 'b':
			bflag = 1;
			break;
		default:
			usage(argv[0]); /* never returns */
            }

        /* used up one more arg */
         pargs++;
         pargc--;
     }

     band = 1;  hcon = 0;  /* some sensible defaults */

     if (cflag == 1){
       if (pargc < 3 || pargc > 6) usage(argv[0]);
       strncpy(cklon, *pargs++, 80); pargc--; cklon[80] = '\0';
       strncpy(cklat, *pargs++, 80); pargc--; cklat[80] = '\0';
       strncpy(c_in.csys, *pargs++, 80); pargc--;
       if (strlen(c_in.csys)<2 || (in_csystem = syscode(c_in.csys))== FALSE){
	  fprintf(stderr,"Coordinate System %s is unknown: check usage.\n\n",
	      c_in.csys);
	  usage(argv[0]);
       }
       if (in_csystem == EQU){
	 if(pargc>0){
          c_in.epoch = atof(*pargs++); pargc--;
          if ( c_in.epoch < 1500.0 || c_in.epoch > 2500.0 ){
	     fprintf (stderr,
	        "Equinox %g out of acceptable range (1500 < e < 2500)\n",
	        c_in.epoch);
             exit(-1);
          }
         } else
	  c_in.epoch = DEFEPOCH;

	 eqflag=1;
       }

       if(check_coord(cklon, c_in.clon, 80, 1) == JUNK){
	  fprintf(stderr,"Error: Don't understand %s\n", cklon);
          exit(-1);
	  }
       if(check_coord(cklat, c_in.clat, 80, 0) == JUNK){
	  fprintf(stderr,"Error: Don't understand %s\n", cklat);
          exit(-1);
	  }

       strcpy(c_out.csys, "equatorial");
       c_out.epoch = 1950.0 ;

       if (cconv(&c_in, &c_out)){
	  fprintf(stderr,"Coordinate Conversion error: check usage.\n\n");
	  usage(argv[0]);
       }
	   
       rad = c_out.lon ;
       decd = c_out.lat ;

     } else {
     rad = atof(*pargs++); pargc--;
     decd = atof(*pargs++); pargc--;
     } /* end of else */

     showflag = 0;
     /* pick up last 2 args band and hcon if there */
     if(pargc > 0){ band = atoi(*pargs++); pargc--; showflag = 1;}
     if(band<1 || band > 4) usage(argv[0]); /* never returns */
     if(pargc > 0){ hcon = atoi(*pargs++); pargc--; }
     if(hcon<0 || hcon > 3) usage(argv[0]); /* never returns */
     
     for(ndx=0;ndx<10;ndx++){  /* zero out everything */
        deams[ndx]= prads[ndx]= pdecds[ndx]= pixely[ndx]= pixelz[ndx]= 0.0;
	plates[ndx] = 0;
     }
#ifdef DEBUG     
     printf("sbstpn test driver, input: rad = %g , decd = %g\n", rad, decd);
#endif
     bstcmdd(rad, decd, &ipcnt, &ipndx, plates,
	      pixely, pixelz, deams, prads, pdecds);

     if (vflag && !bflag){
       if (cflag){
          fprintf(stdout,"\n");
	  fprintf(stdout," Input Coordinates:\n");
	  fprintf(stdout,"  %s   %s   (%s", c_in.clon, c_in.clat, c_in.csys);
	  if (eqflag) fprintf(stdout," %.2lf", c_in.epoch);
          fprintf(stdout,")\n");
	  fprintf(stdout,"  %s   %s   (%s %.2lf)\n",
	           c_out.clon, c_out.clat, c_out.csys, c_out.epoch);
          fprintf(stdout,"  %lf(deg)  %lf(deg)\n", c_out.lon, c_out.lat);
       }

       fprintf(stdout,"\n\n");
       fprintf(stdout ,
	 " R\n");
       fprintf(stdout ,
	 " e\n");
       fprintf(stdout ,
	 " j\n");
       fprintf(stdout ,
	 " e B\n");
       fprintf(stdout ,
	 " c e        Nearest                  ISSA Disk#\n");
       fprintf(stdout ,
	 " t s Field   Edge    Field Center   Coadd  Coadd\n");
       fprintf(stdout ,
	 " ? t Number (arcmin)  RA     DEC     only  & HCON ");
       if (showflag) fprintf(stdout , "   File\n");
       else fprintf(stdout ,"\n");
       fprintf(stdout ,
	 " =================================================");
       if (showflag) fprintf(stdout ,"===============\n");
       else fprintf(stdout ,"\n");
       ndx=0;
       while(plates[ndx]>0 && ndx < 10){
	     sprintf(coaddcd,"   %d ",whichcoadd(plates[ndx]));
	     sprintf(hconcd,"  %d    ",hcd = whichhcon(plates[ndx]));
        fprintf(stdout," %c %c %4d  %6.1f   %6.1f %6.1f  %s  %s",
          (hcd<2||isreject(hcd))?'R':' ', ipndx==(ndx+1)?'>':' ',
           plates[ndx], deams[ndx], prads[ndx], pdecds[ndx], coaddcd, hconcd);
        if(showflag)
   	   fprintf(stdout,"   i%03db%1dh%1d.fit", plates[ndx], band, hcon);
        fprintf(stdout,"\n");
        ndx++;
       }
       fprintf(stdout,"\n");
     }
     else if (bflag)
     {
       hcd =  whichhcon(plates[ipndx-1]);
       reject= (hcd<2||isreject(hcd))?1:0;
       north = whichcoadd(plates[ipndx-1]);
       fprintf(stdout,"i%03db%1dh%1d.fit %d %d\n", plates[ipndx-1], band, hcon,
	   reject, north);
     }
     else
       fprintf(stdout,"i%03db%1dh%1d.fit", plates[ipndx-1], band, hcon);

     fflush(stdout);
     return(STATOK);
}

int usage(s)
char *s;
{
       extern char cd_date[];

       fprintf(stderr,
	       "Usage: %s [-v] Long  Lat  Coord  [Equinox [Band [HCON]]]\n",
	       "issaffld");
       fprintf(stderr,
	       "   or: %s -c[v|b] RA(degrees)  Dec(degrees) [Band [HCON]]\n\n",
	       "issaffld");
       fprintf(stderr,
               "   -v turns off verbose output (default is on) and\n");
       fprintf(stderr,
               "      returns only the filename for the best plate\n");
       fprintf(stderr,
               "   -b turns off verbose output and returns the filename for\n");
       fprintf(stderr,
               "      the best plate, followed by the reject flag and the north flag\n");
       fprintf(stderr,
	       "   -c bypasses the use of the coordinate calculator\n");
       fprintf(stderr,
	       "      so that RA and DEC inputs are interpreted as decimal\n");
       fprintf(stderr,
	       "      degrees in B1950 coordinates.\n\n");
       fprintf(stderr,
               "      Inputs Long, Lat and Coord specify the Longitude,\n");
       fprintf(stderr,
               "      Latitude, and Coordinate System (first 2 characters,\n");
       fprintf(stderr,
	       "      upper or lower case) of the desired position.\n");
       fprintf(stderr,
               "      Coordinate Systems are:\n\n");
       fprintf(stderr, "           Equatorial     (eq)\n");
       fprintf(stderr, "           Ecliptic       (ec)\n");
       fprintf(stderr, "           Galactic       (ga)\n");
       fprintf(stderr, "           Supergalactic  (su)\n\n");
       fprintf(stderr,
               "      If the Coordinate System is Equatorial the fourth\n");
       fprintf(stderr,
               "      argument, if present, is expected to be the equinox.\n");
       fprintf(stderr,
               "      Band (optional) is the IRAS band number (1,2,3,4).\n");
       fprintf(stderr,
               "      HCON (optional) is the IRAS HCON (0 for coadd,1,2,3).\n");
       fprintf(stderr,
               "      Sexagesimal notation maybe used (without the -c option).\n\n");
       fprintf(stderr,
          "      Coordinates may be specified:\n");
       fprintf(stderr,
	  "         nnHnnMnn.nS    nnDnnMnn.nS\n");
       fprintf(stderr,
	  "         nnH nnM nn.nS  nnD nnM nn.nS\n");
       fprintf(stderr,
          "         nn:nn:nn.n\n");
       fprintf(stderr,
	  "         nnnnn.nS        (for decimal arc seconds)\n");
       fprintf(stderr,
	  "         nnnnn.nnn       (for decimal degrees)\n");
       fprintf(stderr,
               "\n    EXAMPLES:\n");
       fprintf(stderr,
	  "         issaffld 7 45 eq\n");
       fprintf(stderr,
	  "         issaffld 00h30m01.8s 45d10m12.0s Equ\n");
       fprintf(stderr,
	  "         issaffld 00h27m19.7s 44d53m37.8s Equ 2000\n");
       fprintf(stderr,
	  "         issaffld 00d28m00.0s 63d59m28.0s Ecliptic\n");
       fprintf(stderr,
	  "         issaffld 00d28m00.0s 63d59m28.0s ec 4 3\n");
       fprintf(stderr,
	  "         issaffld 128d45m40.5s -37d22m28.1s ga 3\n\n");
       fprintf(stderr,
	  " Output\n");
       fprintf(stderr,
	  " Column:       Description:\n\n");
       fprintf(stderr,
      " Reject?       -Contains 'R' if the field was rejected in processing\n");
       fprintf(stderr,
      " Best          -Field with largest target to edge distance has '>'\n"); 
       fprintf(stderr,
	  " Field Number  -ISSA Field number (1<=Fn<=430)\n");
       fprintf(stderr,
	  " Nearest Edge  -Distance to edge from target position (arc minutes)\n"); 
       fprintf(stderr,
	  " Field Center  -Decimal RA/Dec (B1950) at the center of field\n");
       fprintf(stderr,
	  " ISSA Disk#    -CDROM numbers on which this field is located\n");
       fprintf(stderr,
	  "                Disks 0 and 1 contain only coadded images\n");
       fprintf(stderr,
	  "                  (Reject plates are in separate subdirectory\n");
       fprintf(stderr,
	  "                   on disks 0 and 1.\n");
       fprintf(stderr,
	  "                Disks 2-9  contain coadded and HCON images\n");
       fprintf(stderr,
	  "                Disks 7-9  contain rejected coadd and HCON images\n");
       fprintf(stderr,
	  " File          -If a particular IRAS Band or HCON was specified\n");
       fprintf(stderr,
	  "                   this field will be present giving the image\n");
       fprintf(stderr,
	  "                   file name:\n");
       fprintf(stderr,
	  "                     iFFFbBhH.fit (FFF-field#, B-Band, H-HCON )\n");


       fprintf(stderr,
	  "\n   Authors: Rick Ebert, J. White & Xiuqin Wu\n");
       fprintf(stderr,
        "            Infrared Processing and Analysis Center\n");
       fprintf(stderr,
        "            (c) 1991,1993 California Institute of Technology\n");
       fprintf(stderr,
	  "   Revision Number: %s\n", Version);
       fprintf(stderr,
	  "   %s\n", cd_date);
       
       exit(STATOK);
}
