/* 
 * Wed May  5 15:26:19 PDT 1993
 *    Fortran to C port: R. Ebert  <rick@ipac.caltech.edu>
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *   5-05-93 remove CRDD plate scheme support and change name to bstcmdd()<rick>
 *   3-04-91 Remove TapeNumber lookup from this routine (rick ebert)
 *   3-01-91 Split pxlno into 2 1-D arrays for C compatibility (rick ebert)
 *   8-30-89 remove debug stmnt: "write (6,303)"
 *   8-29-89 fix bug introducted by subrtn vrsn...wrong p# selected as best
 *   6-22-89 install platap subr....new CRDD tape #s
 *   approx 6 89 create a subroutine version of bestpn
 *   11-02-88 version of bestpn
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *
 */

/*
 * All rights reserved. 1991,1993
 * California Institute of Technology
 *
 *  $Header: /imaging/config/dev/src/issa/src/RCS/sbstpn.c,v 2.1 1993/05/06 19:38:43 rick Rel $
 */

#ifdef DEBUG
#include <stdio.h>
#endif
#include <math.h>
#if defined(USE_STDLIB)
#include <stdlib.h>
#endif
#define RTD   57.29577951   /* 180/PI */

int rd2ve(double rar, double decr, double *xe, double *ye, double *ze);
int s2pcmdd(double lon, double lat, double lon0, double lat0, 
    double *line, double *sample);
int genpc();

/*
      subroutine sbstpn
     +    (rad,decd,iptype,ipcnt,ipndx,pltnos,pxlnoy,pxlnoz,
     +     deams,pcras, pcdecs)
            in  in   in    out     out      out   out    out
            out   out    out
 
     All arrays are 10 elements deep.
     rad, decd input equatorial 1950 coordinates
 */
double vepc[3][430], radpc[430], decdpc[430];
static int genpc_done = 0;

int bstcmdd(rad,decd,ipcnt,ipndx,pltnos,pxlnoy,pxlnoz,deams,pcras,pcdecs)
double rad, decd;
int *ipcnt, *ipndx, pltnos[];
double pxlnoy[], pxlnoz[];
double deams[], pcras[], pcdecs[];
{

     /*    initialize  */
      int    ipnmax;
      double demax = 0.;
      double     dpr = RTD ;
      double     rar, decr, decpd, deam, rapd;
      double     de;
      double	 sy1, sz1;

      int ipn;
      int ic;

      double sxe, sye, sze, dot;
      double lon0, lat0, line, sample, dl, ds, theta;

     /* init counts */
#ifdef DEBUG
fprintf(stderr,"bstcmdd() args rad=%g, decd=%g \n",
	rad, decd);
#endif
      ic = 0;
      *ipndx=1;

     /*    cmdd plate init  */
      ipnmax=430 ;
      theta=9.1 ;

/*    convert point position to radians  */
      rar=rad/dpr ;
      decr=decd/dpr ;
#ifdef DEBUG
 fprintf(stderr,"rad = %g, decd = %g, rar = %g, dedr = %g\n",
	 rad, decd, rar, decr);
#endif
      rd2ve (rar, decr, &sxe, &sye, &sze);

#ifdef DEBUG
    fprintf (stderr, "rd2ve in %g %g returns %g %g %g\n",
                               rar,decr,sxe,sye,sze );
#endif

/*
 *    compute all plate centers and store in common (vectors&ra,dec)
 *    generate plate center positions (and vectors)
 */
      if(genpc_done == 0){
         genpc();
         genpc_done++;
      }

      for (ipn=0; ipn<ipnmax; ipn++){

/* is the source within theta dist of this plate's center?  */
/*   dot the plate center against the source                */

     dot=sxe*vepc[0][ipn] + sye*vepc[1][ipn] + sze*vepc[2][ipn];
#ifdef DEBUG2
   fprintf(stderr,"dot is %g\n", dot  );
#endif
      if (fabs(acos(dot)) > theta/dpr ) continue;

/*     is the source inside the plate?  */
/*     select the desired plate scheme   transformation */

     /* CMDD selected */

/*     sky to plate transformation for cmdd plates follows  */
      rapd=radpc[ipn];
      decpd=decdpc[ipn];
      lon0=radpc[ipn]/dpr;
      lat0=decdpc[ipn]/dpr;
      s2pcmdd (rar, decr, lon0, lat0, &line, &sample);

/*      now insure the source is inside the plate  */

      if (!((line >= -249.) && (line <= 250.) &&
               (sample >= -249.) && (sample <= 250.))) continue; /* next ipn */

/*     find distance to nearest edge along line axis and sample axis */
      dl=250.0-fabs(line);
      ds=250.0-fabs(sample);
/*     find distance to nearest edge */
      de=dl;
      if (ds < dl) de=ds;
/*     convert dist to nearest edge to arcmins */
      deam=de*1.5;

/*     equate sy1 and sz1 to allow use of previous crdd plate code */

      sy1=line;
      sz1=sample;

/*  save the candidate plate #s ,tape #'s & pxls in arrays  */
/* 200   continue */

      pltnos[ic]=ipn+1;
      pxlnoy[ic]=sy1;
      pxlnoz[ic]=sz1;
      deams[ic]=deam;
      pcras[ic]=rapd;
      pcdecs[ic]=decpd;
      ic++;

      if (deam > demax) {
        demax=deam ;
        *ipndx=ic ;
      }
      }  /* end for(ipn) */
      /*  500   continue  */
      *ipcnt = ic;
      return (0);
}

/*
 *  rd2ve:: convert rar,decr to to vector in the e system
 *
 *  rar, decr supplied inputs
 *  xe,ye,ze  vector components upon return.
 */

int rd2ve(rar,decr,xe,ye,ze)
double rar, decr;
double *xe,*ye,*ze;
{

   double cosa, cosd, sina;

   cosd= cos(decr);
   cosa= cos(rar);
   sina= sin(rar);
   *xe= sin(decr);
   *ye= -cosd*sina;
   *ze=cosd*cosa;
   return (0);
}

/* 
 **********************************************************************

      subroutine genpc(ptype)
 
 
      generate plate  center vectors in equatorial
         store vectors in common vepc array
 **********************************************************************
 */
int genpc()
{
      double xe, ye, ze;
      double decd, decr, rar, latdlt;
      int    ilcmax;
      int ipn, ipnmax, bw, inb;

      int ilc, j;
      int *iw, *ic;
      double ram;

  /* extern float vepc, radpc, decdpc ; but in this module */

      double rpmin = 0.0043633231249;
      double rpd   = 0.01745329253e0;
      double dpr   = RTD ;

/* following array is bin size in minutes at different lat bands */

/* CMDD plate scheme array (ISSA) */
      static int ibwsf[19] = {1440,180,104,76,60,52,46,42,40,40,40,42,
         46,52,60,76, 104,180,1440};
      static int ibcsf[19] = {1, 8, 14,19,24,28,32,35,36,36,36,35,32,28,24,19,
          14,  8,   1};

     /* init for cmdd plates  */
          ipnmax=430;
          ilcmax=19;
          latdlt=10. ;
	  iw = ibwsf;
	  ic = ibcsf;

/*        ipn=0 ;   */
/* 30     continue  */

       decd= -90. ;
       for (ilc=0, ipn=0; ilc<ilcmax && ipn<ipnmax; ilc++){
                                                /* latitude loop */
       ram=0. ;
       bw= *(iw+ilc) ;
       inb= *(ic+ilc);
       for (j=0; j<inb ; j++, ipn++){ /*  longitude loop for this lat */
       rar=ram*rpmin;
       decr=decd*rpd;
/*     save center co-ords */
       radpc[ipn]=rar*dpr ;
       decdpc[ipn]=decd ;
/*     convert ra,dec to vectors  */
       rd2ve( rar,decr, &xe, &ye, &ze);
       vepc[0][ipn]=xe;
       vepc[1][ipn]=ye;
       vepc[2][ipn]=ze;
/*       ipn++;  */
       ram=ram+bw;
       } /*  above is 360 deg longitude loop end range  */

/*       if (ipn < ipnmax) */ /*       if (ipn >= ipnmax) break;*/
       decd=decd+latdlt;
       
       }
       return (0);
}


/*
      s2pcmdd: sky to plate transformation for cmdd plates
      subroutine  s2pcmdd (lon,lat,lon0,lat0,line,sample)
                            in  in  in   in   out   out
                            r   r   r    r    r     r

          lon,lat       lon,lat of desired position in radians
          lon0, lat0    lon,lat of center of plate in radians
          line, sample  pixel numbers of input position

 */
int s2pcmdd(lon,lat,lon0,lat0,line,sample)
double lon,lat,lon0,lat0,*line,*sample;
{
      double r2d, a, f, ff;

      r2d= RTD ;
      a=cos(lat)*cos(lon0-lon);
      ff=sin(lat0)*sin(lat)+a*cos(lat0);
      if(ff == 0.) ff=1.e-34 ;
      f=40.*r2d/ff;
      *sample=f*cos(lat)*sin(lon0-lon);
      *line= -f*(cos(lat0)*sin(lat)-a*sin(lat0));
      return(0);
}
