/*
 * isonline.c :: there is no routine with this name.
 *               this module now contains routines for finding which
 *               CD's in the complete ISSA set contain a given field
 *               number.  The optional test routine at the end shows
 *               the self consistency check.
 *
 *  $Header: /imaging/config/dev/src/issa/src/RCS/isonline.c,v 2.2 1993/05/05 23:35:07 rick Rel $
 *  Wed May  5 14:41:56 PDT 1993
 *  Rick Ebert <rick@ipac.caltech.edu>
 */

char cd_date[]= "CDROM Manifest: ISSA 1993 Release";

/* look_up.c : find a number in an ordered list
 *            return 1 if the supplied number is in the list,
 *                   0 if it is not.
 *            n - the number to search for
 *            l - a pointer to the list of integers, the list
 *            s - the length of the list - number of integers
 *
 *         The list must be in ascending order - lower values
 *         first l[0] increasing to highest at l[s-1]
 *
 *  Fri Apr 30 17:14:58 PDT 1993
 *  Rick Ebert <rick@ipac.caltech.edu>
 *  California Institute of Technology
 *  Copyright 1993 California Institute of Technology
 */

int look_up(n,l,s)
int n, *l, s;
{
  
    int bottom = 0;
    int top    = s;
    int mid;
    while (top-bottom > 1){
      mid = (top+bottom)>>1;
    if(n>=l[mid])
      bottom = mid;
    else
      top=mid;
    }

    if(l[bottom] == n ) return(1);
    else return(0);

}

/*
 *  ISSA - Phase II release disk inventory
 *
 *  Phase I was released in September 1991.  Disks 2,3,4 of the ISSA
 *  come from the Phase I release.  Disk 1 of the Phase I release is
 *  made obsolete by the Phase II release disks  ,1.
 *
 *  The complete ISSA is composed of disks 2,3,4 from the 1991 release,
 *  and seven new disks (0,1,5,6,7,8,9).
 *
 *  This file contains an inventory of which fields appear on which disks.
 *  Disks  ,1 contain only the coadded data for *all* fields.  Disks 2-9
 *  contain data for individual HCONs (see the IRAS or ISSA explanatory
 *  supplement for a description of 'Hours CONfirmation') and another copy
 *  of the coadd field.
 *
 *  Disk0 : Phase II southern sky Coadds (Allsky, includes Phase I plates)
 *  Disk1 : Phase II northern sky Coadds (Allsky, includes Phase I plates)
 *  Disk2 : Phase I  HCON data + Coadds
 *  Disk3 : Phase I  HCON data + Coadds
 *  Disk4 : Phase I  HCON data + Coadds
 *  Disk5 : Phase II HCON data + Coadds southern sky
 *  Disk6 : Phase II HCON data + Coadds northern sky
 *  Disk7 : Phase II HCON + Coadd Reject fields
 *  Disk8 : Phase II HCON + Coadd Reject fields
 *  Disk9 : Phase II HCON + Coadd Reject fields
 *  
 *  Rick Ebert, (C) 1993, California Institute of Technology
 *  Infrared Processing and Analysis Center (IPAC)
 *
 */

/*  CDROM1 == DISK0  */
int disk0[] = {
  1,   2,   3,   4,   5,   6,   7,   8,   9,  10,
 11,  12,  13,  14,  15,  16,  17,  18,  19,  20,
 21,  22,  23,  24,  25,  26,  27,  28,  29,  30,
 31,  32,  33,  34,  35,  36,  37,  38,  39,  40,
 41,  42,  43,  44,  45,  46,  47,  48,  49,  50,
 51,  52,  53,  54,  55,  56,  57,  58,  59,  60,
 61,  62,  63,  64,  65,  66,  67,  68,  69,  70,
 71,  72,  73,  74,  75,  76,  77,  78,  79,  80,
 81,  82,  83,  84,  85,  86,  87,  88,  89,  90,
 91,  92,  93,  94,  95,  96,  97,  98,  99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
111, 112, 113, 114, 115, 116, 117, 118, 119, 120,
121, 122, 123, 124, 125, 126, 127, 128, 129, 130,
131, 132, 133, 134, 135, 136, 137, 138, 139, 140,
141, 142, 143, 144, 145, 146, 147, 148, 149, 150,
151, 152, 153, 154, 155, 156, 157, 158, 159, 160,
161, 162, 163, 164, 165, 166, 167, 168, 169, 170,
171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190,
191, 192, 193, 194, 195, 196, 197
};

/* CDROM2 == DISK1 */
int disk1[] = {
198, 199, 200,
201, 202, 203, 204, 205, 206, 207, 208, 209, 210,
211, 212, 213, 214, 215, 216, 217, 218, 219, 220,
221, 222, 223, 224, 225, 226, 227, 228, 229, 230,
231, 232, 233, 234, 235, 236, 237, 238, 239, 240,
241, 242, 243, 244, 245, 246, 247, 248, 249, 250,
251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270,
271, 272, 273, 274, 275, 276, 277, 278, 279, 280,
281, 282, 283, 284, 285, 286, 287, 288, 289, 290,
291, 292, 293, 294, 295, 296, 297, 298, 299, 300,
301, 302, 303, 304, 305, 306, 307, 308, 309, 310,
311, 312, 313, 314, 315, 316, 317, 318, 319, 320,
321, 322, 323, 324, 325, 326, 327, 328, 329, 330,
331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350,
351, 352, 353, 354, 355, 356, 357, 358, 359, 360,
361, 362, 363, 364, 365, 366, 367, 368, 369, 370,
371, 372, 373, 374, 375, 376, 377, 378, 379, 380,
381, 382, 383, 384, 385, 386, 387, 388, 389, 390,
391, 392, 393, 394, 395, 396, 397, 398, 399, 400,
401, 402, 403, 404, 405, 406, 407, 408, 409, 410,
411, 412, 413, 414, 415, 416, 417, 418, 419, 420,
421, 422, 423, 424, 425, 426, 427, 428, 429, 430
};

/* DISK2 from Phase I */
int disk2[] = {
  1,   2,   3,   4,   5,   6,   7,   8,   9,  10,
 11,  12,  13,  14,  15,  16,  17,  18,  19,  20,
 21,  22,  23,  24,  25,  26,  27,  28,  29,  30,
 31,  32,  33,  34,  35,  36,
 41,  42,  43,  44,  45,  46,  47,  48,  49,  50,
 51,  52,  53,  54,  55,
 68,  69,
 70,  71
};

/* DISK3 from Phase I */
int disk3[] = {
 72,  73,  74,  75,  76,  77,  78,  79,  80,
 98,  99, 100,
101, 102, 103, 104, 105, 106, 107,
133, 134, 135, 136, 137, 138,
293, 294, 295, 296, 297, 298,
324, 325, 326, 327, 328, 329,
330, 331, 332, 333,
352, 353, 354, 355, 356, 357, 358, 359,
360, 361, 362, 363
};

/* DISK4 from Phase I */
int disk4[] = {
364, 365, 366,
376, 377, 378, 379,
380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
390, 391, 396, 397, 398, 399,
400, 401, 402, 403, 404, 405, 406, 407, 408, 409,
410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
420, 421, 422, 423, 424, 425, 426, 427, 428, 429,
430
};

/* CDROM3 == DISK5 */
int disk5[] = {
 37,  38,  39,
 40,
 56,  57,  58,  59,
 60,  61,  62,  63,  64,  65,  66,  67,
 81,  82,  83,  84,
 91,  92,  93,  94,  95,  96,  97,
108, 109,
110, 111,
125, 126, 128, 129,
130, 131, 132, 139,
140, 141, 142, 143,
166, 167, 168, 169,
170, 171, 172, 173, 174, 175, 176
};

/* CDROM4 == DISK6 */
int disk6[] = {
205, 206, 207, 208, 209,
223, 224, 225, 226, 227,
256, 257, 258, 259,
260, 261, 262, 263, 264, 265, 266, 267,
289,
290, 291, 292, 299,
300, 301, 302, 303, 305, 306,
320, 321, 322, 323,
334, 335, 336, 337, 338, 339,
340, 341, 347, 348, 349,
350, 351,
367, 368, 369,
370, 371, 372, 373, 374, 375,
392, 393, 394, 395
};

/* CDROM5 == DISK7 */
int disk7[] = {
 85,  86,  87,  88,  89,
 90,
112, 113, 114, 115, 116, 117, 118, 119,
120, 121, 122, 123, 124, 127,
144, 145, 146, 147, 148, 149,
150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161
};

/* CDROM6 == DISK8 */
int disk8[] = {
162, 163, 164, 165,
177, 178, 179,
180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
190, 191, 192, 193, 194, 195, 196, 197, 198, 199,
200, 201, 202, 203, 204,
210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
220, 221, 222, 228, 229,
230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
250, 251, 252, 253, 254, 255,
268, 269
};

/* CDROM7 == DISK9 */
int disk9[] = {
270, 271, 272, 273, 274, 275, 276, 277, 278, 279,
280, 281, 282, 283, 284, 285, 286, 287, 288,
304, 307, 308, 309,
310, 311, 312, 313, 314, 315, 316, 317, 318, 319,
342, 343, 344, 345, 346
};

/*
 * Some utility routines: note that we don't do a brute force
 * search on all of the above inventories - we use a little bit
 * of intelligence :-)
 */

int isdisk0(int f){if(f>0&&f<=197)return(1);else return(0);}
int isdisk1(int f){if(f>197&&f<=430)return(1);else return(0);}
int isdisk2(int f){return(look_up(f,disk2,sizeof(disk2)/sizeof(int)));}
int isdisk3(int f){return(look_up(f,disk3,sizeof(disk3)/sizeof(int)));}
int isdisk4(int f){return(look_up(f,disk4,sizeof(disk4)/sizeof(int)));}
int isdisk5(int f){return(look_up(f,disk5,sizeof(disk5)/sizeof(int)));}
int isdisk6(int f){return(look_up(f,disk6,sizeof(disk6)/sizeof(int)));}
int isdisk7(int f){return(look_up(f,disk7,sizeof(disk7)/sizeof(int)));}
int isdisk8(int f){return(look_up(f,disk8,sizeof(disk8)/sizeof(int)));}
int isdisk9(int f){return(look_up(f,disk9,sizeof(disk9)/sizeof(int)));}

/* isreject(d):: given disk number, d, 
 * if a field appears on disks 7,8,9 it is a reject field
 * if on disks 2,3,4,5,6 it is a standard (non-reject)
 * disks 0,1 contain all fields and we can't tell
 * return value for disks 0,1 is meaningless!
 */
int isreject(d)
int d;
{
   if (d==7 || d==8 || d==9) return(1);
   else return(0);
}

/* whichhcon(f):: given a field number, f, returns the disk number of
 *    the cd on which the HCON data reside.  invalid field numbers
 *    return -1.
 */
int whichhcon(f)
int f;
{

     if(f<1 || f> 430) return(-1);

     if     (f>=1 && f<=36)
	      return(2);

     else if(f>=37 && f<=71)
	    {
	      if(isdisk2(f)) return(2);
	      else return(5);
            }
     else if(f>=72 && f<=84)
	    {
	      if(isdisk3(f)) return(3);
	      else return(5);
            }
     else if(f>=85 && f<=161)
	    {
	      if(isdisk3(f)) return(3);
	      else if(isdisk5(f)) return(5);
	      else return(7);
            }
     else if(f>=162 && f<=176)
	    {
	      if(isdisk3(f)) return(3);
	      else if(isdisk5(f)) return(5);
	      else return(8);
            }
     else if(f>=177 && f<=204)
	    {
	      if(isdisk3(f)) return(3);
	      else return(8);
            }
     else if(f>=205 && f<=269)
	    {
	      if(isdisk3(f)) return(3);
	      else if(isdisk6(f)) return(6);
	      else return(8);
            }
     else if(f>=270 && f<=346)
	    {
	      if(isdisk3(f)) return(3);
	      else if(isdisk6(f)) return(6);
	      else return(9);
            }
     else if(f>=347 && f<=363)
	    {
	      if(isdisk3(f)) return(3);
	      else return(6);
            }
     else if(f>=364 && f<=395)
	    {
	      if(isdisk4(f)) return(4);
	      else return(6);
            }
     else return(4);
}

/* whichcoadd(f):: given a field number,f, return 0 if the coadd field is
 *                 on disk 0, or return 1 if on disk 1 (this roughly
 *                 corresponds to 0 for ecliptic south and 1 for ecliptic north
 *                 returns -1 if f is an invalid field number.
 */
int whichcoadd(f)
int f;
{
	if(f<1 || f>430) return -1;
	else if(isdisk0(f)) return(0);
	else return(1);
}
#undef TEST
#if defined(TEST)
main()
{

    int i;
    int d;
    printf("Plate  Coadd HCON  Reject?  Disks:\n");
    for(i=0;i<=431;i++){
       printf("%5d : %2d   %2d     %c       ", i, whichcoadd(i), d=whichhcon(i),
				      (d<2||isreject(d))?'R':' ');
       putchar((isdisk0(i)?'0':' '));
       putchar((isdisk1(i)?'1':' '));
       putchar((isdisk2(i)?'2':' '));
       putchar((isdisk3(i)?'3':' '));
       putchar((isdisk4(i)?'4':' '));
       putchar((isdisk5(i)?'5':' '));
       putchar((isdisk6(i)?'6':' '));
       putchar((isdisk7(i)?'7':' '));
       putchar((isdisk8(i)?'8':' '));
       putchar((isdisk9(i)?'9':' '));
       putchar('\n');
    }
}
#endif
