/*
 * coord.h :: Coordinate Conversion Calculator
 * Version  1.7
 * 
 * Copyright Infrared Processing and Analysis Center  1991
 * All Rights Reserved
 * California Institute of Technology
 *
 * <rick@ipac.caltech.edu>
 */
/* #Copyright (C) 1992, California Institute of Technology. */
/* #U.S. Government Sponsorship under NASA Contract NAS7-918 */
/* #is acknowledged. */

#define    LON   1
#define    LAT   0

#define    SEX   1
#define    DEG   2
#define    JUNK  0


#define     FALSE  0
#define     TRUE   !FALSE 

#define     ECL    1
#define     EQU    2
#define     GAL    3
#define     SGAL   4

#ifdef VMS
 extern double atof(); /* declaration isn't in VMS math.h */
#endif
#if defined(DOS) || defined(HPUX)
#define copysign(x,y) (y<0?-1.0:1.0)
#endif

struct COORD
   { 
   double lon;
   double lat;
   char   clon[80];
   char   clat[80];
   char   csys[80];
   double epoch;
   };

int syscode(char *csys);
int check_coord(char *strin, char *strout, int len, int flag);
int cconv( struct COORD *inp, struct COORD *outp);
int bstcmdd(double rad, double decd,int *ipcnt, int *ipndx, int pltnos[],
    double pxlnoy[], double pxlnoz[], double deams[], double pcras[],
    double pcdecs[]);
int whichcoadd(int f);
int whichhcon(int f);
int isreject(int d);
